/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.openspcoop2.core.config.TracciamentoConfigurazione;
import org.openspcoop2.core.config.TracciamentoConfigurazioneFiletrace;
import org.openspcoop2.core.config.TracciamentoConfigurazioneFiletraceConnector;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectException;

public class DriverConfigurazioneDBTracciamentoLIB {
    private DriverConfigurazioneDBTracciamentoLIB() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void crudTracciamentoConfigurazione(int type, Connection con, TracciamentoConfigurazione tracciamentoConfig, Long idProprietario, String tipoProprietario, String tipoConfigurazione) throws DriverConfigurazioneException {
        PreparedStatement updateStmt = null;
        try {
            switch (type) {
                case 1: {
                    if (tracciamentoConfig == null) {
                        return;
                    }
                    DriverConfigurazioneDBTracciamentoLIB.createTracciamentoConfigurazione(con, tracciamentoConfig, idProprietario, tipoProprietario, tipoConfigurazione);
                    return;
                }
                case 2: {
                    TracciamentoConfigurazione tracciamentoConfigOld = DriverConfigurazioneDBTracciamentoLIB.readTracciamentoConfigurazione(con, idProprietario, tipoProprietario, tipoConfigurazione);
                    if (tracciamentoConfigOld != null) {
                        DriverConfigurazioneDBTracciamentoLIB.crudTracciamentoConfigurazione(3, con, tracciamentoConfigOld, idProprietario, tipoProprietario, tipoConfigurazione);
                    }
                    if (tracciamentoConfig == null) return;
                    DriverConfigurazioneDBTracciamentoLIB.crudTracciamentoConfigurazione(1, con, tracciamentoConfig, idProprietario, tipoProprietario, tipoConfigurazione);
                    return;
                }
                case 3: {
                    if (tracciamentoConfig == null) {
                        return;
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("tracce_config");
                    sqlQueryObject.addWhereCondition("proprietario=?");
                    sqlQueryObject.addWhereCondition("tipo=?");
                    if (idProprietario != null) {
                        sqlQueryObject.addWhereCondition("id_proprietario=?");
                    }
                    sqlQueryObject.setANDLogicOperator(true);
                    String updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    int index = 1;
                    updateStmt.setString(index++, tipoProprietario);
                    updateStmt.setString(index++, tipoConfigurazione);
                    if (idProprietario != null) {
                        updateStmt.setLong(index++, idProprietario);
                    }
                    updateStmt.executeUpdate();
                    return;
                }
            }
            return;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::crudTracciamentoConfigurazione] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::crudTracciamentoConfigurazione] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            JDBCUtilities.closeResources(updateStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createTracciamentoConfigurazione(Connection con, TracciamentoConfigurazione tracciamentoConfig, Long idProprietario, String tipoProprietario, String tipoConfigurazione) throws SQLException, SQLQueryObjectException {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
        sqlQueryObject.addInsertTable("tracce_config");
        sqlQueryObject.addInsertField("proprietario", "?");
        sqlQueryObject.addInsertField("tipo", "?");
        sqlQueryObject.addInsertField("id_proprietario", "?");
        sqlQueryObject.addInsertField("stato", "?");
        sqlQueryObject.addInsertField("filtro_esiti", "?");
        sqlQueryObject.addInsertField("request_in", "?");
        sqlQueryObject.addInsertField("request_out", "?");
        sqlQueryObject.addInsertField("response_out", "?");
        sqlQueryObject.addInsertField("response_out_complete", "?");
        PreparedStatement updateStmt = null;
        try {
            String updateQuery = sqlQueryObject.createSQLInsert();
            updateStmt = con.prepareStatement(updateQuery);
            int index = 1;
            updateStmt.setString(index++, tipoProprietario);
            updateStmt.setString(index++, tipoConfigurazione);
            updateStmt.setLong(index++, idProprietario != null ? idProprietario : -1L);
            updateStmt.setString(index++, DriverConfigurazioneDBLib.getValue(tracciamentoConfig.getStato()));
            updateStmt.setString(index++, DriverConfigurazioneDBLib.getValue(tracciamentoConfig.getFiltroEsiti()));
            updateStmt.setString(index++, DriverConfigurazioneDBLib.getValue(tracciamentoConfig.getRequestIn()));
            updateStmt.setString(index++, DriverConfigurazioneDBLib.getValue(tracciamentoConfig.getRequestOut()));
            updateStmt.setString(index++, DriverConfigurazioneDBLib.getValue(tracciamentoConfig.getResponseOut()));
            updateStmt.setString(index++, DriverConfigurazioneDBLib.getValue(tracciamentoConfig.getResponseOutComplete()));
            updateStmt.executeUpdate();
            updateStmt.close();
            updateStmt = null;
        }
        catch (Throwable throwable) {
            JDBCUtilities.closeResources(updateStmt);
            throw throwable;
        }
        JDBCUtilities.closeResources((PreparedStatement)updateStmt);
    }

    protected static TracciamentoConfigurazione readTracciamentoConfigurazione(Connection con, Long idProprietario, String tipoProprietario, String tipoConfigurazione) throws DriverConfigurazioneException {
        TracciamentoConfigurazione tracciamentoConfigurazione;
        PreparedStatement stm1 = null;
        ResultSet rs1 = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
            sqlQueryObject.addFromTable("tracce_config");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("proprietario=?");
            sqlQueryObject.addWhereCondition("tipo=?");
            if (idProprietario != null) {
                sqlQueryObject.addWhereCondition("id_proprietario=?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm1 = con.prepareStatement(sqlQuery);
            int index = 1;
            stm1.setString(index++, tipoProprietario);
            stm1.setString(index++, tipoConfigurazione);
            if (idProprietario != null) {
                stm1.setLong(index++, idProprietario);
            }
            rs1 = stm1.executeQuery();
            TracciamentoConfigurazione tracciamentoConfig = null;
            if (rs1.next()) {
                tracciamentoConfig = new TracciamentoConfigurazione();
                tracciamentoConfig.setId(rs1.getLong("id"));
                tracciamentoConfig.setStato(DriverConfigurazioneDBLib.getEnumStatoFunzionalitaConPersonalizzazione(rs1.getString("stato")));
                tracciamentoConfig.setFiltroEsiti(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs1.getString("filtro_esiti")));
                tracciamentoConfig.setRequestIn(DriverConfigurazioneDBLib.getEnumStatoFunzionalitaBloccante(rs1.getString("request_in")));
                tracciamentoConfig.setRequestOut(DriverConfigurazioneDBLib.getEnumStatoFunzionalitaBloccante(rs1.getString("request_out")));
                tracciamentoConfig.setResponseOut(DriverConfigurazioneDBLib.getEnumStatoFunzionalitaBloccante(rs1.getString("response_out")));
                tracciamentoConfig.setResponseOutComplete(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs1.getString("response_out_complete")));
            }
            tracciamentoConfigurazione = tracciamentoConfig;
        }
        catch (Exception se) {
            try {
                throw new DriverConfigurazioneException(se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs1, stm1);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs1, (PreparedStatement)stm1);
        return tracciamentoConfigurazione;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void crudTracciamentoConfigurazioneFiletrace(int type, Connection con, TracciamentoConfigurazioneFiletrace tracciamentoConfig, Long idProprietario, String tipoProprietario) throws DriverConfigurazioneException {
        PreparedStatement updateStmt = null;
        try {
            switch (type) {
                case 1: {
                    if (tracciamentoConfig == null) {
                        return;
                    }
                    DriverConfigurazioneDBTracciamentoLIB.createTracciamentoConfigurazioneFiletrace(con, tracciamentoConfig, idProprietario, tipoProprietario);
                    return;
                }
                case 2: {
                    TracciamentoConfigurazioneFiletrace tracciamentoConfigOld = DriverConfigurazioneDBTracciamentoLIB.readTracciamentoConfigurazioneFiletrace(con, idProprietario, tipoProprietario);
                    if (tracciamentoConfigOld != null) {
                        DriverConfigurazioneDBTracciamentoLIB.crudTracciamentoConfigurazioneFiletrace(3, con, tracciamentoConfigOld, idProprietario, tipoProprietario);
                    }
                    if (tracciamentoConfig == null) return;
                    DriverConfigurazioneDBTracciamentoLIB.crudTracciamentoConfigurazioneFiletrace(1, con, tracciamentoConfig, idProprietario, tipoProprietario);
                    return;
                }
                case 3: {
                    if (tracciamentoConfig == null) {
                        return;
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("filetrace_config");
                    sqlQueryObject.addWhereCondition("proprietario=?");
                    if (idProprietario != null) {
                        sqlQueryObject.addWhereCondition("id_proprietario=?");
                    }
                    sqlQueryObject.setANDLogicOperator(true);
                    String updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    int index = 1;
                    updateStmt.setString(index++, tipoProprietario);
                    if (idProprietario != null) {
                        updateStmt.setLong(index++, idProprietario);
                    }
                    updateStmt.executeUpdate();
                    return;
                }
            }
            return;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::crudTracciamentoConfigurazioneFiletrace] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::crudTracciamentoConfigurazioneFiletrace] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            JDBCUtilities.closeResources(updateStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createTracciamentoConfigurazioneFiletrace(Connection con, TracciamentoConfigurazioneFiletrace tracciamentoConfig, Long idProprietario, String tipoProprietario) throws SQLException, SQLQueryObjectException {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
        sqlQueryObject.addInsertTable("filetrace_config");
        sqlQueryObject.addInsertField("proprietario", "?");
        sqlQueryObject.addInsertField("id_proprietario", "?");
        sqlQueryObject.addInsertField("config", "?");
        sqlQueryObject.addInsertField("dump_in_stato", "?");
        sqlQueryObject.addInsertField("dump_in_stato_hdr", "?");
        sqlQueryObject.addInsertField("dump_in_stato_body", "?");
        sqlQueryObject.addInsertField("dump_out_stato", "?");
        sqlQueryObject.addInsertField("dump_out_stato_hdr", "?");
        sqlQueryObject.addInsertField("dump_out_stato_body", "?");
        PreparedStatement updateStmt = null;
        try {
            String updateQuery = sqlQueryObject.createSQLInsert();
            updateStmt = con.prepareStatement(updateQuery);
            int index = 1;
            updateStmt.setString(index++, tipoProprietario);
            updateStmt.setLong(index++, idProprietario != null ? idProprietario : -1L);
            updateStmt.setString(index++, tracciamentoConfig.getConfig());
            updateStmt.setString(index++, tracciamentoConfig.getDumpIn() != null ? DriverConfigurazioneDBLib.getValue(tracciamentoConfig.getDumpIn().getStato()) : null);
            updateStmt.setString(index++, tracciamentoConfig.getDumpIn() != null ? DriverConfigurazioneDBLib.getValue(tracciamentoConfig.getDumpIn().getHeader()) : null);
            updateStmt.setString(index++, tracciamentoConfig.getDumpIn() != null ? DriverConfigurazioneDBLib.getValue(tracciamentoConfig.getDumpIn().getPayload()) : null);
            updateStmt.setString(index++, tracciamentoConfig.getDumpOut() != null ? DriverConfigurazioneDBLib.getValue(tracciamentoConfig.getDumpOut().getStato()) : null);
            updateStmt.setString(index++, tracciamentoConfig.getDumpOut() != null ? DriverConfigurazioneDBLib.getValue(tracciamentoConfig.getDumpOut().getHeader()) : null);
            updateStmt.setString(index++, tracciamentoConfig.getDumpOut() != null ? DriverConfigurazioneDBLib.getValue(tracciamentoConfig.getDumpOut().getPayload()) : null);
            updateStmt.executeUpdate();
            updateStmt.close();
            updateStmt = null;
        }
        catch (Throwable throwable) {
            JDBCUtilities.closeResources(updateStmt);
            throw throwable;
        }
        JDBCUtilities.closeResources((PreparedStatement)updateStmt);
    }

    protected static TracciamentoConfigurazioneFiletrace readTracciamentoConfigurazioneFiletrace(Connection con, Long idProprietario, String tipoProprietario) throws DriverConfigurazioneException {
        TracciamentoConfigurazioneFiletrace tracciamentoConfigurazioneFiletrace;
        PreparedStatement stm1 = null;
        ResultSet rs1 = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
            sqlQueryObject.addFromTable("filetrace_config");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("proprietario=?");
            if (idProprietario != null) {
                sqlQueryObject.addWhereCondition("id_proprietario=?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm1 = con.prepareStatement(sqlQuery);
            int index = 1;
            stm1.setString(index++, tipoProprietario);
            if (idProprietario != null) {
                stm1.setLong(index++, idProprietario);
            }
            rs1 = stm1.executeQuery();
            TracciamentoConfigurazioneFiletrace tracciamentoConfig = null;
            if (rs1.next()) {
                tracciamentoConfig = new TracciamentoConfigurazioneFiletrace();
                tracciamentoConfig.setId(rs1.getLong("id"));
                tracciamentoConfig.setConfig(rs1.getString("config"));
                StatoFunzionalita inStato = DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs1.getString("dump_in_stato"));
                StatoFunzionalita inStatoHdr = DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs1.getString("dump_in_stato_hdr"));
                StatoFunzionalita inStatoBody = DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs1.getString("dump_in_stato_body"));
                if (inStato != null || inStatoHdr != null || inStatoBody != null) {
                    tracciamentoConfig.setDumpIn(new TracciamentoConfigurazioneFiletraceConnector());
                    tracciamentoConfig.getDumpIn().setStato(inStato);
                    tracciamentoConfig.getDumpIn().setHeader(inStatoHdr);
                    tracciamentoConfig.getDumpIn().setPayload(inStatoBody);
                }
                StatoFunzionalita outStato = DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs1.getString("dump_out_stato"));
                StatoFunzionalita outStatoHdr = DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs1.getString("dump_out_stato_hdr"));
                StatoFunzionalita outStatoBody = DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs1.getString("dump_out_stato_body"));
                if (outStato != null || outStatoHdr != null || outStatoBody != null) {
                    tracciamentoConfig.setDumpOut(new TracciamentoConfigurazioneFiletraceConnector());
                    tracciamentoConfig.getDumpOut().setStato(outStato);
                    tracciamentoConfig.getDumpOut().setHeader(outStatoHdr);
                    tracciamentoConfig.getDumpOut().setPayload(outStatoBody);
                }
            }
            tracciamentoConfigurazioneFiletrace = tracciamentoConfig;
        }
        catch (Exception se) {
            try {
                throw new DriverConfigurazioneException(se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs1, stm1);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs1, (PreparedStatement)stm1);
        return tracciamentoConfigurazioneFiletrace;
    }
}

