/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.config.RegistroPlugin;
import org.openspcoop2.core.config.RegistroPluginArchivio;
import org.openspcoop2.core.config.constants.PluginSorgenteArchivio;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.jdbc.CustomKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;
import org.openspcoop2.utils.jdbc.IKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKey;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKeyJDBCType;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKeyObject;
import org.openspcoop2.utils.jdbc.JDBCAdapterFactory;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDB_pluginsLIB {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void CRUDRegistroPlugin(int type, RegistroPlugin plugin, Connection con) throws DriverConfigurazioneException {
        if (plugin == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDRegistroPlugin] Il plugin non possono essere NULL");
        }
        PreparedStatement updateStmt = null;
        String updateQuery = "";
        PreparedStatement selectStmt = null;
        ResultSet selectRS = null;
        try {
            if (plugin.getNome() == null) {
                throw new DriverConfigurazioneException("Nome non fornito");
            }
            long idParent = -1L;
            if (type == 2 || type == 3) {
                idParent = DBUtils.getIdRegistroPlugin(plugin.getNome(), con, DriverConfigurazioneDBLib.tipoDB);
                if (idParent <= 0L) {
                    throw new DriverConfigurazioneException("Plugin con nome '" + plugin.getNome() + "' non trovato");
                }
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                sqlQueryObject.addDeleteTable("registro_plug_jar");
                sqlQueryObject.addWhereCondition("id_plugin=?");
                sqlQueryObject.setANDLogicOperator(true);
                updateQuery = sqlQueryObject.createSQLDelete();
                updateStmt = con.prepareStatement(updateQuery);
                updateStmt.setLong(1, idParent);
                updateStmt.executeUpdate();
                updateStmt.close();
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                sqlQueryObject.addDeleteTable("registro_plugins");
                sqlQueryObject.addWhereCondition("id=?");
                updateQuery = sqlQueryObject.createSQLDelete();
                updateStmt = con.prepareStatement(updateQuery);
                updateStmt.setLong(1, idParent);
                updateStmt.executeUpdate();
                updateStmt.close();
            }
            switch (type) {
                case 1: 
                case 2: {
                    ArrayList<InsertAndGeneratedKeyObject> listInsertAndGeneratedKeyObject = new ArrayList<InsertAndGeneratedKeyObject>();
                    listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("nome", (Object)plugin.getNome(), InsertAndGeneratedKeyJDBCType.STRING));
                    listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("posizione", (Object)plugin.getPosizione(), InsertAndGeneratedKeyJDBCType.INT));
                    listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("stato", (Object)DriverConfigurazioneDBLib.getValue(plugin.getStato()), InsertAndGeneratedKeyJDBCType.STRING));
                    listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("descrizione", (Object)plugin.getDescrizione(), InsertAndGeneratedKeyJDBCType.STRING));
                    listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("data", (Object)plugin.getData(), InsertAndGeneratedKeyJDBCType.TIMESTAMP));
                    String compatibilita = null;
                    if (plugin.sizeCompatibilitaList() > 0) {
                        StringBuilder bf = new StringBuilder();
                        for (int i = 0; i < plugin.sizeCompatibilitaList(); ++i) {
                            if (i > 0) {
                                bf.append(",");
                            }
                            bf.append(plugin.getCompatibilita(i));
                        }
                        if (bf.length() > 0) {
                            compatibilita = bf.toString();
                        }
                    }
                    listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("compatibilita", compatibilita, InsertAndGeneratedKeyJDBCType.STRING));
                    long idPlugin = InsertAndGeneratedKey.insertAndReturnGeneratedKey((Connection)con, (TipiDatabase)TipiDatabase.toEnumConstant((String)DriverConfigurazioneDBLib.tipoDB), (IKeyGeneratorObject)new CustomKeyGeneratorObject("registro_plugins", "id", "seq_registro_plugins", "registro_plugins_init_seq"), (InsertAndGeneratedKeyObject[])listInsertAndGeneratedKeyObject.toArray(new InsertAndGeneratedKeyObject[1]));
                    if (idPlugin <= 0L) {
                        throw new Exception("ID (RegistroPlugins) autoincrementale non ottenuto");
                    }
                    int l = 0;
                    while (l < plugin.sizeArchivioList()) {
                        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addInsertTable("registro_plug_jar");
                        sqlQueryObject.addInsertField("id_plugin", "?");
                        sqlQueryObject.addInsertField("nome", "?");
                        sqlQueryObject.addInsertField("data", "?");
                        sqlQueryObject.addInsertField("sorgente", "?");
                        sqlQueryObject.addInsertField("contenuto", "?");
                        sqlQueryObject.addInsertField("url", "?");
                        sqlQueryObject.addInsertField("dir", "?");
                        updateQuery = sqlQueryObject.createSQLInsert();
                        updateStmt = con.prepareStatement(updateQuery);
                        int index = 1;
                        updateStmt.setLong(index++, idPlugin);
                        updateStmt.setString(index++, plugin.getArchivio(l).getNome());
                        Timestamp t = DateManager.getTimestamp();
                        if (plugin.getArchivio(l).getData() != null) {
                            t = new Timestamp(plugin.getArchivio(l).getData().getTime());
                        }
                        updateStmt.setTimestamp(index++, t);
                        PluginSorgenteArchivio sorgente = plugin.getArchivio(l).getSorgente();
                        updateStmt.setString(index++, DriverConfigurazioneDBLib.getValue(sorgente));
                        IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)DriverConfigurazioneDBLib.tipoDB);
                        byte[] archivio = null;
                        String url = null;
                        String dir = null;
                        switch (sorgente) {
                            case JAR: {
                                archivio = plugin.getArchivio(l).getContenuto();
                                break;
                            }
                            case URL: {
                                url = plugin.getArchivio(l).getUrl();
                                break;
                            }
                            case DIR: {
                                dir = plugin.getArchivio(l).getDir();
                                break;
                            }
                        }
                        jdbcAdapter.setBinaryData(updateStmt, index++, archivio);
                        updateStmt.setString(index++, url);
                        updateStmt.setString(index++, dir);
                        updateStmt.executeUpdate();
                        updateStmt.close();
                        ++l;
                    }
                    return;
                }
            }
            return;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDRegistroPlugin] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDRegistroPlugin] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            JDBCUtilities.closeResources(selectRS, selectStmt);
            JDBCUtilities.closeResources(updateStmt);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void updateDatiRegistroPlugin(String nome, RegistroPlugin plugin, Connection con) throws DriverConfigurazioneException {
        if (plugin == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDRegistroPlugin] Il plugin non possono essere NULL");
        }
        PreparedStatement updateStmt = null;
        String updateQuery = "";
        PreparedStatement selectStmt = null;
        ResultSet selectRS = null;
        try {
            long idParent = DBUtils.getIdRegistroPlugin(nome, con, DriverConfigurazioneDBLib.tipoDB);
            if (idParent <= 0L) {
                throw new DriverConfigurazioneException("Plugin con nome '" + nome + "' non trovato");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
            sqlQueryObject.addUpdateTable("registro_plugins");
            sqlQueryObject.addUpdateField("nome", "?");
            sqlQueryObject.addUpdateField("posizione", "?");
            sqlQueryObject.addUpdateField("stato", "?");
            sqlQueryObject.addUpdateField("descrizione", "?");
            sqlQueryObject.addUpdateField("data", "?");
            sqlQueryObject.addUpdateField("compatibilita", "?");
            sqlQueryObject.addWhereCondition("id=?");
            sqlQueryObject.setANDLogicOperator(true);
            updateQuery = sqlQueryObject.createSQLUpdate();
            updateStmt = con.prepareStatement(updateQuery);
            int index = 1;
            updateStmt.setString(index++, plugin.getNome());
            updateStmt.setInt(index++, plugin.getPosizione());
            updateStmt.setString(index++, DriverConfigurazioneDBLib.getValue(plugin.getStato()));
            updateStmt.setString(index++, plugin.getDescrizione());
            Timestamp t = DateManager.getTimestamp();
            if (plugin.getData() != null) {
                t = new Timestamp(plugin.getData().getTime());
            }
            updateStmt.setTimestamp(index++, t);
            String compatibilita = null;
            if (plugin.sizeCompatibilitaList() > 0) {
                StringBuilder bf = new StringBuilder();
                for (int i = 0; i < plugin.sizeCompatibilitaList(); ++i) {
                    if (i > 0) {
                        bf.append(",");
                    }
                    bf.append(plugin.getCompatibilita(i));
                }
                if (bf.length() > 0) {
                    compatibilita = bf.toString();
                }
            }
            updateStmt.setString(index++, compatibilita);
            updateStmt.setLong(index++, idParent);
            updateStmt.executeUpdate();
            updateStmt.close();
            updateStmt = null;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDRegistroPlugin] SQLException [" + se.getMessage() + "].", se);
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDRegistroPlugin] Exception [" + se2.getMessage() + "].", se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(selectRS, selectStmt);
                JDBCUtilities.closeResources(updateStmt);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources(selectRS, selectStmt);
        JDBCUtilities.closeResources((PreparedStatement)updateStmt);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void CRUDRegistroPluginArchivio(int type, String nomePlugin, RegistroPluginArchivio plugin, Connection con) throws DriverConfigurazioneException {
        if (plugin == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDRegistroPluginArchivio] Il plugin non possono essere NULL");
        }
        PreparedStatement updateStmt = null;
        String updateQuery = "";
        PreparedStatement selectStmt = null;
        ResultSet selectRS = null;
        try {
            long idParent = DBUtils.getIdRegistroPlugin(nomePlugin, con, DriverConfigurazioneDBLib.tipoDB);
            if (idParent <= 0L) {
                throw new DriverConfigurazioneException("Plugin con nome '" + nomePlugin + "' non trovato");
            }
            switch (type) {
                case 1: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addInsertTable("registro_plug_jar");
                    sqlQueryObject.addInsertField("id_plugin", "?");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("data", "?");
                    sqlQueryObject.addInsertField("sorgente", "?");
                    sqlQueryObject.addInsertField("contenuto", "?");
                    sqlQueryObject.addInsertField("url", "?");
                    sqlQueryObject.addInsertField("dir", "?");
                    updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    int index = 1;
                    updateStmt.setLong(index++, idParent);
                    updateStmt.setString(index++, plugin.getNome());
                    Timestamp t = DateManager.getTimestamp();
                    if (plugin.getData() != null) {
                        t = new Timestamp(plugin.getData().getTime());
                    }
                    updateStmt.setTimestamp(index++, t);
                    PluginSorgenteArchivio sorgente = plugin.getSorgente();
                    updateStmt.setString(index++, DriverConfigurazioneDBLib.getValue(sorgente));
                    IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)DriverConfigurazioneDBLib.tipoDB);
                    byte[] archivio = null;
                    String url = null;
                    String dir = null;
                    switch (sorgente) {
                        case JAR: {
                            archivio = plugin.getContenuto();
                            break;
                        }
                        case URL: {
                            url = plugin.getUrl();
                            break;
                        }
                        case DIR: {
                            dir = plugin.getDir();
                            break;
                        }
                    }
                    jdbcAdapter.setBinaryData(updateStmt, index++, archivio);
                    updateStmt.setString(index++, url);
                    updateStmt.setString(index++, dir);
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    return;
                }
                case 2: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addUpdateTable("registro_plug_jar");
                    sqlQueryObject.addUpdateField("data", "?");
                    sqlQueryObject.addUpdateField("sorgente", "?");
                    sqlQueryObject.addUpdateField("contenuto", "?");
                    sqlQueryObject.addUpdateField("url", "?");
                    sqlQueryObject.addUpdateField("dir", "?");
                    sqlQueryObject.addWhereCondition("id_plugin = ?");
                    sqlQueryObject.addWhereCondition("nome = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    int index = 1;
                    Timestamp t = DateManager.getTimestamp();
                    updateStmt.setTimestamp(index++, t);
                    PluginSorgenteArchivio sorgente = plugin.getSorgente();
                    updateStmt.setString(index++, DriverConfigurazioneDBLib.getValue(sorgente));
                    IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)DriverConfigurazioneDBLib.tipoDB);
                    byte[] archivio = null;
                    String url = null;
                    String dir = null;
                    switch (sorgente) {
                        case JAR: {
                            archivio = plugin.getContenuto();
                            break;
                        }
                        case URL: {
                            url = plugin.getUrl();
                            break;
                        }
                        case DIR: {
                            dir = plugin.getDir();
                            break;
                        }
                    }
                    jdbcAdapter.setBinaryData(updateStmt, index++, archivio);
                    updateStmt.setString(index++, url);
                    updateStmt.setString(index++, dir);
                    updateStmt.setLong(index++, idParent);
                    updateStmt.setString(index++, plugin.getNome());
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    return;
                }
                case 3: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addDeleteTable("registro_plug_jar");
                    sqlQueryObject.addWhereCondition("id_plugin = ?");
                    sqlQueryObject.addWhereCondition("nome = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    int index = 1;
                    updateStmt.setLong(index++, idParent);
                    updateStmt.setString(index++, plugin.getNome());
                    updateStmt.executeUpdate();
                    updateStmt.close();
                    return;
                }
            }
            return;
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDRegistroPluginArchivio] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDRegistroPluginArchivio] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            JDBCUtilities.closeResources(selectRS, selectStmt);
            JDBCUtilities.closeResources(updateStmt);
        }
    }
}

