/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.Filtri;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.config.CorrelazioneApplicativaElemento;
import org.openspcoop2.core.config.CorrelazioneApplicativaRispostaElemento;
import org.openspcoop2.core.config.MessageSecurityFlowParameter;
import org.openspcoop2.core.config.MtomProcessorFlowParameter;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_porteDelegateDriver;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDB_porteDelegateSearchDriver {
    private DriverConfigurazioneDB driver = null;
    private DriverConfigurazioneDB_porteDelegateDriver porteDelegateDriver = null;

    protected DriverConfigurazioneDB_porteDelegateSearchDriver(DriverConfigurazioneDB driver) {
        this.driver = driver;
        this.porteDelegateDriver = new DriverConfigurazioneDB_porteDelegateDriver(driver);
    }

    protected List<String> portaDelegataRuoliList(long idPD, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "portaDelegataRuoliList";
        int idLista = Liste.PORTE_DELEGATE_RUOLI;
        String nomeTabella = "pd_ruoli";
        return this._portaDelegataRuoliList(idPD, ricerca, nomeMetodo, nomeTabella, idLista);
    }

    protected List<String> portaDelegataRuoliTokenList(long idPD, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "portaDelegataRuoliTokenList";
        int idLista = Liste.PORTE_DELEGATE_TOKEN_RUOLI;
        String nomeTabella = "pd_token_ruoli";
        return this._portaDelegataRuoliList(idPD, ricerca, nomeMetodo, nomeTabella, idLista);
    }

    private List<String> _portaDelegataRuoliList(long idPD, ISearch ricerca, String nomeMetodo, String nomeTabella, int idLista) throws DriverConfigurazioneException {
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        ArrayList<String> listIdRuoli = null;
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable(nomeTabella);
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("porte_delegate.id=?");
                sqlQueryObject.addWhereCondition("porte_delegate.id=" + nomeTabella + ".id_porta");
                sqlQueryObject.addWhereLikeCondition(nomeTabella + ".ruolo", search, true, true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable(nomeTabella);
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("porte_delegate.id=?");
                sqlQueryObject.addWhereCondition("porte_delegate.id=" + nomeTabella + ".id_porta");
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPD);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable(nomeTabella);
                sqlQueryObject.addSelectField(nomeTabella + ".ruolo");
                sqlQueryObject.addWhereCondition("porte_delegate.id=?");
                sqlQueryObject.addWhereCondition("porte_delegate.id=" + nomeTabella + ".id_porta");
                sqlQueryObject.addWhereLikeCondition(nomeTabella + ".ruolo", search, true, true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy(nomeTabella + ".ruolo");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable(nomeTabella);
                sqlQueryObject.addSelectField(nomeTabella + ".ruolo");
                sqlQueryObject.addWhereCondition("porte_delegate.id=?");
                sqlQueryObject.addWhereCondition("porte_delegate.id=" + nomeTabella + ".id_porta");
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy(nomeTabella + ".ruolo");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPD);
            risultato = stmt.executeQuery();
            listIdRuoli = new ArrayList<String>();
            while (risultato.next()) {
                listIdRuoli.add(risultato.getString(1));
            }
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return listIdRuoli;
    }

    protected List<String> portaDelegataScopeList(long idPD, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "portaDelegataScopeList";
        int idLista = Liste.PORTE_DELEGATE_SCOPE;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        ArrayList<String> listIdScope = null;
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable("pd_scope");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("porte_delegate.id=?");
                sqlQueryObject.addWhereCondition("porte_delegate.id=pd_scope.id_porta");
                sqlQueryObject.addWhereLikeCondition("pd_scope.scope", search, true, true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable("pd_scope");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("porte_delegate.id=?");
                sqlQueryObject.addWhereCondition("porte_delegate.id=pd_scope.id_porta");
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPD);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable("pd_scope");
                sqlQueryObject.addSelectField("pd_scope.scope");
                sqlQueryObject.addWhereCondition("porte_delegate.id=?");
                sqlQueryObject.addWhereCondition("porte_delegate.id=pd_scope.id_porta");
                sqlQueryObject.addWhereLikeCondition("pd_scope.scope", search, true, true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("pd_scope.scope");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable("pd_scope");
                sqlQueryObject.addSelectField("pd_scope.scope");
                sqlQueryObject.addWhereCondition("porte_delegate.id=?");
                sqlQueryObject.addWhereCondition("porte_delegate.id=pd_scope.id_porta");
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("pd_scope.scope");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPD);
            risultato = stmt.executeQuery();
            listIdScope = new ArrayList<String>();
            while (risultato.next()) {
                listIdScope.add(risultato.getString(1));
            }
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return listIdScope;
    }

    protected List<PortaDelegata> porteDelegateList(long idSoggetto, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<PortaDelegata> arrayList;
        String nomeMetodo = "porteDelegateList";
        int idLista = Liste.PORTE_DELEGATE_BY_SOGGETTO;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortaDelegata> lista = new ArrayList<PortaDelegata>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteDelegateList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                sqlQueryObject.addWhereLikeCondition("nome_porta", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggetto);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_porta");
                sqlQueryObject.addSelectField("id_soggetto");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                sqlQueryObject.addWhereLikeCondition("nome_porta", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome_porta");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_porta");
                sqlQueryObject.addSelectField("id_soggetto");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome_porta");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggetto);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                PortaDelegata pd = this.porteDelegateDriver.getPortaDelegata(risultato.getLong("id"), con);
                lista.add(pd);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<Proprieta> porteDelegatePropList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<Proprieta> arrayList;
        int idLista = Liste.PORTE_DELEGATE_PROP;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Proprieta> lista = new ArrayList<Proprieta>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteDelegatePropList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteDelegatePropList] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_properties");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_properties");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_properties");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addSelectField("enc_value");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_properties");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addSelectField("enc_value");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            Proprieta prop = null;
            while (risultato.next()) {
                prop = new Proprieta();
                prop.setId(risultato.getLong("id"));
                prop.setNome(risultato.getString("nome"));
                String plainValue = risultato.getString("valore");
                String encValue = risultato.getString("enc_value");
                if (encValue != null && StringUtils.isNotEmpty((CharSequence)encValue)) {
                    prop.setValore(encValue);
                } else {
                    prop.setValore(plainValue);
                }
                lista.add(prop);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteDelegatePropList] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<Proprieta> porteDelegateAutenticazioneCustomPropList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<Proprieta> arrayList;
        int idLista = Liste.PORTE_DELEGATE_PROPRIETA_AUTENTICAZIONE;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Proprieta> lista = new ArrayList<Proprieta>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteDelegatePropList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteDelegatePropList] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_auth_properties");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_auth_properties");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_auth_properties");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addSelectField("enc_value");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_auth_properties");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addSelectField("enc_value");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            Proprieta prop = null;
            while (risultato.next()) {
                prop = new Proprieta();
                prop.setId(risultato.getLong("id"));
                prop.setNome(risultato.getString("nome"));
                String plainValue = risultato.getString("valore");
                String encValue = risultato.getString("enc_value");
                if (encValue != null && StringUtils.isNotEmpty((CharSequence)encValue)) {
                    prop.setValore(encValue);
                } else {
                    prop.setValore(plainValue);
                }
                lista.add(prop);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteDelegatePropList] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<Proprieta> porteDelegateAutorizzazioneCustomPropList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<Proprieta> arrayList;
        int idLista = Liste.PORTE_DELEGATE_PROPRIETA_AUTORIZZAZIONE;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Proprieta> lista = new ArrayList<Proprieta>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteDelegatePropList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteDelegatePropList] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_authz_properties");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_authz_properties");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_authz_properties");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addSelectField("enc_value");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_authz_properties");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addSelectField("enc_value");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            Proprieta prop = null;
            while (risultato.next()) {
                prop = new Proprieta();
                prop.setId(risultato.getLong("id"));
                prop.setNome(risultato.getString("nome"));
                String plainValue = risultato.getString("valore");
                String encValue = risultato.getString("enc_value");
                if (encValue != null && StringUtils.isNotEmpty((CharSequence)encValue)) {
                    prop.setValore(encValue);
                } else {
                    prop.setValore(plainValue);
                }
                lista.add(prop);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteDelegatePropList] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<Proprieta> porteDelegateAutorizzazioneContenutoCustomPropList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<Proprieta> arrayList;
        int idLista = Liste.PORTE_DELEGATE_PROPRIETA_AUTORIZZAZIONE_CONTENUTO;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Proprieta> lista = new ArrayList<Proprieta>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteDelegatePropList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteDelegatePropList] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_authzc_properties");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_authzc_properties");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_authzc_properties");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addSelectField("enc_value");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_authzc_properties");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addSelectField("enc_value");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            Proprieta prop = null;
            while (risultato.next()) {
                prop = new Proprieta();
                prop.setId(risultato.getLong("id"));
                prop.setNome(risultato.getString("nome"));
                String plainValue = risultato.getString("valore");
                String encValue = risultato.getString("enc_value");
                if (encValue != null && StringUtils.isNotEmpty((CharSequence)encValue)) {
                    prop.setValore(encValue);
                } else {
                    prop.setValore(plainValue);
                }
                lista.add(prop);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::porteDelegatePropList] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<PortaDelegata> porteDelegateList(String superuser, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<PortaDelegata> arrayList;
        String nomeMetodo = "porteDelegateList";
        int idLista = Liste.PORTE_DELEGATE;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        String filterProtocollo = SearchUtils.getFilter(ricerca, idLista, "filtroProtocollo");
        String filterProtocolli = SearchUtils.getFilter(ricerca, idLista, "filtroProtocolli");
        List<String> tipoSoggettiProtocollo = null;
        try {
            tipoSoggettiProtocollo = Filtri.convertToTipiSoggetti(filterProtocollo, filterProtocolli);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), e);
        }
        this.driver.logDebug("search : " + search);
        this.driver.logDebug("filterProtocollo : " + filterProtocollo);
        this.driver.logDebug("filterProtocolli : " + filterProtocolli);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortaDelegata> lista = new ArrayList<PortaDelegata>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteDelegateList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                sqlQueryObject.addWhereLikeCondition("nome_porta", search, true, true);
                if (tipoSoggettiProtocollo != null && tipoSoggettiProtocollo.size() > 0) {
                    sqlQueryObject.addWhereINCondition("tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                if (tipoSoggettiProtocollo != null && tipoSoggettiProtocollo.size() > 0) {
                    sqlQueryObject.addWhereINCondition("tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                stmt.setString(1, superuser);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("porte_delegate.id");
                sqlQueryObject.addSelectField("nome_porta");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                sqlQueryObject.addWhereLikeCondition("nome_porta", search, true, true);
                if (tipoSoggettiProtocollo != null && tipoSoggettiProtocollo.size() > 0) {
                    sqlQueryObject.addWhereINCondition("tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome_porta");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("porte_delegate.id");
                sqlQueryObject.addSelectField("nome_porta");
                sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
                if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                if (tipoSoggettiProtocollo != null && tipoSoggettiProtocollo.size() > 0) {
                    sqlQueryObject.addWhereINCondition("tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome_porta");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                stmt.setString(1, superuser);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                PortaDelegata pd = this.porteDelegateDriver.getPortaDelegata(risultato.getLong("id"), con);
                lista.add(pd);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<ServizioApplicativo> porteDelegateServizioApplicativoList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "porteDelegateServizioApplicativoList";
        int idLista = Liste.PORTE_DELEGATE_SERVIZIO_APPLICATIVO;
        String nomeTabella = "porte_delegate_sa";
        return this._porteDelegateServizioApplicativoList(idPortaDelegata, ricerca, nomeMetodo, nomeTabella, idLista);
    }

    protected List<ServizioApplicativo> porteDelegateServizioApplicativoTokenList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "porteDelegateServizioApplicativoTokenList";
        int idLista = Liste.PORTE_DELEGATE_TOKEN_SERVIZIO_APPLICATIVO;
        String nomeTabella = "pd_token_sa";
        return this._porteDelegateServizioApplicativoList(idPortaDelegata, ricerca, nomeMetodo, nomeTabella, idLista);
    }

    private List<ServizioApplicativo> _porteDelegateServizioApplicativoList(long idPortaDelegata, ISearch ricerca, String nomeMetodo, String nomeTabella, int idLista) throws DriverConfigurazioneException {
        ArrayList<ServizioApplicativo> arrayList;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        PreparedStatement stmt1 = null;
        ResultSet risultato = null;
        ResultSet rs1 = null;
        ArrayList<ServizioApplicativo> lista = new ArrayList<ServizioApplicativo>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteDelegateServizioApplicativoList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable(nomeTabella);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereCondition(nomeTabella + ".id_servizio_applicativo=servizi_applicativi.id");
                sqlQueryObject.addWhereLikeCondition("servizi_applicativi.nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable(nomeTabella);
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable(nomeTabella);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addSelectField(nomeTabella, "id_servizio_applicativo");
                sqlQueryObject.addSelectField(nomeTabella, "id_porta");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereCondition(nomeTabella + ".id_servizio_applicativo=servizi_applicativi.id");
                sqlQueryObject.addWhereLikeCondition("servizi_applicativi.nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("id_servizio_applicativo");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable(nomeTabella);
                sqlQueryObject.addSelectField("id_servizio_applicativo");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("id_servizio_applicativo");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            ServizioApplicativo sa = null;
            long idServizioApplicativo = 0L;
            while (risultato.next()) {
                idServizioApplicativo = risultato.getLong("id_servizio_applicativo");
                sa = new ServizioApplicativo();
                ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject2.addFromTable("servizi_applicativi");
                sqlQueryObject2.addSelectField("*");
                sqlQueryObject2.addWhereCondition("id = ?");
                queryString = sqlQueryObject2.createSQLQuery();
                stmt1 = con.prepareStatement(queryString);
                stmt1.setLong(1, idServizioApplicativo);
                rs1 = stmt1.executeQuery();
                if (!rs1.next()) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore recuperando i dati del Servizio Applicativo.");
                }
                sa.setId(idServizioApplicativo);
                sa.setNome(rs1.getString("nome"));
                sa.setDescrizione(rs1.getString("descrizione"));
                sa.setIdSoggetto(rs1.getLong("id_soggetto"));
                rs1.close();
                stmt1.close();
                lista.add(sa);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                JDBCUtilities.closeResources(rs1, stmt1);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        JDBCUtilities.closeResources(rs1, stmt1);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<MessageSecurityFlowParameter> porteDelegateMessageSecurityRequestList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<MessageSecurityFlowParameter> arrayList;
        String nomeMetodo = "porteDelegateMessageSecurityRequestList";
        int idLista = Liste.PORTE_DELEGATE_MESSAGE_SECURITY_REQUEST;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<MessageSecurityFlowParameter> lista = new ArrayList<MessageSecurityFlowParameter>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteDelegateMessageSecurityRequestList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_security_request");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_security_request");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_security_request");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addSelectField("enc_value");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_security_request");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addSelectField("enc_value");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                MessageSecurityFlowParameter wsreq = new MessageSecurityFlowParameter();
                wsreq.setId(risultato.getLong("id_porta"));
                wsreq.setNome(risultato.getString("nome"));
                String plainValue = risultato.getString("valore");
                String encValue = risultato.getString("enc_value");
                if (encValue != null && StringUtils.isNotEmpty((CharSequence)encValue)) {
                    wsreq.setValore(encValue);
                } else {
                    wsreq.setValore(plainValue);
                }
                lista.add(wsreq);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<MessageSecurityFlowParameter> porteDelegateMessageSecurityResponseList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<MessageSecurityFlowParameter> arrayList;
        String nomeMetodo = "porteDelegateMessageSecurityResponseList";
        int idLista = Liste.PORTE_DELEGATE_MESSAGE_SECURITY_RESPONSE;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<MessageSecurityFlowParameter> lista = new ArrayList<MessageSecurityFlowParameter>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteDelegateMessageSecurityResponseList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_security_response");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_security_response");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_security_response");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addSelectField("enc_value");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_security_response");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("valore");
                sqlQueryObject.addSelectField("enc_value");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                MessageSecurityFlowParameter wsresp = new MessageSecurityFlowParameter();
                wsresp.setId(risultato.getLong("id_porta"));
                wsresp.setNome(risultato.getString("nome"));
                String plainValue = risultato.getString("valore");
                String encValue = risultato.getString("enc_value");
                if (encValue != null && StringUtils.isNotEmpty((CharSequence)encValue)) {
                    wsresp.setValore(encValue);
                } else {
                    wsresp.setValore(plainValue);
                }
                lista.add(wsresp);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<CorrelazioneApplicativaElemento> porteDelegateCorrelazioneApplicativaList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<CorrelazioneApplicativaElemento> arrayList;
        String nomeMetodo = "porteDelegateCorrelazioneApplicativaList";
        int idLista = Liste.PORTE_DELEGATE_CORRELAZIONE_APPLICATIVA;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<CorrelazioneApplicativaElemento> lista = new ArrayList<CorrelazioneApplicativaElemento>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteDelegateCorrelazioneApplicativaList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_correlazione");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome_elemento", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_correlazione");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_correlazione");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_elemento");
                sqlQueryObject.addSelectField("mode_correlazione");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("identificazione_fallita");
                sqlQueryObject.addSelectField("riuso_id");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome_elemento", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("id");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_correlazione");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_elemento");
                sqlQueryObject.addSelectField("mode_correlazione");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("identificazione_fallita");
                sqlQueryObject.addSelectField("riuso_id");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("id");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            CorrelazioneApplicativaElemento cae = null;
            while (risultato.next()) {
                cae = new CorrelazioneApplicativaElemento();
                cae.setId(risultato.getLong("id"));
                cae.setNome(risultato.getString("nome_elemento"));
                cae.setIdentificazione(DriverConfigurazioneDBLib.getEnumCorrelazioneApplicativaRichiestaIdentificazione(risultato.getString("mode_correlazione")));
                cae.setIdentificazioneFallita(DriverConfigurazioneDBLib.getEnumCorrelazioneApplicativaGestioneIdentificazioneFallita(risultato.getString("identificazione_fallita")));
                cae.setRiusoIdentificativo(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(risultato.getString("riuso_id")));
                lista.add(cae);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<CorrelazioneApplicativaRispostaElemento> porteDelegateCorrelazioneApplicativaRispostaList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<CorrelazioneApplicativaRispostaElemento> arrayList;
        String nomeMetodo = "porteDelegateCorrelazioneApplicativaRispostaList";
        int idLista = Liste.PORTE_DELEGATE_CORRELAZIONE_APPLICATIVA_RISPOSTA;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<CorrelazioneApplicativaRispostaElemento> lista = new ArrayList<CorrelazioneApplicativaRispostaElemento>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("porteDelegateCorrelazioneApplicativaRispostaList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_correlazione_risposta");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome_elemento", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_correlazione_risposta");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_correlazione_risposta");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_elemento");
                sqlQueryObject.addSelectField("mode_correlazione");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("identificazione_fallita");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome_elemento", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("id");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_correlazione_risposta");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_elemento");
                sqlQueryObject.addSelectField("mode_correlazione");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("identificazione_fallita");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("id");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            CorrelazioneApplicativaRispostaElemento cae = null;
            while (risultato.next()) {
                cae = new CorrelazioneApplicativaRispostaElemento();
                cae.setId(risultato.getLong("id"));
                cae.setNome(risultato.getString("nome_elemento"));
                cae.setIdentificazione(DriverConfigurazioneDBLib.getEnumCorrelazioneApplicativaRispostaIdentificazione(risultato.getString("mode_correlazione")));
                cae.setIdentificazioneFallita(DriverConfigurazioneDBLib.getEnumCorrelazioneApplicativaGestioneIdentificazioneFallita(risultato.getString("identificazione_fallita")));
                lista.add(cae);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<PortaDelegata> serviziFruitoriPorteDelegateList(long idSoggetto, String tipoServizio, String nomeServizio, Long idServizio, String tipoSoggettoErogatore, String nomeSoggettoErogatore, Long idSoggettoErogatore, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<PortaDelegata> arrayList;
        String nomeMetodo = "serviziFruitoriPorteDelegateList";
        int idLista = Liste.SERVIZI_FRUITORI_PORTE_DELEGATE;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortaDelegata> lista = new ArrayList<PortaDelegata>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                if (idSoggettoErogatore != null && idSoggettoErogatore > 0L) {
                    sqlQueryObject.addWhereCondition(false, new String[]{"id_soggetto_erogatore=?", "tipo_soggetto_erogatore=? AND nome_soggetto_erogatore=?"});
                } else {
                    sqlQueryObject.addWhereCondition("tipo_soggetto_erogatore=?");
                    sqlQueryObject.addWhereCondition("nome_soggetto_erogatore=?");
                }
                if (idServizio != null && idServizio > 0L) {
                    sqlQueryObject.addWhereCondition(false, new String[]{"id_servizio=?", "tipo_servizio=? AND nome_servizio=?"});
                } else {
                    sqlQueryObject.addWhereCondition("tipo_servizio=?");
                    sqlQueryObject.addWhereCondition("nome_servizio=?");
                }
                sqlQueryObject.addWhereLikeCondition("nome_porta", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                if (idSoggettoErogatore != null && idSoggettoErogatore > 0L) {
                    sqlQueryObject.addWhereCondition(false, new String[]{"id_soggetto_erogatore=?", "tipo_soggetto_erogatore=? AND nome_soggetto_erogatore=?"});
                } else {
                    sqlQueryObject.addWhereCondition("tipo_soggetto_erogatore=?");
                    sqlQueryObject.addWhereCondition("nome_soggetto_erogatore=?");
                }
                if (idServizio != null && idServizio > 0L) {
                    sqlQueryObject.addWhereCondition(false, new String[]{"id_servizio=?", "tipo_servizio=? AND nome_servizio=?"});
                } else {
                    sqlQueryObject.addWhereCondition("tipo_servizio=?");
                    sqlQueryObject.addWhereCondition("nome_servizio=?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            int index = 1;
            stmt.setLong(index++, idSoggetto);
            if (idSoggettoErogatore != null && idSoggettoErogatore > 0L) {
                stmt.setLong(index++, idSoggettoErogatore);
            }
            stmt.setString(index++, tipoSoggettoErogatore);
            stmt.setString(index++, nomeSoggettoErogatore);
            if (idServizio != null && idServizio > 0L) {
                stmt.setLong(index++, idServizio);
            }
            stmt.setString(index++, tipoServizio);
            stmt.setString(index++, nomeServizio);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_porta");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                if (idSoggettoErogatore != null && idSoggettoErogatore > 0L) {
                    sqlQueryObject.addWhereCondition(false, new String[]{"id_soggetto_erogatore=?", "tipo_soggetto_erogatore=? AND nome_soggetto_erogatore=?"});
                } else {
                    sqlQueryObject.addWhereCondition("tipo_soggetto_erogatore=?");
                    sqlQueryObject.addWhereCondition("nome_soggetto_erogatore=?");
                }
                if (idServizio != null && idServizio > 0L) {
                    sqlQueryObject.addWhereCondition(false, new String[]{"id_servizio=?", "tipo_servizio=? AND nome_servizio=?"});
                } else {
                    sqlQueryObject.addWhereCondition("tipo_servizio=?");
                    sqlQueryObject.addWhereCondition("nome_servizio=?");
                }
                sqlQueryObject.addWhereLikeCondition("nome_porta", search, true, true);
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome_porta");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("porte_delegate");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome_porta");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                if (idSoggettoErogatore != null && idSoggettoErogatore > 0L) {
                    sqlQueryObject.addWhereCondition(false, new String[]{"id_soggetto_erogatore=?", "tipo_soggetto_erogatore=? AND nome_soggetto_erogatore=?"});
                } else {
                    sqlQueryObject.addWhereCondition("tipo_soggetto_erogatore=?");
                    sqlQueryObject.addWhereCondition("nome_soggetto_erogatore=?");
                }
                if (idServizio != null && idServizio > 0L) {
                    sqlQueryObject.addWhereCondition(false, new String[]{"id_servizio=?", "tipo_servizio=? AND nome_servizio=?"});
                } else {
                    sqlQueryObject.addWhereCondition("tipo_servizio=?");
                    sqlQueryObject.addWhereCondition("nome_servizio=?");
                }
                sqlQueryObject.setSelectDistinct(true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome_porta");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            index = 1;
            stmt.setLong(index++, idSoggetto);
            if (idSoggettoErogatore != null && idSoggettoErogatore > 0L) {
                stmt.setLong(index++, idSoggettoErogatore);
            }
            stmt.setString(index++, tipoSoggettoErogatore);
            stmt.setString(index++, nomeSoggettoErogatore);
            if (idServizio != null && idServizio > 0L) {
                stmt.setLong(index++, idServizio);
            }
            stmt.setString(index++, tipoServizio);
            stmt.setString(index++, nomeServizio);
            risultato = stmt.executeQuery();
            PortaDelegata pd = null;
            while (risultato.next()) {
                pd = this.porteDelegateDriver.getPortaDelegata(risultato.getLong("id"));
                lista.add(pd);
            }
            arrayList = lista;
        }
        catch (Exception se) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<PortaDelegata> getPorteDelegateByFruitore(IDSoggetto fruitore, ISearch filters) throws DriverConfigurazioneException {
        return this.getPorteDelegate(null, fruitore, filters);
    }

    protected List<PortaDelegata> getPorteDelegate(IDServizio idSE, IDSoggetto fruitore, ISearch filters) throws DriverConfigurazioneException {
        ArrayList<PortaDelegata> arrayList;
        String search;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        String queryString = "";
        int idLista = Liste.PORTE_DELEGATE;
        int limit = filters.getPageSize(idLista);
        int offset = filters.getIndexIniziale(idLista);
        String string = search = "undefined".equals(filters.getSearchString(idLista)) ? "" : filters.getSearchString(idLista);
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getPorteDelegate(idServizio,fruitore)");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getPorteDelegate] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        ArrayList<PortaDelegata> lista = null;
        try {
            IDSoggetto erogatore = null;
            String nomeErogatore = null;
            String tipoErogatore = null;
            String tipoServizio = null;
            String nomeServizio = null;
            Integer versioneServizio = null;
            if (idSE != null) {
                erogatore = idSE.getSoggettoErogatore();
                nomeErogatore = erogatore.getNome();
                tipoErogatore = erogatore.getTipo();
                tipoServizio = idSE.getTipo();
                nomeServizio = idSE.getNome();
                versioneServizio = idSE.getVersione();
            }
            long idSoggettoFruitore = DBUtils.getIdSoggetto(fruitore.getNome(), fruitore.getTipo(), con, this.driver.tipoDB);
            long idSoggettoErogatore = -1L;
            long idServizio = -1L;
            if (idSE != null) {
                idSoggettoErogatore = DBUtils.getIdSoggetto(erogatore.getNome(), erogatore.getTipo(), con, this.driver.tipoDB);
                idServizio = DBUtils.getIdServizio(nomeServizio, tipoServizio, versioneServizio, erogatore.getNome(), erogatore.getTipo(), con, this.driver.tipoDB);
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.setANDLogicOperator(true);
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome_porta", search, true, true);
            }
            if ((risultato = (stmt = con.prepareStatement(queryString = sqlQueryObject.createSQLQuery())).executeQuery()).next()) {
                filters.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("porte_delegate");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome_porta");
            sqlQueryObject.addWhereCondition("id_soggetto=?");
            sqlQueryObject.setANDLogicOperator(true);
            if (idSE != null) {
                sqlQueryObject.addWhereCondition(false, new String[]{"id_servizio=?", "tipo_servizio=? AND nome_servizio=?"});
                sqlQueryObject.addWhereCondition(false, new String[]{"id_soggetto_erogatore=?", "nome_soggetto_erogatore=? AND tipo_soggetto_erogatore=?"});
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome_porta", search, true, true);
            }
            sqlQueryObject.addOrderBy("nome_porta");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggettoFruitore);
            if (idSE != null) {
                stmt.setLong(2, idServizio);
                stmt.setString(3, tipoServizio);
                stmt.setString(4, nomeServizio);
                stmt.setLong(5, idSoggettoErogatore);
                stmt.setString(6, nomeErogatore);
                stmt.setString(7, tipoErogatore);
            }
            risultato = stmt.executeQuery();
            lista = new ArrayList<PortaDelegata>();
            while (risultato.next()) {
                long id = risultato.getLong("id");
                PortaDelegata pd = this.porteDelegateDriver.getPortaDelegata(id);
                lista.add(pd);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException(qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<MtomProcessorFlowParameter> porteDelegateMTOMRequestList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<MtomProcessorFlowParameter> arrayList;
        String nomeMetodo = "porteDelegateMTOMRequestList";
        int idLista = Liste.PORTE_DELEGATE_MTOM_REQUEST;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<MtomProcessorFlowParameter> lista = new ArrayList<MtomProcessorFlowParameter>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_mtom_request");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_mtom_request");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_mtom_request");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("pattern");
                sqlQueryObject.addSelectField("content_type");
                sqlQueryObject.addSelectField("required");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_mtom_request");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("pattern");
                sqlQueryObject.addSelectField("content_type");
                sqlQueryObject.addSelectField("required");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                MtomProcessorFlowParameter reqPar = new MtomProcessorFlowParameter();
                reqPar.setId(risultato.getLong("id_porta"));
                reqPar.setNome(risultato.getString("nome"));
                reqPar.setPattern(risultato.getString("pattern"));
                reqPar.setContentType(risultato.getString("content_type"));
                int required = risultato.getInt("required");
                boolean isrequired = false;
                if (required == 1) {
                    isrequired = true;
                }
                reqPar.setRequired(isrequired);
                lista.add(reqPar);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<MtomProcessorFlowParameter> porteDelegateMTOMResponseList(long idPortaDelegata, ISearch ricerca) throws DriverConfigurazioneException {
        ArrayList<MtomProcessorFlowParameter> arrayList;
        String nomeMetodo = "porteDelegateMTOMResponseList";
        int idLista = Liste.PORTE_DELEGATE_MTOM_RESPONSE;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<MtomProcessorFlowParameter> lista = new ArrayList<MtomProcessorFlowParameter>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_mtom_response");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_mtom_response");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_mtom_response");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("pattern");
                sqlQueryObject.addSelectField("content_type");
                sqlQueryObject.addSelectField("required");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("pd_mtom_response");
                sqlQueryObject.addSelectField("id_porta");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("pattern");
                sqlQueryObject.addSelectField("content_type");
                sqlQueryObject.addSelectField("required");
                sqlQueryObject.addWhereCondition("id_porta = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortaDelegata);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                MtomProcessorFlowParameter resPar = new MtomProcessorFlowParameter();
                resPar.setId(risultato.getLong("id_porta"));
                resPar.setNome(risultato.getString("nome"));
                resPar.setPattern(risultato.getString("pattern"));
                resPar.setContentType(risultato.getString("content_type"));
                int required = risultato.getInt("required");
                boolean isrequired = false;
                if (required == 1) {
                    isrequired = true;
                }
                resPar.setRequired(isrequired);
                lista.add(resPar);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }
}

