/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.controllo_traffico.beans;

import java.util.ArrayList;
import java.util.List;

public class StatoViolazioniPolicy {
    private List<String> violazioni = new ArrayList<String>();
    private List<String> violazioniWarningOnly = new ArrayList<String>();
    private static String RAGGRUPPAMENTO_DISABILITATO = "*";
    private static String SEPARATOR_VIOLAZIONE = "\n- ";
    private static String SEPARATOR_TRA_VIOLATE_E_WARNING = "\n\n";
    private static String WARN = "in modalit\u00e0 WarningOnly";

    public StatoViolazioniPolicy(String statoAttuale) {
        String entry;
        int i;
        String[] tmp;
        if (statoAttuale == null) {
            return;
        }
        String violate = null;
        String violateWarningOnly = null;
        if (statoAttuale.contains(SEPARATOR_TRA_VIOLATE_E_WARNING)) {
            tmp = statoAttuale.split(SEPARATOR_TRA_VIOLATE_E_WARNING);
            for (i = 0; i < tmp.length; ++i) {
                entry = tmp[i];
                if (entry.contains(WARN)) {
                    violateWarningOnly = entry;
                    continue;
                }
                violate = entry;
            }
        } else if (statoAttuale.contains(WARN)) {
            violateWarningOnly = statoAttuale;
        } else {
            violate = statoAttuale;
        }
        if (violate != null) {
            if (violate.contains(SEPARATOR_VIOLAZIONE)) {
                tmp = statoAttuale.split(SEPARATOR_VIOLAZIONE);
                if (tmp != null && tmp.length > 1) {
                    for (i = 1; i < tmp.length; ++i) {
                        entry = tmp[i];
                        this.violazioni.add(entry);
                    }
                }
            } else {
                this.violazioni.add(violate);
            }
        }
        if (violateWarningOnly != null) {
            if (violateWarningOnly.contains(SEPARATOR_VIOLAZIONE)) {
                tmp = statoAttuale.split(SEPARATOR_VIOLAZIONE);
                if (tmp != null && tmp.length > 1) {
                    for (i = 1; i < tmp.length; ++i) {
                        entry = tmp[i];
                        this.violazioniWarningOnly.add(entry);
                    }
                }
            } else {
                this.violazioniWarningOnly.add(violateWarningOnly);
            }
        }
    }

    public String toString() {
        StringBuilder bf = new StringBuilder();
        if (this.violazioni.size() > 0) {
            if (this.violazioni.size() == 1) {
                bf.append("Rilevata violazione della policy: ");
            } else {
                bf.append("Rilevate ").append(this.violazioni.size()).append(" violazioni della policy: ");
            }
            for (String violazione : this.violazioni) {
                bf.append(SEPARATOR_VIOLAZIONE);
                bf.append(violazione);
            }
        }
        if (this.violazioniWarningOnly.size() > 0) {
            if (this.violazioni.size() > 0) {
                bf.append(SEPARATOR_TRA_VIOLATE_E_WARNING);
            }
            if (this.violazioniWarningOnly.size() == 1) {
                bf.append("Rilevata violazione (in modalit\u00e0 WarningOnly) della policy: ");
            } else {
                bf.append("Rilevate ").append(this.violazioniWarningOnly.size()).append(" violazioni (" + WARN + ") della policy: ");
            }
            for (String violazione : this.violazioniWarningOnly) {
                bf.append(SEPARATOR_VIOLAZIONE);
                bf.append(violazione);
            }
        }
        if (bf.length() > 0) {
            return bf.toString();
        }
        return "";
    }

    public void addViolazione(String gruppo, boolean warningOnly) {
        if (warningOnly) {
            this._addViolazione(gruppo, this.violazioniWarningOnly);
        } else {
            this._addViolazione(gruppo, this.violazioni);
        }
    }

    public boolean existsViolazione(String gruppo, boolean warningOnly) {
        if (warningOnly) {
            return this._existsViolazione(gruppo, this.violazioniWarningOnly);
        }
        return this._existsViolazione(gruppo, this.violazioni);
    }

    public boolean removeViolazione(String gruppo, boolean warningOnly) {
        if (warningOnly) {
            return this._removeViolazione(gruppo, this.violazioniWarningOnly);
        }
        return this._removeViolazione(gruppo, this.violazioni);
    }

    public int sizeViolazioni(boolean warningOnly) {
        if (warningOnly) {
            return this.violazioniWarningOnly.size();
        }
        return this.violazioni.size();
    }

    private void _addViolazione(String gruppo, List<String> violazioni) {
        if (gruppo == null || gruppo.equals("") || gruppo.equalsIgnoreCase("Disabilitato")) {
            gruppo = RAGGRUPPAMENTO_DISABILITATO;
        }
        if (!violazioni.contains(gruppo)) {
            violazioni.add(gruppo);
        }
    }

    private boolean _existsViolazione(String gruppo, List<String> violazioni) {
        if (gruppo == null || gruppo.equals("") || gruppo.equalsIgnoreCase("Disabilitato")) {
            gruppo = RAGGRUPPAMENTO_DISABILITATO;
        }
        return violazioni.contains(gruppo);
    }

    private boolean _removeViolazione(String gruppo, List<String> violazioni) {
        if (gruppo == null || gruppo.equals("") || gruppo.equalsIgnoreCase("Disabilitato")) {
            gruppo = RAGGRUPPAMENTO_DISABILITATO;
        }
        int i = -1;
        boolean found = false;
        for (i = 0; i < violazioni.size(); ++i) {
            if (!violazioni.get(i).equals(gruppo)) continue;
            found = true;
            break;
        }
        if (found) {
            violazioni.remove(i);
            return true;
        }
        return false;
    }
}

