/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.controllo_traffico.constants;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.controllo_traffico.driver.PolicyGroupByActiveThreadsType;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.MapKey;

public class Costanti {
    public static final MapKey<String> PDD_CONTEXT_NAME_CONTROLLO_TRAFFICO_VIOLAZIONE = Map.newMapKey((String)"controlloTrafficoViolazione");
    public static final String PDD_CONTEXT_VALUE_CONNECTION_TIMEOUT = "controlloTrafficoConnectionTimeout";
    public static final String PDD_CONTEXT_VALUE_REQUEST_READ_TIMEOUT = "controlloTrafficoRequestReadTimeout";
    public static final String PDD_CONTEXT_VALUE_RESPONSE_READ_TIMEOUT = "controlloTrafficoResponseReadTimeout";
    public static final String PDD_CONTEXT_VALUE_READ_TIMEOUT = "controlloTrafficoReadTimeout";
    public static final String PDD_CONTEXT_VALUE_POLICY_VIOLATA = "controlloTrafficoRateLimitingPolicyViolata";
    public static final String PDD_CONTEXT_VALUE_POLICY_VIOLATA_WARNING_ONLY = "controlloTrafficoRateLimitingPolicyViolataWarningOnly";
    public static final String PDD_CONTEXT_VALUE_POLICY_IN_ERRORE = "controlloTrafficoRateLimitingPolicyInErrore";
    public static final MapKey<String> PDD_CONTEXT_VALUE_POLICY_IN_ERROR_ESITO = Map.newMapKey((String)"controlloTrafficoRateLimitingPolicyInErroreEsito");
    public static final String SEPARATORE_IDPOLICY_RAGGRUPPAMENTO = " - ";
    private static String controlloTrafficoImagePrefix = "image";
    private static String controlloTrafficoEventiImagePrefix = "imageEventi";
    private static String controlloTrafficoImageExt = ".bin";
    public static final String POLICY_GLOBALE = "Globale";
    public static final String POLICY_API = "API";
    public static final String GESTORE = "ctGestore";
    public static final String GESTORE_HAZELCAST_MAP_BACKWARD_COMPATIBILITY = "HAZELCAST";
    public static final String GESTORE_CONFIG_DATE = "ctGestoreConfigDate";
    public static final String MODALITA_SINCRONIZZAZIONE = "ctSyncMode";
    public static final String VALUE_MODALITA_SINCRONIZZAZIONE_DEFAULT = "default";
    public static final String VALUE_MODALITA_SINCRONIZZAZIONE_LOCALE = "locale";
    public static final String VALUE_MODALITA_SINCRONIZZAZIONE_LOCALE_SUDDIVISA_TRA_NODI = "localePiuNodi";
    public static final String VALUE_MODALITA_SINCRONIZZAZIONE_DISTRIBUITA = "distribuita";
    public static final String LABEL_MODALITA_SINCRONIZZAZIONE = "Sincronizzazione";
    public static final String LABEL_MODALITA_SINCRONIZZAZIONE_DEFAULT = "Default";
    public static final String LABEL_MODALITA_SINCRONIZZAZIONE_LOCALE = "Locale";
    public static final String LABEL_MODALITA_SINCRONIZZAZIONE_LOCALE_SUDDIVISA_TRA_NODI = "Locale - Quota divisa sui nodi";
    public static final String LABEL_MODALITA_SINCRONIZZAZIONE_DISTRIBUITA = "Distribuita";
    public static final String MODALITA_IMPLEMENTAZIONE = "ctImpl";
    public static final String VALUE_MODALITA_IMPLEMENTAZIONE_DATABASE = "database";
    public static final String VALUE_MODALITA_IMPLEMENTAZIONE_HAZELCAST = "hazelcast";
    public static final String VALUE_MODALITA_IMPLEMENTAZIONE_REDIS = "redis";
    public static final String LABEL_MODALITA_IMPLEMENTAZIONE = "Implementazione";
    public static final String LABEL_MODALITA_IMPLEMENTAZIONE_DATABASE = "embedded";
    public static final String LABEL_MODALITA_IMPLEMENTAZIONE_HAZELCAST = "hazelcast";
    public static final String LABEL_MODALITA_IMPLEMENTAZIONE_REDIS = "redis";
    public static final String MODALITA_CONTATORI = "ctCount";
    public static final String VALUE_MODALITA_CONTATORI_EXACT = "exact";
    public static final String VALUE_MODALITA_CONTATORI_APPROXIMATED = "approximated";
    public static final String VALUE_MODALITA_CONTATORI_INCONSISTENT = "inconsistent";
    public static final String LABEL_MODALITA_CONTATORI = "Misurazione";
    public static final String LABEL_MODALITA_CONTATORI_EXACT = "esatta";
    public static final String LABEL_MODALITA_CONTATORI_APPROXIMATED = "approssimata";
    public static final String LABEL_MODALITA_CONTATORI_INCONSISTENT = "inconsistente";
    public static final String MODALITA_TIPOLOGIA = "ctEngineType";
    public static final String VALUE_MODALITA_TIPOLOGIA_HAZELCAST_FULL_SYNC = "full-sync";
    public static final String VALUE_MODALITA_TIPOLOGIA_HAZELCAST_NEAR_CACHE = "near-cache";
    public static final String VALUE_MODALITA_TIPOLOGIA_HAZELCAST_LOCAL_CACHE = "local-cache";
    public static final String VALUE_MODALITA_TIPOLOGIA_HAZELCAST_REMOTE_SYNC = "remote-sync";
    public static final String VALUE_MODALITA_TIPOLOGIA_HAZELCAST_REMOTE_ASYNC = "remote-async";
    public static final String VALUE_MODALITA_TIPOLOGIA_HAZELCAST_REPLICATED_MAP = "replicated-map";
    public static final String VALUE_MODALITA_TIPOLOGIA_HAZELCAST_CONTATORI_ATOMIC_LONG = "atomic-long-counters";
    public static final String VALUE_MODALITA_TIPOLOGIA_HAZELCAST_CONTATORI_ATOMIC_LONG_ASYNC = "atomic-long-async-counters";
    public static final String VALUE_MODALITA_TIPOLOGIA_HAZELCAST_CONTATORI_PNCOUNTER = "pn-counters";
    public static final String VALUE_MODALITA_TIPOLOGIA_REDIS_REDDISSON_MAP = "redisson-map";
    public static final String VALUE_MODALITA_TIPOLOGIA_REDIS_CONTATORI_ATOMIC_LONG = "atomic-long-counters";
    public static final String VALUE_MODALITA_TIPOLOGIA_REDIS_CONTATORI_LONGADDER = "longadder-counters";
    public static final String LABEL_MODALITA_TIPOLOGIA = "Algoritmo";
    public static final String LABEL_MODALITA_TIPOLOGIA_HAZELCAST_FULL_SYNC = "map";
    public static final String LABEL_MODALITA_TIPOLOGIA_HAZELCAST_NEAR_CACHE = "near-cache";
    public static final String LABEL_MODALITA_TIPOLOGIA_HAZELCAST_LOCAL_CACHE = "local-cache";
    public static final String LABEL_MODALITA_TIPOLOGIA_HAZELCAST_REMOTE_SYNC = "remote-sync";
    public static final String LABEL_MODALITA_TIPOLOGIA_HAZELCAST_REMOTE_ASYNC = "remote-async";
    public static final String LABEL_MODALITA_TIPOLOGIA_HAZELCAST_REPLICATED_MAP = "replicated-map";
    public static final String LABEL_MODALITA_TIPOLOGIA_HAZELCAST_CONTATORI_ATOMIC_LONG = "atomic-long-counters";
    public static final String LABEL_MODALITA_TIPOLOGIA_HAZELCAST_CONTATORI_ATOMIC_LONG_ASYNC = "atomic-long-async-counters";
    public static final String LABEL_MODALITA_TIPOLOGIA_HAZELCAST_CONTATORI_PNCOUNTER = "pn-counters";
    public static final String LABEL_MODALITA_TIPOLOGIA_REDIS_REDDISSON = "map";
    public static final String LABEL_MODALITA_TIPOLOGIA_REDIS_CONTATORI_ATOMIC_LONG = "atomic-long-counters";
    public static final String LABEL_MODALITA_TIPOLOGIA_REDIS_CONTATORI_LONGADDER = "longadder-counters";
    public static final String VALUE_HTTP_HEADER_DEFAULT = "default";
    public static final String VALUE_HTTP_HEADER_DISABILITATO = "disabilitato";
    public static final String VALUE_HTTP_HEADER_ABILITATO = "abilitato";
    public static final String VALUE_HTTP_HEADER_ABILITATO_NO_WINDOWS = "noWindows";
    public static final String VALUE_HTTP_HEADER_ABILITATO_WINDOWS = "windows";
    public static final String VALUE_HTTP_HEADER_ABILITATO_NO_BACKOFF = "noBackoff";
    public static final String VALUE_HTTP_HEADER_ABILITATO_BACKOFF = "backoff";
    public static final String VALUE_HTTP_HEADER_RIDEFINITO = "ridefinito";
    public static final String LABEL_HTTP_HEADER_DEFAULT = "Default";
    public static final String LABEL_HTTP_HEADER_DISABILITATO = "Disabilitato";
    public static final String LABEL_HTTP_HEADER_ABILITATO = "Abilitato";
    public static final String LABEL_HTTP_HEADER_ABILITATO_NO_WINDOWS = "Abilitato (senza finestra temporale)";
    public static final String LABEL_HTTP_HEADER_ABILITATO_WINDOWS = "Abilitato (con finestra temporale)";
    public static final String LABEL_HTTP_HEADER_ABILITATO_NO_BACKOFF = "Abilitato (senza backoff)";
    public static final String LABEL_HTTP_HEADER_ABILITATO_BACKOFF = "Abilitato (con backoff)";
    public static final String LABEL_HTTP_HEADER_RIDEFINITO = "Ridefinito";
    public static final String MODALITA_GENERAZIONE_HEADER_HTTP = "ctHttpMode";
    public static final List<String> VALUES_MODALITA_GENERAZIONE_HEADER_HTTP = new ArrayList<String>();
    public static final String LABEL_MODALITA_GENERAZIONE_HEADER_HTTP = "HTTP Headers";
    public static final List<String> LABELS_MODALITA_GENERAZIONE_HEADER_HTTP;
    public static final String MODALITA_GENERAZIONE_HEADER_HTTP_LIMIT = "ctHttpQuota";
    public static final List<String> VALUES_MODALITA_GENERAZIONE_HEADER_HTTP_LIMIT;
    public static final String LABEL_MODALITA_GENERAZIONE_HEADER_HTTP_LIMIT = "Limiti di Quota";
    public static final List<String> LABELS_MODALITA_GENERAZIONE_HEADER_HTTP_LIMIT;
    public static final String MODALITA_GENERAZIONE_HEADER_HTTP_REMAINING = "ctHttpRemaining";
    public static final List<String> VALUES_MODALITA_GENERAZIONE_HEADER_HTTP_REMAINING;
    public static final String LABEL_MODALITA_GENERAZIONE_HEADER_HTTP_REMAINING = "Rimanenza della Quota";
    public static final List<String> LABELS_MODALITA_GENERAZIONE_HEADER_HTTP_REMAINING;
    public static final String MODALITA_GENERAZIONE_HEADER_HTTP_RESET = "ctHttpReset";
    public static final List<String> VALUES_MODALITA_GENERAZIONE_HEADER_HTTP_RESET;
    public static final String LABEL_MODALITA_GENERAZIONE_HEADER_HTTP_RESET = "Reset della Quota (secondi)";
    public static final List<String> LABELS_MODALITA_GENERAZIONE_HEADER_HTTP_RESET;
    public static final String MODALITA_GENERAZIONE_HEADER_HTTP_RETRY_AFTER = "ctHttpRetryAfter";
    public static final List<String> VALUES_MODALITA_GENERAZIONE_HEADER_HTTP_RETRY_AFTER;
    public static final String LABEL_MODALITA_GENERAZIONE_HEADER_HTTP_RETRY_AFTER = "Retry-After";
    public static final List<String> LABELS_MODALITA_GENERAZIONE_HEADER_HTTP_RETRY_AFTER;
    public static final String MODALITA_GENERAZIONE_HEADER_HTTP_RETRY_AFTER_BACKOFF_SECONDS = "ctHttpRetryAfterBackoff";
    public static final String LABEL_MODALITA_GENERAZIONE_HEADER_HTTP_RETRY_AFTER_BACKOFF_SECONDS = "Backoff (secondi)";

    private Costanti() {
    }

    public static String getControlloTrafficoImage(String ctPolicyType) {
        return Costanti.getEngineControlloTrafficoImagePrefix(ctPolicyType, controlloTrafficoImagePrefix);
    }

    public static String getControlloTrafficoEventiImage(String ctPolicyType) {
        return Costanti.getEngineControlloTrafficoImagePrefix(ctPolicyType, controlloTrafficoEventiImagePrefix);
    }

    private static String getEngineControlloTrafficoImagePrefix(String ctPolicyType, String prefix) {
        StringBuilder sb = new StringBuilder(prefix);
        if (ctPolicyType != null && !"LOCAL".equals(ctPolicyType)) {
            sb.append("-").append(ctPolicyType);
        }
        sb.append(controlloTrafficoImageExt);
        return sb.toString();
    }

    public static final List<String> getVALUES_MODALITA_SINCRONIZZAZIONE(List<PolicyGroupByActiveThreadsType> tipiSupportati) {
        return Costanti.getEngineMODALITA_SINCRONIZZAZIONE(tipiSupportati, true);
    }

    public static final List<String> getLABELS_MODALITA_SINCRONIZZAZIONE(List<PolicyGroupByActiveThreadsType> tipiSupportati) {
        return Costanti.getEngineMODALITA_SINCRONIZZAZIONE(tipiSupportati, false);
    }

    private static final List<String> getEngineMODALITA_SINCRONIZZAZIONE(List<PolicyGroupByActiveThreadsType> tipiSupportati, boolean values) {
        boolean locale = false;
        boolean localeNodi = false;
        boolean distribuita = false;
        for (PolicyGroupByActiveThreadsType tipo : tipiSupportati) {
            if (PolicyGroupByActiveThreadsType.LOCAL.equals((Object)tipo)) {
                locale = true;
                continue;
            }
            if (PolicyGroupByActiveThreadsType.LOCAL_DIVIDED_BY_NODES.equals((Object)tipo)) {
                localeNodi = true;
                continue;
            }
            distribuita = true;
        }
        ArrayList<String> l = new ArrayList<String>();
        l.add(values ? "default" : "Default");
        if (locale) {
            l.add(values ? VALUE_MODALITA_SINCRONIZZAZIONE_LOCALE : LABEL_MODALITA_SINCRONIZZAZIONE_LOCALE);
        }
        if (localeNodi) {
            l.add(values ? VALUE_MODALITA_SINCRONIZZAZIONE_LOCALE_SUDDIVISA_TRA_NODI : LABEL_MODALITA_SINCRONIZZAZIONE_LOCALE_SUDDIVISA_TRA_NODI);
        }
        if (distribuita) {
            l.add(values ? VALUE_MODALITA_SINCRONIZZAZIONE_DISTRIBUITA : LABEL_MODALITA_SINCRONIZZAZIONE_DISTRIBUITA);
        }
        return l;
    }

    public static final List<String> getVALUES_MODALITA_IMPLEMENTAZIONE(List<PolicyGroupByActiveThreadsType> tipiSupportati) {
        return Costanti.getEngineMODALITA_IMPLEMENTAZIONE(tipiSupportati, true);
    }

    public static final List<String> getLABELS_MODALITA_IMPLEMENTAZIONE(List<PolicyGroupByActiveThreadsType> tipiSupportati) {
        return Costanti.getEngineMODALITA_IMPLEMENTAZIONE(tipiSupportati, false);
    }

    private static final List<String> getEngineMODALITA_IMPLEMENTAZIONE(List<PolicyGroupByActiveThreadsType> tipiSupportati, boolean values) {
        boolean database = false;
        boolean hazelcast = false;
        boolean redis = false;
        for (PolicyGroupByActiveThreadsType tipo : tipiSupportati) {
            if (PolicyGroupByActiveThreadsType.DATABASE.equals((Object)tipo)) {
                database = true;
                continue;
            }
            if (tipo.isHazelcast()) {
                hazelcast = true;
                continue;
            }
            if (!tipo.isRedis()) continue;
            redis = true;
        }
        ArrayList<String> l = new ArrayList<String>();
        if (hazelcast) {
            l.add(values ? "hazelcast" : "hazelcast");
        }
        if (redis) {
            l.add(values ? "redis" : "redis");
        }
        if (database) {
            l.add(values ? VALUE_MODALITA_IMPLEMENTAZIONE_DATABASE : LABEL_MODALITA_IMPLEMENTAZIONE_DATABASE);
        }
        return l;
    }

    public static final List<String> getVALUES_MODALITA_CONTATORI(List<PolicyGroupByActiveThreadsType> tipiSupportati, String impl) {
        return Costanti.getEngineMODALITA_CONTATORI(tipiSupportati, impl, true);
    }

    public static final List<String> getLABELS_MODALITA_CONTATORI(List<PolicyGroupByActiveThreadsType> tipiSupportati, String impl) {
        return Costanti.getEngineMODALITA_CONTATORI(tipiSupportati, impl, false);
    }

    private static final List<String> getEngineMODALITA_CONTATORI(List<PolicyGroupByActiveThreadsType> tipiSupportati, String impl, boolean values) {
        boolean exact = false;
        boolean approximated = false;
        boolean inconsistent = false;
        if ("hazelcast".equals(impl)) {
            for (PolicyGroupByActiveThreadsType tipo : tipiSupportati) {
                if (!tipo.isHazelcast()) continue;
                if (tipo.isExact()) {
                    exact = true;
                    continue;
                }
                if (tipo.isApproximated()) {
                    approximated = true;
                    continue;
                }
                if (!tipo.isInconsistent()) continue;
                inconsistent = true;
            }
        } else if ("redis".equals(impl)) {
            for (PolicyGroupByActiveThreadsType tipo : tipiSupportati) {
                if (!tipo.isRedis()) continue;
                if (tipo.isExact()) {
                    exact = true;
                    continue;
                }
                if (tipo.isApproximated()) {
                    approximated = true;
                    continue;
                }
                if (!tipo.isInconsistent()) continue;
                inconsistent = true;
            }
        }
        ArrayList<String> l = new ArrayList<String>();
        if (exact) {
            l.add(values ? VALUE_MODALITA_CONTATORI_EXACT : LABEL_MODALITA_CONTATORI_EXACT);
        }
        if (approximated) {
            l.add(values ? VALUE_MODALITA_CONTATORI_APPROXIMATED : LABEL_MODALITA_CONTATORI_APPROXIMATED);
        }
        if (inconsistent) {
            l.add(values ? VALUE_MODALITA_CONTATORI_INCONSISTENT : LABEL_MODALITA_CONTATORI_INCONSISTENT);
        }
        return l;
    }

    public static final List<String> getVALUES_MODALITA_TIPOLOGIA(List<PolicyGroupByActiveThreadsType> tipiSupportati, String impl, String counter) {
        return Costanti.getEngineMODALITA_TIPOLOGIA(tipiSupportati, impl, counter, true);
    }

    public static final List<String> getLABELS_MODALITA_TIPOLOGIA(List<PolicyGroupByActiveThreadsType> tipiSupportati, String impl, String counter) {
        return Costanti.getEngineMODALITA_TIPOLOGIA(tipiSupportati, impl, counter, false);
    }

    private static final List<String> getEngineMODALITA_TIPOLOGIA(List<PolicyGroupByActiveThreadsType> tipiSupportati, String impl, String counter, boolean values) {
        ArrayList<String> l;
        block13: {
            block12: {
                l = new ArrayList<String>();
                if (!"hazelcast".equals(impl)) break block12;
                for (PolicyGroupByActiveThreadsType tipo : tipiSupportati) {
                    if (VALUE_MODALITA_CONTATORI_EXACT.equals(counter)) {
                        if (PolicyGroupByActiveThreadsType.HAZELCAST_ATOMIC_LONG.equals((Object)tipo)) {
                            l.add(values ? "atomic-long-counters" : "atomic-long-counters");
                            continue;
                        }
                        if (!PolicyGroupByActiveThreadsType.HAZELCAST_MAP.equals((Object)tipo)) continue;
                        l.add(values ? VALUE_MODALITA_TIPOLOGIA_HAZELCAST_FULL_SYNC : "map");
                        continue;
                    }
                    if (VALUE_MODALITA_CONTATORI_APPROXIMATED.equals(counter)) {
                        if (PolicyGroupByActiveThreadsType.HAZELCAST_PNCOUNTER.equals((Object)tipo)) {
                            l.add(values ? "pn-counters" : "pn-counters");
                            continue;
                        }
                        if (PolicyGroupByActiveThreadsType.HAZELCAST_ATOMIC_LONG_ASYNC.equals((Object)tipo)) {
                            l.add(values ? "atomic-long-async-counters" : "atomic-long-async-counters");
                            continue;
                        }
                        if (PolicyGroupByActiveThreadsType.HAZELCAST_NEAR_CACHE.equals((Object)tipo)) {
                            l.add(values ? "near-cache" : "near-cache");
                            continue;
                        }
                        if (!PolicyGroupByActiveThreadsType.HAZELCAST_LOCAL_CACHE.equals((Object)tipo)) continue;
                        l.add(values ? "local-cache" : "local-cache");
                        continue;
                    }
                    if (!VALUE_MODALITA_CONTATORI_INCONSISTENT.equals(counter)) continue;
                    if (PolicyGroupByActiveThreadsType.HAZELCAST_NEAR_CACHE_UNSAFE_SYNC_MAP.equals((Object)tipo)) {
                        l.add(values ? "remote-sync" : "remote-sync");
                        continue;
                    }
                    if (PolicyGroupByActiveThreadsType.HAZELCAST_NEAR_CACHE_UNSAFE_ASYNC_MAP.equals((Object)tipo)) {
                        l.add(values ? "remote-async" : "remote-async");
                        continue;
                    }
                    if (!PolicyGroupByActiveThreadsType.HAZELCAST_REPLICATED_MAP.equals((Object)tipo)) continue;
                    l.add(values ? "replicated-map" : "replicated-map");
                }
                break block13;
            }
            if (!"redis".equals(impl)) break block13;
            for (PolicyGroupByActiveThreadsType tipo : tipiSupportati) {
                if (VALUE_MODALITA_CONTATORI_EXACT.equals(counter)) {
                    if (PolicyGroupByActiveThreadsType.REDISSON_ATOMIC_LONG.equals((Object)tipo)) {
                        l.add(values ? "atomic-long-counters" : "atomic-long-counters");
                        continue;
                    }
                    if (!PolicyGroupByActiveThreadsType.REDISSON_MAP.equals((Object)tipo)) continue;
                    l.add(values ? VALUE_MODALITA_TIPOLOGIA_REDIS_REDDISSON_MAP : "map");
                    continue;
                }
                if (!VALUE_MODALITA_CONTATORI_INCONSISTENT.equals(counter) || !PolicyGroupByActiveThreadsType.REDISSON_LONGADDER.equals((Object)tipo)) continue;
                l.add(values ? "longadder-counters" : "longadder-counters");
            }
        }
        return l;
    }

    static {
        VALUES_MODALITA_GENERAZIONE_HEADER_HTTP.add("default");
        VALUES_MODALITA_GENERAZIONE_HEADER_HTTP.add(VALUE_HTTP_HEADER_DISABILITATO);
        VALUES_MODALITA_GENERAZIONE_HEADER_HTTP.add(VALUE_HTTP_HEADER_RIDEFINITO);
        LABELS_MODALITA_GENERAZIONE_HEADER_HTTP = new ArrayList<String>();
        LABELS_MODALITA_GENERAZIONE_HEADER_HTTP.add("Default");
        LABELS_MODALITA_GENERAZIONE_HEADER_HTTP.add(LABEL_HTTP_HEADER_DISABILITATO);
        LABELS_MODALITA_GENERAZIONE_HEADER_HTTP.add(LABEL_HTTP_HEADER_RIDEFINITO);
        VALUES_MODALITA_GENERAZIONE_HEADER_HTTP_LIMIT = new ArrayList<String>();
        VALUES_MODALITA_GENERAZIONE_HEADER_HTTP_LIMIT.add("default");
        VALUES_MODALITA_GENERAZIONE_HEADER_HTTP_LIMIT.add(VALUE_HTTP_HEADER_ABILITATO_NO_WINDOWS);
        VALUES_MODALITA_GENERAZIONE_HEADER_HTTP_LIMIT.add(VALUE_HTTP_HEADER_ABILITATO_WINDOWS);
        VALUES_MODALITA_GENERAZIONE_HEADER_HTTP_LIMIT.add(VALUE_HTTP_HEADER_DISABILITATO);
        LABELS_MODALITA_GENERAZIONE_HEADER_HTTP_LIMIT = new ArrayList<String>();
        LABELS_MODALITA_GENERAZIONE_HEADER_HTTP_LIMIT.add("Default");
        LABELS_MODALITA_GENERAZIONE_HEADER_HTTP_LIMIT.add(LABEL_HTTP_HEADER_ABILITATO_NO_WINDOWS);
        LABELS_MODALITA_GENERAZIONE_HEADER_HTTP_LIMIT.add(LABEL_HTTP_HEADER_ABILITATO_WINDOWS);
        LABELS_MODALITA_GENERAZIONE_HEADER_HTTP_LIMIT.add(LABEL_HTTP_HEADER_DISABILITATO);
        VALUES_MODALITA_GENERAZIONE_HEADER_HTTP_REMAINING = new ArrayList<String>();
        VALUES_MODALITA_GENERAZIONE_HEADER_HTTP_REMAINING.add("default");
        VALUES_MODALITA_GENERAZIONE_HEADER_HTTP_REMAINING.add(VALUE_HTTP_HEADER_ABILITATO);
        VALUES_MODALITA_GENERAZIONE_HEADER_HTTP_REMAINING.add(VALUE_HTTP_HEADER_DISABILITATO);
        LABELS_MODALITA_GENERAZIONE_HEADER_HTTP_REMAINING = new ArrayList<String>();
        LABELS_MODALITA_GENERAZIONE_HEADER_HTTP_REMAINING.add("Default");
        LABELS_MODALITA_GENERAZIONE_HEADER_HTTP_REMAINING.add(LABEL_HTTP_HEADER_ABILITATO);
        LABELS_MODALITA_GENERAZIONE_HEADER_HTTP_REMAINING.add(LABEL_HTTP_HEADER_DISABILITATO);
        VALUES_MODALITA_GENERAZIONE_HEADER_HTTP_RESET = new ArrayList<String>();
        VALUES_MODALITA_GENERAZIONE_HEADER_HTTP_RESET.add("default");
        VALUES_MODALITA_GENERAZIONE_HEADER_HTTP_RESET.add(VALUE_HTTP_HEADER_ABILITATO);
        VALUES_MODALITA_GENERAZIONE_HEADER_HTTP_RESET.add(VALUE_HTTP_HEADER_DISABILITATO);
        LABELS_MODALITA_GENERAZIONE_HEADER_HTTP_RESET = new ArrayList<String>();
        LABELS_MODALITA_GENERAZIONE_HEADER_HTTP_RESET.add("Default");
        LABELS_MODALITA_GENERAZIONE_HEADER_HTTP_RESET.add(LABEL_HTTP_HEADER_ABILITATO);
        LABELS_MODALITA_GENERAZIONE_HEADER_HTTP_RESET.add(LABEL_HTTP_HEADER_DISABILITATO);
        VALUES_MODALITA_GENERAZIONE_HEADER_HTTP_RETRY_AFTER = new ArrayList<String>();
        VALUES_MODALITA_GENERAZIONE_HEADER_HTTP_RETRY_AFTER.add("default");
        VALUES_MODALITA_GENERAZIONE_HEADER_HTTP_RETRY_AFTER.add(VALUE_HTTP_HEADER_ABILITATO_NO_BACKOFF);
        VALUES_MODALITA_GENERAZIONE_HEADER_HTTP_RETRY_AFTER.add(VALUE_HTTP_HEADER_ABILITATO_BACKOFF);
        VALUES_MODALITA_GENERAZIONE_HEADER_HTTP_RETRY_AFTER.add(VALUE_HTTP_HEADER_DISABILITATO);
        LABELS_MODALITA_GENERAZIONE_HEADER_HTTP_RETRY_AFTER = new ArrayList<String>();
        LABELS_MODALITA_GENERAZIONE_HEADER_HTTP_RETRY_AFTER.add("Default");
        LABELS_MODALITA_GENERAZIONE_HEADER_HTTP_RETRY_AFTER.add(LABEL_HTTP_HEADER_ABILITATO_NO_BACKOFF);
        LABELS_MODALITA_GENERAZIONE_HEADER_HTTP_RETRY_AFTER.add(LABEL_HTTP_HEADER_ABILITATO_BACKOFF);
        LABELS_MODALITA_GENERAZIONE_HEADER_HTTP_RETRY_AFTER.add(LABEL_HTTP_HEADER_DISABILITATO);
    }
}

