/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.plugins.dao.jdbc;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.plugins.ConfigurazioneFiltro;
import org.openspcoop2.core.plugins.IdConfigurazioneFiltro;
import org.openspcoop2.core.plugins.dao.IDBConfigurazioneFiltroServiceSearch;
import org.openspcoop2.core.plugins.dao.jdbc.JDBCLimitedServiceManager;
import org.openspcoop2.core.plugins.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.plugins.utils.ProjectInfo;
import org.openspcoop2.core.plugins.utils.XSDValidator;
import org.openspcoop2.generic_project.beans.FunctionField;
import org.openspcoop2.generic_project.beans.IDMappingBehaviour;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.beans.InUse;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.beans.Union;
import org.openspcoop2.generic_project.beans.UnionExpression;
import org.openspcoop2.generic_project.dao.IDBServiceUtilities;
import org.openspcoop2.generic_project.dao.jdbc.IJDBCServiceSearchWithId;
import org.openspcoop2.generic_project.dao.jdbc.JDBCExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCPaginatedExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCProperties;
import org.openspcoop2.generic_project.dao.jdbc.JDBCServiceManagerProperties;
import org.openspcoop2.generic_project.dao.jdbc.utils.IJDBCFetch;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBC_SQLObjectFactory;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.exception.ValidationException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.utils.beans.BaseBean;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.xml.AbstractValidatoreXSD;
import org.slf4j.Logger;

public class JDBCConfigurazioneFiltroServiceSearch
implements IDBConfigurazioneFiltroServiceSearch,
IDBServiceUtilities<ConfigurazioneFiltro> {
    protected JDBCServiceManagerProperties jdbcProperties = null;
    protected JDBCServiceManager jdbcServiceManager = null;
    protected Logger log = null;
    protected IJDBCServiceSearchWithId<ConfigurazioneFiltro, IdConfigurazioneFiltro, JDBCServiceManager> serviceSearch = null;
    protected JDBC_SQLObjectFactory jdbcSqlObjectFactory = null;
    private static final String PARAMETER_TYPE_PREFIX = "Parameter (type:";

    public JDBCConfigurazioneFiltroServiceSearch(JDBCServiceManager jdbcServiceManager) throws ServiceException {
        this.jdbcServiceManager = jdbcServiceManager;
        this.jdbcProperties = jdbcServiceManager.getJdbcProperties();
        this.log = jdbcServiceManager.getLog();
        String msgInit = JDBCConfigurazioneFiltroServiceSearch.class.getName() + " initialized";
        this.log.debug(msgInit);
        this.serviceSearch = (IJDBCServiceSearchWithId)JDBCProperties.getInstance((Package)JDBCServiceManager.class.getPackage(), (IProjectInfo)ProjectInfo.getInstance()).getServiceSearch("configurazioneFiltro");
        this.serviceSearch.setServiceManager((Object)new JDBCLimitedServiceManager(this.jdbcServiceManager));
        this.jdbcSqlObjectFactory = new JDBC_SQLObjectFactory();
    }

    protected void logError(Exception e) {
        if (e != null && this.log != null) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void logDebug(Exception e) {
        if (e != null && this.log != null) {
            this.log.debug(e.getMessage(), (Throwable)e);
        }
    }

    protected void logJDBCExpression(JDBCExpression jdbcExpression) throws ExpressionException {
        if (this.log != null) {
            String msgDebug = "sql = " + jdbcExpression.toSql();
            this.log.debug(msgDebug);
        }
    }

    protected void logJDBCPaginatedExpression(JDBCPaginatedExpression jdbcPaginatedExpression) throws ExpressionException {
        if (this.log != null) {
            String msgDebug = "sql = " + jdbcPaginatedExpression.toSql();
            this.log.debug(msgDebug);
        }
    }

    private ServiceException newServiceExceptionParameterObjIsNull() {
        return new ServiceException(PARAMETER_TYPE_PREFIX + ConfigurazioneFiltro.class.getName() + ") 'obj' is null");
    }

    protected ServiceException newServiceExceptionParameterIdIsNull() {
        return new ServiceException(PARAMETER_TYPE_PREFIX + IdConfigurazioneFiltro.class.getName() + ") 'id' is null");
    }

    private ServiceException newServiceExceptionParameterIdMappingResolutionBehaviourIsNull() {
        return new ServiceException(PARAMETER_TYPE_PREFIX + IDMappingBehaviour.class.getName() + ") 'idMappingResolutionBehaviour' is null");
    }

    protected ServiceException newServiceExceptionParameterExpressionWrongType(IExpression expression) {
        return new ServiceException(PARAMETER_TYPE_PREFIX + expression.getClass().getName() + ") 'expression' has wrong type, expect " + JDBCExpression.class.getName());
    }

    protected ServiceException newServiceExceptionParameterExpressionIsNull() {
        return new ServiceException(PARAMETER_TYPE_PREFIX + IExpression.class.getName() + ") 'expression' is null");
    }

    private ServiceException newServiceExceptionParameterPaginatedExpressionIsNull() {
        return new ServiceException(PARAMETER_TYPE_PREFIX + IPaginatedExpression.class.getName() + ") 'expression' is null");
    }

    private ServiceException newServiceExceptionParameterPaginatedExpressionIsNullErrorParameterPaginated() {
        return new ServiceException(PARAMETER_TYPE_PREFIX + IPaginatedExpression.class.getName() + ") 'paginatedExpression' is null");
    }

    private ServiceException newServiceExceptionParameterPaginatedExpressionWrongType(IPaginatedExpression expression) {
        return new ServiceException(PARAMETER_TYPE_PREFIX + expression.getClass().getName() + ") 'expression' has wrong type, expect " + JDBCPaginatedExpression.class.getName());
    }

    private ServiceException newServiceExceptionParameterPaginatedExpressionWrongTypeErrorParameterPaginated(IPaginatedExpression paginatedExpression) {
        return new ServiceException(PARAMETER_TYPE_PREFIX + paginatedExpression.getClass().getName() + ") 'paginatedExpression' has wrong type, expect " + JDBCPaginatedExpression.class.getName());
    }

    private ServiceException newServiceExceptionParameterUnionExpressionIsNull() {
        return new ServiceException(PARAMETER_TYPE_PREFIX + UnionExpression.class.getName() + ") 'unionExpression' is null");
    }

    private ServiceException newServiceExceptionParameterWithTypeTableIdLessEqualsZero() {
        return new ServiceException(PARAMETER_TYPE_PREFIX + IdConfigurazioneFiltro.class.getName() + ") 'tableId' is lessEquals 0");
    }

    private ServiceException newServiceExceptionParameterTableIdLessEqualsZero() {
        return new ServiceException("Parameter 'tableId' is less equals 0");
    }

    public void validate(ConfigurazioneFiltro configurazioneFiltro) throws ServiceException, ValidationException, NotImplementedException {
        org.openspcoop2.generic_project.utils.XSDValidator.validate((BaseBean)configurazioneFiltro, (Logger)this.log, (AbstractValidatoreXSD)XSDValidator.getXSDValidator(this.log));
    }

    public IJDBCFetch getFetch() {
        return this.serviceSearch.getFetch();
    }

    public ISQLFieldConverter getFieldConverter() {
        return this.serviceSearch.getFieldConverter();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IdConfigurazioneFiltro convertToId(ConfigurazioneFiltro obj) throws ServiceException, NotImplementedException {
        IdConfigurazioneFiltro idConfigurazioneFiltro;
        block7: {
            Connection connection = null;
            try {
                if (obj == null) {
                    throw this.newServiceExceptionParameterObjIsNull();
                }
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                idConfigurazioneFiltro = (IdConfigurazioneFiltro)this.serviceSearch.convertToId(this.jdbcProperties, this.log, connection, sqlQueryObject, (Object)obj);
                if (connection == null) break block7;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (Exception e2) {
                        this.logError(e2);
                        throw new ServiceException("ConvertToId not completed: " + e2.getMessage(), (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return idConfigurazioneFiltro;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConfigurazioneFiltro get(IdConfigurazioneFiltro id) throws ServiceException, NotFoundException, MultipleResultException, NotImplementedException {
        ConfigurazioneFiltro configurazioneFiltro;
        block8: {
            Connection connection = null;
            try {
                if (id == null) {
                    throw this.newServiceExceptionParameterIdIsNull();
                }
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                configurazioneFiltro = (ConfigurazioneFiltro)this.serviceSearch.get(this.jdbcProperties, this.log, connection, sqlQueryObject, (Object)id, null);
                if (connection == null) break block8;
            }
            catch (MultipleResultException | NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("Get not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return configurazioneFiltro;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConfigurazioneFiltro get(IdConfigurazioneFiltro id, IDMappingBehaviour idMappingResolutionBehaviour) throws ServiceException, NotFoundException, MultipleResultException, NotImplementedException {
        ConfigurazioneFiltro configurazioneFiltro;
        block9: {
            Connection connection = null;
            try {
                if (id == null) {
                    throw this.newServiceExceptionParameterIdIsNull();
                }
                if (idMappingResolutionBehaviour == null) {
                    throw this.newServiceExceptionParameterIdMappingResolutionBehaviourIsNull();
                }
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                configurazioneFiltro = (ConfigurazioneFiltro)this.serviceSearch.get(this.jdbcProperties, this.log, connection, sqlQueryObject, (Object)id, idMappingResolutionBehaviour);
                if (connection == null) break block9;
            }
            catch (MultipleResultException | NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("Get (idMappingResolutionBehaviour) not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return configurazioneFiltro;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exists(IdConfigurazioneFiltro id) throws MultipleResultException, ServiceException, NotImplementedException {
        boolean bl;
        block7: {
            Connection connection = null;
            try {
                if (id == null) {
                    throw this.newServiceExceptionParameterIdIsNull();
                }
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                bl = this.serviceSearch.exists(this.jdbcProperties, this.log, connection, sqlQueryObject, (Object)id);
                if (connection == null) break block7;
            }
            catch (MultipleResultException | NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (Exception e2) {
                        this.logError(e2);
                        throw new ServiceException("Exists not completed: " + e2.getMessage(), (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<IdConfigurazioneFiltro> findAllIds(IPaginatedExpression expression) throws ServiceException, NotImplementedException {
        List list;
        block8: {
            Connection connection = null;
            try {
                if (expression == null) {
                    throw this.newServiceExceptionParameterPaginatedExpressionIsNull();
                }
                if (!(expression instanceof JDBCPaginatedExpression)) {
                    throw this.newServiceExceptionParameterPaginatedExpressionWrongType(expression);
                }
                JDBCPaginatedExpression jdbcPaginatedExpression = (JDBCPaginatedExpression)expression;
                this.logJDBCPaginatedExpression(jdbcPaginatedExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                list = this.serviceSearch.findAllIds(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcPaginatedExpression, null);
                if (connection == null) break block8;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (Exception e2) {
                        this.logError(e2);
                        throw new ServiceException("FindAllIds not completed: " + e2.getMessage(), (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<IdConfigurazioneFiltro> findAllIds(IPaginatedExpression expression, IDMappingBehaviour idMappingResolutionBehaviour) throws ServiceException, NotImplementedException {
        List list;
        block9: {
            Connection connection = null;
            try {
                if (idMappingResolutionBehaviour == null) {
                    throw this.newServiceExceptionParameterIdMappingResolutionBehaviourIsNull();
                }
                if (expression == null) {
                    throw this.newServiceExceptionParameterPaginatedExpressionIsNull();
                }
                if (!(expression instanceof JDBCPaginatedExpression)) {
                    throw this.newServiceExceptionParameterPaginatedExpressionWrongType(expression);
                }
                JDBCPaginatedExpression jdbcPaginatedExpression = (JDBCPaginatedExpression)expression;
                this.logJDBCPaginatedExpression(jdbcPaginatedExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                list = this.serviceSearch.findAllIds(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcPaginatedExpression, idMappingResolutionBehaviour);
                if (connection == null) break block9;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (Exception e2) {
                        this.logError(e2);
                        throw new ServiceException("FindAllIds not completed: " + e2.getMessage(), (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ConfigurazioneFiltro> findAll(IPaginatedExpression expression) throws ServiceException, NotImplementedException {
        List list;
        block8: {
            Connection connection = null;
            try {
                if (expression == null) {
                    throw this.newServiceExceptionParameterPaginatedExpressionIsNull();
                }
                if (!(expression instanceof JDBCPaginatedExpression)) {
                    throw this.newServiceExceptionParameterPaginatedExpressionWrongType(expression);
                }
                JDBCPaginatedExpression jdbcPaginatedExpression = (JDBCPaginatedExpression)expression;
                this.logJDBCPaginatedExpression(jdbcPaginatedExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                list = this.serviceSearch.findAll(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcPaginatedExpression, null);
                if (connection == null) break block8;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (Exception e2) {
                        this.logError(e2);
                        throw new ServiceException("FindAll not completed: " + e2.getMessage(), (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ConfigurazioneFiltro> findAll(IPaginatedExpression expression, IDMappingBehaviour idMappingResolutionBehaviour) throws ServiceException, NotImplementedException {
        List list;
        block9: {
            Connection connection = null;
            try {
                if (idMappingResolutionBehaviour == null) {
                    throw this.newServiceExceptionParameterIdMappingResolutionBehaviourIsNull();
                }
                if (expression == null) {
                    throw this.newServiceExceptionParameterPaginatedExpressionIsNull();
                }
                if (!(expression instanceof JDBCPaginatedExpression)) {
                    throw this.newServiceExceptionParameterPaginatedExpressionWrongType(expression);
                }
                JDBCPaginatedExpression jdbcPaginatedExpression = (JDBCPaginatedExpression)expression;
                this.logJDBCPaginatedExpression(jdbcPaginatedExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                list = this.serviceSearch.findAll(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcPaginatedExpression, idMappingResolutionBehaviour);
                if (connection == null) break block9;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (Exception e2) {
                        this.logError(e2);
                        throw new ServiceException("FindAll not completed: " + e2.getMessage(), (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConfigurazioneFiltro find(IExpression expression) throws ServiceException, NotFoundException, MultipleResultException, NotImplementedException {
        ConfigurazioneFiltro configurazioneFiltro;
        block9: {
            Connection connection = null;
            try {
                if (expression == null) {
                    throw this.newServiceExceptionParameterExpressionIsNull();
                }
                if (!(expression instanceof JDBCExpression)) {
                    throw this.newServiceExceptionParameterExpressionWrongType(expression);
                }
                JDBCExpression jdbcExpression = (JDBCExpression)expression;
                this.logJDBCExpression(jdbcExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                configurazioneFiltro = (ConfigurazioneFiltro)this.serviceSearch.find(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcExpression, null);
                if (connection == null) break block9;
            }
            catch (MultipleResultException | NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("Find not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return configurazioneFiltro;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConfigurazioneFiltro find(IExpression expression, IDMappingBehaviour idMappingResolutionBehaviour) throws ServiceException, NotFoundException, MultipleResultException, NotImplementedException {
        ConfigurazioneFiltro configurazioneFiltro;
        block10: {
            Connection connection = null;
            try {
                if (idMappingResolutionBehaviour == null) {
                    throw this.newServiceExceptionParameterIdMappingResolutionBehaviourIsNull();
                }
                if (expression == null) {
                    throw this.newServiceExceptionParameterExpressionIsNull();
                }
                if (!(expression instanceof JDBCExpression)) {
                    throw this.newServiceExceptionParameterExpressionWrongType(expression);
                }
                JDBCExpression jdbcExpression = (JDBCExpression)expression;
                this.logJDBCExpression(jdbcExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                configurazioneFiltro = (ConfigurazioneFiltro)this.serviceSearch.find(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcExpression, idMappingResolutionBehaviour);
                if (connection == null) break block10;
            }
            catch (MultipleResultException | NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("Find not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return configurazioneFiltro;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NonNegativeNumber count(IExpression expression) throws ServiceException, NotImplementedException {
        NonNegativeNumber nonNegativeNumber;
        block8: {
            Connection connection = null;
            try {
                if (expression == null) {
                    throw this.newServiceExceptionParameterExpressionIsNull();
                }
                if (!(expression instanceof JDBCExpression)) {
                    throw this.newServiceExceptionParameterExpressionWrongType(expression);
                }
                JDBCExpression jdbcExpression = (JDBCExpression)expression;
                this.logJDBCExpression(jdbcExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                nonNegativeNumber = this.serviceSearch.count(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcExpression);
                if (connection == null) break block8;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (Exception e2) {
                        this.logError(e2);
                        throw new ServiceException("Count not completed: " + e2.getMessage(), (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return nonNegativeNumber;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InUse inUse(IdConfigurazioneFiltro id) throws ServiceException, NotFoundException, NotImplementedException {
        InUse inUse;
        block8: {
            Connection connection = null;
            try {
                if (id == null) {
                    throw this.newServiceExceptionParameterIdIsNull();
                }
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                inUse = this.serviceSearch.inUse(this.jdbcProperties, this.log, connection, sqlQueryObject, (Object)id);
                if (connection == null) break block8;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("InUse not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return inUse;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Object> select(IPaginatedExpression paginatedExpression, IField field) throws ServiceException, NotFoundException, NotImplementedException {
        List list;
        block9: {
            Connection connection = null;
            try {
                if (paginatedExpression == null) {
                    throw this.newServiceExceptionParameterPaginatedExpressionIsNullErrorParameterPaginated();
                }
                if (!(paginatedExpression instanceof JDBCPaginatedExpression)) {
                    throw this.newServiceExceptionParameterPaginatedExpressionWrongTypeErrorParameterPaginated(paginatedExpression);
                }
                JDBCPaginatedExpression jdbcPaginatedExpression = (JDBCPaginatedExpression)paginatedExpression;
                this.logJDBCPaginatedExpression(jdbcPaginatedExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                list = this.serviceSearch.select(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcPaginatedExpression, field);
                if (connection == null) break block9;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("Select 'field' not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Object> select(IPaginatedExpression paginatedExpression, boolean distinct, IField field) throws ServiceException, NotFoundException, NotImplementedException {
        List list;
        block9: {
            Connection connection = null;
            try {
                if (paginatedExpression == null) {
                    throw this.newServiceExceptionParameterPaginatedExpressionIsNullErrorParameterPaginated();
                }
                if (!(paginatedExpression instanceof JDBCPaginatedExpression)) {
                    throw this.newServiceExceptionParameterPaginatedExpressionWrongTypeErrorParameterPaginated(paginatedExpression);
                }
                JDBCPaginatedExpression jdbcPaginatedExpression = (JDBCPaginatedExpression)paginatedExpression;
                this.logJDBCPaginatedExpression(jdbcPaginatedExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                list = this.serviceSearch.select(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcPaginatedExpression, distinct, field);
                if (connection == null) break block9;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("Select 'distinct:" + distinct + "' field not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Map<String, Object>> select(IPaginatedExpression paginatedExpression, IField ... field) throws ServiceException, NotFoundException, NotImplementedException {
        List list;
        block9: {
            Connection connection = null;
            try {
                if (paginatedExpression == null) {
                    throw this.newServiceExceptionParameterPaginatedExpressionIsNullErrorParameterPaginated();
                }
                if (!(paginatedExpression instanceof JDBCPaginatedExpression)) {
                    throw this.newServiceExceptionParameterPaginatedExpressionWrongTypeErrorParameterPaginated(paginatedExpression);
                }
                JDBCPaginatedExpression jdbcPaginatedExpression = (JDBCPaginatedExpression)paginatedExpression;
                this.logJDBCPaginatedExpression(jdbcPaginatedExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                list = this.serviceSearch.select(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcPaginatedExpression, field);
                if (connection == null) break block9;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("Select not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Map<String, Object>> select(IPaginatedExpression paginatedExpression, boolean distinct, IField ... field) throws ServiceException, NotFoundException, NotImplementedException {
        List list;
        block9: {
            Connection connection = null;
            try {
                if (paginatedExpression == null) {
                    throw this.newServiceExceptionParameterPaginatedExpressionIsNullErrorParameterPaginated();
                }
                if (!(paginatedExpression instanceof JDBCPaginatedExpression)) {
                    throw this.newServiceExceptionParameterPaginatedExpressionWrongTypeErrorParameterPaginated(paginatedExpression);
                }
                JDBCPaginatedExpression jdbcPaginatedExpression = (JDBCPaginatedExpression)paginatedExpression;
                this.logJDBCPaginatedExpression(jdbcPaginatedExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                list = this.serviceSearch.select(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcPaginatedExpression, distinct, field);
                if (connection == null) break block9;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("Select distinct:" + distinct + " not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object aggregate(IExpression expression, FunctionField functionField) throws ServiceException, NotFoundException, NotImplementedException {
        Object object;
        block9: {
            Connection connection = null;
            try {
                if (expression == null) {
                    throw this.newServiceExceptionParameterExpressionIsNull();
                }
                if (!(expression instanceof JDBCExpression)) {
                    throw this.newServiceExceptionParameterExpressionWrongType(expression);
                }
                JDBCExpression jdbcExpression = (JDBCExpression)expression;
                this.logJDBCExpression(jdbcExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                object = this.serviceSearch.aggregate(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcExpression, functionField);
                if (connection == null) break block9;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("Aggregate not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return object;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> aggregate(IExpression expression, FunctionField ... functionField) throws ServiceException, NotFoundException, NotImplementedException {
        Map map;
        block9: {
            Connection connection = null;
            try {
                if (expression == null) {
                    throw this.newServiceExceptionParameterExpressionIsNull();
                }
                if (!(expression instanceof JDBCExpression)) {
                    throw this.newServiceExceptionParameterExpressionWrongType(expression);
                }
                JDBCExpression jdbcExpression = (JDBCExpression)expression;
                this.logJDBCExpression(jdbcExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                map = this.serviceSearch.aggregate(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcExpression, functionField);
                if (connection == null) break block9;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("Aggregate not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return map;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Map<String, Object>> groupBy(IExpression expression, FunctionField ... functionField) throws ServiceException, NotFoundException, NotImplementedException {
        List list;
        block9: {
            Connection connection = null;
            try {
                if (expression == null) {
                    throw this.newServiceExceptionParameterExpressionIsNull();
                }
                if (!(expression instanceof JDBCExpression)) {
                    throw this.newServiceExceptionParameterExpressionWrongType(expression);
                }
                JDBCExpression jdbcExpression = (JDBCExpression)expression;
                this.logJDBCExpression(jdbcExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                list = this.serviceSearch.groupBy(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcExpression, functionField);
                if (connection == null) break block9;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("GroupBy not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Map<String, Object>> groupBy(IPaginatedExpression paginatedExpression, FunctionField ... functionField) throws ServiceException, NotFoundException, NotImplementedException {
        List list;
        block9: {
            Connection connection = null;
            try {
                if (paginatedExpression == null) {
                    throw this.newServiceExceptionParameterPaginatedExpressionIsNullErrorParameterPaginated();
                }
                if (!(paginatedExpression instanceof JDBCPaginatedExpression)) {
                    throw this.newServiceExceptionParameterPaginatedExpressionWrongTypeErrorParameterPaginated(paginatedExpression);
                }
                JDBCPaginatedExpression jdbcPaginatedExpression = (JDBCPaginatedExpression)paginatedExpression;
                this.logJDBCPaginatedExpression(jdbcPaginatedExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                list = this.serviceSearch.groupBy(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcPaginatedExpression, functionField);
                if (connection == null) break block9;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("GroupBy not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Map<String, Object>> union(Union union, UnionExpression ... unionExpression) throws ServiceException, NotFoundException, NotImplementedException {
        List list;
        block8: {
            Connection connection = null;
            try {
                if (unionExpression == null) {
                    throw this.newServiceExceptionParameterUnionExpressionIsNull();
                }
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                list = this.serviceSearch.union(this.jdbcProperties, this.log, connection, sqlQueryObject, union, unionExpression);
                if (connection == null) break block8;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("Union not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NonNegativeNumber unionCount(Union union, UnionExpression ... unionExpression) throws ServiceException, NotFoundException, NotImplementedException {
        NonNegativeNumber nonNegativeNumber;
        block8: {
            Connection connection = null;
            try {
                if (unionExpression == null) {
                    throw this.newServiceExceptionParameterUnionExpressionIsNull();
                }
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                nonNegativeNumber = this.serviceSearch.unionCount(this.jdbcProperties, this.log, connection, sqlQueryObject, union, unionExpression);
                if (connection == null) break block8;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("UnionCount not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return nonNegativeNumber;
    }

    public IExpression newExpression() throws ServiceException, NotImplementedException {
        return this.serviceSearch.newExpression(this.log);
    }

    public IPaginatedExpression newPaginatedExpression() throws ServiceException, NotImplementedException {
        return this.serviceSearch.newPaginatedExpression(this.log);
    }

    public IExpression toExpression(IPaginatedExpression paginatedExpression) throws ServiceException, NotImplementedException {
        return this.serviceSearch.toExpression((JDBCPaginatedExpression)paginatedExpression, this.log);
    }

    public IPaginatedExpression toPaginatedExpression(IExpression expression) throws ServiceException, NotImplementedException {
        return this.serviceSearch.toPaginatedExpression((JDBCExpression)expression, this.log);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mappingTableIds(IdConfigurazioneFiltro id, ConfigurazioneFiltro obj) throws ServiceException, NotFoundException, NotImplementedException {
        Connection connection = null;
        try {
            if (id == null) {
                throw this.newServiceExceptionParameterIdIsNull();
            }
            if (obj == null) {
                throw this.newServiceExceptionParameterObjIsNull();
            }
            ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
            sqlQueryObject.setANDLogicOperator(true);
            connection = this.jdbcServiceManager.getConnection();
            this.serviceSearch.mappingTableIds(this.jdbcProperties, this.log, connection, sqlQueryObject, (Object)id, (Object)obj);
            if (connection == null) return;
        }
        catch (NotImplementedException | ServiceException e) {
            try {
                this.logError((Exception)e);
                throw e;
                catch (NotFoundException e2) {
                    this.logDebug((Exception)((Object)e2));
                    throw e2;
                }
                catch (Exception e3) {
                    this.logError(e3);
                    throw new ServiceException("mappingIds(IdObject) not completed: " + e3.getMessage(), (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                if (connection == null) throw throwable;
                this.jdbcServiceManager.closeConnection(connection);
                throw throwable;
            }
        }
        this.jdbcServiceManager.closeConnection(connection);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mappingTableIds(long tableId, ConfigurazioneFiltro obj) throws ServiceException, NotFoundException, NotImplementedException {
        Connection connection = null;
        try {
            if (tableId <= 0L) {
                throw this.newServiceExceptionParameterWithTypeTableIdLessEqualsZero();
            }
            if (obj == null) {
                throw this.newServiceExceptionParameterObjIsNull();
            }
            ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
            sqlQueryObject.setANDLogicOperator(true);
            connection = this.jdbcServiceManager.getConnection();
            this.serviceSearch.mappingTableIds(this.jdbcProperties, this.log, connection, sqlQueryObject, tableId, (Object)obj);
            if (connection == null) return;
        }
        catch (NotImplementedException | ServiceException e) {
            try {
                this.logError((Exception)e);
                throw e;
                catch (NotFoundException e2) {
                    this.logDebug((Exception)((Object)e2));
                    throw e2;
                }
                catch (Exception e3) {
                    this.logError(e3);
                    throw new ServiceException("mappingIds(tableId) not completed: " + e3.getMessage(), (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                if (connection == null) throw throwable;
                this.jdbcServiceManager.closeConnection(connection);
                throw throwable;
            }
        }
        this.jdbcServiceManager.closeConnection(connection);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConfigurazioneFiltro get(long tableId) throws ServiceException, NotFoundException, MultipleResultException, NotImplementedException {
        ConfigurazioneFiltro configurazioneFiltro;
        block8: {
            Connection connection = null;
            try {
                if (tableId <= 0L) {
                    throw this.newServiceExceptionParameterTableIdLessEqualsZero();
                }
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                configurazioneFiltro = (ConfigurazioneFiltro)this.serviceSearch.get(this.jdbcProperties, this.log, connection, sqlQueryObject, tableId, null);
                if (connection == null) break block8;
            }
            catch (MultipleResultException | NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("Get(tableId) not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return configurazioneFiltro;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConfigurazioneFiltro get(long tableId, IDMappingBehaviour idMappingResolutionBehaviour) throws ServiceException, NotFoundException, MultipleResultException, NotImplementedException {
        ConfigurazioneFiltro configurazioneFiltro;
        block9: {
            Connection connection = null;
            try {
                if (tableId <= 0L) {
                    throw this.newServiceExceptionParameterTableIdLessEqualsZero();
                }
                if (idMappingResolutionBehaviour == null) {
                    throw this.newServiceExceptionParameterIdMappingResolutionBehaviourIsNull();
                }
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                configurazioneFiltro = (ConfigurazioneFiltro)this.serviceSearch.get(this.jdbcProperties, this.log, connection, sqlQueryObject, tableId, idMappingResolutionBehaviour);
                if (connection == null) break block9;
            }
            catch (MultipleResultException | NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("Get(tableId,idMappingResolutionBehaviour) not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return configurazioneFiltro;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exists(long tableId) throws MultipleResultException, ServiceException, NotImplementedException {
        boolean bl;
        block7: {
            Connection connection = null;
            try {
                if (tableId <= 0L) {
                    throw this.newServiceExceptionParameterTableIdLessEqualsZero();
                }
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                bl = this.serviceSearch.exists(this.jdbcProperties, this.log, connection, sqlQueryObject, tableId);
                if (connection == null) break block7;
            }
            catch (MultipleResultException | NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (Exception e2) {
                        this.logError(e2);
                        throw new ServiceException("Exists(tableId) not completed: " + e2.getMessage(), (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Long> findAllTableIds(IPaginatedExpression expression) throws ServiceException, NotImplementedException {
        List list;
        block8: {
            Connection connection = null;
            try {
                if (expression == null) {
                    throw this.newServiceExceptionParameterPaginatedExpressionIsNull();
                }
                if (!(expression instanceof JDBCPaginatedExpression)) {
                    throw this.newServiceExceptionParameterPaginatedExpressionWrongType(expression);
                }
                JDBCPaginatedExpression jdbcPaginatedExpression = (JDBCPaginatedExpression)expression;
                this.logJDBCPaginatedExpression(jdbcPaginatedExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                list = this.serviceSearch.findAllTableIds(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcPaginatedExpression);
                if (connection == null) break block8;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (Exception e2) {
                        this.logError(e2);
                        throw new ServiceException("findAllTableIds not completed: " + e2.getMessage(), (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long findTableId(IExpression expression) throws ServiceException, NotFoundException, MultipleResultException, NotImplementedException {
        long l;
        block9: {
            Connection connection = null;
            try {
                if (expression == null) {
                    throw this.newServiceExceptionParameterPaginatedExpressionIsNull();
                }
                if (!(expression instanceof JDBCExpression)) {
                    throw this.newServiceExceptionParameterExpressionWrongType(expression);
                }
                JDBCExpression jdbcExpression = (JDBCExpression)expression;
                this.logJDBCExpression(jdbcExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                l = this.serviceSearch.findTableId(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcExpression);
                if (connection == null) break block9;
            }
            catch (MultipleResultException | NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("findTableId not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return l;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InUse inUse(long tableId) throws ServiceException, NotFoundException, NotImplementedException {
        InUse inUse;
        block8: {
            Connection connection = null;
            try {
                if (tableId <= 0L) {
                    throw this.newServiceExceptionParameterTableIdLessEqualsZero();
                }
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                inUse = this.serviceSearch.inUse(this.jdbcProperties, this.log, connection, sqlQueryObject, tableId);
                if (connection == null) break block8;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("InUse(tableId) not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return inUse;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IdConfigurazioneFiltro findId(long tableId, boolean throwNotFound) throws NotFoundException, ServiceException, NotImplementedException {
        IdConfigurazioneFiltro idConfigurazioneFiltro;
        block8: {
            Connection connection = null;
            try {
                if (tableId <= 0L) {
                    throw this.newServiceExceptionParameterTableIdLessEqualsZero();
                }
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                idConfigurazioneFiltro = (IdConfigurazioneFiltro)this.serviceSearch.findId(this.jdbcProperties, this.log, connection, sqlQueryObject, tableId, throwNotFound);
                if (connection == null) break block8;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("findId(tableId,throwNotFound) not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return idConfigurazioneFiltro;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long findTableId(IdConfigurazioneFiltro id, boolean throwNotFound) throws NotFoundException, ServiceException, NotImplementedException {
        Long l;
        block8: {
            Connection connection = null;
            try {
                if (id == null) {
                    throw new ServiceException("Parameter 'id' is null");
                }
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                l = this.serviceSearch.findTableId(this.jdbcProperties, this.log, connection, sqlQueryObject, (Object)id, throwNotFound);
                if (connection == null) break block8;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("findId(tableId,throwNotFound) not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return l;
    }

    public void disableSelectForUpdate() throws ServiceException, NotImplementedException {
        this.jdbcSqlObjectFactory.setSelectForUpdate(false);
    }

    public void enableSelectForUpdate() throws ServiceException, NotImplementedException {
        this.jdbcSqlObjectFactory.setSelectForUpdate(true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<List<Object>> nativeQuery(String sql, List<Class<?>> returnClassTypes, Object ... param) throws ServiceException, NotFoundException, NotImplementedException {
        List list;
        block8: {
            Connection connection = null;
            try {
                if (returnClassTypes == null || returnClassTypes.isEmpty()) {
                    throw new ServiceException("Parameter 'returnClassTypes' is less equals 0");
                }
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                list = this.serviceSearch.nativeQuery(this.jdbcProperties, this.log, connection, sqlQueryObject, sql, returnClassTypes, param);
                if (connection == null) break block8;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("nativeQuery not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return list;
    }
}

