/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.plugins.dao.jdbc;

import java.sql.Connection;
import javax.sql.DataSource;
import org.openspcoop2.core.plugins.dao.IConfigurazioneFiltroService;
import org.openspcoop2.core.plugins.dao.IConfigurazioneFiltroServiceSearch;
import org.openspcoop2.core.plugins.dao.IConfigurazioneServizioAzioneService;
import org.openspcoop2.core.plugins.dao.IConfigurazioneServizioAzioneServiceSearch;
import org.openspcoop2.core.plugins.dao.IConfigurazioneServizioService;
import org.openspcoop2.core.plugins.dao.IConfigurazioneServizioServiceSearch;
import org.openspcoop2.core.plugins.dao.IPluginService;
import org.openspcoop2.core.plugins.dao.IPluginServiceSearch;
import org.openspcoop2.core.plugins.dao.jdbc.JDBCConfigurazioneFiltroService;
import org.openspcoop2.core.plugins.dao.jdbc.JDBCConfigurazioneFiltroServiceSearch;
import org.openspcoop2.core.plugins.dao.jdbc.JDBCConfigurazioneServizioAzioneService;
import org.openspcoop2.core.plugins.dao.jdbc.JDBCConfigurazioneServizioAzioneServiceSearch;
import org.openspcoop2.core.plugins.dao.jdbc.JDBCConfigurazioneServizioService;
import org.openspcoop2.core.plugins.dao.jdbc.JDBCConfigurazioneServizioServiceSearch;
import org.openspcoop2.core.plugins.dao.jdbc.JDBCPluginService;
import org.openspcoop2.core.plugins.dao.jdbc.JDBCPluginServiceSearch;
import org.openspcoop2.core.plugins.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.utils.UtilsRuntimeException;

public class JDBCLimitedServiceManager
extends JDBCServiceManager {
    private JDBCServiceManager unlimitedJdbcServiceManager;
    private static final String CONNNECTION_MANAGED = "Connection managed from framework";

    public JDBCLimitedServiceManager(JDBCServiceManager jdbcServiceManager) {
        this.datasource = jdbcServiceManager.getDatasourceInternalResource();
        this.connection = jdbcServiceManager.getConnectionInternalResource();
        this.log = jdbcServiceManager.getLoggerInternalResource();
        this.jdbcProperties = jdbcServiceManager.getJdbcPropertiesInternalResource();
        this.unlimitedJdbcServiceManager = jdbcServiceManager;
    }

    @Override
    public Connection getConnection() throws ServiceException {
        throw new ServiceException(CONNNECTION_MANAGED);
    }

    @Override
    public void closeConnection(Connection connection) throws ServiceException {
        throw new ServiceException(CONNNECTION_MANAGED);
    }

    @Override
    protected Connection getConnectionInternalResource() {
        throw new UtilsRuntimeException(CONNNECTION_MANAGED);
    }

    @Override
    protected DataSource getDatasourceInternalResource() {
        throw new UtilsRuntimeException(CONNNECTION_MANAGED);
    }

    @Override
    public IPluginServiceSearch getPluginServiceSearch() throws ServiceException, NotImplementedException {
        return new JDBCPluginServiceSearch(this.unlimitedJdbcServiceManager);
    }

    @Override
    public IPluginService getPluginService() throws ServiceException, NotImplementedException {
        return new JDBCPluginService(this.unlimitedJdbcServiceManager);
    }

    @Override
    public IConfigurazioneServizioServiceSearch getConfigurazioneServizioServiceSearch() throws ServiceException, NotImplementedException {
        return new JDBCConfigurazioneServizioServiceSearch(this.unlimitedJdbcServiceManager);
    }

    @Override
    public IConfigurazioneServizioService getConfigurazioneServizioService() throws ServiceException, NotImplementedException {
        return new JDBCConfigurazioneServizioService(this.unlimitedJdbcServiceManager);
    }

    @Override
    public IConfigurazioneServizioAzioneServiceSearch getConfigurazioneServizioAzioneServiceSearch() throws ServiceException, NotImplementedException {
        return new JDBCConfigurazioneServizioAzioneServiceSearch(this.unlimitedJdbcServiceManager);
    }

    @Override
    public IConfigurazioneServizioAzioneService getConfigurazioneServizioAzioneService() throws ServiceException, NotImplementedException {
        return new JDBCConfigurazioneServizioAzioneService(this.unlimitedJdbcServiceManager);
    }

    @Override
    public IConfigurazioneFiltroServiceSearch getConfigurazioneFiltroServiceSearch() throws ServiceException, NotImplementedException {
        return new JDBCConfigurazioneFiltroServiceSearch(this.unlimitedJdbcServiceManager);
    }

    @Override
    public IConfigurazioneFiltroService getConfigurazioneFiltroService() throws ServiceException, NotImplementedException {
        return new JDBCConfigurazioneFiltroService(this.unlimitedJdbcServiceManager);
    }
}

