/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.plugins.dao.jdbc;

import java.sql.Connection;
import org.openspcoop2.core.plugins.IdPlugin;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.dao.IDBPluginService;
import org.openspcoop2.core.plugins.dao.jdbc.JDBCLimitedServiceManager;
import org.openspcoop2.core.plugins.dao.jdbc.JDBCPluginServiceSearch;
import org.openspcoop2.core.plugins.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.plugins.utils.ProjectInfo;
import org.openspcoop2.generic_project.beans.IDMappingBehaviour;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.beans.UpdateField;
import org.openspcoop2.generic_project.beans.UpdateModel;
import org.openspcoop2.generic_project.dao.jdbc.IJDBCServiceCRUDWithId;
import org.openspcoop2.generic_project.dao.jdbc.JDBCExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCProperties;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.exception.ValidationException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.utils.sql.ISQLQueryObject;

public class JDBCPluginService
extends JDBCPluginServiceSearch
implements IDBPluginService {
    private IJDBCServiceCRUDWithId<Plugin, IdPlugin, JDBCServiceManager> serviceCRUD = null;
    private static final String PARAMETER_TYPE_PREFIX = "Parameter (type:";

    public JDBCPluginService(JDBCServiceManager jdbcServiceManager) throws ServiceException {
        super(jdbcServiceManager);
        String msgInit = JDBCPluginService.class.getName() + " initialized";
        this.log.debug(msgInit);
        this.serviceCRUD = (IJDBCServiceCRUDWithId)JDBCProperties.getInstance((Package)JDBCServiceManager.class.getPackage(), (IProjectInfo)ProjectInfo.getInstance()).getServiceCRUD("plugin");
        this.serviceCRUD.setServiceManager((Object)new JDBCLimitedServiceManager(this.jdbcServiceManager));
    }

    private ServiceException newServiceExceptionParameterIsNull() {
        return new ServiceException(PARAMETER_TYPE_PREFIX + Plugin.class.getName() + ") 'plugin' is null");
    }

    private ServiceException newServiceExceptionParameterIsLessEqualsZero() {
        return new ServiceException(PARAMETER_TYPE_PREFIX + Long.TYPE.getName() + ") 'tableId' is less equals 0");
    }

    private ServiceException newServiceExceptionParameterUpdateFieldsIsNull() {
        return new ServiceException(PARAMETER_TYPE_PREFIX + UpdateField.class.getName() + ") 'updateFields' is null");
    }

    private ServiceException newServiceExceptionParameterOldIdIsNull() {
        return new ServiceException(PARAMETER_TYPE_PREFIX + IdPlugin.class.getName() + ") 'oldId' is null");
    }

    private ServiceException newServiceExceptionParameterConditionIsNull() {
        return new ServiceException(PARAMETER_TYPE_PREFIX + IExpression.class.getName() + ") 'condition' is null");
    }

    private ServiceException newServiceExceptionParameterUpdateModelsIsNull() {
        return new ServiceException(PARAMETER_TYPE_PREFIX + UpdateModel.class.getName() + ") 'updateModels' is null");
    }

    private ServiceException newServiceExceptionUpdateFieldsNotCompleted(Exception e) {
        return new ServiceException("UpdateFields not completed: " + e.getMessage(), (Throwable)e);
    }

    private void releaseResources(boolean rollback, Connection connection, boolean oldValueAutoCommit) throws ServiceException {
        if (this.jdbcProperties.isAutomaticTransactionManagement()) {
            this.manageTransaction(rollback, connection);
            try {
                if (connection != null) {
                    connection.setAutoCommit(oldValueAutoCommit);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (connection != null) {
            this.jdbcServiceManager.closeConnection(connection);
        }
    }

    private void manageTransaction(boolean rollback, Connection connection) {
        if (rollback) {
            try {
                if (connection != null) {
                    connection.rollback();
                }
            }
            catch (Exception exception) {}
        } else {
            try {
                if (connection != null) {
                    connection.commit();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void create(Plugin plugin) throws ServiceException, NotImplementedException {
        try {
            this.create(plugin, false, null);
        }
        catch (ValidationException vE) {
            throw new ServiceException(vE.getMessage(), (Throwable)vE);
        }
    }

    public void create(Plugin plugin, IDMappingBehaviour idMappingResolutionBehaviour) throws ServiceException, NotImplementedException {
        try {
            this.create(plugin, false, idMappingResolutionBehaviour);
        }
        catch (ValidationException vE) {
            throw new ServiceException(vE.getMessage(), (Throwable)vE);
        }
    }

    public void create(Plugin plugin, boolean validate) throws ServiceException, NotImplementedException, ValidationException {
        this.create(plugin, validate, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void create(Plugin plugin, boolean validate, IDMappingBehaviour idMappingResolutionBehaviour) throws ServiceException, NotImplementedException, ValidationException {
        Connection connection = null;
        boolean oldValueAutoCommit = false;
        boolean rollback = false;
        try {
            if (plugin == null) {
                throw this.newServiceExceptionParameterIsNull();
            }
            if (validate) {
                this.validate(plugin);
            }
            ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
            sqlQueryObject.setANDLogicOperator(true);
            connection = this.jdbcServiceManager.getConnection();
            if (this.jdbcProperties.isAutomaticTransactionManagement()) {
                oldValueAutoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
            }
            this.serviceCRUD.create(this.jdbcProperties, this.log, connection, sqlQueryObject, (Object)plugin, idMappingResolutionBehaviour);
        }
        catch (NotImplementedException | ServiceException | ValidationException e) {
            try {
                rollback = true;
                this.logError((Exception)e);
                throw e;
                catch (Exception e2) {
                    rollback = true;
                    this.logError(e2);
                    throw new ServiceException("Create not completed: " + e2.getMessage(), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.releaseResources(rollback, connection, oldValueAutoCommit);
                throw throwable;
            }
        }
        this.releaseResources(rollback, connection, oldValueAutoCommit);
    }

    public void update(IdPlugin oldId, Plugin plugin) throws ServiceException, NotFoundException, NotImplementedException {
        try {
            this.update(oldId, plugin, false, null);
        }
        catch (ValidationException vE) {
            throw new ServiceException(vE.getMessage(), (Throwable)vE);
        }
    }

    public void update(IdPlugin oldId, Plugin plugin, IDMappingBehaviour idMappingResolutionBehaviour) throws ServiceException, NotFoundException, NotImplementedException {
        try {
            this.update(oldId, plugin, false, idMappingResolutionBehaviour);
        }
        catch (ValidationException vE) {
            throw new ServiceException(vE.getMessage(), (Throwable)vE);
        }
    }

    public void update(IdPlugin oldId, Plugin plugin, boolean validate) throws ServiceException, NotFoundException, NotImplementedException, ValidationException {
        this.update(oldId, plugin, validate, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(IdPlugin oldId, Plugin plugin, boolean validate, IDMappingBehaviour idMappingResolutionBehaviour) throws ServiceException, NotFoundException, NotImplementedException, ValidationException {
        Connection connection = null;
        boolean oldValueAutoCommit = false;
        boolean rollback = false;
        try {
            if (plugin == null) {
                throw this.newServiceExceptionParameterIsNull();
            }
            if (oldId == null) {
                throw this.newServiceExceptionParameterOldIdIsNull();
            }
            if (validate) {
                this.validate(plugin);
            }
            ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
            sqlQueryObject.setANDLogicOperator(true);
            connection = this.jdbcServiceManager.getConnection();
            if (this.jdbcProperties.isAutomaticTransactionManagement()) {
                oldValueAutoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
            }
            this.serviceCRUD.update(this.jdbcProperties, this.log, connection, sqlQueryObject, (Object)oldId, (Object)plugin, idMappingResolutionBehaviour);
        }
        catch (NotImplementedException | ServiceException | ValidationException e) {
            try {
                rollback = true;
                this.logError((Exception)e);
                throw e;
                catch (NotFoundException e2) {
                    rollback = true;
                    this.logDebug((Exception)((Object)e2));
                    throw e2;
                }
                catch (Exception e3) {
                    rollback = true;
                    this.logError(e3);
                    throw new ServiceException("Update not completed: " + e3.getMessage(), (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                this.releaseResources(rollback, connection, oldValueAutoCommit);
                throw throwable;
            }
        }
        this.releaseResources(rollback, connection, oldValueAutoCommit);
    }

    public void update(long tableId, Plugin plugin) throws ServiceException, NotFoundException, NotImplementedException {
        try {
            this.update(tableId, plugin, false, null);
        }
        catch (ValidationException vE) {
            throw new ServiceException(vE.getMessage(), (Throwable)vE);
        }
    }

    public void update(long tableId, Plugin plugin, IDMappingBehaviour idMappingResolutionBehaviour) throws ServiceException, NotFoundException, NotImplementedException {
        try {
            this.update(tableId, plugin, false, idMappingResolutionBehaviour);
        }
        catch (ValidationException vE) {
            throw new ServiceException(vE.getMessage(), (Throwable)vE);
        }
    }

    public void update(long tableId, Plugin plugin, boolean validate) throws ServiceException, NotFoundException, NotImplementedException, ValidationException {
        this.update(tableId, plugin, validate, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(long tableId, Plugin plugin, boolean validate, IDMappingBehaviour idMappingResolutionBehaviour) throws ServiceException, NotFoundException, NotImplementedException, ValidationException {
        Connection connection = null;
        boolean oldValueAutoCommit = false;
        boolean rollback = false;
        try {
            if (plugin == null) {
                throw this.newServiceExceptionParameterIsNull();
            }
            if (tableId <= 0L) {
                throw this.newServiceExceptionParameterIsLessEqualsZero();
            }
            if (validate) {
                this.validate(plugin);
            }
            ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
            sqlQueryObject.setANDLogicOperator(true);
            connection = this.jdbcServiceManager.getConnection();
            if (this.jdbcProperties.isAutomaticTransactionManagement()) {
                oldValueAutoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
            }
            this.serviceCRUD.update(this.jdbcProperties, this.log, connection, sqlQueryObject, tableId, (Object)plugin, idMappingResolutionBehaviour);
        }
        catch (NotImplementedException | ServiceException | ValidationException e) {
            try {
                rollback = true;
                this.logError((Exception)e);
                throw e;
                catch (NotFoundException e2) {
                    rollback = true;
                    this.logDebug((Exception)((Object)e2));
                    throw e2;
                }
                catch (Exception e3) {
                    rollback = true;
                    this.logError(e3);
                    throw new ServiceException("Update not completed: " + e3.getMessage(), (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                this.releaseResources(rollback, connection, oldValueAutoCommit);
                throw throwable;
            }
        }
        this.releaseResources(rollback, connection, oldValueAutoCommit);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateFields(IdPlugin id, UpdateField ... updateFields) throws ServiceException, NotFoundException, NotImplementedException {
        Connection connection = null;
        boolean oldValueAutoCommit = false;
        boolean rollback = false;
        try {
            if (id == null) {
                throw this.newServiceExceptionParameterIdIsNull();
            }
            if (updateFields == null) {
                throw this.newServiceExceptionParameterUpdateFieldsIsNull();
            }
            ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
            sqlQueryObject.setANDLogicOperator(true);
            connection = this.jdbcServiceManager.getConnection();
            if (this.jdbcProperties.isAutomaticTransactionManagement()) {
                oldValueAutoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
            }
            this.serviceCRUD.updateFields(this.jdbcProperties, this.log, connection, sqlQueryObject, (Object)id, updateFields);
        }
        catch (NotImplementedException | ServiceException e) {
            try {
                rollback = true;
                this.logError((Exception)e);
                throw e;
                catch (NotFoundException e2) {
                    rollback = true;
                    this.logDebug((Exception)((Object)e2));
                    throw e2;
                }
                catch (Exception e3) {
                    rollback = true;
                    this.logError(e3);
                    throw this.newServiceExceptionUpdateFieldsNotCompleted(e3);
                }
            }
            catch (Throwable throwable) {
                this.releaseResources(rollback, connection, oldValueAutoCommit);
                throw throwable;
            }
        }
        this.releaseResources(rollback, connection, oldValueAutoCommit);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateFields(IdPlugin id, IExpression condition, UpdateField ... updateFields) throws ServiceException, NotFoundException, NotImplementedException {
        Connection connection = null;
        boolean oldValueAutoCommit = false;
        boolean rollback = false;
        try {
            if (id == null) {
                throw this.newServiceExceptionParameterIdIsNull();
            }
            if (condition == null) {
                throw this.newServiceExceptionParameterConditionIsNull();
            }
            if (updateFields == null) {
                throw this.newServiceExceptionParameterUpdateFieldsIsNull();
            }
            ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
            sqlQueryObject.setANDLogicOperator(true);
            connection = this.jdbcServiceManager.getConnection();
            if (this.jdbcProperties.isAutomaticTransactionManagement()) {
                oldValueAutoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
            }
            this.serviceCRUD.updateFields(this.jdbcProperties, this.log, connection, sqlQueryObject, (Object)id, condition, updateFields);
        }
        catch (NotImplementedException | ServiceException e) {
            try {
                rollback = true;
                this.logError((Exception)e);
                throw e;
                catch (NotFoundException e2) {
                    rollback = true;
                    this.logDebug((Exception)((Object)e2));
                    throw e2;
                }
                catch (Exception e3) {
                    rollback = true;
                    this.logError(e3);
                    throw this.newServiceExceptionUpdateFieldsNotCompleted(e3);
                }
            }
            catch (Throwable throwable) {
                this.releaseResources(rollback, connection, oldValueAutoCommit);
                throw throwable;
            }
        }
        this.releaseResources(rollback, connection, oldValueAutoCommit);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateFields(IdPlugin id, UpdateModel ... updateModels) throws ServiceException, NotFoundException, NotImplementedException {
        Connection connection = null;
        boolean oldValueAutoCommit = false;
        boolean rollback = false;
        try {
            if (id == null) {
                throw this.newServiceExceptionParameterIdIsNull();
            }
            if (updateModels == null) {
                throw this.newServiceExceptionParameterUpdateModelsIsNull();
            }
            ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
            sqlQueryObject.setANDLogicOperator(true);
            connection = this.jdbcServiceManager.getConnection();
            if (this.jdbcProperties.isAutomaticTransactionManagement()) {
                oldValueAutoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
            }
            this.serviceCRUD.updateFields(this.jdbcProperties, this.log, connection, sqlQueryObject, (Object)id, updateModels);
        }
        catch (NotImplementedException | ServiceException e) {
            try {
                rollback = true;
                this.logError((Exception)e);
                throw e;
                catch (NotFoundException e2) {
                    rollback = true;
                    this.logDebug((Exception)((Object)e2));
                    throw e2;
                }
                catch (Exception e3) {
                    rollback = true;
                    this.logError(e3);
                    throw this.newServiceExceptionUpdateFieldsNotCompleted(e3);
                }
            }
            catch (Throwable throwable) {
                this.releaseResources(rollback, connection, oldValueAutoCommit);
                throw throwable;
            }
        }
        this.releaseResources(rollback, connection, oldValueAutoCommit);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateFields(long tableId, UpdateField ... updateFields) throws ServiceException, NotFoundException, NotImplementedException {
        Connection connection = null;
        boolean oldValueAutoCommit = false;
        boolean rollback = false;
        try {
            if (tableId <= 0L) {
                throw this.newServiceExceptionParameterIsLessEqualsZero();
            }
            if (updateFields == null) {
                throw this.newServiceExceptionParameterUpdateFieldsIsNull();
            }
            ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
            sqlQueryObject.setANDLogicOperator(true);
            connection = this.jdbcServiceManager.getConnection();
            if (this.jdbcProperties.isAutomaticTransactionManagement()) {
                oldValueAutoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
            }
            this.serviceCRUD.updateFields(this.jdbcProperties, this.log, connection, sqlQueryObject, tableId, updateFields);
        }
        catch (NotImplementedException | ServiceException e) {
            try {
                rollback = true;
                this.logError((Exception)e);
                throw e;
                catch (NotFoundException e2) {
                    rollback = true;
                    this.logDebug((Exception)((Object)e2));
                    throw e2;
                }
                catch (Exception e3) {
                    rollback = true;
                    this.logError(e3);
                    throw this.newServiceExceptionUpdateFieldsNotCompleted(e3);
                }
            }
            catch (Throwable throwable) {
                this.releaseResources(rollback, connection, oldValueAutoCommit);
                throw throwable;
            }
        }
        this.releaseResources(rollback, connection, oldValueAutoCommit);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateFields(long tableId, IExpression condition, UpdateField ... updateFields) throws ServiceException, NotFoundException, NotImplementedException {
        Connection connection = null;
        boolean oldValueAutoCommit = false;
        boolean rollback = false;
        try {
            if (tableId <= 0L) {
                throw this.newServiceExceptionParameterIsLessEqualsZero();
            }
            if (condition == null) {
                throw this.newServiceExceptionParameterConditionIsNull();
            }
            if (updateFields == null) {
                throw this.newServiceExceptionParameterUpdateFieldsIsNull();
            }
            ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
            sqlQueryObject.setANDLogicOperator(true);
            connection = this.jdbcServiceManager.getConnection();
            if (this.jdbcProperties.isAutomaticTransactionManagement()) {
                oldValueAutoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
            }
            this.serviceCRUD.updateFields(this.jdbcProperties, this.log, connection, sqlQueryObject, tableId, condition, updateFields);
        }
        catch (NotImplementedException | ServiceException e) {
            try {
                rollback = true;
                this.logError((Exception)e);
                throw e;
                catch (NotFoundException e2) {
                    rollback = true;
                    this.logDebug((Exception)((Object)e2));
                    throw e2;
                }
                catch (Exception e3) {
                    rollback = true;
                    this.logError(e3);
                    throw this.newServiceExceptionUpdateFieldsNotCompleted(e3);
                }
            }
            catch (Throwable throwable) {
                this.releaseResources(rollback, connection, oldValueAutoCommit);
                throw throwable;
            }
        }
        this.releaseResources(rollback, connection, oldValueAutoCommit);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateFields(long tableId, UpdateModel ... updateModels) throws ServiceException, NotFoundException, NotImplementedException {
        Connection connection = null;
        boolean oldValueAutoCommit = false;
        boolean rollback = false;
        try {
            if (tableId <= 0L) {
                throw this.newServiceExceptionParameterIsLessEqualsZero();
            }
            if (updateModels == null) {
                throw this.newServiceExceptionParameterUpdateModelsIsNull();
            }
            ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
            sqlQueryObject.setANDLogicOperator(true);
            connection = this.jdbcServiceManager.getConnection();
            if (this.jdbcProperties.isAutomaticTransactionManagement()) {
                oldValueAutoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
            }
            this.serviceCRUD.updateFields(this.jdbcProperties, this.log, connection, sqlQueryObject, tableId, updateModels);
        }
        catch (NotImplementedException | ServiceException e) {
            try {
                rollback = true;
                this.logError((Exception)e);
                throw e;
                catch (NotFoundException e2) {
                    rollback = true;
                    this.logDebug((Exception)((Object)e2));
                    throw e2;
                }
                catch (Exception e3) {
                    rollback = true;
                    this.logError(e3);
                    throw this.newServiceExceptionUpdateFieldsNotCompleted(e3);
                }
            }
            catch (Throwable throwable) {
                this.releaseResources(rollback, connection, oldValueAutoCommit);
                throw throwable;
            }
        }
        this.releaseResources(rollback, connection, oldValueAutoCommit);
    }

    public void updateOrCreate(IdPlugin oldId, Plugin plugin) throws ServiceException, NotImplementedException {
        try {
            this.updateOrCreate(oldId, plugin, false, null);
        }
        catch (ValidationException vE) {
            throw new ServiceException(vE.getMessage(), (Throwable)vE);
        }
    }

    public void updateOrCreate(IdPlugin oldId, Plugin plugin, IDMappingBehaviour idMappingResolutionBehaviour) throws ServiceException, NotImplementedException {
        try {
            this.updateOrCreate(oldId, plugin, false, idMappingResolutionBehaviour);
        }
        catch (ValidationException vE) {
            throw new ServiceException(vE.getMessage(), (Throwable)vE);
        }
    }

    public void updateOrCreate(IdPlugin oldId, Plugin plugin, boolean validate) throws ServiceException, NotImplementedException, ValidationException {
        this.updateOrCreate(oldId, plugin, validate, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateOrCreate(IdPlugin oldId, Plugin plugin, boolean validate, IDMappingBehaviour idMappingResolutionBehaviour) throws ServiceException, NotImplementedException, ValidationException {
        Connection connection = null;
        boolean oldValueAutoCommit = false;
        boolean rollback = false;
        try {
            if (plugin == null) {
                throw this.newServiceExceptionParameterIsNull();
            }
            if (oldId == null) {
                throw this.newServiceExceptionParameterOldIdIsNull();
            }
            if (validate) {
                this.validate(plugin);
            }
            ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
            sqlQueryObject.setANDLogicOperator(true);
            connection = this.jdbcServiceManager.getConnection();
            if (this.jdbcProperties.isAutomaticTransactionManagement()) {
                oldValueAutoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
            }
            this.serviceCRUD.updateOrCreate(this.jdbcProperties, this.log, connection, sqlQueryObject, (Object)oldId, (Object)plugin, idMappingResolutionBehaviour);
        }
        catch (NotImplementedException | ServiceException | ValidationException e) {
            try {
                rollback = true;
                this.logError((Exception)e);
                throw e;
                catch (Exception e2) {
                    rollback = true;
                    this.logError(e2);
                    throw new ServiceException("UpdateOrCreate not completed: " + e2.getMessage(), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.releaseResources(rollback, connection, oldValueAutoCommit);
                throw throwable;
            }
        }
        this.releaseResources(rollback, connection, oldValueAutoCommit);
    }

    public void updateOrCreate(long tableId, Plugin plugin) throws ServiceException, NotImplementedException {
        try {
            this.updateOrCreate(tableId, plugin, false, null);
        }
        catch (ValidationException vE) {
            throw new ServiceException(vE.getMessage(), (Throwable)vE);
        }
    }

    public void updateOrCreate(long tableId, Plugin plugin, IDMappingBehaviour idMappingResolutionBehaviour) throws ServiceException, NotImplementedException {
        try {
            this.updateOrCreate(tableId, plugin, false, idMappingResolutionBehaviour);
        }
        catch (ValidationException vE) {
            throw new ServiceException(vE.getMessage(), (Throwable)vE);
        }
    }

    public void updateOrCreate(long tableId, Plugin plugin, boolean validate) throws ServiceException, NotImplementedException, ValidationException {
        this.updateOrCreate(tableId, plugin, validate, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateOrCreate(long tableId, Plugin plugin, boolean validate, IDMappingBehaviour idMappingResolutionBehaviour) throws ServiceException, NotImplementedException, ValidationException {
        Connection connection = null;
        boolean oldValueAutoCommit = false;
        boolean rollback = false;
        try {
            if (plugin == null) {
                throw this.newServiceExceptionParameterIsNull();
            }
            if (tableId <= 0L) {
                throw this.newServiceExceptionParameterIsLessEqualsZero();
            }
            if (validate) {
                this.validate(plugin);
            }
            ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
            sqlQueryObject.setANDLogicOperator(true);
            connection = this.jdbcServiceManager.getConnection();
            if (this.jdbcProperties.isAutomaticTransactionManagement()) {
                oldValueAutoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
            }
            this.serviceCRUD.updateOrCreate(this.jdbcProperties, this.log, connection, sqlQueryObject, tableId, (Object)plugin, idMappingResolutionBehaviour);
        }
        catch (NotImplementedException | ServiceException | ValidationException e) {
            try {
                rollback = true;
                this.logError((Exception)e);
                throw e;
                catch (Exception e2) {
                    rollback = true;
                    this.logError(e2);
                    throw new ServiceException("UpdateOrCreate not completed: " + e2.getMessage(), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.releaseResources(rollback, connection, oldValueAutoCommit);
                throw throwable;
            }
        }
        this.releaseResources(rollback, connection, oldValueAutoCommit);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(Plugin plugin) throws ServiceException, NotImplementedException {
        Connection connection = null;
        boolean oldValueAutoCommit = false;
        boolean rollback = false;
        try {
            if (plugin == null) {
                throw this.newServiceExceptionParameterIsNull();
            }
            ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
            sqlQueryObject.setANDLogicOperator(true);
            connection = this.jdbcServiceManager.getConnection();
            if (this.jdbcProperties.isAutomaticTransactionManagement()) {
                oldValueAutoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
            }
            this.serviceCRUD.delete(this.jdbcProperties, this.log, connection, sqlQueryObject, (Object)plugin);
        }
        catch (NotImplementedException | ServiceException e) {
            try {
                rollback = true;
                this.logError((Exception)e);
                throw e;
                catch (Exception e2) {
                    rollback = true;
                    this.logError(e2);
                    throw new ServiceException("Delete not completed: " + e2.getMessage(), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.releaseResources(rollback, connection, oldValueAutoCommit);
                throw throwable;
            }
        }
        this.releaseResources(rollback, connection, oldValueAutoCommit);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteById(IdPlugin id) throws ServiceException, NotImplementedException {
        Connection connection = null;
        boolean oldValueAutoCommit = false;
        boolean rollback = false;
        try {
            if (id == null) {
                throw this.newServiceExceptionParameterIdIsNull();
            }
            ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
            sqlQueryObject.setANDLogicOperator(true);
            connection = this.jdbcServiceManager.getConnection();
            if (this.jdbcProperties.isAutomaticTransactionManagement()) {
                oldValueAutoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
            }
            this.serviceCRUD.deleteById(this.jdbcProperties, this.log, connection, sqlQueryObject, (Object)id);
        }
        catch (NotImplementedException | ServiceException e) {
            try {
                rollback = true;
                this.logError((Exception)e);
                throw e;
                catch (Exception e2) {
                    rollback = true;
                    this.logError(e2);
                    throw new ServiceException("DeleteById not completed: " + e2.getMessage(), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.releaseResources(rollback, connection, oldValueAutoCommit);
                throw throwable;
            }
        }
        this.releaseResources(rollback, connection, oldValueAutoCommit);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NonNegativeNumber deleteAll() throws ServiceException, NotImplementedException {
        NonNegativeNumber nonNegativeNumber;
        Connection connection = null;
        boolean oldValueAutoCommit = false;
        boolean rollback = false;
        try {
            ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
            sqlQueryObject.setANDLogicOperator(true);
            connection = this.jdbcServiceManager.getConnection();
            if (this.jdbcProperties.isAutomaticTransactionManagement()) {
                oldValueAutoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
            }
            nonNegativeNumber = this.serviceCRUD.deleteAll(this.jdbcProperties, this.log, connection, sqlQueryObject);
        }
        catch (NotImplementedException | ServiceException e) {
            try {
                rollback = true;
                this.logError((Exception)e);
                throw e;
                catch (Exception e2) {
                    rollback = true;
                    this.logError(e2);
                    throw new ServiceException("DeleteAll not completed: " + e2.getMessage(), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.releaseResources(rollback, connection, oldValueAutoCommit);
                throw throwable;
            }
        }
        this.releaseResources(rollback, connection, oldValueAutoCommit);
        return nonNegativeNumber;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NonNegativeNumber deleteAll(IExpression expression) throws ServiceException, NotImplementedException {
        NonNegativeNumber nonNegativeNumber;
        Connection connection = null;
        boolean oldValueAutoCommit = false;
        boolean rollback = false;
        try {
            if (expression == null) {
                throw this.newServiceExceptionParameterExpressionIsNull();
            }
            if (!(expression instanceof JDBCExpression)) {
                throw this.newServiceExceptionParameterExpressionWrongType(expression);
            }
            JDBCExpression jdbcExpression = (JDBCExpression)expression;
            this.logJDBCExpression(jdbcExpression);
            ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
            sqlQueryObject.setANDLogicOperator(true);
            connection = this.jdbcServiceManager.getConnection();
            if (this.jdbcProperties.isAutomaticTransactionManagement()) {
                oldValueAutoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
            }
            nonNegativeNumber = this.serviceCRUD.deleteAll(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcExpression);
        }
        catch (NotImplementedException | ServiceException e) {
            try {
                rollback = true;
                this.logError((Exception)e);
                throw e;
                catch (Exception e2) {
                    rollback = true;
                    this.logError(e2);
                    throw new ServiceException("DeleteAll(expression) not completed: " + e2.getMessage(), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.releaseResources(rollback, connection, oldValueAutoCommit);
                throw throwable;
            }
        }
        this.releaseResources(rollback, connection, oldValueAutoCommit);
        return nonNegativeNumber;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteById(long tableId) throws ServiceException, NotImplementedException {
        Connection connection = null;
        boolean oldValueAutoCommit = false;
        boolean rollback = false;
        try {
            if (tableId <= 0L) {
                throw new ServiceException("Parameter 'tableId' is less equals 0");
            }
            ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
            sqlQueryObject.setANDLogicOperator(true);
            connection = this.jdbcServiceManager.getConnection();
            if (this.jdbcProperties.isAutomaticTransactionManagement()) {
                oldValueAutoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
            }
            this.serviceCRUD.deleteById(this.jdbcProperties, this.log, connection, sqlQueryObject, tableId);
        }
        catch (NotImplementedException | ServiceException e) {
            try {
                rollback = true;
                this.logError((Exception)e);
                throw e;
                catch (Exception e2) {
                    rollback = true;
                    this.logError(e2);
                    throw new ServiceException("DeleteById(tableId) not completed: " + e2.getMessage(), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.releaseResources(rollback, connection, oldValueAutoCommit);
                throw throwable;
            }
        }
        this.releaseResources(rollback, connection, oldValueAutoCommit);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int nativeUpdate(String sql, Object ... param) throws ServiceException, NotImplementedException {
        int n;
        Connection connection = null;
        boolean oldValueAutoCommit = false;
        boolean rollback = false;
        try {
            if (sql == null) {
                throw new ServiceException("Parameter 'sql' is null");
            }
            ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
            sqlQueryObject.setANDLogicOperator(true);
            connection = this.jdbcServiceManager.getConnection();
            if (this.jdbcProperties.isAutomaticTransactionManagement()) {
                oldValueAutoCommit = connection.getAutoCommit();
                connection.setAutoCommit(false);
            }
            n = this.serviceCRUD.nativeUpdate(this.jdbcProperties, this.log, connection, sqlQueryObject, sql, param);
        }
        catch (NotImplementedException | ServiceException e) {
            try {
                rollback = true;
                this.logError((Exception)e);
                throw e;
                catch (Exception e2) {
                    rollback = true;
                    this.logError(e2);
                    throw new ServiceException("DeleteById(tableId) not completed: " + e2.getMessage(), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                this.releaseResources(rollback, connection, oldValueAutoCommit);
                throw throwable;
            }
        }
        this.releaseResources(rollback, connection, oldValueAutoCommit);
        return n;
    }
}

