/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.plugins.dao.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.plugins.IdPlugin;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.PluginProprietaCompatibilita;
import org.openspcoop2.core.plugins.PluginServizioAzioneCompatibilita;
import org.openspcoop2.core.plugins.PluginServizioCompatibilita;
import org.openspcoop2.core.plugins.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.plugins.dao.jdbc.converter.PluginFieldConverter;
import org.openspcoop2.core.plugins.dao.jdbc.fetch.PluginFetch;
import org.openspcoop2.core.plugins.utils.AliasTableRicerchePersonalizzate;
import org.openspcoop2.generic_project.beans.CustomField;
import org.openspcoop2.generic_project.beans.FunctionField;
import org.openspcoop2.generic_project.beans.IDMappingBehaviour;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.beans.InUse;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.beans.Union;
import org.openspcoop2.generic_project.beans.UnionExpression;
import org.openspcoop2.generic_project.dao.jdbc.IJDBCServiceSearchWithId;
import org.openspcoop2.generic_project.dao.jdbc.JDBCExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCPaginatedExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCServiceManagerProperties;
import org.openspcoop2.generic_project.dao.jdbc.utils.GenericJDBCUtilities;
import org.openspcoop2.generic_project.dao.jdbc.utils.IJDBCFetch;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCObject;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBCPreparedStatementUtilities;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.generic_project.utils.Utilities;
import org.openspcoop2.generic_project.utils.UtilsTemplate;
import org.openspcoop2.utils.beans.BaseBeanWithId;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.slf4j.Logger;

public class JDBCPluginServiceSearchImpl
implements IJDBCServiceSearchWithId<Plugin, IdPlugin, JDBCServiceManager> {
    private PluginFieldConverter _pluginFieldConverter = null;
    private PluginFetch pluginFetch = new PluginFetch();
    private JDBCServiceManager jdbcServiceManager = null;

    public PluginFieldConverter getPluginFieldConverter() {
        if (this._pluginFieldConverter == null) {
            this._pluginFieldConverter = new PluginFieldConverter(this.jdbcServiceManager.getJdbcProperties().getDatabaseType());
        }
        return this._pluginFieldConverter;
    }

    public ISQLFieldConverter getFieldConverter() {
        return this.getPluginFieldConverter();
    }

    public PluginFetch getPluginFetch() {
        return this.pluginFetch;
    }

    public IJDBCFetch getFetch() {
        return this.getPluginFetch();
    }

    public void setServiceManager(JDBCServiceManager serviceManager) throws ServiceException {
        this.jdbcServiceManager = serviceManager;
    }

    public JDBCServiceManager getServiceManager() throws ServiceException {
        return this.jdbcServiceManager;
    }

    public IdPlugin convertToId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Plugin plugin) throws NotImplementedException, ServiceException, Exception {
        IdPlugin idPlugin = new IdPlugin();
        idPlugin.setTipoPlugin(plugin.getTipoPlugin());
        idPlugin.setTipo(plugin.getTipo());
        idPlugin.setClassName(plugin.getClassName());
        idPlugin.setLabel(plugin.getLabel());
        return idPlugin;
    }

    public Plugin get(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdPlugin id, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        Long id_plugin = id != null && id.getId() != null && id.getId() > 0L ? id.getId() : this.findIdPlugin(jdbcProperties, log, connection, sqlQueryObject, id, true);
        return this.getEngine(jdbcProperties, log, connection, sqlQueryObject, id_plugin, idMappingResolutionBehaviour);
    }

    public boolean exists(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdPlugin id) throws MultipleResultException, NotImplementedException, ServiceException, Exception {
        Long id_plugin = this.findIdPlugin(jdbcProperties, log, connection, sqlQueryObject, id, false);
        return id_plugin != null && id_plugin > 0L;
    }

    public List<IdPlugin> findAllIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression expression, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        ArrayList<IdPlugin> list = new ArrayList<IdPlugin>();
        List<Long> ids = this.findAllTableIds(jdbcProperties, log, connection, sqlQueryObject, expression);
        for (Long id : ids) {
            Plugin plugin = this.get(jdbcProperties, log, connection, sqlQueryObject, id, idMappingResolutionBehaviour);
            IdPlugin idPlugin = this.convertToId(jdbcProperties, log, connection, sqlQueryObject, plugin);
            list.add(idPlugin);
        }
        return list;
    }

    public List<Plugin> findAll(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression expression, IDMappingBehaviour idMappingResolutionBehaviour) throws NotImplementedException, ServiceException, Exception {
        ArrayList<Plugin> list = new ArrayList<Plugin>();
        List<Long> ids = this.findAllTableIds(jdbcProperties, log, connection, sqlQueryObject, expression);
        for (Long id : ids) {
            list.add(this.get(jdbcProperties, log, connection, sqlQueryObject, id, idMappingResolutionBehaviour));
        }
        return list;
    }

    public Plugin find(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        long id = this.findTableId(jdbcProperties, log, connection, sqlQueryObject, expression);
        if (id > 0L) {
            return this.get(jdbcProperties, log, connection, sqlQueryObject, id, idMappingResolutionBehaviour);
        }
        throw new NotFoundException("Entry with id[" + id + "] not found");
    }

    public NonNegativeNumber count(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression) throws NotImplementedException, ServiceException, Exception {
        List listaQuery = GenericJDBCUtilities.prepareCount((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getPluginFieldConverter(), (IModel)Plugin.model());
        sqlQueryObject.addSelectCountField(this.getPluginFieldConverter().toTable((IModel)Plugin.model()) + ".id", "tot", true);
        this.joinEngine((IExpression)expression, sqlQueryObject);
        return GenericJDBCUtilities.count((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getPluginFieldConverter(), (IModel)Plugin.model(), (List)listaQuery);
    }

    public InUse inUse(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdPlugin id) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        Long id_plugin = this.findIdPlugin(jdbcProperties, log, connection, sqlQueryObject, id, true);
        return this.inUseEngine(jdbcProperties, log, connection, sqlQueryObject, id_plugin);
    }

    public List<Object> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, IField field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.select(jdbcProperties, log, connection, sqlQueryObject, paginatedExpression, false, field);
    }

    public List<Object> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, boolean distinct, IField field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        List<Map<String, Object>> map = this.select(jdbcProperties, log, connection, sqlQueryObject, paginatedExpression, distinct, new IField[]{field});
        return GenericJDBCUtilities.selectSingleObject(map);
    }

    public List<Map<String, Object>> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, IField ... field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.select(jdbcProperties, log, connection, sqlQueryObject, paginatedExpression, false, field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> select(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, boolean distinct, IField ... field) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (IField[])field);
        try {
            ISQLQueryObject sqlQueryObjectDistinct = GenericJDBCUtilities.prepareSqlQueryObjectForSelectDistinct((boolean)distinct, (ISQLQueryObject)sqlQueryObject, (IExpression)paginatedExpression, (Logger)log, (ISQLFieldConverter)this.getPluginFieldConverter(), (IField[])field);
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)paginatedExpression, sqlQueryObjectDistinct);
            return list;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (IField[])field);
        }
    }

    public Object aggregate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, FunctionField functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        Map<String, Object> map = this.aggregate(jdbcProperties, log, connection, sqlQueryObject, expression, new FunctionField[]{functionField});
        return GenericJDBCUtilities.selectAggregateObject(map, (FunctionField)functionField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> aggregate(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, FunctionField ... functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        try {
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)expression);
            Map<String, Object> map = list.get(0);
            return map;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> groupBy(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression, FunctionField ... functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        if (expression.getGroupByFields().isEmpty()) {
            throw new ServiceException("GroupBy conditions not found in expression");
        }
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        try {
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)expression);
            return list;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCExpression)expression, (FunctionField[])functionField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> groupBy(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression, FunctionField ... functionField) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        if (paginatedExpression.getGroupByFields().isEmpty()) {
            throw new ServiceException("GroupBy conditions not found in expression");
        }
        GenericJDBCUtilities.setFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (FunctionField[])functionField);
        try {
            List<Map<String, Object>> list = this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, (IExpression)paginatedExpression);
            return list;
        }
        finally {
            GenericJDBCUtilities.removeFields((ISQLQueryObject)sqlQueryObject, (JDBCPaginatedExpression)paginatedExpression, (FunctionField[])functionField);
        }
    }

    protected List<Map<String, Object>> selectEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IExpression expression) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.selectEngine(jdbcProperties, log, connection, sqlQueryObject, expression, null);
    }

    protected List<Map<String, Object>> selectEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IExpression expression, ISQLQueryObject sqlQueryObjectDistinct) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        ArrayList listaQuery = new ArrayList();
        ArrayList listaParams = new ArrayList();
        List returnField = GenericJDBCUtilities.prepareSelect((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getPluginFieldConverter(), (IModel)Plugin.model(), listaQuery, listaParams);
        this.joinEngine(expression, sqlQueryObject);
        List list = GenericJDBCUtilities.select((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)GenericJDBCUtilities.prepareSqlQueryObjectForSelectDistinct((ISQLQueryObject)sqlQueryObject, (ISQLQueryObject)sqlQueryObjectDistinct), (IExpression)expression, (ISQLFieldConverter)this.getPluginFieldConverter(), (IModel)Plugin.model(), listaQuery, listaParams, (List)returnField);
        if (list != null && !list.isEmpty()) {
            return list;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public List<Map<String, Object>> union(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Union union, UnionExpression ... unionExpression) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        List list;
        ArrayList sqlQueryObjectInnerList = new ArrayList();
        ArrayList jdbcObjects = new ArrayList();
        List returnClassTypes = GenericJDBCUtilities.prepareUnion((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getPluginFieldConverter(), (IModel)Plugin.model(), sqlQueryObjectInnerList, jdbcObjects, (Union)union, (UnionExpression[])unionExpression);
        if (unionExpression != null) {
            for (int i = 0; i < unionExpression.length; ++i) {
                UnionExpression ue = unionExpression[i];
                IExpression expression = ue.getExpression();
                this.joinEngine(expression, (ISQLQueryObject)sqlQueryObjectInnerList.get(i));
            }
        }
        if ((list = GenericJDBCUtilities.union((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getPluginFieldConverter(), (IModel)Plugin.model(), sqlQueryObjectInnerList, jdbcObjects, (List)returnClassTypes, (Union)union, (UnionExpression[])unionExpression)) != null && !list.isEmpty()) {
            return list;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public NonNegativeNumber unionCount(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Union union, UnionExpression ... unionExpression) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        NonNegativeNumber number;
        ArrayList sqlQueryObjectInnerList = new ArrayList();
        ArrayList jdbcObjects = new ArrayList();
        List returnClassTypes = GenericJDBCUtilities.prepareUnionCount((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getPluginFieldConverter(), (IModel)Plugin.model(), sqlQueryObjectInnerList, jdbcObjects, (Union)union, (UnionExpression[])unionExpression);
        if (unionExpression != null) {
            for (int i = 0; i < unionExpression.length; ++i) {
                UnionExpression ue = unionExpression[i];
                IExpression expression = ue.getExpression();
                this.joinEngine(expression, (ISQLQueryObject)sqlQueryObjectInnerList.get(i));
            }
        }
        if ((number = GenericJDBCUtilities.unionCount((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (ISQLFieldConverter)this.getPluginFieldConverter(), (IModel)Plugin.model(), sqlQueryObjectInnerList, jdbcObjects, (List)returnClassTypes, (Union)union, (UnionExpression[])unionExpression)) != null && number.longValue() >= 0L) {
            return number;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public JDBCExpression newExpression(Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCExpression((ISQLFieldConverter)this.getPluginFieldConverter());
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public JDBCPaginatedExpression newPaginatedExpression(Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCPaginatedExpression((ISQLFieldConverter)this.getPluginFieldConverter());
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public JDBCExpression toExpression(JDBCPaginatedExpression paginatedExpression, Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCExpression(paginatedExpression);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public JDBCPaginatedExpression toPaginatedExpression(JDBCExpression expression, Logger log) throws NotImplementedException, ServiceException {
        try {
            return new JDBCPaginatedExpression(expression);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void mappingTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdPlugin id, Plugin obj) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        this._mappingTableIds(jdbcProperties, log, connection, sqlQueryObject, obj, this.get(jdbcProperties, log, connection, sqlQueryObject, id, null));
    }

    public void mappingTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, Plugin obj) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        this._mappingTableIds(jdbcProperties, log, connection, sqlQueryObject, obj, this.get(jdbcProperties, log, connection, sqlQueryObject, tableId, (IDMappingBehaviour)null));
    }

    private void _mappingTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Plugin obj, Plugin imgSaved) throws NotFoundException, NotImplementedException, ServiceException, Exception {
        boolean objEqualsToImgSaved_;
        List<BaseBeanWithId> listImgSaved_;
        PluginServizioCompatibilita itemAlreadySaved_;
        List<BaseBeanWithId> listObj_;
        if (imgSaved == null) {
            return;
        }
        obj.setId(imgSaved.getId());
        if (obj.getPluginServizioCompatibilitaList() != null) {
            listObj_ = obj.getPluginServizioCompatibilitaList();
            for (BaseBeanWithId itemObj_ : listObj_) {
                itemAlreadySaved_ = null;
                if (imgSaved.getPluginServizioCompatibilitaList() != null) {
                    listImgSaved_ = imgSaved.getPluginServizioCompatibilitaList();
                    for (BaseBeanWithId itemImgSaved_ : listImgSaved_) {
                        objEqualsToImgSaved_ = false;
                        objEqualsToImgSaved_ = Utilities.equals((Object)itemObj_.getUriAccordo(), (Object)itemImgSaved_.getUriAccordo()) && Utilities.equals((Object)itemObj_.getServizio(), (Object)itemImgSaved_.getServizio());
                        if (!objEqualsToImgSaved_) continue;
                        itemAlreadySaved_ = itemImgSaved_;
                        break;
                    }
                }
                if (itemAlreadySaved_ == null) continue;
                itemObj_.setId(itemAlreadySaved_.getId());
                if (itemObj_.getPluginServizioAzioneCompatibilitaList() == null) continue;
                List<PluginServizioAzioneCompatibilita> listObj_pluginServizioCompatibilita = itemObj_.getPluginServizioAzioneCompatibilitaList();
                for (PluginServizioAzioneCompatibilita itemObj_pluginServizioCompatibilita : listObj_pluginServizioCompatibilita) {
                    PluginServizioAzioneCompatibilita itemAlreadySaved_pluginServizioCompatibilita = null;
                    if (itemAlreadySaved_.getPluginServizioAzioneCompatibilitaList() != null) {
                        List<PluginServizioAzioneCompatibilita> listImgSaved_pluginServizioCompatibilita = itemAlreadySaved_.getPluginServizioAzioneCompatibilitaList();
                        for (PluginServizioAzioneCompatibilita itemImgSaved_pluginServizioCompatibilita : listImgSaved_pluginServizioCompatibilita) {
                            boolean objEqualsToImgSaved_pluginServizioCompatibilita = false;
                            objEqualsToImgSaved_pluginServizioCompatibilita = Utilities.equals((Object)itemObj_pluginServizioCompatibilita.getAzione(), (Object)itemImgSaved_pluginServizioCompatibilita.getAzione());
                            if (!objEqualsToImgSaved_pluginServizioCompatibilita) continue;
                            itemAlreadySaved_pluginServizioCompatibilita = itemImgSaved_pluginServizioCompatibilita;
                            break;
                        }
                    }
                    if (itemAlreadySaved_pluginServizioCompatibilita == null) continue;
                    itemObj_pluginServizioCompatibilita.setId(itemAlreadySaved_pluginServizioCompatibilita.getId());
                }
            }
        }
        if (obj.getPluginProprietaCompatibilitaList() != null) {
            listObj_ = obj.getPluginProprietaCompatibilitaList();
            for (BaseBeanWithId itemObj_ : listObj_) {
                itemAlreadySaved_ = null;
                if (imgSaved.getPluginProprietaCompatibilitaList() != null) {
                    listImgSaved_ = imgSaved.getPluginProprietaCompatibilitaList();
                    for (BaseBeanWithId itemImgSaved_ : listImgSaved_) {
                        objEqualsToImgSaved_ = false;
                        objEqualsToImgSaved_ = Utilities.equals((Object)itemObj_.getNome(), (Object)itemImgSaved_.getNome());
                        if (!objEqualsToImgSaved_) continue;
                        itemAlreadySaved_ = itemImgSaved_;
                        break;
                    }
                }
                if (itemAlreadySaved_ == null) continue;
                itemObj_.setId(itemAlreadySaved_.getId());
            }
        }
    }

    public Plugin get(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        return this.getEngine(jdbcProperties, log, connection, sqlQueryObject, tableId, idMappingResolutionBehaviour);
    }

    private Plugin getEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Long tableId, IDMappingBehaviour idMappingResolutionBehaviour) throws NotFoundException, MultipleResultException, NotImplementedException, ServiceException, Exception {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectGet = sqlQueryObject.newSQLQueryObject();
        Plugin plugin = new Plugin();
        ISQLQueryObject sqlQueryObjectGet_plugin = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectGet_plugin.setANDLogicOperator(true);
        sqlQueryObjectGet_plugin.addFromTable(this.getPluginFieldConverter().toTable((IModel)Plugin.model()));
        sqlQueryObjectGet_plugin.addSelectField("id");
        sqlQueryObjectGet_plugin.addSelectField(this.getPluginFieldConverter().toColumn(Plugin.model().TIPO_PLUGIN, true));
        sqlQueryObjectGet_plugin.addSelectField(this.getPluginFieldConverter().toColumn(Plugin.model().CLASS_NAME, true));
        sqlQueryObjectGet_plugin.addSelectField(this.getPluginFieldConverter().toColumn(Plugin.model().TIPO, true));
        sqlQueryObjectGet_plugin.addSelectField(this.getPluginFieldConverter().toColumn(Plugin.model().DESCRIZIONE, true));
        sqlQueryObjectGet_plugin.addSelectField(this.getPluginFieldConverter().toColumn(Plugin.model().LABEL, true));
        sqlQueryObjectGet_plugin.addSelectField(this.getPluginFieldConverter().toColumn(Plugin.model().STATO, true));
        sqlQueryObjectGet_plugin.addWhereCondition("id=?");
        plugin = (Plugin)jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet_plugin.createSQLQuery(), jdbcProperties.isShowSql(), (IModel)Plugin.model(), (IJDBCFetch)this.getPluginFetch(), new JDBCObject[]{new JDBCObject((Object)tableId, Long.class)});
        ISQLQueryObject sqlQueryObjectGet_plugin_pluginServizioCompatibilita = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectGet_plugin_pluginServizioCompatibilita.setANDLogicOperator(true);
        sqlQueryObjectGet_plugin_pluginServizioCompatibilita.addFromTable(this.getPluginFieldConverter().toTable((IModel)Plugin.model().PLUGIN_SERVIZIO_COMPATIBILITA));
        sqlQueryObjectGet_plugin_pluginServizioCompatibilita.addSelectField("id");
        sqlQueryObjectGet_plugin_pluginServizioCompatibilita.addSelectField(this.getPluginFieldConverter().toColumn(Plugin.model().PLUGIN_SERVIZIO_COMPATIBILITA.URI_ACCORDO, true));
        sqlQueryObjectGet_plugin_pluginServizioCompatibilita.addSelectField(this.getPluginFieldConverter().toColumn(Plugin.model().PLUGIN_SERVIZIO_COMPATIBILITA.SERVIZIO, true));
        sqlQueryObjectGet_plugin_pluginServizioCompatibilita.addWhereCondition("id_plugin=?");
        List plugin_pluginServizioCompatibilita_list = jdbcUtilities.executeQuery(sqlQueryObjectGet_plugin_pluginServizioCompatibilita.createSQLQuery(), jdbcProperties.isShowSql(), (IModel)Plugin.model().PLUGIN_SERVIZIO_COMPATIBILITA, (IJDBCFetch)this.getPluginFetch(), new JDBCObject[]{new JDBCObject((Object)plugin.getId(), Long.class)});
        if (plugin_pluginServizioCompatibilita_list != null) {
            for (Object plugin_pluginServizioCompatibilita_object : plugin_pluginServizioCompatibilita_list) {
                PluginServizioCompatibilita plugin_pluginServizioCompatibilita = (PluginServizioCompatibilita)plugin_pluginServizioCompatibilita_object;
                ISQLQueryObject sqlQueryObjectGet_plugin_pluginServizioCompatibilita_pluginServizioAzioneCompatibilita = sqlQueryObjectGet.newSQLQueryObject();
                sqlQueryObjectGet_plugin_pluginServizioCompatibilita_pluginServizioAzioneCompatibilita.setANDLogicOperator(true);
                sqlQueryObjectGet_plugin_pluginServizioCompatibilita_pluginServizioAzioneCompatibilita.addFromTable(this.getPluginFieldConverter().toTable((IModel)Plugin.model().PLUGIN_SERVIZIO_COMPATIBILITA.PLUGIN_SERVIZIO_AZIONE_COMPATIBILITA));
                sqlQueryObjectGet_plugin_pluginServizioCompatibilita_pluginServizioAzioneCompatibilita.addSelectField("id");
                sqlQueryObjectGet_plugin_pluginServizioCompatibilita_pluginServizioAzioneCompatibilita.addSelectField(this.getPluginFieldConverter().toColumn(Plugin.model().PLUGIN_SERVIZIO_COMPATIBILITA.PLUGIN_SERVIZIO_AZIONE_COMPATIBILITA.AZIONE, true));
                sqlQueryObjectGet_plugin_pluginServizioCompatibilita_pluginServizioAzioneCompatibilita.addWhereCondition("id_plugin_servizio_comp=?");
                List plugin_pluginServizioCompatibilita_pluginServizioAzioneCompatibilita_list = jdbcUtilities.executeQuery(sqlQueryObjectGet_plugin_pluginServizioCompatibilita_pluginServizioAzioneCompatibilita.createSQLQuery(), jdbcProperties.isShowSql(), (IModel)Plugin.model().PLUGIN_SERVIZIO_COMPATIBILITA.PLUGIN_SERVIZIO_AZIONE_COMPATIBILITA, (IJDBCFetch)this.getPluginFetch(), new JDBCObject[]{new JDBCObject((Object)plugin_pluginServizioCompatibilita.getId(), Long.class)});
                if (plugin_pluginServizioCompatibilita_pluginServizioAzioneCompatibilita_list != null) {
                    for (Object plugin_pluginServizioCompatibilita_pluginServizioAzioneCompatibilita_object : plugin_pluginServizioCompatibilita_pluginServizioAzioneCompatibilita_list) {
                        PluginServizioAzioneCompatibilita plugin_pluginServizioCompatibilita_pluginServizioAzioneCompatibilita = (PluginServizioAzioneCompatibilita)plugin_pluginServizioCompatibilita_pluginServizioAzioneCompatibilita_object;
                        plugin_pluginServizioCompatibilita.addPluginServizioAzioneCompatibilita(plugin_pluginServizioCompatibilita_pluginServizioAzioneCompatibilita);
                    }
                }
                plugin.addPluginServizioCompatibilita(plugin_pluginServizioCompatibilita);
            }
        }
        ISQLQueryObject sqlQueryObjectGet_plugin_pluginProprietaCompatibilita = sqlQueryObjectGet.newSQLQueryObject();
        sqlQueryObjectGet_plugin_pluginProprietaCompatibilita.setANDLogicOperator(true);
        sqlQueryObjectGet_plugin_pluginProprietaCompatibilita.addFromTable(this.getPluginFieldConverter().toTable((IModel)Plugin.model().PLUGIN_PROPRIETA_COMPATIBILITA));
        sqlQueryObjectGet_plugin_pluginProprietaCompatibilita.addSelectField("id");
        sqlQueryObjectGet_plugin_pluginProprietaCompatibilita.addSelectField(this.getPluginFieldConverter().toColumn(Plugin.model().PLUGIN_PROPRIETA_COMPATIBILITA.NOME, true));
        sqlQueryObjectGet_plugin_pluginProprietaCompatibilita.addSelectField(this.getPluginFieldConverter().toColumn(Plugin.model().PLUGIN_PROPRIETA_COMPATIBILITA.VALORE, true));
        sqlQueryObjectGet_plugin_pluginProprietaCompatibilita.addWhereCondition("id_plugin=?");
        List plugin_pluginProprietaCompatibilita_list = jdbcUtilities.executeQuery(sqlQueryObjectGet_plugin_pluginProprietaCompatibilita.createSQLQuery(), jdbcProperties.isShowSql(), (IModel)Plugin.model().PLUGIN_PROPRIETA_COMPATIBILITA, (IJDBCFetch)this.getPluginFetch(), new JDBCObject[]{new JDBCObject((Object)plugin.getId(), Long.class)});
        if (plugin_pluginProprietaCompatibilita_list != null) {
            for (Object plugin_pluginProprietaCompatibilita_object : plugin_pluginProprietaCompatibilita_list) {
                PluginProprietaCompatibilita plugin_pluginProprietaCompatibilita = (PluginProprietaCompatibilita)plugin_pluginProprietaCompatibilita_object;
                plugin.addPluginProprietaCompatibilita(plugin_pluginProprietaCompatibilita);
            }
        }
        return plugin;
    }

    public boolean exists(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId) throws MultipleResultException, NotImplementedException, ServiceException, Exception {
        return this._exists(jdbcProperties, log, connection, sqlQueryObject, tableId);
    }

    private boolean _exists(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Long tableId) throws MultipleResultException, NotImplementedException, ServiceException, Exception {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        boolean existsPlugin = false;
        sqlQueryObject = sqlQueryObject.newSQLQueryObject();
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addFromTable(this.getPluginFieldConverter().toTable((IModel)Plugin.model()));
        sqlQueryObject.addSelectField(this.getPluginFieldConverter().toColumn(Plugin.model().TIPO_PLUGIN, true));
        sqlQueryObject.addWhereCondition("id=?");
        existsPlugin = jdbcUtilities.exists(sqlQueryObject.createSQLQuery(), jdbcProperties.isShowSql(), new JDBCObject[]{new JDBCObject((Object)tableId, Long.class)});
        return existsPlugin;
    }

    private void joinEngine(IExpression expression, ISQLQueryObject sqlQueryObject) throws NotImplementedException, ServiceException, Exception {
        String tableName2;
        String tableName1;
        if (expression.inUseModel((IModel)Plugin.model().PLUGIN_SERVIZIO_COMPATIBILITA, false)) {
            tableName1 = this.getPluginFieldConverter().toAliasTable((IModel)Plugin.model());
            tableName2 = this.getPluginFieldConverter().toAliasTable((IModel)Plugin.model().PLUGIN_SERVIZIO_COMPATIBILITA);
            sqlQueryObject.addWhereCondition(tableName1 + ".id=" + tableName2 + ".id_plugin");
        }
        if (expression.inUseModel((IModel)Plugin.model().PLUGIN_SERVIZIO_COMPATIBILITA.PLUGIN_SERVIZIO_AZIONE_COMPATIBILITA, false)) {
            tableName1 = this.getPluginFieldConverter().toAliasTable((IModel)Plugin.model().PLUGIN_SERVIZIO_COMPATIBILITA);
            tableName2 = this.getPluginFieldConverter().toAliasTable((IModel)Plugin.model().PLUGIN_SERVIZIO_COMPATIBILITA.PLUGIN_SERVIZIO_AZIONE_COMPATIBILITA);
            sqlQueryObject.addWhereCondition(tableName1 + ".id=" + tableName2 + ".id_plugin_servizio_comp");
        }
        if (expression.inUseModel((IModel)Plugin.model().PLUGIN_SERVIZIO_COMPATIBILITA.PLUGIN_SERVIZIO_AZIONE_COMPATIBILITA, false) && !expression.inUseModel((IModel)Plugin.model().PLUGIN_SERVIZIO_COMPATIBILITA, false)) {
            sqlQueryObject.addFromTable(this.getPluginFieldConverter().toTable((IModel)Plugin.model().PLUGIN_SERVIZIO_COMPATIBILITA));
        }
        AliasTableRicerchePersonalizzate.join(expression, sqlQueryObject, Plugin.model(), Plugin.model().PLUGIN_PROPRIETA_COMPATIBILITA, this.getFieldConverter());
    }

    protected List<Object> getRootTablePrimaryKeyValuesEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdPlugin id) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        ArrayList<Object> rootTableIdValues = new ArrayList<Object>();
        Long longId = this.findIdPlugin(jdbcProperties, log, connection, sqlQueryObject.newSQLQueryObject(), id, true);
        rootTableIdValues.add(longId);
        return rootTableIdValues;
    }

    protected Map<String, List<IField>> getMapTableToPKColumnEngine() throws NotImplementedException, Exception {
        PluginFieldConverter converter = this.getPluginFieldConverter();
        HashMap<String, List<IField>> mapTableToPKColumn = new HashMap<String, List<IField>>();
        UtilsTemplate utilities = new UtilsTemplate();
        mapTableToPKColumn.put(converter.toTable((IModel)Plugin.model()), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)Plugin.model()))}));
        mapTableToPKColumn.put(converter.toTable((IModel)Plugin.model().PLUGIN_SERVIZIO_COMPATIBILITA), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)Plugin.model().PLUGIN_SERVIZIO_COMPATIBILITA))}));
        mapTableToPKColumn.put(converter.toTable((IModel)Plugin.model().PLUGIN_SERVIZIO_COMPATIBILITA.PLUGIN_SERVIZIO_AZIONE_COMPATIBILITA), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)Plugin.model().PLUGIN_SERVIZIO_COMPATIBILITA.PLUGIN_SERVIZIO_AZIONE_COMPATIBILITA))}));
        mapTableToPKColumn.put(converter.toTable((IModel)Plugin.model().PLUGIN_PROPRIETA_COMPATIBILITA), utilities.newList((Object[])new IField[]{new CustomField("id", Long.class, "id", converter.toTable((IModel)Plugin.model().PLUGIN_PROPRIETA_COMPATIBILITA))}));
        return mapTableToPKColumn;
    }

    public List<Long> findAllTableIds(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCPaginatedExpression paginatedExpression) throws ServiceException, NotImplementedException, Exception {
        ArrayList<Long> list = new ArrayList<Long>();
        sqlQueryObject.setSelectDistinct(true);
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addSelectField(this.getPluginFieldConverter().toTable((IModel)Plugin.model()) + ".id");
        Class<Long> objectIdClass = Long.class;
        List listaQuery = GenericJDBCUtilities.prepareFindAll((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)paginatedExpression, (ISQLFieldConverter)this.getPluginFieldConverter(), (IModel)Plugin.model());
        this.joinEngine((IExpression)paginatedExpression, sqlQueryObject);
        List listObjects = GenericJDBCUtilities.findAll((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)paginatedExpression, (ISQLFieldConverter)this.getPluginFieldConverter(), (IModel)Plugin.model(), objectIdClass, (List)listaQuery);
        for (Object object : listObjects) {
            list.add((Long)object);
        }
        return list;
    }

    public long findTableId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, JDBCExpression expression) throws ServiceException, NotFoundException, MultipleResultException, NotImplementedException, Exception {
        sqlQueryObject.setSelectDistinct(true);
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addSelectField(this.getPluginFieldConverter().toTable((IModel)Plugin.model()) + ".id");
        Class<Long> objectIdClass = Long.class;
        List listaQuery = GenericJDBCUtilities.prepareFind((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getPluginFieldConverter(), (IModel)Plugin.model());
        this.joinEngine((IExpression)expression, sqlQueryObject);
        Object res = GenericJDBCUtilities.find((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (IExpression)expression, (ISQLFieldConverter)this.getPluginFieldConverter(), (IModel)Plugin.model(), objectIdClass, (List)listaQuery);
        if (res != null && (Long)res > 0L) {
            return (Long)res;
        }
        throw GenericJDBCUtilities.newNotFoundException();
    }

    public InUse inUse(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return this.inUseEngine(jdbcProperties, log, connection, sqlQueryObject, tableId);
    }

    private InUse inUseEngine(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, Long tableId) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        InUse inUse = new InUse();
        inUse.setInUse(false);
        boolean throwNotImplemented = true;
        if (throwNotImplemented) {
            throw new NotImplementedException("NotImplemented");
        }
        return inUse;
    }

    public IdPlugin findId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, long tableId, boolean throwNotFound) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
        ISQLQueryObject sqlQueryObjectGet = sqlQueryObject.newSQLQueryObject();
        sqlQueryObjectGet.addFromTable(this.getPluginFieldConverter().toTable((IModel)Plugin.model()));
        sqlQueryObjectGet.addSelectField(this.getPluginFieldConverter().toColumn(Plugin.model().TIPO_PLUGIN, true));
        sqlQueryObjectGet.addSelectField(this.getPluginFieldConverter().toColumn(Plugin.model().TIPO, true));
        sqlQueryObjectGet.addSelectField(this.getPluginFieldConverter().toColumn(Plugin.model().CLASS_NAME, true));
        sqlQueryObjectGet.addSelectField(this.getPluginFieldConverter().toColumn(Plugin.model().LABEL, true));
        sqlQueryObjectGet.setANDLogicOperator(true);
        sqlQueryObjectGet.addWhereCondition("id=?");
        JDBCObject[] searchParams_plugin = new JDBCObject[]{new JDBCObject((Object)tableId, Long.class)};
        ArrayList<Class<String>> listaFieldIdReturnType_plugin = new ArrayList<Class<String>>();
        listaFieldIdReturnType_plugin.add(String.class);
        listaFieldIdReturnType_plugin.add(String.class);
        IdPlugin id_plugin = null;
        List listaFieldId_plugin = jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet.createSQLQuery(), jdbcProperties.isShowSql(), listaFieldIdReturnType_plugin, searchParams_plugin);
        if (listaFieldId_plugin == null || listaFieldId_plugin.size() <= 0) {
            if (throwNotFound) {
                throw GenericJDBCUtilities.newNotFoundException();
            }
        } else {
            id_plugin = new IdPlugin();
            id_plugin.setTipoPlugin((String)listaFieldId_plugin.get(0));
            id_plugin.setTipo((String)listaFieldId_plugin.get(1));
            id_plugin.setClassName((String)listaFieldId_plugin.get(2));
            id_plugin.setLabel((String)listaFieldId_plugin.get(3));
        }
        return id_plugin;
    }

    public Long findTableId(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdPlugin id, boolean throwNotFound) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        return this.findIdPlugin(jdbcProperties, log, connection, sqlQueryObject, id, throwNotFound);
    }

    public List<List<Object>> nativeQuery(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, String sql, List<Class<?>> returnClassTypes, Object ... param) throws ServiceException, NotFoundException, NotImplementedException, Exception {
        return GenericJDBCUtilities.nativeQuery((JDBCServiceManagerProperties)jdbcProperties, (Logger)log, (Connection)connection, (ISQLQueryObject)sqlQueryObject, (String)sql, returnClassTypes, (Object[])param);
    }

    protected Long findIdPlugin(JDBCServiceManagerProperties jdbcProperties, Logger log, Connection connection, ISQLQueryObject sqlQueryObject, IdPlugin id, boolean throwNotFound) throws NotFoundException, ServiceException, NotImplementedException, Exception {
        Long id_plugin;
        block11: {
            if (jdbcProperties == null) {
                throw new ServiceException("Param jdbcProperties is null");
            }
            if (sqlQueryObject == null) {
                throw new ServiceException("Param sqlQueryObject is null");
            }
            if (id == null) {
                throw new ServiceException("Param id is null");
            }
            JDBCPreparedStatementUtilities jdbcUtilities = new JDBCPreparedStatementUtilities(sqlQueryObject.getTipoDatabaseOpenSPCoop2(), log, connection);
            ISQLQueryObject sqlQueryObjectGet = sqlQueryObject.newSQLQueryObject();
            if (id.getTipoPlugin() == null) {
                throw new ServiceException("Nell'identificativo di plugin deve essere fornito il tipo di plugin");
            }
            sqlQueryObjectGet.addFromTable(this.getPluginFieldConverter().toTable((IModel)Plugin.model()));
            sqlQueryObjectGet.addSelectField("id");
            sqlQueryObjectGet.setANDLogicOperator(true);
            sqlQueryObjectGet.setSelectDistinct(true);
            sqlQueryObjectGet.addWhereCondition(this.getPluginFieldConverter().toColumn(Plugin.model().TIPO_PLUGIN, true) + "=?");
            String valore = null;
            if (id.getTipo() != null) {
                sqlQueryObjectGet.addWhereCondition(this.getPluginFieldConverter().toColumn(Plugin.model().TIPO, true) + "=?");
                valore = id.getTipo();
            } else if (id.getClassName() != null) {
                sqlQueryObjectGet.addWhereCondition(this.getPluginFieldConverter().toColumn(Plugin.model().CLASS_NAME, true) + "=?");
                valore = id.getClassName();
            } else {
                throw new ServiceException("Nell'identificativo di plugin deve essere fornito almeno un tipo o un class name");
            }
            JDBCObject[] searchParams_plugin = new JDBCObject[]{new JDBCObject((Object)id.getTipoPlugin(), String.class), new JDBCObject((Object)valore, String.class)};
            id_plugin = null;
            try {
                id_plugin = (Long)jdbcUtilities.executeQuerySingleResult(sqlQueryObjectGet.createSQLQuery(), jdbcProperties.isShowSql(), Long.class, searchParams_plugin);
            }
            catch (NotFoundException notFound) {
                if (!throwNotFound) break block11;
                throw new NotFoundException((Throwable)notFound);
            }
        }
        if ((id_plugin == null || id_plugin <= 0L) && throwNotFound) {
            throw GenericJDBCUtilities.newNotFoundException();
        }
        return id_plugin;
    }
}

