/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.Filtri;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Azione;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.CostantiRegistroServizi;
import org.openspcoop2.core.registry.constants.ProfiloCollaborazione;
import org.openspcoop2.core.registry.constants.ProprietariDocumento;
import org.openspcoop2.core.registry.constants.RuoliDocumento;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.ValidazioneStatoPackageException;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_LIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_accordiGruppiDriver;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_accordiLIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_accordiRestDriver;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_accordiServiziCompostiDriver;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_accordiSoapDriver;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_documentiLIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_utilsDriver;
import org.openspcoop2.core.registry.driver.db.IDAccordoDB;
import org.openspcoop2.core.registry.driver.db.IDSoggettoDB;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverRegistroServiziDB_accordiDriver {
    private DriverRegistroServiziDB driver = null;
    private DriverRegistroServiziDB_accordiSoapDriver driverSoap = null;
    private DriverRegistroServiziDB_accordiRestDriver driverRest = null;
    private DriverRegistroServiziDB_accordiGruppiDriver driverGruppi = null;
    private DriverRegistroServiziDB_accordiServiziCompostiDriver driverAccordiServiziComposti = null;

    protected DriverRegistroServiziDB_accordiDriver(DriverRegistroServiziDB driver) {
        this.driver = driver;
        this.driverSoap = new DriverRegistroServiziDB_accordiSoapDriver(driver);
        this.driverRest = new DriverRegistroServiziDB_accordiRestDriver(driver);
        this.driverGruppi = new DriverRegistroServiziDB_accordiGruppiDriver(driver);
        this.driverAccordiServiziComposti = new DriverRegistroServiziDB_accordiServiziCompostiDriver(driver);
    }

    protected int getAccordoServizioParteComuneNextVersion(IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComuneNextVersion] Parametro idAccordo is null");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComuneNextVersion] Parametro idAccordo.getNome is null");
        }
        if (idAccordo.getNome().trim().equals("")) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComuneNextVersion] Parametro idAccordo.getNome non e' definito");
        }
        this.driver.logDebug("richiesto getAccordoServizioParteComuneNextVersion: " + idAccordo.toString());
        int nextVersion = -1;
        Connection con = null;
        try {
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = this.driver.atomica ? this.driver.getConnectionFromDatasource("getAccordoServizioParteComuneNextVersion(idAccordo)") : this.driver.globalConnection;
            nextVersion = DBUtils.getAccordoServizioParteComuneNextVersion(idAccordo, con, this.driver.tipoDB);
            this.driver.closeConnection(con);
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizioParteComuneNextVersion] Exception :" + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        return nextVersion;
    }

    protected AccordoServizioParteComune getAccordoServizioParteComune(IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteComune(idAccordo, false, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AccordoServizioParteComune getAccordoServizioParteComune(IDAccordo idAccordo, boolean readContenutoAllegati, boolean readDatiRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioParteComune accordoServizioParteComune;
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComune] Parametro idAccordo is null");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComune] Parametro idAccordo.getNome is null");
        }
        if (idAccordo.getNome().trim().equals("")) {
            throw new DriverRegistroServiziException("[getAccordoServizioParteComune] Parametro idAccordo.getNome non e' definito");
        }
        this.driver.logDebug("richiesto getAccordoServizioParteComune: " + idAccordo.toString());
        AccordoServizioParteComune accordoServizio = null;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        try {
            int i;
            long idReferente;
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = this.driver.atomica ? this.driver.getConnectionFromDatasource("getAccordoServizioParteComune(idAccordo)") : this.driver.globalConnection;
            long idAccordoLong = DBUtils.getIdAccordoServizioParteComune(idAccordo, con, this.driver.tipoDB);
            if (idAccordoLong <= 0L) {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoServizioParteComune] Accordo non trovato (id:" + String.valueOf(idAccordo) + ")");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong));
            rs = stm.executeQuery();
            if (!rs.next()) {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoServizioParteComune] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong));
            }
            accordoServizio = new AccordoServizioParteComune();
            accordoServizio.setId(rs.getLong("id"));
            String tmp = rs.getString("nome");
            accordoServizio.setNome(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("descrizione");
            accordoServizio.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("service_binding");
            accordoServizio.setServiceBinding(DriverRegistroServiziDB_LIB.getEnumServiceBinding(tmp == null || tmp.equals("") ? null : tmp));
            tmp = rs.getString("message_type");
            accordoServizio.setMessageType(DriverRegistroServiziDB_LIB.getEnumMessageType(tmp == null || tmp.equals("") ? null : tmp));
            tmp = rs.getString("profilo_collaborazione");
            accordoServizio.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
            if (accordoServizio.getProfiloCollaborazione() == null) {
                accordoServizio.setProfiloCollaborazione(ProfiloCollaborazione.ONEWAY);
            }
            accordoServizio.setFormatoSpecifica(DriverRegistroServiziDB_LIB.getEnumFormatoSpecifica((tmp = rs.getString("formato_specifica")) == null || tmp.equals("") ? null : tmp));
            tmp = rs.getString("wsdl_definitorio");
            accordoServizio.setByteWsdlDefinitorio(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
            tmp = rs.getString("wsdl_concettuale");
            accordoServizio.setByteWsdlConcettuale(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
            tmp = rs.getString("wsdl_logico_erogatore");
            accordoServizio.setByteWsdlLogicoErogatore(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
            tmp = rs.getString("wsdl_logico_fruitore");
            accordoServizio.setByteWsdlLogicoFruitore(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
            tmp = rs.getString("spec_conv_concettuale");
            accordoServizio.setByteSpecificaConversazioneConcettuale(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
            tmp = rs.getString("spec_conv_erogatore");
            accordoServizio.setByteSpecificaConversazioneErogatore(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
            tmp = rs.getString("spec_conv_fruitore");
            accordoServizio.setByteSpecificaConversazioneFruitore(tmp == null || tmp.trim().equals("") ? null : tmp.getBytes());
            accordoServizio.setUtilizzoSenzaAzione(rs.getInt("utilizzo_senza_azione") == 1);
            tmp = rs.getString("filtro_duplicati");
            accordoServizio.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
            tmp = rs.getString("conferma_ricezione");
            accordoServizio.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
            tmp = rs.getString("identificativo_collaborazione");
            accordoServizio.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
            tmp = rs.getString("id_riferimento_richiesta");
            accordoServizio.setIdRiferimentoRichiesta(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
            tmp = rs.getString("consegna_in_ordine");
            accordoServizio.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
            tmp = rs.getString("scadenza");
            accordoServizio.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
            tmp = rs.getString("superuser");
            accordoServizio.setSuperUser(tmp == null || tmp.equals("") ? null : tmp);
            if (rs.getInt("privato") == 1) {
                accordoServizio.setPrivato(true);
            } else {
                accordoServizio.setPrivato(false);
            }
            if (rs.getTimestamp("ora_registrazione") != null) {
                accordoServizio.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
            }
            if ((idReferente = rs.getLong("id_referente")) > 0L) {
                IDSoggetto soggettoReferente = null;
                try {
                    soggettoReferente = this.driver.getIdSoggetto(idReferente, con);
                    if (soggettoReferente == null) {
                        throw new DriverRegistroServiziNotFound("non esiste");
                    }
                }
                catch (DriverRegistroServiziNotFound notFound) {
                    throw new Exception("Soggetto referente [" + idReferente + "] dell'accordo non esiste");
                }
                IdSoggetto assr = new IdSoggetto();
                assr.setTipo(soggettoReferente.getTipo());
                assr.setNome(soggettoReferente.getNome());
                assr.setId(idReferente);
                accordoServizio.setSoggettoReferente(assr);
            }
            if (rs.getString("versione") != null && !"".equals(rs.getString("versione"))) {
                accordoServizio.setVersione(rs.getInt("versione"));
            }
            accordoServizio.setStatoPackage((tmp = rs.getString("stato")) == null || tmp.equals("") ? null : tmp);
            String canale = rs.getString("canale");
            accordoServizio.setCanale(canale);
            accordoServizio.setProprietaOggetto(DriverRegistroServiziDB_utilsDriver.readProprietaOggetto(rs, false));
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idAccordoLong);
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, idAccordoLong));
            rs = stm.executeQuery();
            Azione azione = null;
            while (rs.next()) {
                azione = new Azione();
                tmp = rs.getString("conferma_ricezione");
                azione.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("consegna_in_ordine");
                azione.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("filtro_duplicati");
                azione.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("identificativo_collaborazione");
                azione.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("id_riferimento_richiesta");
                azione.setIdRiferimentoRichiesta(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("nome");
                azione.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("scadenza");
                azione.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_collaborazione");
                azione.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("correlata");
                azione.setCorrelata(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_azione");
                if (tmp == null || tmp.equals("")) {
                    azione.setProfAzione("default");
                } else {
                    azione.setProfAzione(tmp);
                }
                long idAzione = rs.getLong("id");
                azione.setId(idAzione);
                try {
                    List<ProtocolProperty> listPP = DriverRegistroServiziDB_LIB.getListaProtocolProperty(idAzione, ProprietariProtocolProperty.AZIONE_ACCORDO, con, this.driver.tipoDB, this.driver.getDriverUnwrapBYOK());
                    if (listPP != null && !listPP.isEmpty()) {
                        for (ProtocolProperty protocolProperty : listPP) {
                            azione.addProtocolProperty(protocolProperty);
                        }
                    }
                }
                catch (DriverRegistroServiziNotFound listPP) {
                    // empty catch block
                }
                accordoServizio.addAzione(azione);
            }
            rs.close();
            stm.close();
            this.driverSoap.readPortTypes(accordoServizio, con);
            this.driverRest.readResources(accordoServizio, con, readDatiRegistro);
            this.driverGruppi.readAccordiGruppi(accordoServizio, con);
            this.driverAccordiServiziComposti.readAccordoServizioComposto(accordoServizio, con);
            try {
                List<Documento> allegati = DriverRegistroServiziDB_documentiLIB.getListaDocumenti(RuoliDocumento.allegato.toString(), idAccordoLong, ProprietariDocumento.accordoServizio, readContenutoAllegati, con, this.driver.tipoDB);
                for (i = 0; i < allegati.size(); ++i) {
                    accordoServizio.addAllegato(allegati.get(i));
                }
            }
            catch (DriverRegistroServiziNotFound allegati) {
                // empty catch block
            }
            try {
                List<Documento> specificheSemiformali = DriverRegistroServiziDB_documentiLIB.getListaDocumenti(RuoliDocumento.specificaSemiformale.toString(), idAccordoLong, ProprietariDocumento.accordoServizio, readContenutoAllegati, con, this.driver.tipoDB);
                for (i = 0; i < specificheSemiformali.size(); ++i) {
                    accordoServizio.addSpecificaSemiformale(specificheSemiformali.get(i));
                }
            }
            catch (DriverRegistroServiziNotFound specificheSemiformali) {
                // empty catch block
            }
            if (accordoServizio.getServizioComposto() != null) {
                try {
                    List<Documento> specificheCoordinamento = DriverRegistroServiziDB_documentiLIB.getListaDocumenti(RuoliDocumento.specificaCoordinamento.toString(), idAccordoLong, ProprietariDocumento.accordoServizio, readContenutoAllegati, con, this.driver.tipoDB);
                    for (i = 0; i < specificheCoordinamento.size(); ++i) {
                        accordoServizio.getServizioComposto().addSpecificaCoordinamento(specificheCoordinamento.get(i));
                    }
                }
                catch (DriverRegistroServiziNotFound specificheCoordinamento) {
                    // empty catch block
                }
            }
            try {
                List<ProtocolProperty> listPP = DriverRegistroServiziDB_LIB.getListaProtocolProperty(idAccordoLong, ProprietariProtocolProperty.ACCORDO_SERVIZIO_PARTE_COMUNE, con, this.driver.tipoDB, this.driver.getDriverUnwrapBYOK());
                if (listPP != null && !listPP.isEmpty()) {
                    for (ProtocolProperty protocolProperty : listPP) {
                        accordoServizio.addProtocolProperty(protocolProperty);
                    }
                }
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {}
            accordoServizioParteComune = accordoServizio;
        }
        catch (DriverRegistroServiziNotFound e) {
            try {
                throw e;
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizioParteComune] Exception :" + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return accordoServizioParteComune;
    }

    protected AccordoServizioParteComune getAccordoServizioParteComune(long id) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteComune(id, false, false, null);
    }

    protected AccordoServizioParteComune getAccordoServizioParteComune(long id, boolean readContenutoAllegati, boolean readDatiRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteComune(id, readContenutoAllegati, readDatiRegistro, null);
    }

    protected AccordoServizioParteComune getAccordoServizioParteComune(long id, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAccordoServizioParteComune(id, false, false, conParam);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AccordoServizioParteComune getAccordoServizioParteComune(long id, boolean readContenutoAllegati, boolean readDatiRegistro, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.driver.logDebug("richiesto getAccordoServizio: " + id);
        if (id <= 0L) {
            return null;
        }
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        IDAccordo idAccordo = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = conParam != null ? conParam : (this.driver.atomica ? this.driver.getConnectionFromDatasource("getAccordoServizioParteComune(longId)") : this.driver.globalConnection);
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            rs = stm.executeQuery();
            if (!rs.next()) {
                rs.close();
                stm.close();
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoServizio] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            }
            IDSoggetto referente = null;
            long idReferente = rs.getLong("id_referente");
            if (idReferente > 0L) {
                try {
                    referente = this.driver.getIdSoggetto(idReferente, con);
                    if (referente == null) {
                        throw new DriverRegistroServiziNotFound("non esiste");
                    }
                }
                catch (DriverRegistroServiziNotFound notFound) {
                    throw new Exception("Soggetto referente [" + idReferente + "] dell'accordo non esiste");
                }
            }
            idAccordo = this.driver.idAccordoFactory.getIDAccordoFromValues(rs.getString("nome"), referente, rs.getInt("versione"));
            rs.close();
            stm.close();
        }
        catch (SQLException se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizio] SQLException :" + se.getMessage(), se);
                catch (DriverRegistroServiziNotFound e) {
                    throw e;
                }
                catch (Exception se2) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoServizio] Exception :" + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(conParam, con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(conParam, con);
        return this.getAccordoServizioParteComune(idAccordo, readContenutoAllegati, readDatiRegistro);
    }

    protected List<AccordoServizioParteComune> accordiCompatibiliList(ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "accordiCompatibiliList";
        int idLista = Liste.ACCORDI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        this.driver.logDebug("search : " + search);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteComune> lista = new ArrayList<AccordoServizioParteComune>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("accordiCompatibiliList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlquery = DriverRegistroServiziDB_accordiLIB.getSQLRicercaAccordiValidi();
            sqlquery.setANDLogicOperator(true);
            ISQLQueryObject sqlQueryObjectSoggetti = null;
            if (!search.equals("")) {
                sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectSoggetti.addFromTable("soggetti");
                sqlQueryObjectSoggetti.addSelectField("soggetti", "nome_soggetto");
                sqlQueryObjectSoggetti.addWhereCondition(true, new String[]{sqlQueryObjectSoggetti.getWhereLikeCondition("nome_soggetto", search, true, true), "accordi.id_referente=soggetti.id"});
            }
            if (!search.equals("")) {
                sqlquery.addSelectCountField("*", "cont");
                sqlquery.addWhereCondition(false, new String[]{sqlquery.getWhereLikeCondition("nome", search, true, true), sqlquery.getWhereLikeCondition("versione", search, true, true), sqlquery.getWhereExistsCondition(false, sqlQueryObjectSoggetti)});
                queryString = sqlquery.createSQLQuery();
            } else {
                sqlquery.addSelectCountField("*", "cont");
                queryString = sqlquery.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            sqlquery = DriverRegistroServiziDB_accordiLIB.getSQLRicercaAccordiValidi();
            sqlquery.setANDLogicOperator(true);
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlquery.addSelectField("id");
                sqlquery.addSelectField("nome");
                sqlquery.addSelectField("descrizione");
                sqlquery.addSelectField("id_referente");
                sqlquery.addSelectField("versione");
                sqlquery.addSelectField("stato");
                sqlquery.addWhereCondition(false, new String[]{sqlquery.getWhereLikeCondition("nome", search, true, true), sqlquery.getWhereLikeCondition("versione", search, true, true), sqlquery.getWhereExistsCondition(false, sqlQueryObjectSoggetti)});
                sqlquery.addOrderBy("nome");
                sqlquery.addOrderBy("versione");
                sqlquery.addOrderBy("id_referente");
                sqlquery.setSortType(true);
                sqlquery.setLimit(limit);
                sqlquery.setOffset(offset);
                queryString = sqlquery.createSQLQuery();
            } else {
                sqlquery.addSelectField("id");
                sqlquery.addSelectField("nome");
                sqlquery.addSelectField("descrizione");
                sqlquery.addSelectField("id_referente");
                sqlquery.addSelectField("versione");
                sqlquery.addSelectField("stato");
                sqlquery.addOrderBy("nome");
                sqlquery.addOrderBy("versione");
                sqlquery.addOrderBy("id_referente");
                sqlquery.setSortType(true);
                sqlquery.setLimit(limit);
                sqlquery.setOffset(offset);
                queryString = sqlquery.createSQLQuery();
            }
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0]));
            stmt = con.prepareStatement(queryString);
            risultato = stmt.executeQuery();
            AccordoServizioParteComune accordo = null;
            while (risultato.next()) {
                accordo = new AccordoServizioParteComune();
                accordo.setId(risultato.getLong("id"));
                accordo.setNome(risultato.getString("nome"));
                accordo.setDescrizione(risultato.getString("descrizione"));
                accordo.setStatoPackage(risultato.getString("stato"));
                accordo.setVersione(risultato.getInt("versione"));
                long id_referente = risultato.getLong("id_referente");
                IDSoggetto soggettoReferente = null;
                if (id_referente > 0L) {
                    try {
                        soggettoReferente = this.driver.getIdSoggetto(id_referente, con);
                        if (soggettoReferente == null) {
                            throw new DriverRegistroServiziNotFound("non esiste");
                        }
                    }
                    catch (DriverRegistroServiziNotFound notFound) {
                        throw new Exception("Soggetto referente [" + id_referente + "] dell'accordo non esiste");
                    }
                    IdSoggetto assr = new IdSoggetto();
                    assr.setTipo(soggettoReferente.getTipo());
                    assr.setNome(soggettoReferente.getNome());
                    accordo.setSoggettoReferente(assr);
                }
                lista.add(accordo);
                this.driverAccordiServiziComposti.readAccordoServizioComposto(accordo, con);
            }
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return lista;
    }

    protected void createAccordoServizioParteComune(AccordoServizioParteComune accordoServizio) throws DriverRegistroServiziException {
        Connection connection = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                connection = this.driver.getConnectionFromDatasource("createAccordoServizioParteComune");
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::createAccordoServizioParteComune] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            DriverRegistroServiziDB_accordiLIB.createAccordoServizioParteComune(accordoServizio, connection, this.driver.tabellaSoggetti, this.driver.log, this.driver.idAccordoFactory, this.driver.getDriverWrapBYOK());
        }
        catch (DriverRegistroServiziException e) {
            error = true;
            throw e;
        }
        catch (Exception e) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createAccordoServizioParteComune] Exception [" + e.getMessage() + "].", e);
        }
        finally {
            this.driver.closeConnection(error, connection);
        }
    }

    protected void updateAccordoServizioParteComune(AccordoServizioParteComune accordoServizio) throws DriverRegistroServiziException {
        Connection connection = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                connection = this.driver.getConnectionFromDatasource("updateAccordoServizioParteComune");
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::createAccordoServizio] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            DriverRegistroServiziDB_accordiLIB.updateAccordoServizioParteComune(accordoServizio, connection, this.driver.tabellaSoggetti, this.driver.log, this.driver.idAccordoFactory, this.driver.getDriverWrapBYOK());
        }
        catch (DriverRegistroServiziException se) {
            this.driver.log.error(se.getMessage(), (Throwable)se);
            error = true;
            throw se;
        }
        catch (Exception se) {
            this.driver.log.error(se.getMessage(), (Throwable)se);
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateAccordoServizio] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            this.driver.closeConnection(error, connection);
        }
    }

    protected void deleteAccordoServizioParteComune(AccordoServizioParteComune accordoServizio) throws DriverRegistroServiziException {
        Connection connection = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                connection = this.driver.getConnectionFromDatasource("deleteAccordoServizioParteComune");
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::deleteAccordoServizioParteComune] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            DriverRegistroServiziDB_accordiLIB.deleteAccordoServizioParteComune(accordoServizio, connection, this.driver.tabellaSoggetti, this.driver.log, this.driver.idAccordoFactory, this.driver.getDriverWrapBYOK());
        }
        catch (DriverRegistroServiziException se) {
            error = true;
            throw se;
        }
        catch (Exception se) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteAccordoServizio] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            this.driver.closeConnection(error, connection);
        }
    }

    protected List<IDAccordoDB> idAccordiList(String superuser, ISearch ricerca, boolean soloAccordiConsistentiRest, boolean soloAccordiConsistentiSoap) throws DriverRegistroServiziException {
        return this.idAccordiListEngine(superuser, ricerca, false, false, soloAccordiConsistentiRest, soloAccordiConsistentiSoap);
    }

    protected List<IDAccordoDB> idAccordiServizioParteComuneList(String superuser, ISearch ricerca, boolean soloAccordiConsistentiRest, boolean soloAccordiConsistentiSoap) throws DriverRegistroServiziException {
        return this.idAccordiListEngine(superuser, ricerca, false, true, soloAccordiConsistentiRest, soloAccordiConsistentiSoap);
    }

    protected List<IDAccordoDB> idAccordiServizioCompostiList(String superuser, ISearch ricerca, boolean soloAccordiConsistentiRest, boolean soloAccordiConsistentiSoap) throws DriverRegistroServiziException {
        return this.idAccordiListEngine(superuser, ricerca, true, false, soloAccordiConsistentiRest, soloAccordiConsistentiSoap);
    }

    private List<IDAccordoDB> idAccordiListEngine(String superuser, ISearch ricerca, boolean excludeASParteComune, boolean excludeASComposti, boolean soloAccordiConsistentiRest, boolean soloAccordiConsistentiSoap) throws DriverRegistroServiziException {
        ArrayList<IDAccordoDB> arrayList;
        String nomeMetodo = "idAccordiList";
        int idLista = Liste.ACCORDI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        String filterProtocollo = SearchUtils.getFilter(ricerca, idLista, "filtroProtocollo");
        String filterProtocolli = SearchUtils.getFilter(ricerca, idLista, "filtroProtocolli");
        List<String> tipoSoggettiProtocollo = null;
        try {
            tipoSoggettiProtocollo = Filtri.convertToTipiSoggetti(filterProtocollo, filterProtocolli);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException(e.getMessage(), e);
        }
        boolean searchByTipoSoggetto = tipoSoggettiProtocollo != null && tipoSoggettiProtocollo.size() > 0;
        String filterTipoAPI = SearchUtils.getFilter(ricerca, idLista, "filtroServiceBinding");
        String filterStatoAccordo = SearchUtils.getFilter(ricerca, idLista, "filtroStatoAccordo");
        String filterGruppo = SearchUtils.getFilter(ricerca, idLista, "filtroGruppo");
        String filterCanale = SearchUtils.getFilter(ricerca, idLista, "filtroCanale");
        boolean searchCanale = false;
        boolean canaleDefault = false;
        if (filterCanale != null && !filterCanale.equals("")) {
            searchCanale = true;
            if (filterCanale.startsWith("__DEFAULT__ ")) {
                filterCanale = filterCanale.substring("__DEFAULT__ ".length());
                canaleDefault = true;
            }
        }
        this.driver.logDebug("search : " + search);
        this.driver.logDebug("filterProtocollo : " + filterProtocollo);
        this.driver.logDebug("filterProtocolli : " + filterProtocolli);
        this.driver.logDebug("filterTipoAPI : " + filterTipoAPI);
        this.driver.logDebug("filterStatoAccordo : " + filterStatoAccordo);
        this.driver.logDebug("filterGruppo : " + filterGruppo);
        this.driver.logDebug("filterCanale : " + filterCanale);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<IDAccordoDB> lista = new ArrayList<IDAccordoDB>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("accordiListEngine");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            if (excludeASComposti && excludeASParteComune) {
                throw new Exception("Non e' possibile invocare il metodo accordiListEngine con entrambi i parametri excludeASParteComune,excludeASComposti impostati al valore true");
            }
            ISQLQueryObject sqlQueryObjectExclude = null;
            if (excludeASComposti || excludeASParteComune) {
                sqlQueryObjectExclude = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectExclude.addFromTable("acc_serv_composti");
                sqlQueryObjectExclude.addSelectField("acc_serv_composti", "id_accordo");
                sqlQueryObjectExclude.addWhereCondition("acc_serv_composti.id_accordo=accordi.id");
            }
            ISQLQueryObject sqlQueryObjectExistsResource = null;
            if (soloAccordiConsistentiRest) {
                sqlQueryObjectExistsResource = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectExistsResource.addFromTable("api_resources");
                sqlQueryObjectExistsResource.addSelectField("api_resources", "id_accordo");
                sqlQueryObjectExistsResource.addWhereCondition("api_resources.id_accordo=accordi.id");
                sqlQueryObjectExistsResource.setANDLogicOperator(true);
            }
            ISQLQueryObject sqlQueryObjectExistsPortTypeConAzioni = null;
            if (soloAccordiConsistentiSoap) {
                ISQLQueryObject sqlQueryObjectExistsPortTypeCheckAzioni = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectExistsPortTypeCheckAzioni.addFromTable("port_type_azioni");
                sqlQueryObjectExistsPortTypeCheckAzioni.addSelectField("port_type_azioni", "id_port_type");
                sqlQueryObjectExistsPortTypeCheckAzioni.addWhereCondition("port_type_azioni.id_port_type=port_type.id");
                sqlQueryObjectExistsPortTypeCheckAzioni.setANDLogicOperator(true);
                sqlQueryObjectExistsPortTypeConAzioni = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectExistsPortTypeConAzioni.addFromTable("port_type");
                sqlQueryObjectExistsPortTypeConAzioni.addSelectField("port_type", "id_accordo");
                sqlQueryObjectExistsPortTypeConAzioni.addWhereCondition("port_type.id_accordo=accordi.id");
                sqlQueryObjectExistsPortTypeConAzioni.addWhereExistsCondition(false, sqlQueryObjectExistsPortTypeCheckAzioni);
                sqlQueryObjectExistsPortTypeConAzioni.setANDLogicOperator(true);
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addWhereCondition("accordi.id_referente=soggetti.id");
            sqlQueryObject.addSelectCountField("*", "cont");
            if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                sqlQueryObject.addWhereCondition("accordi.superuser = ?");
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("accordi.nome", search, true, true)});
            }
            if (searchByTipoSoggetto) {
                sqlQueryObject.addWhereINCondition("tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
            }
            if (excludeASParteComune) {
                sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectExclude);
            }
            if (excludeASComposti) {
                sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectExclude);
            }
            if (filterTipoAPI != null && !filterTipoAPI.equals("")) {
                sqlQueryObject.addWhereCondition("accordi.service_binding = ?");
            }
            if (filterStatoAccordo != null && !filterStatoAccordo.equals("")) {
                sqlQueryObject.addWhereCondition("accordi.stato = ?");
            }
            if (filterGruppo != null && !filterGruppo.equals("")) {
                sqlQueryObject.addFromTable("accordi_gruppi");
                sqlQueryObject.addFromTable("gruppi");
                sqlQueryObject.addWhereCondition("accordi_gruppi.id_accordo=accordi.id");
                sqlQueryObject.addWhereCondition("accordi_gruppi.id_gruppo=gruppi.id");
                sqlQueryObject.addWhereCondition("gruppi.nome = ?");
            }
            if (soloAccordiConsistentiRest && soloAccordiConsistentiSoap) {
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObjectExistsResource.getWhereExistsCondition(false, sqlQueryObjectExistsResource), sqlQueryObjectExistsPortTypeConAzioni.getWhereExistsCondition(false, sqlQueryObjectExistsPortTypeConAzioni)});
            } else if (soloAccordiConsistentiRest) {
                sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectExistsResource);
            } else if (soloAccordiConsistentiSoap) {
                sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectExistsPortTypeConAzioni);
            }
            if (searchCanale) {
                if (canaleDefault) {
                    sqlQueryObject.addWhereCondition(false, new String[]{"accordi.canale = ?", "accordi.canale is null"});
                } else {
                    sqlQueryObject.addWhereCondition("accordi.canale = ?");
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int index = 1;
            if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                stmt.setString(index++, superuser);
            }
            if (filterTipoAPI != null && !filterTipoAPI.equals("")) {
                stmt.setString(index++, filterTipoAPI);
            }
            if (filterStatoAccordo != null && !filterStatoAccordo.equals("")) {
                stmt.setString(index++, filterStatoAccordo);
            }
            if (filterGruppo != null && !filterGruppo.equals("")) {
                stmt.setString(index++, filterGruppo);
            }
            if (searchCanale) {
                stmt.setString(index++, filterCanale);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectAliasField("accordi", "id", "idAccordo");
            sqlQueryObject.addSelectAliasField("accordi", "nome", "nomeAccordo");
            sqlQueryObject.addSelectField("accordi", "versione");
            sqlQueryObject.addSelectField("soggetti", "tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti", "nome_soggetto");
            sqlQueryObject.addSelectAliasField("soggetti", "id", "idSoggetto");
            sqlQueryObject.addWhereCondition("accordi.id_referente=soggetti.id");
            if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                sqlQueryObject.addWhereCondition("accordi.superuser = ?");
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("accordi.nome", search, true, true)});
            }
            if (searchByTipoSoggetto) {
                sqlQueryObject.addWhereINCondition("tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
            }
            if (excludeASParteComune) {
                sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectExclude);
            }
            if (excludeASComposti) {
                sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectExclude);
            }
            if (filterTipoAPI != null && !filterTipoAPI.equals("")) {
                sqlQueryObject.addWhereCondition("accordi.service_binding = ?");
            }
            if (filterStatoAccordo != null && !filterStatoAccordo.equals("")) {
                sqlQueryObject.addWhereCondition("accordi.stato = ?");
            }
            if (filterGruppo != null && !filterGruppo.equals("")) {
                sqlQueryObject.addFromTable("accordi_gruppi");
                sqlQueryObject.addFromTable("gruppi");
                sqlQueryObject.addWhereCondition("accordi_gruppi.id_accordo=accordi.id");
                sqlQueryObject.addWhereCondition("accordi_gruppi.id_gruppo=gruppi.id");
                sqlQueryObject.addWhereCondition("gruppi.nome = ?");
            }
            if (soloAccordiConsistentiRest && soloAccordiConsistentiSoap) {
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObjectExistsResource.getWhereExistsCondition(false, sqlQueryObjectExistsResource), sqlQueryObjectExistsPortTypeConAzioni.getWhereExistsCondition(false, sqlQueryObjectExistsPortTypeConAzioni)});
            } else if (soloAccordiConsistentiRest) {
                sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectExistsResource);
            } else if (soloAccordiConsistentiSoap) {
                sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectExistsPortTypeConAzioni);
            }
            if (searchCanale) {
                if (canaleDefault) {
                    sqlQueryObject.addWhereCondition(false, new String[]{"accordi.canale = ?", "accordi.canale is null"});
                } else {
                    sqlQueryObject.addWhereCondition("accordi.canale = ?");
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nomeAccordo");
            sqlQueryObject.addOrderBy("versione");
            sqlQueryObject.addOrderBy("nome_soggetto");
            sqlQueryObject.addOrderBy("tipo_soggetto");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0]));
            stmt = con.prepareStatement(queryString);
            index = 1;
            if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                stmt.setString(index++, superuser);
            }
            if (filterTipoAPI != null && !filterTipoAPI.equals("")) {
                stmt.setString(index++, filterTipoAPI);
            }
            if (filterStatoAccordo != null && !filterStatoAccordo.equals("")) {
                stmt.setString(index++, filterStatoAccordo);
            }
            if (filterGruppo != null && !filterGruppo.equals("")) {
                stmt.setString(index++, filterGruppo);
            }
            if (searchCanale) {
                stmt.setString(index++, filterCanale);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                IDSoggettoDB idSoggettoDB = new IDSoggettoDB(risultato.getString("tipo_soggetto"), risultato.getString("nome_soggetto"));
                idSoggettoDB.setId(risultato.getLong("idSoggetto"));
                IDAccordoDB idAccordoDB = new IDAccordoDB(risultato.getString("nomeAccordo"), idSoggettoDB, risultato.getInt("versione"));
                idAccordoDB.setId(risultato.getLong("idAccordo"));
                lista.add(idAccordoDB);
            }
            this.driver.logDebug("size lista :" + (lista == null ? null : Integer.valueOf(lista.size())));
            arrayList = lista;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AccordoServizioParteComune[] getAllIdAccordiWithSoggettoReferente(IDSoggetto idsoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioParteComune[] accordoServizioParteComuneArray;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        this.driver.logDebug("getAllIdAccordiWithSoggettoReferente...");
        try {
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = this.driver.atomica ? this.driver.getConnectionFromDatasource("getAllIdAccordiWithSoggettoReferente") : this.driver.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectAliasField("accordi", "id", "idAccordo");
            sqlQueryObject.addWhereCondition("accordi.id_referente=soggetti.id");
            sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto=?");
            sqlQueryObject.addWhereCondition("soggetti.nome_soggetto=?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.driver.logDebug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, idsoggetto.getTipo());
            stm.setString(2, idsoggetto.getNome());
            rs = stm.executeQuery();
            ArrayList<AccordoServizioParteComune> accordi = new ArrayList<AccordoServizioParteComune>();
            while (rs.next()) {
                accordi.add(this.getAccordoServizioParteComune(rs.getLong("idAccordo")));
            }
            if (accordi.size() == 0) {
                throw new DriverRegistroServiziNotFound("Accordi non trovati con soggetto referente [" + String.valueOf(idsoggetto) + "]");
            }
            AccordoServizioParteComune[] res = new AccordoServizioParteComune[1];
            accordoServizioParteComuneArray = accordi.toArray(res);
        }
        catch (DriverRegistroServiziNotFound de) {
            try {
                throw de;
                catch (Exception e) {
                    throw new DriverRegistroServiziException("getAllIdAccordiWithSoggettoReferente error", e);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return accordoServizioParteComuneArray;
    }

    protected IDAccordo getIdAccordoServizioParteComune(long id) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getIdAccordoServizioParteComune(id, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IDAccordo getIdAccordoServizioParteComune(long id, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.driver.logDebug("richiesto getIdAccordoServizioParteComune: " + id);
        if (id <= 0L) {
            return null;
        }
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        IDAccordo idAccordo = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("id_referente");
            sqlQueryObject.addSelectField("versione");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = conParam != null ? conParam : (this.driver.atomica ? this.driver.getConnectionFromDatasource("getIdAccordoServizioParteComune(longId)") : this.driver.globalConnection);
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            rs = stm.executeQuery();
            if (!rs.next()) {
                rs.close();
                stm.close();
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getIdAccordoServizioParteComune] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            }
            IDSoggetto referente = null;
            long idReferente = rs.getLong("id_referente");
            if (idReferente > 0L && (referente = this.driver.getIdSoggetto(idReferente, con)) == null) {
                throw new Exception("Soggetto referente non presente?");
            }
            idAccordo = this.driver.idAccordoFactory.getIDAccordoFromValues(rs.getString("nome"), referente, rs.getInt("versione"));
            rs.close();
            stm.close();
        }
        catch (SQLException se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getIdAccordoServizioParteComune] SQLException :" + se.getMessage(), se);
                catch (DriverRegistroServiziNotFound e) {
                    throw e;
                }
                catch (Exception se2) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getIdAccordoServizioParteComune] Exception :" + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(conParam, con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(conParam, con);
        return idAccordo;
    }

    protected List<Documento> accordiAllegatiList(long idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        ArrayList<Documento> arrayList;
        String nomeMetodo = "accordiAllegatiList";
        int idLista = Liste.ACCORDI_ALLEGATI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Documento> lista = new ArrayList<Documento>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("accordiAllegatiList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("documenti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_proprietario = ?");
                sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("nome", search, true, true)});
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("documenti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_proprietario = ?");
                sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            stmt.setString(2, ProprietariDocumento.accordoServizio.toString());
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("documenti");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("ruolo");
            sqlQueryObject.addSelectField("id_proprietario");
            sqlQueryObject.addSelectField("tipo_proprietario");
            sqlQueryObject.addWhereCondition("id_proprietario = ?");
            sqlQueryObject.addWhereCondition("tipo_proprietario = ?");
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("nome", search, true, true)});
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            stmt.setString(2, ProprietariDocumento.accordoServizio.toString());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Documento doc = DriverRegistroServiziDB_documentiLIB.getDocumento(risultato.getLong("id"), false, con, this.driver.tipoDB);
                lista.add(doc);
            }
            arrayList = lista;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<IDServizio> getIdServiziWithAccordo(IDAccordo idAccordo, boolean checkPTisNull) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDServizio> arrayList;
        String nomeMetodo = "getIdServiziWithPortType";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getIdServiziWithAccordo");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.atomica = " + this.driver.atomica);
        ArrayList<IDServizio> idServizi = new ArrayList<IDServizio>();
        try {
            long idAccordoLong = DBUtils.getIdAccordoServizioParteComune(idAccordo, con, this.driver.tipoDB);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("nome_servizio");
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("versione_servizio");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("servizi.id_accordo=?");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto=soggetti.id");
            if (checkPTisNull) {
                sqlQueryObject.addWhereCondition("servizi.port_type is null");
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordoLong);
            rs = stmt.executeQuery();
            while (rs.next()) {
                IDSoggetto soggettoErogatore = new IDSoggetto(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"));
                IDServizio idServizio = this.driver.idServizioFactory.getIDServizioFromValues(rs.getString("tipo_servizio"), rs.getString("nome_servizio"), soggettoErogatore, rs.getInt("versione_servizio"));
                idServizi.add(idServizio);
            }
            if (idServizi.size() <= 0) {
                throw new DriverRegistroServiziNotFound("Servizi non trovato che implementano l'accordo di servizio " + idAccordo.toString());
            }
            arrayList = idServizi;
        }
        catch (DriverRegistroServiziNotFound dNot) {
            try {
                throw dNot;
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected void validaStatoAccordoServizio(AccordoServizioParteComune as, boolean utilizzoAzioniDiretteInAccordoAbilitato) throws ValidazioneStatoPackageException {
        ValidazioneStatoPackageException erroreValidazione;
        block51: {
            erroreValidazione = new ValidazioneStatoPackageException("AccordoServizio", as.getStatoPackage(), null);
            try {
                if (!(as.getPrivato() != null && as.getPrivato().booleanValue() || as.getSoggettoReferente() == null)) {
                    IDSoggetto idS = new IDSoggetto(as.getSoggettoReferente().getTipo(), as.getSoggettoReferente().getNome());
                    try {
                        Soggetto s = this.driver.getSoggetto(idS);
                        if (s.getPrivato() != null && s.getPrivato().booleanValue()) {
                            erroreValidazione.addErroreValidazione("soggetto referente [" + String.valueOf(idS) + "] con visibilita' privata, in un accordo di servizio con visibilita' pubblica");
                        }
                    }
                    catch (DriverRegistroServiziNotFound s) {
                        // empty catch block
                    }
                }
                if (as.getServizioComposto() != null) {
                    if (as.getServizioComposto().getIdAccordoCooperazione() > 0L) {
                        try {
                            AccordoCooperazione ac = this.driver.getAccordoCooperazione(as.getServizioComposto().getIdAccordoCooperazione());
                            if ((as.getPrivato() == null || !as.getPrivato().booleanValue()) && ac.getPrivato() != null && ac.getPrivato().booleanValue()) {
                                erroreValidazione.addErroreValidazione("accordo di cooperazione [" + this.driver.idAccordoCooperazioneFactory.getUriFromAccordo(ac) + "] con visibilita' privata, in un accordo di servizio con visibilita' pubblica");
                            }
                        }
                        catch (DriverRegistroServiziNotFound ac) {
                            // empty catch block
                        }
                    }
                    if (as.getServizioComposto().sizeServizioComponenteList() >= 2) {
                        for (int i = 0; i < as.getServizioComposto().sizeServizioComponenteList(); ++i) {
                            if (as.getServizioComposto().getServizioComponente(i).getId() <= 0L) continue;
                            try {
                                AccordoServizioParteSpecifica sc = this.driver.getAccordoServizioParteSpecifica(as.getServizioComposto().getServizioComponente(i).getId());
                                if (as.getPrivato() != null && as.getPrivato().booleanValue() || sc.getPrivato() == null || !sc.getPrivato().booleanValue()) continue;
                                String uriServizioComponente = this.driver.idServizioFactory.getUriFromAccordo(sc);
                                erroreValidazione.addErroreValidazione("servizio componente [" + uriServizioComponente + "] con visibilita' privata, in un accordo di servizio con visibilita' pubblica");
                                continue;
                            }
                            catch (DriverRegistroServiziNotFound sc) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (ServiceBinding.SOAP.equals(as.getServiceBinding())) {
                    if (StatiAccordo.bozza.toString().equals(as.getStatoPackage())) break block51;
                    if (!utilizzoAzioniDiretteInAccordoAbilitato) {
                        if (as.sizePortTypeList() == 0) {
                            erroreValidazione.addErroreValidazione("non sono definiti Servizi");
                        }
                        for (int j = 0; j < as.sizePortTypeList(); ++j) {
                            if (as.getPortType(j).sizeAzioneList() != 0) continue;
                            erroreValidazione.addErroreValidazione("servizio[" + as.getPortType(j).getNome() + "] non possiede azioni");
                        }
                    } else {
                        if (as.sizePortTypeList() == 0 && as.sizeAzioneList() == 0 && !as.getUtilizzoSenzaAzione()) {
                            erroreValidazione.addErroreValidazione("non sono definite ne Azioni (utilizzoSenzaAzione=false) ne Servizi");
                        }
                        if (as.sizePortTypeList() != 0) {
                            for (int j = 0; j < as.sizePortTypeList(); ++j) {
                                if (as.getPortType(j).sizeAzioneList() != 0) continue;
                                erroreValidazione.addErroreValidazione("servizio[" + as.getPortType(j).getNome() + "] non possiede azioni");
                            }
                        }
                        if (as.sizePortTypeList() != 0) {
                            for (int j = 0; j < as.sizePortTypeList(); ++j) {
                                PortType pt = as.getPortType(j);
                                for (int k = 0; k < pt.sizeAzioneList(); ++k) {
                                    Operation op = pt.getAzione(k);
                                    ProfiloCollaborazione profiloCollaborazioneOP = op.getProfiloCollaborazione();
                                    if ("default".equals(op.getProfAzione())) {
                                        profiloCollaborazioneOP = pt.getProfiloCollaborazione();
                                        if ("default".equals(pt.getProfiloPT())) {
                                            profiloCollaborazioneOP = as.getProfiloCollaborazione();
                                        }
                                    }
                                    if (!CostantiRegistroServizi.ASINCRONO_ASIMMETRICO.equals(profiloCollaborazioneOP) && !CostantiRegistroServizi.ASINCRONO_SIMMETRICO.equals(profiloCollaborazioneOP) || op.getCorrelata() != null) continue;
                                    boolean trovataCorrelazione = false;
                                    block17: for (int verificaPTIndex = 0; verificaPTIndex < as.sizePortTypeList(); ++verificaPTIndex) {
                                        PortType ptVerifica = as.getPortType(verificaPTIndex);
                                        for (int verificaOPIndex = 0; verificaOPIndex < ptVerifica.sizeAzioneList(); ++verificaOPIndex) {
                                            Operation opVerifica = ptVerifica.getAzione(verificaOPIndex);
                                            if (opVerifica.getCorrelata() == null || !opVerifica.getCorrelata().equals(op.getNome())) continue;
                                            if (opVerifica.getCorrelataServizio() == null) {
                                                if (!CostantiRegistroServizi.ASINCRONO_ASIMMETRICO.equals(profiloCollaborazioneOP) || !ptVerifica.getNome().equals(pt.getNome())) continue;
                                                trovataCorrelazione = true;
                                                continue block17;
                                            }
                                            if (!opVerifica.getCorrelataServizio().equals(pt.getNome())) continue;
                                            trovataCorrelazione = true;
                                            continue block17;
                                        }
                                    }
                                    if (trovataCorrelazione) continue;
                                    erroreValidazione.addErroreValidazione("L'azione [" + op.getNome() + "] del servizio[" + as.getPortType(j).getNome() + "] non risulta correlata da altre azioni");
                                }
                            }
                        }
                    }
                    if (!StatiAccordo.finale.toString().equals(as.getStatoPackage())) break block51;
                    String wsdlConcettuale = as.getByteWsdlConcettuale() != null ? new String(as.getByteWsdlConcettuale()) : null;
                    String wsdlLogicoErogatore = as.getByteWsdlLogicoErogatore() != null ? new String(as.getByteWsdlLogicoErogatore()) : null;
                    wsdlConcettuale = wsdlConcettuale != null && !"".equals(wsdlConcettuale.trim().replaceAll("\n", "")) ? wsdlConcettuale : null;
                    String string = wsdlLogicoErogatore = wsdlLogicoErogatore != null && !"".equals(wsdlLogicoErogatore.trim().replaceAll("\n", "")) ? wsdlLogicoErogatore : null;
                    if (wsdlConcettuale == null) {
                        erroreValidazione.addErroreValidazione("interfaccia WSDL Concettuale non definita");
                    }
                    if (wsdlLogicoErogatore == null) {
                        erroreValidazione.addErroreValidazione("interfaccia WSDL LogicoErogatore non definita");
                    }
                    if (as.getServizioComposto() == null) break block51;
                    if (as.getServizioComposto().getIdAccordoCooperazione() <= 0L) {
                        erroreValidazione.addErroreValidazione("accordo di cooperazione (id) non definito");
                    } else {
                        try {
                            AccordoCooperazione ac = this.driver.getAccordoCooperazione(as.getServizioComposto().getIdAccordoCooperazione());
                            if (!StatiAccordo.finale.toString().equals(ac.getStatoPackage())) {
                                erroreValidazione.addErroreValidazione("accordo di cooperazione [" + this.driver.idAccordoCooperazioneFactory.getUriFromAccordo(ac) + "] in uno stato non finale [" + ac.getStatoPackage() + "]");
                            }
                        }
                        catch (DriverRegistroServiziNotFound dNot) {
                            erroreValidazione.addErroreValidazione("accordo di cooperazione non definito");
                        }
                    }
                    if (as.getServizioComposto().sizeSpecificaCoordinamentoList() <= 0) {
                        erroreValidazione.addErroreValidazione("specifica di coordinamento non definita");
                    }
                    if (as.getServizioComposto().sizeServizioComponenteList() <= 0) {
                        erroreValidazione.addErroreValidazione("servizi componenti non definiti");
                    } else if (as.getServizioComposto().sizeServizioComponenteList() < 2) {
                        erroreValidazione.addErroreValidazione("almeno 2 servizi componenti sono necessari per realizzare un servizio composto");
                    } else {
                        for (int i = 0; i < as.getServizioComposto().sizeServizioComponenteList(); ++i) {
                            if (as.getServizioComposto().getServizioComponente(i).getIdServizioComponente() <= 0L) {
                                erroreValidazione.addErroreValidazione("servizio componente [" + i + "] (id) non definito");
                                continue;
                            }
                            try {
                                AccordoServizioParteSpecifica sc = this.driver.getAccordoServizioParteSpecifica(as.getServizioComposto().getServizioComponente(i).getIdServizioComponente());
                                if (StatiAccordo.finale.toString().equals(sc.getStatoPackage())) continue;
                                String uriServizioComponente = this.driver.idServizioFactory.getUriFromAccordo(sc);
                                erroreValidazione.addErroreValidazione("servizio componente [" + uriServizioComponente + "] in uno stato non finale [" + sc.getStatoPackage() + "]");
                                continue;
                            }
                            catch (DriverRegistroServiziNotFound dNot) {
                                erroreValidazione.addErroreValidazione("servizio componente [" + i + "] non definito");
                            }
                        }
                    }
                    break block51;
                }
                if (!StatiAccordo.bozza.toString().equals(as.getStatoPackage()) && as.sizeResourceList() == 0) {
                    erroreValidazione.addErroreValidazione("non sono definite alcune risorse");
                }
                if (StatiAccordo.finale.toString().equals(as.getStatoPackage())) {
                    String wsdlConcettuale = as.getByteWsdlConcettuale() != null ? new String(as.getByteWsdlConcettuale()) : null;
                    String string = wsdlConcettuale = wsdlConcettuale != null && !"".equals(wsdlConcettuale.trim().replaceAll("\n", "")) ? wsdlConcettuale : null;
                    if (wsdlConcettuale == null) {
                        erroreValidazione.addErroreValidazione("Specifica di interfaccia non definita");
                    }
                }
            }
            catch (Exception e) {
                throw new ValidazioneStatoPackageException(e);
            }
        }
        if (erroreValidazione.sizeErroriValidazione() > 0) {
            throw erroreValidazione;
        }
    }

    protected void controlloUnicitaImplementazioneAccordoPerSoggetto(String portType, IDSoggetto idSoggettoErogatore, long idSoggettoErogatoreLong, IDAccordo idAccordoServizioParteComune, long idAccordoServizioParteComuneLong, IDServizio idAccordoServizioParteSpecifica, long idAccordoServizioParteSpecificaLong, boolean isUpdate, boolean isServizioCorrelato, boolean isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto, boolean isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto) throws DriverRegistroServiziException {
        String tmpServCorr = CostantiRegistroServizi.DISABILITATO.toString();
        if (isServizioCorrelato) {
            tmpServCorr = CostantiRegistroServizi.ABILITATO.toString();
        }
        String s = "servizio";
        if (isServizioCorrelato) {
            s = "servizio correlato";
        }
        if (portType == null || "-".equals(portType)) {
            if (isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto) {
                long idAccordoServizioParteSpecificaAlreadyExists = this.driver.getServizioWithSoggettoAccordoServCorr(idSoggettoErogatoreLong, idAccordoServizioParteComuneLong, tmpServCorr);
                boolean addError = !isUpdate && idAccordoServizioParteSpecificaAlreadyExists > 0L;
                boolean changeError = false;
                if (isUpdate && idAccordoServizioParteSpecificaAlreadyExists > 0L) {
                    boolean bl = changeError = idAccordoServizioParteSpecificaLong != idAccordoServizioParteSpecificaAlreadyExists;
                }
                if (addError || changeError) {
                    throw new DriverRegistroServiziException("Esiste gi&agrave; un " + s + " del Soggetto " + String.valueOf(idSoggettoErogatore) + " che implementa l'accordo selezionato [" + IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordoServizioParteComune) + "]");
                }
            }
        } else if (isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto) {
            long idAccordoServizioParteSpecificaAlreadyExists = this.driver.getServizioWithSoggettoAccordoServCorrPt(idSoggettoErogatoreLong, idAccordoServizioParteComuneLong, tmpServCorr, portType);
            boolean addError = !isUpdate && idAccordoServizioParteSpecificaAlreadyExists > 0L;
            boolean changeError = false;
            if (isUpdate && idAccordoServizioParteSpecificaAlreadyExists > 0L) {
                boolean bl = changeError = idAccordoServizioParteSpecificaLong != idAccordoServizioParteSpecificaAlreadyExists;
            }
            if (addError || changeError) {
                throw new DriverRegistroServiziException("Esiste gi&agrave; un " + s + " del Soggetto " + String.valueOf(idSoggettoErogatore) + " che implementa il servizio " + portType + " dell'accordo selezionato [" + IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordoServizioParteComune) + "]");
            }
        }
    }
}

