/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.id.IDPortType;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.Azione;
import org.openspcoop2.core.registry.Message;
import org.openspcoop2.core.registry.MessagePart;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_LIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_accordiLIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_accordiSoapLIB;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverRegistroServiziDB_accordiSoapDriver {
    private DriverRegistroServiziDB driver = null;

    protected DriverRegistroServiziDB_accordiSoapDriver(DriverRegistroServiziDB driver) {
        this.driver = driver;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readPortTypes(AccordoServizioParteComune as, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = null;
        try {
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = conParam != null ? conParam : (this.driver.atomica ? this.driver.getConnectionFromDatasource("readPortTypes") : this.driver.globalConnection);
            if (as.getId() == null) throw new Exception("Accordo id non definito");
            if (as.getId() <= 0L) {
                throw new Exception("Accordo id non definito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, as.getId());
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, as.getId()));
            rs = stm.executeQuery();
            while (rs.next()) {
                PortType pt = new PortType();
                String tmp = rs.getString("nome");
                pt.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("descrizione");
                pt.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_collaborazione");
                pt.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("filtro_duplicati");
                pt.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("conferma_ricezione");
                pt.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("identificativo_collaborazione");
                pt.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("id_riferimento_richiesta");
                pt.setIdRiferimentoRichiesta(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("consegna_in_ordine");
                pt.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("scadenza");
                pt.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_pt");
                if (tmp == null || tmp.equals("")) {
                    pt.setProfiloPT("default");
                } else {
                    pt.setProfiloPT(tmp);
                }
                tmp = rs.getString("soap_style");
                pt.setStyle(DriverRegistroServiziDB_LIB.getEnumBindingStyle(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("message_type");
                pt.setMessageType(DriverRegistroServiziDB_LIB.getEnumMessageType(tmp == null || tmp.equals("") ? null : tmp));
                pt.setIdAccordo(as.getId());
                long idPortType = rs.getLong("id");
                pt.setId(idPortType);
                this.readAzioniPortTypes(pt, con);
                try {
                    List<ProtocolProperty> listPP = DriverRegistroServiziDB_LIB.getListaProtocolProperty(idPortType, ProprietariProtocolProperty.PORT_TYPE, con, this.driver.tipoDB, this.driver.getDriverUnwrapBYOK());
                    if (listPP != null && !listPP.isEmpty()) {
                        for (ProtocolProperty protocolProperty : listPP) {
                            pt.addProtocolProperty(protocolProperty);
                        }
                    }
                }
                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                    // empty catch block
                }
                as.addPortType(pt);
            }
            rs.close();
            stm.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            try {
                throw e;
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readPortTypes] Exception :" + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(conParam, con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(conParam, con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readAzioniPortTypes(PortType pt, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = null;
        try {
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = conParam != null ? conParam : (this.driver.atomica ? this.driver.getConnectionFromDatasource("readAzioniPortTypes") : this.driver.globalConnection);
            if (pt.getId() == null) throw new Exception("Port Type id non definito");
            if (pt.getId() <= 0L) {
                throw new Exception("Port Type id non definito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_port_type = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, pt.getId());
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, pt.getId()));
            rs = stm.executeQuery();
            Operation azionePT = null;
            while (rs.next()) {
                azionePT = new Operation();
                String tmp = rs.getString("conferma_ricezione");
                azionePT.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("consegna_in_ordine");
                azionePT.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("filtro_duplicati");
                azionePT.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("identificativo_collaborazione");
                azionePT.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("id_riferimento_richiesta");
                azionePT.setIdRiferimentoRichiesta(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("nome");
                azionePT.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("scadenza");
                azionePT.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_collaborazione");
                azionePT.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("correlata_servizio");
                azionePT.setCorrelataServizio(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("correlata");
                azionePT.setCorrelata(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_pt_azione");
                if (tmp == null || tmp.equals("")) {
                    azionePT.setProfAzione("default");
                } else {
                    azionePT.setProfAzione(tmp);
                }
                tmp = rs.getString("soap_style");
                azionePT.setStyle(DriverRegistroServiziDB_LIB.getEnumBindingStyle(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("soap_action");
                azionePT.setSoapAction(tmp == null || tmp.equals("") ? null : tmp);
                azionePT.setIdPortType(pt.getId());
                long idAzionePortType = rs.getLong("id");
                azionePT.setId(idAzionePortType);
                this.readMessagesAzioniPortTypes(azionePT, con);
                String msgInput = rs.getString("soap_use_msg_input");
                if (azionePT.getMessageInput() != null || msgInput != null) {
                    if (azionePT.getMessageInput() == null) {
                        azionePT.setMessageInput(new Message());
                    }
                    azionePT.getMessageInput().setUse(DriverRegistroServiziDB_LIB.getEnumBindingUse(msgInput == null || msgInput.equals("") ? null : msgInput));
                    tmp = rs.getString("soap_namespace_msg_input");
                    azionePT.getMessageInput().setSoapNamespace(tmp == null || tmp.equals("") ? null : tmp);
                }
                String msgOutput = rs.getString("soap_use_msg_output");
                if (azionePT.getMessageOutput() != null || msgOutput != null) {
                    if (azionePT.getMessageOutput() == null) {
                        azionePT.setMessageOutput(new Message());
                    }
                    azionePT.getMessageOutput().setUse(DriverRegistroServiziDB_LIB.getEnumBindingUse(msgOutput == null || msgOutput.equals("") ? null : msgOutput));
                    tmp = rs.getString("soap_namespace_msg_output");
                    azionePT.getMessageOutput().setSoapNamespace(tmp == null || tmp.equals("") ? null : tmp);
                }
                try {
                    List<ProtocolProperty> listPP = DriverRegistroServiziDB_LIB.getListaProtocolProperty(idAzionePortType, ProprietariProtocolProperty.OPERATION, con, this.driver.tipoDB, this.driver.getDriverUnwrapBYOK());
                    if (listPP != null && !listPP.isEmpty()) {
                        for (ProtocolProperty protocolProperty : listPP) {
                            azionePT.addProtocolProperty(protocolProperty);
                        }
                    }
                }
                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                    // empty catch block
                }
                pt.addAzione(azionePT);
            }
            rs.close();
            stm.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            try {
                throw e;
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readAzioniPortTypes] Exception :" + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(conParam, con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(conParam, con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readMessagesAzioniPortTypes(Operation azionePT, Connection conParam) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = null;
        try {
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = conParam != null ? conParam : (this.driver.atomica ? this.driver.getConnectionFromDatasource("readMessagesAzioniPortTypes") : this.driver.globalConnection);
            if (azionePT.getId() == null) throw new Exception("Port Type azione id non definito");
            if (azionePT.getId() <= 0L) {
                throw new Exception("Port Type azione id non definito");
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("operation_messages");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_port_type_azione = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, azionePT.getId());
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, azionePT.getId()));
            rs = stm.executeQuery();
            Message messageInputPart = null;
            Message messageOutputPart = null;
            while (rs.next()) {
                boolean isInputMessage = false;
                if (rs.getInt("input_message") == 1) {
                    isInputMessage = true;
                }
                MessagePart part = new MessagePart();
                String name = rs.getString("name");
                name = name == null || name.equals("") ? null : name;
                part.setName(name);
                String elementName = rs.getString("element_name");
                elementName = elementName == null || elementName.equals("") ? null : elementName;
                part.setElementName(elementName);
                String elementNamespace = rs.getString("element_namespace");
                elementNamespace = elementNamespace == null || elementNamespace.equals("") ? null : elementNamespace;
                part.setElementNamespace(elementNamespace);
                String typeName = rs.getString("type_name");
                typeName = typeName == null || typeName.equals("") ? null : typeName;
                part.setTypeName(typeName);
                String typeNamespace = rs.getString("type_namespace");
                typeNamespace = typeNamespace == null || typeNamespace.equals("") ? null : typeNamespace;
                part.setTypeNamespace(typeNamespace);
                long idMessage = rs.getLong("id");
                part.setId(idMessage);
                if (isInputMessage) {
                    if (messageInputPart == null) {
                        messageInputPart = new Message();
                    }
                    messageInputPart.addPart(part);
                    continue;
                }
                if (messageOutputPart == null) {
                    messageOutputPart = new Message();
                }
                messageOutputPart.addPart(part);
            }
            if (messageInputPart != null) {
                azionePT.setMessageInput(messageInputPart);
            }
            if (messageOutputPart != null) {
                azionePT.setMessageOutput(messageOutputPart);
            }
            rs.close();
            stm.close();
        }
        catch (DriverRegistroServiziNotFound e) {
            try {
                throw e;
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::readMessagesAzioniPortTypes] Exception :" + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(conParam, con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(conParam, con);
    }

    protected PortType getPortType(long id) throws DriverRegistroServiziException {
        PortType portType;
        String nomeMetodo = "getPortType(long)";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getPortType");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("port_type.id=?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, id);
            rs = stmt.executeQuery();
            PortType pt = null;
            if (rs.next()) {
                pt = new PortType();
                String tmp = rs.getString("nome");
                pt.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("descrizione");
                pt.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_collaborazione");
                pt.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("filtro_duplicati");
                pt.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("conferma_ricezione");
                pt.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("identificativo_collaborazione");
                pt.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("id_riferimento_richiesta");
                pt.setIdRiferimentoRichiesta(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("consegna_in_ordine");
                pt.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = rs.getString("scadenza");
                pt.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = rs.getString("profilo_pt");
                if (tmp == null || tmp.equals("")) {
                    pt.setProfiloPT("default");
                } else {
                    pt.setProfiloPT(tmp);
                }
                tmp = rs.getString("soap_style");
                pt.setStyle(DriverRegistroServiziDB_LIB.getEnumBindingStyle(tmp == null || tmp.equals("") ? null : tmp));
                pt.setIdAccordo(rs.getLong("id_accordo"));
                long idPortType = rs.getLong("id");
                pt.setId(idPortType);
                this.readAzioniPortTypes(pt, con);
            }
            portType = pt;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return portType;
    }

    protected List<PortType> accordiPorttypeCompatibiliList(long idAccordo, boolean isErogazione, ISearch ricerca) throws DriverRegistroServiziException {
        ArrayList<PortType> arrayList;
        String nomeMetodo = "accordiPorttypeCompatibiliList";
        int idLista = Liste.ACCORDI_PORTTYPE;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortType> lista = new ArrayList<PortType>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("accordiPorttypeCompatibiliList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlquery = DriverRegistroServiziDB_accordiLIB.getSQLRicercaServiziValidiByIdAccordo(isErogazione);
            sqlquery.setANDLogicOperator(true);
            if (!search.equals("")) {
                sqlquery.addSelectCountField("*", "cont");
                sqlquery.addWhereLikeCondition("nome", search, true, true);
                sqlquery.setANDLogicOperator(true);
                queryString = sqlquery.createSQLQuery();
            } else {
                sqlquery.addSelectCountField("*", "cont");
                queryString = sqlquery.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            sqlquery = DriverRegistroServiziDB_accordiLIB.getSQLRicercaServiziValidiByIdAccordo(isErogazione);
            sqlquery.setANDLogicOperator(true);
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlquery.addSelectField("id_accordo");
                sqlquery.addSelectField("nome");
                sqlquery.addSelectField("descrizione");
                sqlquery.addSelectField("profilo_collaborazione");
                sqlquery.addSelectField("filtro_duplicati");
                sqlquery.addSelectField("conferma_ricezione");
                sqlquery.addSelectField("identificativo_collaborazione");
                sqlquery.addSelectField("id_riferimento_richiesta");
                sqlquery.addSelectField("consegna_in_ordine");
                sqlquery.addSelectField("scadenza");
                sqlquery.addSelectField("profilo_pt");
                sqlquery.addSelectField("soap_style");
                sqlquery.addSelectField("id");
                sqlquery.addWhereLikeCondition("nome", search, true, true);
                sqlquery.setANDLogicOperator(true);
                sqlquery.addOrderBy("nome");
                sqlquery.setSortType(true);
                sqlquery.setLimit(limit);
                sqlquery.setOffset(offset);
                queryString = sqlquery.createSQLQuery();
            } else {
                sqlquery.addSelectField("id_accordo");
                sqlquery.addSelectField("nome");
                sqlquery.addSelectField("descrizione");
                sqlquery.addSelectField("profilo_collaborazione");
                sqlquery.addSelectField("filtro_duplicati");
                sqlquery.addSelectField("conferma_ricezione");
                sqlquery.addSelectField("identificativo_collaborazione");
                sqlquery.addSelectField("id_riferimento_richiesta");
                sqlquery.addSelectField("consegna_in_ordine");
                sqlquery.addSelectField("scadenza");
                sqlquery.addSelectField("profilo_pt");
                sqlquery.addSelectField("soap_style");
                sqlquery.addSelectField("id");
                sqlquery.addOrderBy("nome");
                sqlquery.setSortType(true);
                sqlquery.setLimit(limit);
                sqlquery.setOffset(offset);
                queryString = sqlquery.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                PortType pt = new PortType();
                String tmp = risultato.getString("nome");
                pt.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("descrizione");
                pt.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profilo_collaborazione");
                pt.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("filtro_duplicati");
                pt.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("conferma_ricezione");
                pt.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("identificativo_collaborazione");
                pt.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("id_riferimento_richiesta");
                pt.setIdRiferimentoRichiesta(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("consegna_in_ordine");
                pt.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("scadenza");
                pt.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profilo_pt");
                if (tmp == null || tmp.equals("")) {
                    pt.setProfiloPT("default");
                } else {
                    pt.setProfiloPT(tmp);
                }
                tmp = risultato.getString("soap_style");
                pt.setStyle(DriverRegistroServiziDB_LIB.getEnumBindingStyle(tmp == null || tmp.equals("") ? null : tmp));
                pt.setIdAccordo(risultato.getLong("id_accordo"));
                long idPortType = risultato.getLong("id");
                pt.setId(idPortType);
                this.readAzioniPortTypes(pt, con);
                lista.add(pt);
            }
            arrayList = lista;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected void updatePortType(PortType portType, String user) throws DriverRegistroServiziException {
        if (portType == null) {
            throw new DriverRegistroServiziException("Il port-type non puo' essere null.");
        }
        String nome = portType.getNome();
        if (nome == null || nome.equals("")) {
            throw new DriverRegistroServiziException("Il nome del port-type non e' valido.");
        }
        Connection connection = null;
        PreparedStatement stm = null;
        PreparedStatement updateStmt = null;
        ResultSet rs = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                connection = this.driver.getConnectionFromDatasource("updatePortType");
                connection.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::updatePortType] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            AccordoServizioParteComune as = this.driver.getAccordoServizioParteComune(portType.getIdAccordo(), connection);
            if (portType.getId() == null || portType.getId() <= 0L) {
                for (PortType ptCheck : as.getPortTypeList()) {
                    if (!ptCheck.getNome().equals(portType.getNome())) continue;
                    portType.setId(ptCheck.getId());
                }
            }
            if (portType.getId() == null || portType.getId() <= 0L) {
                throw new DriverRegistroServiziException("Id PortType undefined");
            }
            ArrayList<Long> idsOperation = new ArrayList<Long>();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addWhereCondition("id_port_type=?");
            String queryString = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(queryString);
            stm.setLong(1, portType.getId());
            rs = stm.executeQuery();
            while (rs.next()) {
                idsOperation.add(rs.getLong("id"));
            }
            rs.close();
            stm.close();
            if (idsOperation != null && !idsOperation.isEmpty()) {
                for (Long id : idsOperation) {
                    ISQLQueryObject sqlQueryObjectMessages = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObjectMessages.addDeleteTable("operation_messages");
                    sqlQueryObjectMessages.addWhereCondition("id_port_type_azione=?");
                    String updateString = sqlQueryObjectMessages.createSQLDelete();
                    stm = connection.prepareStatement(updateString);
                    stm.setLong(1, id);
                    int n = stm.executeUpdate();
                    stm.close();
                    this.driver.logDebug("Cancellate " + n + " operation messages associate all'azione con id " + id + " del port type " + portType.getNome() + " dell'accordo: " + as.getNome());
                }
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addDeleteTable("port_type_azioni");
            sqlQueryObject.addWhereCondition("id_port_type=?");
            String updateString = sqlQueryObject.createSQLDelete();
            stm = connection.prepareStatement(updateString);
            stm.setLong(1, portType.getId());
            int n = stm.executeUpdate();
            stm.close();
            this.driver.logDebug("Cancellate " + n + " azioni associate al portType " + portType.getNome() + " dell'accordo: " + (as != null ? as.getNome() : null));
            for (int i = 0; i < portType.sizeAzioneList(); ++i) {
                Operation azione = portType.getAzione(i);
                DriverRegistroServiziDB_accordiSoapLIB.CRUDAzionePortType(1, as, portType, azione, connection, portType.getId(), this.driver.getDriverWrapBYOK());
            }
            this.driver.logDebug("inserite " + portType.sizeAzioneList() + " azioni relative al port type[" + portType.getNome() + "] id-porttype[" + portType.getId() + "]");
            if (user != null && as != null && as.getId() != null && as.getId() > 0L) {
                ISQLQueryObject sqlQueryObjectUpdate = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectUpdate.addUpdateTable("accordi");
                sqlQueryObjectUpdate.addUpdateField("utente_ultima_modifica", "?");
                sqlQueryObjectUpdate.addUpdateField("data_ultima_modifica", "?");
                sqlQueryObjectUpdate.addWhereCondition("id=?");
                updateString = sqlQueryObjectUpdate.createSQLUpdate();
                stm = connection.prepareStatement(updateString);
                int index = 1;
                stm.setString(index++, user);
                stm.setTimestamp(index++, DateManager.getTimestamp());
                stm.setLong(index, as.getId());
                n = stm.executeUpdate();
                stm.close();
                this.driver.logDebug("Aggiornata " + n + " entry per l'operazione di ultima modifica dell'accordo: " + as.getNome());
            }
        }
        catch (Exception se) {
            try {
                this.driver.log.error(se.getMessage(), (Throwable)se);
                error = true;
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updatePortType] Exception [" + se.getMessage() + "].", se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                JDBCUtilities.closeResources(updateStmt);
                this.driver.closeConnection(error, connection);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        JDBCUtilities.closeResources(updateStmt);
        this.driver.closeConnection(error, connection);
    }

    protected List<Azione> accordiAzioniList(long idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        ArrayList<Azione> arrayList;
        String nomeMetodo = "accordiAzioniList";
        int idLista = Liste.ACCORDI_AZIONI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Azione> lista = new ArrayList<Azione>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("accordiAzioniList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("accordi_azioni");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("accordi_azioni");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("accordi_azioni");
                sqlQueryObject.addSelectAliasField("id", "idAzione");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("conferma_ricezione");
                sqlQueryObject.addSelectField("consegna_in_ordine");
                sqlQueryObject.addSelectField("filtro_duplicati");
                sqlQueryObject.addSelectField("identificativo_collaborazione");
                sqlQueryObject.addSelectField("id_riferimento_richiesta");
                sqlQueryObject.addSelectField("scadenza");
                sqlQueryObject.addSelectField("profilo_collaborazione");
                sqlQueryObject.addSelectField("profilo_azione");
                sqlQueryObject.addSelectField("id_accordo");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("accordi_azioni");
                sqlQueryObject.addSelectAliasField("id", "idAzione");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("conferma_ricezione");
                sqlQueryObject.addSelectField("consegna_in_ordine");
                sqlQueryObject.addSelectField("filtro_duplicati");
                sqlQueryObject.addSelectField("identificativo_collaborazione");
                sqlQueryObject.addSelectField("id_riferimento_richiesta");
                sqlQueryObject.addSelectField("scadenza");
                sqlQueryObject.addSelectField("profilo_collaborazione");
                sqlQueryObject.addSelectField("profilo_azione");
                sqlQueryObject.addSelectField("id_accordo");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Azione az = new Azione();
                az.setId(risultato.getLong("idAzione"));
                az.setNome(risultato.getString("nome"));
                az.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("conferma_ricezione")));
                az.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("consegna_in_ordine")));
                az.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("filtro_duplicati")));
                az.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("identificativo_collaborazione")));
                az.setIdRiferimentoRichiesta(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("id_riferimento_richiesta")));
                az.setScadenza(risultato.getString("scadenza"));
                az.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(risultato.getString("profilo_collaborazione")));
                az.setProfAzione(risultato.getString("profilo_azione"));
                lista.add(az);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<Azione> accordiAzioniList(long idAccordo, String profiloCollaborazione, ISearch ricerca) throws DriverRegistroServiziException {
        ArrayList<Azione> arrayList;
        String nomeMetodo = "accordiAzioniList";
        int idLista = Liste.ACCORDI_AZIONI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Azione> lista = new ArrayList<Azione>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("accordiAzioniList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addFromTable("accordi_azioni");
            sqlQueryObject.addSelectCountField("accordi_azioni.id", "cont");
            sqlQueryObject.addWhereCondition("accordi_azioni.id_accordo = accordi.id");
            sqlQueryObject.addWhereCondition("accordi_azioni.id_accordo = ?");
            sqlQueryObject.addWhereCondition(false, new String[]{"accordi_azioni.profilo_collaborazione = ? AND accordi_azioni.profilo_azione= ?", "accordi.profilo_collaborazione=?"});
            sqlQueryObject.setANDLogicOperator(true);
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            stmt.setString(2, profiloCollaborazione);
            stmt.setString(3, "ridefinito");
            stmt.setString(4, profiloCollaborazione);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addFromTable("accordi_azioni");
            sqlQueryObject.addSelectField("accordi_azioni", "nome");
            sqlQueryObject.addSelectField("accordi_azioni", "conferma_ricezione");
            sqlQueryObject.addSelectField("accordi_azioni", "consegna_in_ordine");
            sqlQueryObject.addSelectField("accordi_azioni", "filtro_duplicati");
            sqlQueryObject.addSelectField("accordi_azioni", "identificativo_collaborazione");
            sqlQueryObject.addSelectField("accordi_azioni", "id_riferimento_richiesta");
            sqlQueryObject.addSelectField("accordi_azioni", "scadenza");
            sqlQueryObject.addSelectField("accordi_azioni", "profilo_collaborazione");
            sqlQueryObject.addSelectField("accordi_azioni", "profilo_azione");
            sqlQueryObject.addSelectField("accordi_azioni", "id_accordo");
            sqlQueryObject.addSelectField("accordi_azioni", "correlata");
            sqlQueryObject.addWhereCondition("accordi_azioni.id_accordo = accordi.id");
            sqlQueryObject.addWhereCondition("accordi_azioni.id_accordo = ?");
            sqlQueryObject.addWhereCondition(false, new String[]{"accordi_azioni.profilo_collaborazione = ? AND accordi_azioni.profilo_azione= ?", "accordi.profilo_collaborazione=?"});
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            sqlQueryObject.addOrderBy("accordi_azioni.nome");
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            stmt.setString(2, profiloCollaborazione);
            stmt.setString(3, "ridefinito");
            stmt.setString(4, profiloCollaborazione);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Azione az = new Azione();
                az.setNome(risultato.getString("nome"));
                az.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("conferma_ricezione")));
                az.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("consegna_in_ordine")));
                az.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("filtro_duplicati")));
                az.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("identificativo_collaborazione")));
                az.setIdRiferimentoRichiesta(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(risultato.getString("id_riferimento_richiesta")));
                az.setScadenza(risultato.getString("scadenza"));
                az.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(risultato.getString("profilo_collaborazione")));
                az.setProfAzione(risultato.getString("profilo_azione"));
                az.setCorrelata(risultato.getString("correlata"));
                lista.add(az);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected void deleteAzione(long idAccordo, String nomeAzione) throws DriverRegistroServiziException {
        String nomeMetodo = "deleteAzione";
        Connection con = null;
        PreparedStatement stmt = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("deleteAzione");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addDeleteTable("accordi_azioni");
            sqlQueryObject.addWhereCondition("id_accordo=?");
            sqlQueryObject.addWhereCondition("nome=?");
            sqlQueryObject.setANDLogicOperator(true);
            String updateString = sqlQueryObject.createSQLDelete();
            stmt = con.prepareStatement(updateString);
            stmt.setLong(1, idAccordo);
            stmt.setString(2, nomeAzione);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((PreparedStatement)stmt);
        this.driver.closeConnection(con);
    }

    protected List<PortType> accordiPorttypeList(long idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        ArrayList<PortType> arrayList;
        String nomeMetodo = "accordiPorttypeList";
        int idLista = Liste.ACCORDI_PORTTYPE;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortType> lista = new ArrayList<PortType>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("accordiPorttypeList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("port_type");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("port_type");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("port_type");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("port_type");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addWhereCondition("id_accordo = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            risultato = stmt.executeQuery();
            ArrayList<Long> listID = new ArrayList<Long>();
            while (risultato.next()) {
                long idPortType = risultato.getLong("id");
                listID.add(idPortType);
            }
            if (listID.size() > 0) {
                for (Long idPT : listID) {
                    lista.add(this.getPortType(idPT));
                }
            }
            arrayList = lista;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<PortType> accordiPorttypeList(long idAccordo, String profiloCollaborazione, ISearch ricerca) throws DriverRegistroServiziException {
        ArrayList<PortType> arrayList;
        String nomeMetodo = "accordiPorttypeList";
        int idLista = Liste.ACCORDI_PORTTYPE;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<PortType> lista = new ArrayList<PortType>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("accordiPorttypeList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("port_type.id_accordo = accordi.id");
            sqlQueryObject.addWhereCondition("port_type.id_accordo = ?");
            if (profiloCollaborazione != null) {
                sqlQueryObject.addWhereCondition(false, new String[]{"accordi.profilo_collaborazione=?", "port_type.profilo_collaborazione = ? AND port_type.profilo_pt= ?"});
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            if (profiloCollaborazione != null) {
                stmt.setString(2, profiloCollaborazione);
                stmt.setString(3, profiloCollaborazione);
                stmt.setString(4, "ridefinito");
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addSelectField("port_type", "id_accordo");
            sqlQueryObject.addSelectField("port_type", "nome");
            sqlQueryObject.addSelectField("port_type", "descrizione");
            sqlQueryObject.addSelectField("port_type", "profilo_collaborazione");
            sqlQueryObject.addSelectField("port_type", "filtro_duplicati");
            sqlQueryObject.addSelectField("port_type", "conferma_ricezione");
            sqlQueryObject.addSelectField("port_type", "identificativo_collaborazione");
            sqlQueryObject.addSelectField("port_type", "id_riferimento_richiesta");
            sqlQueryObject.addSelectField("port_type", "consegna_in_ordine");
            sqlQueryObject.addSelectField("port_type", "scadenza");
            sqlQueryObject.addSelectField("port_type", "profilo_pt");
            sqlQueryObject.addSelectField("port_type", "soap_style");
            sqlQueryObject.addSelectField("port_type", "id");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("port_type.id_accordo = accordi.id");
            sqlQueryObject.addWhereCondition("port_type.id_accordo = ?");
            if (profiloCollaborazione != null) {
                sqlQueryObject.addWhereCondition(false, new String[]{"accordi.profilo_collaborazione=?", "port_type.profilo_collaborazione = ? AND port_type.profilo_pt= ?"});
            }
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            sqlQueryObject.addOrderBy("port_type.nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            if (profiloCollaborazione != null) {
                stmt.setString(2, profiloCollaborazione);
                stmt.setString(3, profiloCollaborazione);
                stmt.setString(4, "ridefinito");
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                PortType pt = new PortType();
                String tmp = risultato.getString("nome");
                pt.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("descrizione");
                pt.setDescrizione(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profilo_collaborazione");
                pt.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("filtro_duplicati");
                pt.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("conferma_ricezione");
                pt.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("identificativo_collaborazione");
                pt.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("id_riferimento_richiesta");
                pt.setIdRiferimentoRichiesta(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("consegna_in_ordine");
                pt.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("scadenza");
                pt.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profilo_pt");
                if (tmp == null || tmp.equals("")) {
                    pt.setProfiloPT("default");
                } else {
                    pt.setProfiloPT(tmp);
                }
                tmp = risultato.getString("soap_style");
                pt.setStyle(DriverRegistroServiziDB_LIB.getEnumBindingStyle(tmp == null || tmp.equals("") ? null : tmp));
                pt.setIdAccordo(risultato.getLong("id_accordo"));
                long idPortType = risultato.getLong("id");
                pt.setId(idPortType);
                lista.add(pt);
            }
            arrayList = lista;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<Operation> accordiPorttypeOperationList(long idPortType, String profiloCollaborazione, ISearch ricerca) throws DriverRegistroServiziException {
        ArrayList<Operation> arrayList;
        String nomeMetodo = "accordiPorttypeOperationsList";
        int idLista = Liste.ACCORDI_PORTTYPE_AZIONI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Operation> lista = new ArrayList<Operation>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("accordiPorttypeOperationList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectCountField("port_type_azioni.id", "cont");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("port_type.id_accordo = accordi.id");
            sqlQueryObject.addWhereCondition("port_type_azioni.id_port_type = port_type.id");
            sqlQueryObject.addWhereCondition("port_type.id = ?");
            sqlQueryObject.addWhereCondition(false, new String[]{"accordi.profilo_collaborazione=?", "port_type.profilo_collaborazione = ? AND port_type.profilo_pt= ?", "port_type_azioni.profilo_collaborazione = ? AND port_type_azioni.profilo_pt_azione= ?"});
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortType);
            stmt.setString(2, profiloCollaborazione);
            stmt.setString(3, profiloCollaborazione);
            stmt.setString(4, "ridefinito");
            stmt.setString(5, profiloCollaborazione);
            stmt.setString(6, "ridefinito");
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi");
            sqlQueryObject.addFromTable("port_type");
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectField("port_type_azioni", "id_port_type");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "nome", "nomePTAz");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "profilo_collaborazione", "profCollPTAz");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "filtro_duplicati", "filtro_duplicatiPTAz");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "conferma_ricezione", "conferma_ricezionePTAz");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "identificativo_collaborazione", "idCollPTAz");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "id_riferimento_richiesta", "idRifRichiestaPTAz");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "consegna_in_ordine", "consegna_in_ordinePTAz");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "scadenza", "scadenzaPTAz");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "correlata", "correlataPTAz");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "correlata_servizio", "correlataServizioPTAz");
            sqlQueryObject.addSelectField("port_type_azioni", "profilo_pt_azione");
            sqlQueryObject.addSelectAliasField("port_type_azioni", "id", "idPTAz");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("port_type.id_accordo = accordi.id");
            sqlQueryObject.addWhereCondition("port_type_azioni.id_port_type = port_type.id");
            sqlQueryObject.addWhereCondition("port_type.id = ?");
            sqlQueryObject.addWhereCondition(false, new String[]{"accordi.profilo_collaborazione=?", "port_type.profilo_collaborazione = ? AND port_type.profilo_pt= ?", "port_type_azioni.profilo_collaborazione = ? AND port_type_azioni.profilo_pt_azione= ?"});
            if (!search.equals("")) {
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
            }
            sqlQueryObject.addOrderBy("port_type_azioni.nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            queryString = sqlQueryObject.createSQLQuery();
            this.driver.logDebug("Query: " + queryString);
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortType);
            stmt.setString(2, profiloCollaborazione);
            stmt.setString(3, profiloCollaborazione);
            stmt.setString(4, "ridefinito");
            stmt.setString(5, profiloCollaborazione);
            stmt.setString(6, "ridefinito");
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Operation op = new Operation();
                String tmp = risultato.getString("nomePTAz");
                op.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profCollPTAz");
                op.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("filtro_duplicatiPTAz");
                op.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("conferma_ricezionePTAz");
                op.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("idCollPTAz");
                op.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("idRifRichiestaPTAz");
                op.setIdRiferimentoRichiesta(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("consegna_in_ordinePTAz");
                op.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("scadenzaPTAz");
                op.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("correlataPTAz");
                op.setCorrelata(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("correlataServizioPTAz");
                op.setCorrelataServizio(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profilo_pt_azione");
                if (tmp == null || tmp.equals("")) {
                    op.setProfAzione("default");
                } else {
                    op.setProfAzione(tmp);
                }
                op.setIdPortType(risultato.getLong("id_port_type"));
                long idOperation = risultato.getLong("idPTAz");
                op.setId(idOperation);
                lista.add(op);
            }
            arrayList = lista;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<Operation> accordiPorttypeOperationList(long idPortType, ISearch ricerca) throws DriverRegistroServiziException {
        ArrayList<Operation> arrayList;
        String nomeMetodo = "accordiPorttypeOperationsList";
        int idLista = Liste.ACCORDI_PORTTYPE_AZIONI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Operation> lista = new ArrayList<Operation>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("accordiPorttypeOperationList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("port_type_azioni");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_port_type = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("port_type_azioni");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_port_type = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortType);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("port_type_azioni");
                sqlQueryObject.addSelectField("id_port_type");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("profilo_collaborazione");
                sqlQueryObject.addSelectField("filtro_duplicati");
                sqlQueryObject.addSelectField("conferma_ricezione");
                sqlQueryObject.addSelectField("identificativo_collaborazione");
                sqlQueryObject.addSelectField("id_riferimento_richiesta");
                sqlQueryObject.addSelectField("consegna_in_ordine");
                sqlQueryObject.addSelectField("scadenza");
                sqlQueryObject.addSelectField("profilo_pt_azione");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_port_type = ?");
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("port_type_azioni");
                sqlQueryObject.addSelectField("id_port_type");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("profilo_collaborazione");
                sqlQueryObject.addSelectField("filtro_duplicati");
                sqlQueryObject.addSelectField("conferma_ricezione");
                sqlQueryObject.addSelectField("identificativo_collaborazione");
                sqlQueryObject.addSelectField("id_riferimento_richiesta");
                sqlQueryObject.addSelectField("consegna_in_ordine");
                sqlQueryObject.addSelectField("scadenza");
                sqlQueryObject.addSelectField("profilo_pt_azione");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_port_type = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortType);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Operation op = new Operation();
                String tmp = risultato.getString("nome");
                op.setNome(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profilo_collaborazione");
                op.setProfiloCollaborazione(DriverRegistroServiziDB_LIB.getEnumProfiloCollaborazione(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("filtro_duplicati");
                op.setFiltroDuplicati(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("conferma_ricezione");
                op.setConfermaRicezione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("identificativo_collaborazione");
                op.setIdCollaborazione(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("id_riferimento_richiesta");
                op.setIdRiferimentoRichiesta(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("consegna_in_ordine");
                op.setConsegnaInOrdine(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita(tmp == null || tmp.equals("") ? null : tmp));
                tmp = risultato.getString("scadenza");
                op.setScadenza(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("profilo_pt_azione");
                if (tmp == null || tmp.equals("")) {
                    op.setProfAzione("default");
                } else {
                    op.setProfAzione(tmp);
                }
                op.setIdPortType(risultato.getLong("id_port_type"));
                long idOperation = risultato.getLong("id");
                op.setId(idOperation);
                lista.add(op);
            }
            arrayList = lista;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<MessagePart> accordiPorttypeOperationMessagePartList(long idOperation, boolean isInput, ISearch ricerca) throws DriverRegistroServiziException {
        ArrayList<MessagePart> arrayList;
        String nomeMetodo = "accordiPorttypeOperationMessagePartList";
        int idLista = Liste.ACCORDI_PORTTYPE_AZIONI_MESSAGE_INPUT;
        if (!isInput) {
            idLista = Liste.ACCORDI_PORTTYPE_AZIONI_MESSAGE_OUTPUT;
        }
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<MessagePart> lista = new ArrayList<MessagePart>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("accordiPorttypeOperationMessagePartList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("operation_messages");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_port_type_azione = ?");
                if (isInput) {
                    sqlQueryObject.addWhereCondition("input_message = 1");
                } else {
                    sqlQueryObject.addWhereCondition("input_message != 1");
                }
                sqlQueryObject.addWhereLikeCondition("name", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("operation_messages");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("id_port_type_azione = ?");
                if (isInput) {
                    sqlQueryObject.addWhereCondition("input_message = 1");
                } else {
                    sqlQueryObject.addWhereCondition("input_message != 1");
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idOperation);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt("cont"));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("operation_messages");
                sqlQueryObject.addSelectField("name");
                sqlQueryObject.addSelectField("element_name");
                sqlQueryObject.addSelectField("element_namespace");
                sqlQueryObject.addSelectField("type_name");
                sqlQueryObject.addSelectField("type_namespace");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_port_type_azione = ?");
                if (isInput) {
                    sqlQueryObject.addWhereCondition("input_message = 1");
                } else {
                    sqlQueryObject.addWhereCondition("input_message != 1");
                }
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("name");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("operation_messages");
                sqlQueryObject.addSelectField("name");
                sqlQueryObject.addSelectField("element_name");
                sqlQueryObject.addSelectField("element_namespace");
                sqlQueryObject.addSelectField("type_name");
                sqlQueryObject.addSelectField("type_namespace");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addWhereCondition("id_port_type_azione = ?");
                if (isInput) {
                    sqlQueryObject.addWhereCondition("input_message = 1");
                } else {
                    sqlQueryObject.addWhereCondition("input_message != 1");
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("name");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idOperation);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                MessagePart mp = new MessagePart();
                String tmp = risultato.getString("name");
                mp.setName(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("element_name");
                mp.setElementName(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("element_namespace");
                mp.setElementNamespace(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("type_name");
                mp.setTypeName(tmp == null || tmp.equals("") ? null : tmp);
                tmp = risultato.getString("type_namespace");
                mp.setTypeNamespace(tmp == null || tmp.equals("") ? null : tmp);
                long idMessage = risultato.getLong("id");
                mp.setId(idMessage);
                lista.add(mp);
            }
            arrayList = lista;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected boolean isCorrelata(long idAccordo, String nomeAzione, String owner) throws DriverRegistroServiziException {
        boolean bl;
        String nomeMetodo = "isCorrelata";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("isCorrelata");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi_azioni");
            sqlQueryObject.addSelectCountField("id", "tot");
            sqlQueryObject.addWhereCondition("id_accordo = ?");
            sqlQueryObject.addWhereCondition("correlata = ?");
            sqlQueryObject.addWhereCondition("nome <> ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordo);
            stmt.setString(2, nomeAzione);
            stmt.setString(3, owner);
            risultato = stmt.executeQuery();
            int tot = 0;
            if (risultato.next()) {
                tot = risultato.getInt("tot");
            }
            risultato.close();
            bl = tot > 0;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return bl;
    }

    protected boolean isOperationCorrelata(long idPortType, String nomeCorrelata, String owner) throws DriverRegistroServiziException {
        boolean bl;
        String nomeMetodo = "isOperationCorrelata";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("isOperationCorrelata");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectCountField("id", "tot");
            sqlQueryObject.addWhereCondition("id_port_type = ?");
            sqlQueryObject.addWhereCondition("correlata = ?");
            sqlQueryObject.addWhereCondition("nome <> ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPortType);
            stmt.setString(2, nomeCorrelata);
            stmt.setString(3, owner);
            risultato = stmt.executeQuery();
            int tot = 0;
            if (risultato.next()) {
                tot = risultato.getInt("tot");
            }
            risultato.close();
            bl = tot > 0;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return bl;
    }

    protected boolean isOperationCorrelataDaAltraAzione(String nomePortType, long idPortType, String azioneDaVerificare, long idAzioneDaVerificare) throws DriverRegistroServiziException {
        return this.isOperationCorrelata(nomePortType, idPortType, azioneDaVerificare, idAzioneDaVerificare, false, true);
    }

    protected boolean isOperationCorrelataRichiesta(String nomePortType, long idPortType, String azioneDaVerificare, long idAzioneDaVerificare) throws DriverRegistroServiziException {
        return this.isOperationCorrelata(nomePortType, idPortType, azioneDaVerificare, idAzioneDaVerificare, true, false);
    }

    protected boolean isOperationCorrelata(String nomePortType, long idPortType, String azioneDaVerificare, long idAzioneDaVerificare) throws DriverRegistroServiziException {
        return this.isOperationCorrelata(nomePortType, idPortType, azioneDaVerificare, idAzioneDaVerificare, true, true);
    }

    private boolean isOperationCorrelata(String nomePortType, long idPortType, String azioneDaVerificare, long idAzioneDaVerificare, boolean checkCorrelazioneARichiesta, boolean checkCorrelazioneDaAltraAzione) throws DriverRegistroServiziException {
        String nomeMetodo = "isOperationCorrelata";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("isOperationCorrelata(nomePortType,id,azione,idAzione,check)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            String queryString;
            boolean correlataAdUnaRichiesta = false;
            if (checkCorrelazioneARichiesta) {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("port_type_azioni");
                sqlQueryObject.addSelectCountField("id", "tot");
                sqlQueryObject.addWhereCondition("port_type_azioni.id_port_type = ?");
                sqlQueryObject.addWhereCondition("nome = ?");
                sqlQueryObject.addWhereCondition(false, new String[]{"port_type_azioni.correlata is not null", "port_type_azioni.correlata_servizio is not null"});
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
                this.driver.logDebug("VERIFICO CORRELAZIONE AD UNA RICHIESTA [" + idPortType + "] [" + azioneDaVerificare + "]: " + queryString);
                stmt = con.prepareStatement(queryString);
                stmt.setLong(1, idPortType);
                stmt.setString(2, azioneDaVerificare);
                risultato = stmt.executeQuery();
                int tot = 0;
                if (risultato.next()) {
                    tot = risultato.getInt("tot");
                }
                risultato.close();
                stmt.close();
                correlataAdUnaRichiesta = tot > 0;
                this.driver.logDebug("VERIFICO CORRELAZIONE AD UNA RICHIESTA, risultato [" + tot + "]: " + correlataAdUnaRichiesta);
            }
            boolean correlataDaUnAltraAzione = false;
            if (checkCorrelazioneDaAltraAzione) {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("port_type_azioni");
                sqlQueryObject.addSelectCountField("id", "tot");
                sqlQueryObject.addWhereCondition("port_type_azioni.id<>?");
                sqlQueryObject.addWhereCondition(true, new String[]{"port_type_azioni.correlata =?", "port_type_azioni.correlata_servizio =?"});
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                this.driver.logDebug("VERIFICO CHE NON SIA CORRELATA DA UN'ALTRA AZIONE (AS e AA con PT diverso) [" + idAzioneDaVerificare + "] [" + azioneDaVerificare + "] [" + nomePortType + "]: " + queryString);
                stmt.setLong(1, idAzioneDaVerificare);
                stmt.setString(2, azioneDaVerificare);
                stmt.setString(3, nomePortType);
                risultato = stmt.executeQuery();
                int tot = 0;
                if (risultato.next()) {
                    tot = risultato.getInt("tot");
                }
                risultato.close();
                stmt.close();
                correlataDaUnAltraAzione = tot > 0;
                this.driver.logDebug("VERIFICO CHE NON SIA CORRELATA DA UN'ALTRA AZIONE (AS e AA con PT diverso), risultato [" + tot + "]: " + correlataDaUnAltraAzione);
                if (!correlataDaUnAltraAzione) {
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable("port_type_azioni");
                    sqlQueryObject.addSelectCountField("id", "tot");
                    sqlQueryObject.addWhereCondition("port_type_azioni.id<>?");
                    sqlQueryObject.addWhereCondition(true, new String[]{"port_type_azioni.correlata =?", "port_type_azioni.correlata_servizio is null", "port_type_azioni.id_port_type = ?"});
                    sqlQueryObject.setANDLogicOperator(true);
                    queryString = sqlQueryObject.createSQLQuery();
                    stmt = con.prepareStatement(queryString);
                    this.driver.logDebug("VERIFICO CHE NON SIA CORRELATA DA UN'ALTRA AZIONE (AA con stesso port type) [" + idAzioneDaVerificare + "] [" + azioneDaVerificare + "] [" + nomePortType + "] [" + azioneDaVerificare + "] [" + idPortType + "]: " + queryString);
                    stmt.setLong(1, idAzioneDaVerificare);
                    stmt.setString(2, azioneDaVerificare);
                    stmt.setLong(3, idPortType);
                    risultato = stmt.executeQuery();
                    tot = 0;
                    if (risultato.next()) {
                        tot = risultato.getInt("tot");
                    }
                    risultato.close();
                    stmt.close();
                    correlataDaUnAltraAzione = tot > 0;
                    this.driver.logDebug("VERIFICO CHE NON SIA CORRELATA DA UN'ALTRA AZIONE (AA con stesso port type), risultato [" + tot + "]: " + correlataDaUnAltraAzione);
                }
            }
            if (correlataAdUnaRichiesta) {
                boolean bl = true;
                return bl;
            }
            if (correlataDaUnAltraAzione) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            JDBCUtilities.closeResources(risultato, stmt);
            this.driver.closeConnection(con);
        }
    }

    protected PortType getPortType(IDPortType idPT) throws DriverRegistroServiziException {
        String nomeMetodo = "getPortType";
        Connection con = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getPortType");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            PortType e = this.getPortType(DBUtils.getIdPortType(DBUtils.getIdAccordoServizioParteComune(idPT.getIdAccordo(), con, this.driver.tipoDB), idPT.getNome(), con));
            return e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.driver.closeConnection(con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<IDServizio> getIdServiziWithPortType(IDPortType idPT) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDServizio> arrayList;
        String nomeMetodo = "getIdServiziWithPortType";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getIdServiziWithPortType");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        ArrayList<IDServizio> idServizi = new ArrayList<IDServizio>();
        try {
            long idAccordoLong = DBUtils.getIdAccordoServizioParteComune(idPT.getIdAccordo(), con, this.driver.tipoDB);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("nome_servizio");
            sqlQueryObject.addSelectField("tipo_servizio");
            sqlQueryObject.addSelectField("versione_servizio");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("servizi.id_accordo=?");
            sqlQueryObject.addWhereCondition("servizi.port_type=?");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto=soggetti.id");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordoLong);
            stmt.setString(2, idPT.getNome());
            rs = stmt.executeQuery();
            while (rs.next()) {
                IDSoggetto soggettoErogatore = new IDSoggetto(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"));
                IDServizio idServizio = this.driver.idServizioFactory.getIDServizioFromValues(rs.getString("tipo_servizio"), rs.getString("nome_servizio"), soggettoErogatore, rs.getInt("versione_servizio"));
                idServizi.add(idServizio);
            }
            if (idServizi.size() <= 0) {
                throw new DriverRegistroServiziNotFound("Servizi non trovato che implementano il servizio " + idPT.getNome() + " dell'accordo di servizio " + idPT.getIdAccordo().toString());
            }
            arrayList = idServizi;
        }
        catch (DriverRegistroServiziNotFound dNot) {
            try {
                throw dNot;
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected boolean isUnicaAzioneInAccordi(String azione) throws DriverRegistroServiziException {
        boolean bl;
        String nomeMetodo = "isUnicaAzioneInAccordi";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("isUnicaAzioneInAccordi");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("accordi_azioni");
            sqlQueryObject.addSelectCountField("nome", "countAzioni");
            sqlQueryObject.addWhereCondition("accordi_azioni.nome=?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, azione);
            rs = stmt.executeQuery();
            int count = 0;
            if (!rs.next()) {
                throw new Exception("Azione [" + azione + "] non trovata (rs.next fallita)");
            }
            count = rs.getInt("countAzioni");
            rs.close();
            stmt.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("port_type_azioni");
            sqlQueryObject.addSelectCountField("nome", "countAzioni");
            sqlQueryObject.addWhereCondition("port_type_azioni.nome=?");
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, azione);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new Exception("Azione [" + azione + "] non trovata (rs.next fallita pt)");
            }
            if ((count += rs.getInt("countAzioni")) <= 0) {
                throw new Exception("Azione [" + azione + "] non trovata");
            }
            bl = count == 1;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziException::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return bl;
    }
}

