/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.Filtri;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.constants.RuoloContesto;
import org.openspcoop2.core.registry.constants.RuoloTipologia;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicercaRuoli;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_LIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_utilsDriver;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectException;

public class DriverRegistroServiziDB_ruoliDriver {
    private DriverRegistroServiziDB driver = null;

    protected DriverRegistroServiziDB_ruoliDriver(DriverRegistroServiziDB driver) {
        this.driver = driver;
    }

    protected Ruolo getRuolo(IDRuolo idRuolo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.driver.logDebug("richiesto getRuolo: " + String.valueOf(idRuolo));
        if (idRuolo == null) {
            throw new DriverRegistroServiziException("[getRuolo] Parametro idRuolo is null");
        }
        if (idRuolo.getNome() == null || idRuolo.getNome().trim().equals("")) {
            throw new DriverRegistroServiziException("[getRuolo] Parametro idRuolo.nome non e' definito");
        }
        Connection con = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getRuolo(nome)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getRuolo] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            Ruolo e = this.getRuolo(con, idRuolo);
            return e;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getRuolo] Exception: " + se.getMessage(), se);
        }
        finally {
            this.driver.closeConnection(con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Ruolo getRuolo(Connection conParam, IDRuolo idRuolo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Ruolo ruolo;
        this.driver.logDebug("richiesto getRuolo: " + String.valueOf(idRuolo));
        if (idRuolo == null) {
            throw new DriverRegistroServiziException("[getRuolo] Parametro idRuolo is null");
        }
        if (idRuolo.getNome() == null || idRuolo.getNome().trim().equals("")) {
            throw new DriverRegistroServiziException("[getRuolo] Parametro idRuolo.nome non e' definito");
        }
        PreparedStatement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("ruoli");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stm = conParam.prepareStatement(queryString);
            stm.setString(1, idRuolo.getNome());
            rs = stm.executeQuery();
            Ruolo ruolo2 = null;
            if (!rs.next()) {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getRuolo] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(queryString, idRuolo.getNome()));
            }
            ruolo2 = new Ruolo();
            ruolo2.setId(rs.getLong("id"));
            ruolo2.setNome(rs.getString("nome"));
            ruolo2.setDescrizione(rs.getString("descrizione"));
            String tipologia = rs.getString("tipologia");
            if (tipologia != null) {
                ruolo2.setTipologia(RuoloTipologia.toEnumConstant(tipologia));
            }
            ruolo2.setNomeEsterno(rs.getString("nome_esterno"));
            String contestoUtilizzo = rs.getString("contesto_utilizzo");
            if (contestoUtilizzo != null) {
                ruolo2.setContestoUtilizzo(RuoloContesto.toEnumConstant(contestoUtilizzo));
            }
            ruolo2.setSuperUser(rs.getString("superuser"));
            if (rs.getTimestamp("ora_registrazione") != null) {
                ruolo2.setOraRegistrazione(new Date(rs.getTimestamp("ora_registrazione").getTime()));
            }
            ruolo2.setProprietaOggetto(DriverRegistroServiziDB_utilsDriver.readProprietaOggetto(rs, false));
            ruolo = ruolo2;
        }
        catch (DriverRegistroServiziNotFound e) {
            try {
                throw e;
                catch (SQLException se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getRuolo] SqlException: " + se.getMessage(), se);
                }
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getRuolo] Exception: " + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return ruolo;
    }

    protected Ruolo getRuolo(long idRuolo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.driver.logDebug("richiesto getRuolo: " + idRuolo);
        if (idRuolo <= 0L) {
            throw new DriverRegistroServiziException("[getRuolo] Parametro idRuolo non valido");
        }
        Connection con = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getRuolo(id)");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getRuolo] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            Ruolo e = this.getRuolo(con, idRuolo);
            return e;
        }
        catch (DriverRegistroServiziNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getRuolo] Exception: " + se.getMessage(), se);
        }
        finally {
            this.driver.closeConnection(con);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Ruolo getRuolo(Connection conParam, long idRuolo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        this.driver.logDebug("richiesto getRuolo: " + idRuolo);
        if (idRuolo <= 0L) {
            throw new DriverRegistroServiziException("[getRuolo] Parametro idRuolo non valido");
        }
        PreparedStatement stm = null;
        ResultSet rs = null;
        IDRuolo idRuoloObject = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("ruoli");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addWhereCondition("id = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stm = conParam.prepareStatement(queryString);
            stm.setLong(1, idRuolo);
            rs = stm.executeQuery();
            if (!rs.next()) {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getRuolo] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(queryString, idRuolo));
            }
            idRuoloObject = new IDRuolo(rs.getString("nome"));
        }
        catch (DriverRegistroServiziNotFound e) {
            try {
                throw e;
                catch (SQLException se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getRuolo] SqlException: " + se.getMessage(), se);
                }
                catch (Exception se) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getRuolo] Exception: " + se.getMessage(), se);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return this.getRuolo(conParam, idRuoloObject);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<IDRuolo> getAllIdRuoli(FiltroRicercaRuoli filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        ArrayList<IDRuolo> arrayList;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        boolean filtroRicercaTipo = false;
        if (filtroRicerca != null) {
            filtroRicercaTipo = filtroRicerca.getTipologia() != null && !RuoloTipologia.QUALSIASI.equals(filtroRicerca.getTipologia());
        }
        ArrayList<String> listTipologia = null;
        if (filtroRicercaTipo) {
            listTipologia = new ArrayList<String>();
            listTipologia.add(RuoloTipologia.QUALSIASI.getValue());
            listTipologia.add(filtroRicerca.getTipologia().getValue());
        }
        boolean filtroRicercaContesto = false;
        if (filtroRicerca != null) {
            filtroRicercaContesto = filtroRicerca.getContesto() != null && !RuoloContesto.QUALSIASI.equals(filtroRicerca.getContesto());
        }
        ArrayList<String> listContesto = null;
        if (filtroRicercaContesto) {
            listContesto = new ArrayList<String>();
            listContesto.add(RuoloContesto.QUALSIASI.getValue());
            listContesto.add(filtroRicerca.getContesto().getValue());
        }
        this.driver.logDebug("getAllIdRuoli...");
        try {
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = this.driver.atomica ? this.driver.getConnectionFromDatasource("getAllIdRuoli") : this.driver.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("ruoli");
            sqlQueryObject.addSelectField("nome");
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    sqlQueryObject.addWhereCondition("ora_registrazione > ?");
                }
                if (filtroRicerca.getMaxDate() != null) {
                    sqlQueryObject.addWhereCondition("ora_registrazione < ?");
                }
                if (filtroRicerca.getNome() != null) {
                    sqlQueryObject.addWhereCondition("nome = ?");
                }
                if (filtroRicercaTipo) {
                    sqlQueryObject.addWhereCondition(false, new String[]{"tipologia = ?", "tipologia = ?"});
                }
                if (filtroRicercaContesto) {
                    sqlQueryObject.addWhereCondition(false, new String[]{"contesto_utilizzo = ?", "contesto_utilizzo = ?"});
                }
                sqlQueryObject.addOrderBy("nome");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.driver.logDebug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            if (filtroRicerca != null) {
                int i;
                if (filtroRicerca.getMinDate() != null) {
                    this.driver.logDebug("minDate stmt.setTimestamp(" + String.valueOf(filtroRicerca.getMinDate()) + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    this.driver.logDebug("maxDate stmt.setTimestamp(" + String.valueOf(filtroRicerca.getMaxDate()) + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getNome() != null) {
                    this.driver.logDebug("nome stmt.setString(" + filtroRicerca.getNome() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNome());
                    ++indexStmt;
                }
                if (filtroRicercaTipo) {
                    for (i = 0; i < listTipologia.size(); ++indexStmt, ++i) {
                        this.driver.logDebug("tipo stmt.setString(" + (String)listTipologia.get(i) + ")");
                        stm.setString(indexStmt, (String)listTipologia.get(i));
                    }
                }
                if (filtroRicercaContesto) {
                    for (i = 0; i < listContesto.size(); ++indexStmt, ++i) {
                        this.driver.logDebug("contesto stmt.setString(" + (String)listContesto.get(i) + ")");
                        stm.setString(indexStmt, (String)listContesto.get(i));
                    }
                }
            }
            rs = stm.executeQuery();
            ArrayList<IDRuolo> nomiRuoli = new ArrayList<IDRuolo>();
            while (rs.next()) {
                nomiRuoli.add(new IDRuolo(rs.getString("nome")));
            }
            if (nomiRuoli.isEmpty()) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Ruoli non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Ruoli non trovati");
            }
            arrayList = nomiRuoli;
        }
        catch (DriverRegistroServiziNotFound de) {
            try {
                throw de;
                catch (Exception e) {
                    throw new DriverRegistroServiziException("getAllIdRuoli error", e);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected void createRuolo(Ruolo ruolo) throws DriverRegistroServiziException {
        if (ruolo == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createRuolo] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("createRuolo");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createRuolo] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDRuolo type = 1");
            DriverRegistroServiziDB_LIB.CRUDRuolo(1, ruolo, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::createRuolo] Errore durante la creazione del ruolo : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean existsRuolo(IDRuolo idRuolo) throws DriverRegistroServiziException {
        boolean exist = false;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (idRuolo == null) {
            throw new DriverRegistroServiziException("Parametro non valido");
        }
        if (idRuolo.getNome() == null || idRuolo.getNome().equals("")) {
            throw new DriverRegistroServiziException("Parametro vuoto non valido");
        }
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("existsRuolo");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::existsRuolo] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("ruoli");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, idRuolo.getNome());
            rs = stm.executeQuery();
            if (rs.next()) {
                exist = true;
            }
            rs.close();
            stm.close();
            JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
            this.driver.closeConnection(con);
        }
        catch (Exception e) {
            exist = false;
            this.driver.log.error("Errore durante verifica esistenza ruolo: " + e.getMessage(), (Throwable)e);
        }
        finally {
            JDBCUtilities.closeResources(rs, stm);
            this.driver.closeConnection(con);
        }
        return exist;
    }

    protected void updateRuolo(Ruolo ruolo) throws DriverRegistroServiziException {
        if (ruolo == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateRuolo] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("updateRuolo");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateRuolo] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDRuolo type = 2");
            DriverRegistroServiziDB_LIB.CRUDRuolo(2, ruolo, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::updateRuolo] Errore durante l'aggiornamento del ruolo : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void deleteRuolo(Ruolo ruolo) throws DriverRegistroServiziException {
        if (ruolo == null) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteRuolo] Parametro non valido.");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("deleteRuolo");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteRuolo] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDRuolo type = 3");
            DriverRegistroServiziDB_LIB.CRUDRuolo(3, ruolo, con);
        }
        catch (Exception qe) {
            error = true;
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::deleteRuolo] Errore durante l'eliminazione del ruolo : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    private ISQLQueryObject buildSqlQueryObjectAutorizzazioniPorteDelegate(String nomeTabella, String aliasPDRUOLI, String aliasPD, String aliasSERVIZI, String aliasACCORDI, String aliasACCORDIGRUPPI, String aliasGRUPPI, String aliasSOGGETTI, boolean isFilterGruppoFruizione, IDFruizione apiImplementazioneFruizione, boolean filterSoggettoProprietario, boolean filterTipoSoggettoProtocollo, String filterGruppo, String filterSoggettoTipo, String filterSoggettoNome, List<String> tipoSoggettiProtocollo, List<Object> existsParameters) throws SQLQueryObjectException {
        ISQLQueryObject sqlQueryObjectAutorizzazioniPorteDelegate = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
        sqlQueryObjectAutorizzazioniPorteDelegate.addFromTable(nomeTabella, aliasPDRUOLI);
        sqlQueryObjectAutorizzazioniPorteDelegate.addFromTable("porte_delegate", aliasPD);
        if (isFilterGruppoFruizione) {
            sqlQueryObjectAutorizzazioniPorteDelegate.addFromTable("servizi", aliasSERVIZI);
            sqlQueryObjectAutorizzazioniPorteDelegate.addFromTable("accordi", aliasACCORDI);
            sqlQueryObjectAutorizzazioniPorteDelegate.addFromTable("accordi_gruppi", aliasACCORDIGRUPPI);
            sqlQueryObjectAutorizzazioniPorteDelegate.addFromTable("gruppi", aliasGRUPPI);
        }
        if (apiImplementazioneFruizione != null || filterSoggettoProprietario || filterTipoSoggettoProtocollo) {
            sqlQueryObjectAutorizzazioniPorteDelegate.addFromTable("soggetti", aliasSOGGETTI);
        }
        sqlQueryObjectAutorizzazioniPorteDelegate.addSelectAliasField(aliasPDRUOLI, "id", aliasPDRUOLI + "id");
        sqlQueryObjectAutorizzazioniPorteDelegate.setANDLogicOperator(true);
        sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasPDRUOLI + ".ruolo = ruoli.nome");
        sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasPDRUOLI + ".id_porta = " + aliasPD + ".id");
        if (isFilterGruppoFruizione) {
            sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasPD + ".id_servizio = " + aliasSERVIZI + ".id");
            sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasSERVIZI + ".id_accordo = " + aliasACCORDI + ".id");
            sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasACCORDIGRUPPI + ".id_accordo = " + aliasACCORDI + ".id");
            sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasACCORDIGRUPPI + ".id_gruppo = " + aliasGRUPPI + ".id");
            sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasGRUPPI + ".nome = ?");
            existsParameters.add(filterGruppo);
        }
        if (apiImplementazioneFruizione != null || filterSoggettoProprietario || filterTipoSoggettoProtocollo) {
            sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasPD + ".id_soggetto = " + aliasSOGGETTI + ".id");
            if (apiImplementazioneFruizione != null) {
                sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasPD + ".tipo_soggetto_erogatore = ?");
                sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasPD + ".nome_soggetto_erogatore = ?");
                sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasPD + ".tipo_servizio = ?");
                sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasPD + ".nome_servizio = ?");
                sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasPD + ".versione_servizio = ?");
                existsParameters.add(apiImplementazioneFruizione.getIdFruitore().getTipo());
                existsParameters.add(apiImplementazioneFruizione.getIdFruitore().getNome());
                existsParameters.add(apiImplementazioneFruizione.getIdServizio().getSoggettoErogatore().getTipo());
                existsParameters.add(apiImplementazioneFruizione.getIdServizio().getSoggettoErogatore().getNome());
                existsParameters.add(apiImplementazioneFruizione.getIdServizio().getTipo());
                existsParameters.add(apiImplementazioneFruizione.getIdServizio().getNome());
                existsParameters.add(apiImplementazioneFruizione.getIdServizio().getVersione());
            } else if (filterSoggettoProprietario) {
                sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                sqlQueryObjectAutorizzazioniPorteDelegate.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                existsParameters.add(filterSoggettoTipo);
                existsParameters.add(filterSoggettoNome);
            } else if (filterTipoSoggettoProtocollo) {
                sqlQueryObjectAutorizzazioniPorteDelegate.addWhereINCondition(aliasSOGGETTI + ".tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
            }
        }
        return sqlQueryObjectAutorizzazioniPorteDelegate;
    }

    private ISQLQueryObject buildSqlQueryObjectAutorizzazioniPorteApplicative(String nomeTabella, String aliasPARUOLI, String aliasPA, String aliasSERVIZI, String aliasACCORDI, String aliasACCORDIGRUPPI, String aliasGRUPPI, String aliasSOGGETTI, boolean isFilterGruppoErogazione, IDServizio apiImplementazioneErogazione, boolean filterSoggettoProprietario, boolean filterTipoSoggettoProtocollo, String filterGruppo, String filterSoggettoTipo, String filterSoggettoNome, List<String> tipoSoggettiProtocollo, List<Object> existsParameters) throws SQLQueryObjectException {
        ISQLQueryObject sqlQueryObjectAutorizzazioniPorteApplicative = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
        sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable(nomeTabella, aliasPARUOLI);
        sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable("porte_applicative", aliasPA);
        if (isFilterGruppoErogazione) {
            sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable("servizi", aliasSERVIZI);
            sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable("accordi", aliasACCORDI);
            sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable("accordi_gruppi", aliasACCORDIGRUPPI);
            sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable("gruppi", aliasGRUPPI);
        }
        if (apiImplementazioneErogazione != null || filterSoggettoProprietario || filterTipoSoggettoProtocollo) {
            sqlQueryObjectAutorizzazioniPorteApplicative.addFromTable("soggetti", aliasSOGGETTI);
        }
        sqlQueryObjectAutorizzazioniPorteApplicative.addSelectAliasField(aliasPARUOLI, "id", aliasPARUOLI + "id");
        sqlQueryObjectAutorizzazioniPorteApplicative.setANDLogicOperator(true);
        sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasPARUOLI + ".ruolo = ruoli.nome");
        sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasPARUOLI + ".id_porta = " + aliasPA + ".id");
        if (isFilterGruppoErogazione) {
            sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasPA + ".id_servizio = " + aliasSERVIZI + ".id");
            sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasSERVIZI + ".id_accordo = " + aliasACCORDI + ".id");
            sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasACCORDIGRUPPI + ".id_accordo = " + aliasACCORDI + ".id");
            sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasACCORDIGRUPPI + ".id_gruppo = " + aliasGRUPPI + ".id");
            sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasGRUPPI + ".nome = ?");
            existsParameters.add(filterGruppo);
        }
        if (apiImplementazioneErogazione != null || filterSoggettoProprietario || filterTipoSoggettoProtocollo) {
            sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasPA + ".id_soggetto = " + aliasSOGGETTI + ".id");
            if (apiImplementazioneErogazione != null) {
                sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasPA + ".tipo_servizio = ?");
                sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasPA + ".servizio = ?");
                sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasPA + ".versione_servizio = ?");
                existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getTipo());
                existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getNome());
                existsParameters.add(apiImplementazioneErogazione.getTipo());
                existsParameters.add(apiImplementazioneErogazione.getNome());
                existsParameters.add(apiImplementazioneErogazione.getVersione());
            } else if (filterSoggettoProprietario) {
                sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                sqlQueryObjectAutorizzazioniPorteApplicative.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                existsParameters.add(filterSoggettoTipo);
                existsParameters.add(filterSoggettoNome);
            } else if (filterTipoSoggettoProtocollo) {
                sqlQueryObjectAutorizzazioniPorteApplicative.addWhereINCondition(aliasSOGGETTI + ".tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
            }
        }
        return sqlQueryObjectAutorizzazioniPorteApplicative;
    }

    protected List<Ruolo> ruoliList(String superuser, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "ruoliList";
        int idLista = Liste.RUOLI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        String filterRuoloTipologia = SearchUtils.getFilter(ricerca, idLista, "filtroRuoloTipologia");
        RuoloTipologia ruoloTipologia = null;
        if (filterRuoloTipologia != null) {
            ruoloTipologia = RuoloTipologia.toEnumConstant(filterRuoloTipologia);
        }
        String filterRuoloContesto = SearchUtils.getFilter(ricerca, idLista, "filtroRuoloContesto");
        RuoloContesto ruoloContesto = null;
        if (filterRuoloContesto != null) {
            ruoloContesto = RuoloContesto.toEnumConstant(filterRuoloContesto);
        }
        boolean isFilterGruppoErogazione = false;
        boolean isFilterGruppoFruizione = false;
        String filterGruppo = SearchUtils.getFilter(ricerca, idLista, "filtroGruppo");
        if (filterGruppo != null && !"".equals(filterGruppo)) {
            isFilterGruppoErogazione = true;
            isFilterGruppoFruizione = true;
        }
        TipoPdD apiContesto = null;
        boolean filterServiziApplicativi = false;
        boolean filterSoggetti = false;
        String filterApiContesto = SearchUtils.getFilter(ricerca, idLista, "filtroApiContesto");
        if (filterApiContesto != null && !"".equals(filterApiContesto)) {
            apiContesto = TipoPdD.toTipoPdD(filterApiContesto);
            if (TipoPdD.APPLICATIVA.equals(apiContesto)) {
                isFilterGruppoFruizione = false;
            } else if (TipoPdD.DELEGATA.equals(apiContesto)) {
                isFilterGruppoErogazione = false;
            } else {
                apiContesto = null;
                if ("Applicativi".equals(filterApiContesto)) {
                    filterServiziApplicativi = true;
                } else if ("Soggetti".equals(filterApiContesto)) {
                    filterSoggetti = true;
                }
            }
        }
        String filterProtocollo = null;
        String filterProtocolli = null;
        List<String> tipoSoggettiProtocollo = null;
        String filterSoggettoTipo = null;
        String filterSoggettoNome = null;
        boolean filterSoggettoProprietario = false;
        boolean filterTipoSoggettoProtocollo = false;
        if (apiContesto != null || filterServiziApplicativi || filterSoggetti) {
            String filterSoggettoTipoNome;
            filterProtocollo = SearchUtils.getFilter(ricerca, idLista, "filtroProtocollo");
            filterProtocolli = SearchUtils.getFilter(ricerca, idLista, "filtroProtocolli");
            try {
                tipoSoggettiProtocollo = Filtri.convertToTipiSoggetti(filterProtocollo, filterProtocolli);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
            if (tipoSoggettiProtocollo != null && !tipoSoggettiProtocollo.isEmpty()) {
                filterTipoSoggettoProtocollo = true;
            }
            if ((filterSoggettoTipoNome = SearchUtils.getFilter(ricerca, idLista, "filtroSoggetto")) != null && !"".equals(filterSoggettoTipoNome)) {
                filterSoggettoTipo = filterSoggettoTipoNome.split("/")[0];
                filterSoggettoNome = filterSoggettoTipoNome.split("/")[1];
                filterSoggettoProprietario = true;
                filterTipoSoggettoProtocollo = false;
            }
        }
        String filterApiImplementazione = null;
        IDServizio apiImplementazioneErogazione = null;
        IDFruizione apiImplementazioneFruizione = null;
        if (apiContesto != null && (filterApiImplementazione = SearchUtils.getFilter(ricerca, idLista, "filtroApiImpl")) != null && !"".equals(filterApiImplementazione)) {
            if (TipoPdD.APPLICATIVA.equals(apiContesto)) {
                try {
                    apiImplementazioneErogazione = IDServizio.toIDServizio(filterApiImplementazione);
                    isFilterGruppoErogazione = false;
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("Filtro API Implementazione '" + filterApiImplementazione + "' non valido: " + e.getMessage(), e);
                }
            }
            if (TipoPdD.DELEGATA.equals(apiContesto)) {
                try {
                    apiImplementazioneFruizione = IDFruizione.toIDFruizione(filterApiImplementazione);
                    isFilterGruppoFruizione = false;
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("Filtro API Implementazione '" + filterApiImplementazione + "' non valido: " + e.getMessage(), e);
                }
            }
        }
        String filterServizioApplicativo = null;
        IDServizioApplicativo idServizioApplicativo = null;
        if (filterServiziApplicativi && (filterServizioApplicativo = SearchUtils.getFilter(ricerca, idLista, "filtroSA")) != null && !"".equals(filterServizioApplicativo)) {
            try {
                idServizioApplicativo = IDServizioApplicativo.toIDServizioApplicativo(filterServizioApplicativo);
                isFilterGruppoErogazione = false;
                isFilterGruppoFruizione = false;
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Filtro Applicativo '" + filterServizioApplicativo + "' non valido: " + e.getMessage(), e);
            }
        }
        this.driver.logDebug("search : " + search);
        this.driver.logDebug("filterRuoloTipologia : " + filterRuoloTipologia);
        this.driver.logDebug("filterRuoloContesto : " + filterRuoloContesto);
        this.driver.logDebug("filterGruppo : " + filterGruppo);
        this.driver.logDebug("filterApiContesto : " + filterApiContesto);
        this.driver.logDebug("filterProtocollo : " + filterProtocollo);
        this.driver.logDebug("filterProtocolli : " + filterProtocolli);
        this.driver.logDebug("filterSoggettoNome : " + filterSoggettoNome);
        this.driver.logDebug("filterSoggettoTipo : " + filterSoggettoTipo);
        this.driver.logDebug("filterApiImplementazione : " + filterApiImplementazione);
        this.driver.logDebug("filterServizioApplicativo : " + filterServizioApplicativo);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Ruolo> lista = new ArrayList<Ruolo>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("ruoliList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        ArrayList<IDRuolo> listIdRuoli = null;
        try {
            String queryString;
            ISQLQueryObject sqlQueryObjectAutorizzazioniPorteApplicative;
            ISQLQueryObject sqlQueryObjectAutorizzazioniPorteDelegate;
            ISQLQueryObject sqlQueryObjectServiziApplicativi;
            ArrayList<String> existsConditions = new ArrayList<String>();
            ArrayList<Object> existsParameters = new ArrayList<Object>();
            String aliasCT = "ct";
            String aliasALLARMI = "alarm";
            String aliasSOGGETTIRUOLI = "sogruoli";
            String aliasSARUOLI = "saruoli";
            String aliasSA = "sa";
            String aliasPDRUOLI = "pdruoli";
            String aliasPDTOKENRUOLI = "pdtokenruoli";
            String aliasPD = "pd";
            String aliasPARUOLI = "paruoli";
            String aliasPATOKENRUOLI = "patokenruoli";
            String aliasPA = "pa";
            String aliasSERVIZI = "s";
            String aliasACCORDI = "a";
            String aliasACCORDIGRUPPI = "ag";
            String aliasGRUPPI = "g";
            String aliasSOGGETTI = "sProprietario";
            if (filterSoggetti) {
                sqlQueryObjectServiziApplicativi = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectServiziApplicativi.addFromTable("soggetti_ruoli", aliasSOGGETTIRUOLI);
                sqlQueryObjectServiziApplicativi.addFromTable("soggetti", aliasSOGGETTI);
                sqlQueryObjectServiziApplicativi.addSelectAliasField(aliasSOGGETTIRUOLI, "id", aliasSOGGETTIRUOLI + "id");
                sqlQueryObjectServiziApplicativi.setANDLogicOperator(true);
                sqlQueryObjectServiziApplicativi.addWhereCondition(aliasSOGGETTIRUOLI + ".id_ruolo = ruoli.id");
                sqlQueryObjectServiziApplicativi.addWhereCondition(aliasSOGGETTIRUOLI + ".id_soggetto = " + aliasSOGGETTI + ".id");
                if (filterSoggettoProprietario || filterTipoSoggettoProtocollo) {
                    if (filterSoggettoProprietario) {
                        sqlQueryObjectServiziApplicativi.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                        sqlQueryObjectServiziApplicativi.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                        existsParameters.add(filterSoggettoTipo);
                        existsParameters.add(filterSoggettoNome);
                    } else if (filterTipoSoggettoProtocollo) {
                        sqlQueryObjectServiziApplicativi.addWhereINCondition(aliasSOGGETTI + ".tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                    }
                }
                existsConditions.add(sqlQueryObjectServiziApplicativi.getWhereExistsCondition(false, sqlQueryObjectServiziApplicativi));
            }
            if (filterServiziApplicativi) {
                sqlQueryObjectServiziApplicativi = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectServiziApplicativi.addFromTable("sa_ruoli", aliasSARUOLI);
                sqlQueryObjectServiziApplicativi.addFromTable("servizi_applicativi", aliasSA);
                if (idServizioApplicativo != null || filterSoggettoProprietario || filterTipoSoggettoProtocollo) {
                    sqlQueryObjectServiziApplicativi.addFromTable("soggetti", aliasSOGGETTI);
                }
                sqlQueryObjectServiziApplicativi.addSelectAliasField(aliasSARUOLI, "id", aliasSARUOLI + "id");
                sqlQueryObjectServiziApplicativi.setANDLogicOperator(true);
                sqlQueryObjectServiziApplicativi.addWhereCondition(aliasSARUOLI + ".ruolo = ruoli.nome");
                sqlQueryObjectServiziApplicativi.addWhereCondition(aliasSARUOLI + ".id_servizio_applicativo = " + aliasSA + ".id");
                if (idServizioApplicativo != null || filterSoggettoProprietario || filterTipoSoggettoProtocollo) {
                    sqlQueryObjectServiziApplicativi.addWhereCondition(aliasSA + ".id_soggetto = " + aliasSOGGETTI + ".id");
                    if (idServizioApplicativo != null) {
                        sqlQueryObjectServiziApplicativi.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                        sqlQueryObjectServiziApplicativi.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                        sqlQueryObjectServiziApplicativi.addWhereCondition(aliasSA + ".nome = ?");
                        existsParameters.add(idServizioApplicativo.getIdSoggettoProprietario().getTipo());
                        existsParameters.add(idServizioApplicativo.getIdSoggettoProprietario().getNome());
                        existsParameters.add(idServizioApplicativo.getNome());
                    } else if (filterSoggettoProprietario) {
                        sqlQueryObjectServiziApplicativi.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                        sqlQueryObjectServiziApplicativi.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                        existsParameters.add(filterSoggettoTipo);
                        existsParameters.add(filterSoggettoNome);
                    } else if (filterTipoSoggettoProtocollo) {
                        sqlQueryObjectServiziApplicativi.addWhereINCondition(aliasSOGGETTI + ".tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                    }
                }
                existsConditions.add(sqlQueryObjectServiziApplicativi.getWhereExistsCondition(false, sqlQueryObjectServiziApplicativi));
            }
            if (isFilterGruppoFruizione || TipoPdD.DELEGATA.equals(apiContesto) || apiImplementazioneFruizione != null) {
                sqlQueryObjectAutorizzazioniPorteDelegate = this.buildSqlQueryObjectAutorizzazioniPorteDelegate("pd_ruoli", aliasPDRUOLI, aliasPD, aliasSERVIZI, aliasACCORDI, aliasACCORDIGRUPPI, aliasGRUPPI, aliasSOGGETTI, isFilterGruppoFruizione, apiImplementazioneFruizione, filterSoggettoProprietario, filterTipoSoggettoProtocollo, filterGruppo, filterSoggettoTipo, filterSoggettoNome, tipoSoggettiProtocollo, existsParameters);
                existsConditions.add(sqlQueryObjectAutorizzazioniPorteDelegate.getWhereExistsCondition(false, sqlQueryObjectAutorizzazioniPorteDelegate));
            }
            if (isFilterGruppoFruizione || TipoPdD.DELEGATA.equals(apiContesto) || apiImplementazioneFruizione != null) {
                sqlQueryObjectAutorizzazioniPorteDelegate = this.buildSqlQueryObjectAutorizzazioniPorteDelegate("pd_token_ruoli", aliasPDTOKENRUOLI, aliasPD, aliasSERVIZI, aliasACCORDI, aliasACCORDIGRUPPI, aliasGRUPPI, aliasSOGGETTI, isFilterGruppoFruizione, apiImplementazioneFruizione, filterSoggettoProprietario, filterTipoSoggettoProtocollo, filterGruppo, filterSoggettoTipo, filterSoggettoNome, tipoSoggettiProtocollo, existsParameters);
                existsConditions.add(sqlQueryObjectAutorizzazioniPorteDelegate.getWhereExistsCondition(false, sqlQueryObjectAutorizzazioniPorteDelegate));
            }
            if (isFilterGruppoErogazione || TipoPdD.APPLICATIVA.equals(apiContesto) || apiImplementazioneErogazione != null) {
                sqlQueryObjectAutorizzazioniPorteApplicative = this.buildSqlQueryObjectAutorizzazioniPorteApplicative("pa_ruoli", aliasPARUOLI, aliasPA, aliasSERVIZI, aliasACCORDI, aliasACCORDIGRUPPI, aliasGRUPPI, aliasSOGGETTI, isFilterGruppoErogazione, apiImplementazioneErogazione, filterSoggettoProprietario, filterTipoSoggettoProtocollo, filterGruppo, filterSoggettoTipo, filterSoggettoNome, tipoSoggettiProtocollo, existsParameters);
                existsConditions.add(sqlQueryObjectAutorizzazioniPorteApplicative.getWhereExistsCondition(false, sqlQueryObjectAutorizzazioniPorteApplicative));
            }
            if (isFilterGruppoErogazione || TipoPdD.APPLICATIVA.equals(apiContesto) || apiImplementazioneErogazione != null) {
                sqlQueryObjectAutorizzazioniPorteApplicative = this.buildSqlQueryObjectAutorizzazioniPorteApplicative("pa_token_ruoli", aliasPATOKENRUOLI, aliasPA, aliasSERVIZI, aliasACCORDI, aliasACCORDIGRUPPI, aliasGRUPPI, aliasSOGGETTI, isFilterGruppoErogazione, apiImplementazioneErogazione, filterSoggettoProprietario, filterTipoSoggettoProtocollo, filterGruppo, filterSoggettoTipo, filterSoggettoNome, tipoSoggettiProtocollo, existsParameters);
                existsConditions.add(sqlQueryObjectAutorizzazioniPorteApplicative.getWhereExistsCondition(false, sqlQueryObjectAutorizzazioniPorteApplicative));
            }
            if (isFilterGruppoFruizione || TipoPdD.DELEGATA.equals(apiContesto) || apiImplementazioneFruizione != null) {
                ISQLQueryObject sqlQueryObjectControlloTrafficoPorteDelegate = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectControlloTrafficoPorteDelegate.addFromTable("ct_active_policy", aliasCT);
                if (isFilterGruppoFruizione || apiImplementazioneFruizione != null || filterSoggettoProprietario || filterTipoSoggettoProtocollo) {
                    sqlQueryObjectControlloTrafficoPorteDelegate.addFromTable("porte_delegate", aliasPD);
                    if (isFilterGruppoFruizione) {
                        sqlQueryObjectControlloTrafficoPorteDelegate.addFromTable("servizi", aliasSERVIZI);
                        sqlQueryObjectControlloTrafficoPorteDelegate.addFromTable("accordi", aliasACCORDI);
                        sqlQueryObjectControlloTrafficoPorteDelegate.addFromTable("accordi_gruppi", aliasACCORDIGRUPPI);
                        sqlQueryObjectControlloTrafficoPorteDelegate.addFromTable("gruppi", aliasGRUPPI);
                    }
                    if (apiImplementazioneFruizione != null || filterSoggettoProprietario || filterTipoSoggettoProtocollo) {
                        sqlQueryObjectControlloTrafficoPorteDelegate.addFromTable("soggetti", aliasSOGGETTI);
                    }
                }
                sqlQueryObjectControlloTrafficoPorteDelegate.addSelectAliasField(aliasCT, "id", aliasCT + "id");
                sqlQueryObjectControlloTrafficoPorteDelegate.setANDLogicOperator(true);
                sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasCT + ".filtro_ruolo_fruitore = ruoli.nome");
                sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasCT + ".filtro_ruolo = 'delegata'");
                if (isFilterGruppoFruizione || apiImplementazioneFruizione != null || filterSoggettoProprietario || filterTipoSoggettoProtocollo) {
                    sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasCT + ".filtro_porta = " + aliasPD + ".nome_porta");
                    if (isFilterGruppoFruizione) {
                        sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasPD + ".id_servizio = " + aliasSERVIZI + ".id");
                        sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasSERVIZI + ".id_accordo = " + aliasACCORDI + ".id");
                        sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasACCORDIGRUPPI + ".id_accordo = " + aliasACCORDI + ".id");
                        sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasACCORDIGRUPPI + ".id_gruppo = " + aliasGRUPPI + ".id");
                        sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasGRUPPI + ".nome = ?");
                        existsParameters.add(filterGruppo);
                    }
                    if (apiImplementazioneFruizione != null || filterSoggettoProprietario || filterTipoSoggettoProtocollo) {
                        sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasPD + ".id_soggetto = " + aliasSOGGETTI + ".id");
                        if (apiImplementazioneFruizione != null) {
                            sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                            sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                            sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasPD + ".tipo_soggetto_erogatore = ?");
                            sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasPD + ".nome_soggetto_erogatore = ?");
                            sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasPD + ".tipo_servizio = ?");
                            sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasPD + ".nome_servizio = ?");
                            sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasPD + ".versione_servizio = ?");
                            existsParameters.add(apiImplementazioneFruizione.getIdFruitore().getTipo());
                            existsParameters.add(apiImplementazioneFruizione.getIdFruitore().getNome());
                            existsParameters.add(apiImplementazioneFruizione.getIdServizio().getSoggettoErogatore().getTipo());
                            existsParameters.add(apiImplementazioneFruizione.getIdServizio().getSoggettoErogatore().getNome());
                            existsParameters.add(apiImplementazioneFruizione.getIdServizio().getTipo());
                            existsParameters.add(apiImplementazioneFruizione.getIdServizio().getNome());
                            existsParameters.add(apiImplementazioneFruizione.getIdServizio().getVersione());
                        } else if (filterSoggettoProprietario) {
                            sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                            sqlQueryObjectControlloTrafficoPorteDelegate.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                            existsParameters.add(filterSoggettoTipo);
                            existsParameters.add(filterSoggettoNome);
                        } else if (filterTipoSoggettoProtocollo) {
                            sqlQueryObjectControlloTrafficoPorteDelegate.addWhereINCondition(aliasSOGGETTI + ".tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                        }
                    }
                }
                existsConditions.add(sqlQueryObjectControlloTrafficoPorteDelegate.getWhereExistsCondition(false, sqlQueryObjectControlloTrafficoPorteDelegate));
            }
            if (isFilterGruppoErogazione || TipoPdD.APPLICATIVA.equals(apiContesto) || apiImplementazioneErogazione != null) {
                ISQLQueryObject sqlQueryObjectControlloTrafficoPorteApplicative = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectControlloTrafficoPorteApplicative.addFromTable("ct_active_policy", aliasCT);
                if (isFilterGruppoErogazione || apiImplementazioneErogazione != null || filterSoggettoProprietario || filterTipoSoggettoProtocollo) {
                    sqlQueryObjectControlloTrafficoPorteApplicative.addFromTable("porte_applicative", aliasPA);
                    if (isFilterGruppoErogazione) {
                        sqlQueryObjectControlloTrafficoPorteApplicative.addFromTable("servizi", aliasSERVIZI);
                        sqlQueryObjectControlloTrafficoPorteApplicative.addFromTable("accordi", aliasACCORDI);
                        sqlQueryObjectControlloTrafficoPorteApplicative.addFromTable("accordi_gruppi", aliasACCORDIGRUPPI);
                        sqlQueryObjectControlloTrafficoPorteApplicative.addFromTable("gruppi", aliasGRUPPI);
                    }
                    if (apiImplementazioneErogazione != null || filterSoggettoProprietario || filterTipoSoggettoProtocollo) {
                        sqlQueryObjectControlloTrafficoPorteApplicative.addFromTable("soggetti", aliasSOGGETTI);
                    }
                }
                sqlQueryObjectControlloTrafficoPorteApplicative.addSelectAliasField(aliasCT, "id", aliasCT + "id");
                sqlQueryObjectControlloTrafficoPorteApplicative.setANDLogicOperator(true);
                sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasCT + ".filtro_ruolo_fruitore = ruoli.nome");
                sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasCT + ".filtro_ruolo = 'applicativa'");
                if (isFilterGruppoErogazione || apiImplementazioneErogazione != null || filterSoggettoProprietario || filterTipoSoggettoProtocollo) {
                    sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasCT + ".filtro_porta = " + aliasPA + ".nome_porta");
                    if (isFilterGruppoErogazione) {
                        sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasPA + ".id_servizio = " + aliasSERVIZI + ".id");
                        sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasSERVIZI + ".id_accordo = " + aliasACCORDI + ".id");
                        sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasACCORDIGRUPPI + ".id_accordo = " + aliasACCORDI + ".id");
                        sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasACCORDIGRUPPI + ".id_gruppo = " + aliasGRUPPI + ".id");
                        sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasGRUPPI + ".nome = ?");
                        existsParameters.add(filterGruppo);
                    }
                    if (apiImplementazioneErogazione != null || filterSoggettoProprietario || filterTipoSoggettoProtocollo) {
                        sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasPA + ".id_soggetto = " + aliasSOGGETTI + ".id");
                        if (apiImplementazioneErogazione != null) {
                            sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                            sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                            sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasPA + ".tipo_servizio = ?");
                            sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasPA + ".servizio = ?");
                            sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasPA + ".versione_servizio = ?");
                            existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getTipo());
                            existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getNome());
                            existsParameters.add(apiImplementazioneErogazione.getTipo());
                            existsParameters.add(apiImplementazioneErogazione.getNome());
                            existsParameters.add(apiImplementazioneErogazione.getVersione());
                        } else if (filterSoggettoProprietario) {
                            sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                            sqlQueryObjectControlloTrafficoPorteApplicative.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                            existsParameters.add(filterSoggettoTipo);
                            existsParameters.add(filterSoggettoNome);
                        } else if (filterTipoSoggettoProtocollo) {
                            sqlQueryObjectControlloTrafficoPorteApplicative.addWhereINCondition(aliasSOGGETTI + ".tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                        }
                    }
                }
                existsConditions.add(sqlQueryObjectControlloTrafficoPorteApplicative.getWhereExistsCondition(false, sqlQueryObjectControlloTrafficoPorteApplicative));
            }
            if (CostantiDB.isAllarmiEnabled()) {
                if (isFilterGruppoFruizione || TipoPdD.DELEGATA.equals(apiContesto) || apiImplementazioneFruizione != null) {
                    ISQLQueryObject sqlQueryObjectAllarmiPorteDelegate = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObjectAllarmiPorteDelegate.addFromTable("allarmi", aliasALLARMI);
                    if (isFilterGruppoFruizione || apiImplementazioneFruizione != null || filterSoggettoProprietario || filterTipoSoggettoProtocollo) {
                        sqlQueryObjectAllarmiPorteDelegate.addFromTable("porte_delegate", aliasPD);
                        if (isFilterGruppoFruizione) {
                            sqlQueryObjectAllarmiPorteDelegate.addFromTable("servizi", aliasSERVIZI);
                            sqlQueryObjectAllarmiPorteDelegate.addFromTable("accordi", aliasACCORDI);
                            sqlQueryObjectAllarmiPorteDelegate.addFromTable("accordi_gruppi", aliasACCORDIGRUPPI);
                            sqlQueryObjectAllarmiPorteDelegate.addFromTable("gruppi", aliasGRUPPI);
                        }
                        if (apiImplementazioneFruizione != null || filterSoggettoProprietario || filterTipoSoggettoProtocollo) {
                            sqlQueryObjectAllarmiPorteDelegate.addFromTable("soggetti", aliasSOGGETTI);
                        }
                    }
                    sqlQueryObjectAllarmiPorteDelegate.addSelectAliasField(aliasALLARMI, "id", aliasALLARMI + "id");
                    sqlQueryObjectAllarmiPorteDelegate.setANDLogicOperator(true);
                    sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasALLARMI + ".filtro_ruolo_fruitore = ruoli.nome");
                    sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasALLARMI + ".filtro_ruolo = 'delegata'");
                    if (isFilterGruppoFruizione || apiImplementazioneFruizione != null || filterSoggettoProprietario || filterTipoSoggettoProtocollo) {
                        sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasALLARMI + ".filtro_porta = " + aliasPD + ".nome_porta");
                        if (isFilterGruppoFruizione) {
                            sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasPD + ".id_servizio = " + aliasSERVIZI + ".id");
                            sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasSERVIZI + ".id_accordo = " + aliasACCORDI + ".id");
                            sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasACCORDIGRUPPI + ".id_accordo = " + aliasACCORDI + ".id");
                            sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasACCORDIGRUPPI + ".id_gruppo = " + aliasGRUPPI + ".id");
                            sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasGRUPPI + ".nome = ?");
                            existsParameters.add(filterGruppo);
                        }
                        if (apiImplementazioneFruizione != null || filterSoggettoProprietario || filterTipoSoggettoProtocollo) {
                            sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasPD + ".id_soggetto = " + aliasSOGGETTI + ".id");
                            if (apiImplementazioneFruizione != null) {
                                sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                                sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                                sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasPD + ".tipo_soggetto_erogatore = ?");
                                sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasPD + ".nome_soggetto_erogatore = ?");
                                sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasPD + ".tipo_servizio = ?");
                                sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasPD + ".nome_servizio = ?");
                                sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasPD + ".versione_servizio = ?");
                                existsParameters.add(apiImplementazioneFruizione.getIdFruitore().getTipo());
                                existsParameters.add(apiImplementazioneFruizione.getIdFruitore().getNome());
                                existsParameters.add(apiImplementazioneFruizione.getIdServizio().getSoggettoErogatore().getTipo());
                                existsParameters.add(apiImplementazioneFruizione.getIdServizio().getSoggettoErogatore().getNome());
                                existsParameters.add(apiImplementazioneFruizione.getIdServizio().getTipo());
                                existsParameters.add(apiImplementazioneFruizione.getIdServizio().getNome());
                                existsParameters.add(apiImplementazioneFruizione.getIdServizio().getVersione());
                            } else if (filterSoggettoProprietario) {
                                sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                                sqlQueryObjectAllarmiPorteDelegate.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                                existsParameters.add(filterSoggettoTipo);
                                existsParameters.add(filterSoggettoNome);
                            } else if (filterTipoSoggettoProtocollo) {
                                sqlQueryObjectAllarmiPorteDelegate.addWhereINCondition(aliasSOGGETTI + ".tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                            }
                        }
                    }
                    existsConditions.add(sqlQueryObjectAllarmiPorteDelegate.getWhereExistsCondition(false, sqlQueryObjectAllarmiPorteDelegate));
                }
                if (isFilterGruppoErogazione || TipoPdD.APPLICATIVA.equals(apiContesto) || apiImplementazioneErogazione != null) {
                    ISQLQueryObject sqlQueryObjectAllarmiPorteApplicative = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObjectAllarmiPorteApplicative.addFromTable("allarmi", aliasALLARMI);
                    if (isFilterGruppoErogazione || apiImplementazioneErogazione != null || filterSoggettoProprietario || filterTipoSoggettoProtocollo) {
                        sqlQueryObjectAllarmiPorteApplicative.addFromTable("porte_applicative", aliasPA);
                        if (isFilterGruppoErogazione) {
                            sqlQueryObjectAllarmiPorteApplicative.addFromTable("servizi", aliasSERVIZI);
                            sqlQueryObjectAllarmiPorteApplicative.addFromTable("accordi", aliasACCORDI);
                            sqlQueryObjectAllarmiPorteApplicative.addFromTable("accordi_gruppi", aliasACCORDIGRUPPI);
                            sqlQueryObjectAllarmiPorteApplicative.addFromTable("gruppi", aliasGRUPPI);
                        }
                        if (apiImplementazioneErogazione != null || filterSoggettoProprietario || filterTipoSoggettoProtocollo) {
                            sqlQueryObjectAllarmiPorteApplicative.addFromTable("soggetti", aliasSOGGETTI);
                        }
                    }
                    sqlQueryObjectAllarmiPorteApplicative.addSelectAliasField(aliasALLARMI, "id", aliasALLARMI + "id");
                    sqlQueryObjectAllarmiPorteApplicative.setANDLogicOperator(true);
                    sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasALLARMI + ".filtro_ruolo_fruitore = ruoli.nome");
                    sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasALLARMI + ".filtro_ruolo = 'applicativa'");
                    if (isFilterGruppoErogazione || apiImplementazioneErogazione != null || filterSoggettoProprietario || filterTipoSoggettoProtocollo) {
                        sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasALLARMI + ".filtro_porta = " + aliasPA + ".nome_porta");
                        if (isFilterGruppoErogazione) {
                            sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasPA + ".id_servizio = " + aliasSERVIZI + ".id");
                            sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasSERVIZI + ".id_accordo = " + aliasACCORDI + ".id");
                            sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasACCORDIGRUPPI + ".id_accordo = " + aliasACCORDI + ".id");
                            sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasACCORDIGRUPPI + ".id_gruppo = " + aliasGRUPPI + ".id");
                            sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasGRUPPI + ".nome = ?");
                            existsParameters.add(filterGruppo);
                        }
                        if (apiImplementazioneErogazione != null || filterSoggettoProprietario || filterTipoSoggettoProtocollo) {
                            sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasPA + ".id_soggetto = " + aliasSOGGETTI + ".id");
                            if (apiImplementazioneErogazione != null) {
                                sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                                sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                                sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasPA + ".tipo_servizio = ?");
                                sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasPA + ".servizio = ?");
                                sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasPA + ".versione_servizio = ?");
                                existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getTipo());
                                existsParameters.add(apiImplementazioneErogazione.getSoggettoErogatore().getNome());
                                existsParameters.add(apiImplementazioneErogazione.getTipo());
                                existsParameters.add(apiImplementazioneErogazione.getNome());
                                existsParameters.add(apiImplementazioneErogazione.getVersione());
                            } else if (filterSoggettoProprietario) {
                                sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasSOGGETTI + ".tipo_soggetto = ?");
                                sqlQueryObjectAllarmiPorteApplicative.addWhereCondition(aliasSOGGETTI + ".nome_soggetto = ?");
                                existsParameters.add(filterSoggettoTipo);
                                existsParameters.add(filterSoggettoNome);
                            } else if (filterTipoSoggettoProtocollo) {
                                sqlQueryObjectAllarmiPorteApplicative.addWhereINCondition(aliasSOGGETTI + ".tipo_soggetto", true, tipoSoggettiProtocollo.toArray(new String[1]));
                            }
                        }
                    }
                    existsConditions.add(sqlQueryObjectAllarmiPorteApplicative.getWhereExistsCondition(false, sqlQueryObjectAllarmiPorteApplicative));
                }
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("ruoli");
                sqlQueryObject.addSelectCountField("*", "cont");
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                if (ruoloContesto != null) {
                    sqlQueryObject.addWhereCondition("contesto_utilizzo = ?");
                }
                if (ruoloTipologia != null) {
                    sqlQueryObject.addWhereCondition("tipologia = ?");
                }
                if (!existsConditions.isEmpty()) {
                    sqlQueryObject.addWhereCondition(false, existsConditions.toArray(new String[1]));
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("ruoli");
                sqlQueryObject.addSelectCountField("*", "cont");
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                if (ruoloContesto != null) {
                    sqlQueryObject.addWhereCondition("contesto_utilizzo = ?");
                }
                if (ruoloTipologia != null) {
                    sqlQueryObject.addWhereCondition("tipologia = ?");
                }
                if (!existsConditions.isEmpty()) {
                    sqlQueryObject.addWhereCondition(false, existsConditions.toArray(new String[1]));
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            int index = 1;
            if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                stmt.setString(index++, superuser);
            }
            if (ruoloContesto != null) {
                stmt.setString(index++, ruoloContesto.getValue());
            }
            if (ruoloTipologia != null) {
                stmt.setString(index++, ruoloTipologia.getValue());
            }
            if (existsParameters != null && !existsParameters.isEmpty()) {
                for (Object e : existsParameters) {
                    if (e instanceof String) {
                        stmt.setString(index++, (String)e);
                        continue;
                    }
                    stmt.setInt(index++, (Integer)e);
                }
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("ruoli");
                sqlQueryObject.addSelectField("nome");
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                if (ruoloContesto != null) {
                    sqlQueryObject.addWhereCondition("contesto_utilizzo = ?");
                }
                if (ruoloTipologia != null) {
                    sqlQueryObject.addWhereCondition("tipologia = ?");
                }
                if (!existsConditions.isEmpty()) {
                    sqlQueryObject.addWhereCondition(false, existsConditions.toArray(new String[1]));
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("ruoli");
                sqlQueryObject.addSelectField("nome");
                if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                if (ruoloContesto != null) {
                    sqlQueryObject.addWhereCondition("contesto_utilizzo = ?");
                }
                if (ruoloTipologia != null) {
                    sqlQueryObject.addWhereCondition("tipologia = ?");
                }
                if (!existsConditions.isEmpty()) {
                    sqlQueryObject.addWhereCondition(false, existsConditions.toArray(new String[1]));
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            index = 1;
            if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                stmt.setString(index++, superuser);
            }
            if (ruoloContesto != null) {
                stmt.setString(index++, ruoloContesto.getValue());
            }
            if (ruoloTipologia != null) {
                stmt.setString(index++, ruoloTipologia.getValue());
            }
            if (existsParameters != null && !existsParameters.isEmpty()) {
                for (Object e : existsParameters) {
                    if (e instanceof String) {
                        stmt.setString(index++, (String)e);
                        continue;
                    }
                    stmt.setInt(index++, (Integer)e);
                }
            }
            risultato = stmt.executeQuery();
            listIdRuoli = new ArrayList<IDRuolo>();
            while (risultato.next()) {
                listIdRuoli.add(new IDRuolo(risultato.getString("nome")));
            }
        }
        catch (Exception qe) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        if (listIdRuoli != null) {
            for (IDRuolo idRuolo : listIdRuoli) {
                try {
                    lista.add(this.getRuolo(idRuolo));
                }
                catch (DriverRegistroServiziNotFound notFound) {
                    throw new DriverRegistroServiziException(notFound.getMessage(), notFound);
                }
            }
        }
        return lista;
    }
}

