/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.CredenzialeTipo;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_LIB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_soggettiDriver;
import org.openspcoop2.core.registry.driver.db.IDSoggettoDB;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.ArchiveType;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.certificate.CertificateUtils;
import org.openspcoop2.utils.certificate.PrincipalType;
import org.openspcoop2.utils.crypt.CryptConfig;
import org.openspcoop2.utils.crypt.CryptFactory;
import org.openspcoop2.utils.crypt.ICrypt;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;
import org.openspcoop2.utils.jdbc.JDBCAdapterFactory;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.slf4j.Logger;

public class DriverRegistroServiziDB_soggettiCredenzialiDriver {
    private DriverRegistroServiziDB driver = null;
    private DriverRegistroServiziDB_soggettiDriver soggettiDriver = null;

    protected DriverRegistroServiziDB_soggettiCredenzialiDriver(DriverRegistroServiziDB driver) {
        this.driver = driver;
        this.soggettiDriver = new DriverRegistroServiziDB_soggettiDriver(driver);
    }

    protected Soggetto soggettoWithCredenzialiBasic(String utente, String password, boolean checkPassword) throws DriverRegistroServiziException {
        Soggetto soggetto;
        String nomeMetodo = "soggettoWithCredenzialiBasic";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        Soggetto sogg = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("tipoauth = ?");
            sqlQueryObject.addWhereCondition("utente = ?");
            if (checkPassword) {
                sqlQueryObject.addWhereCondition("password = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int index = 1;
            stmt.setString(index++, CredenzialeTipo.BASIC.getValue());
            stmt.setString(index++, utente);
            if (checkPassword) {
                stmt.setString(index++, password);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                sogg = this.soggettiDriver.getSoggetto(risultato.getLong("id"));
            }
            soggetto = sogg;
        }
        catch (Exception qe) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return soggetto;
    }

    protected Soggetto soggettoWithCredenzialiApiKey(String utente, boolean appId) throws DriverRegistroServiziException {
        Soggetto soggetto;
        String nomeMetodo = "soggettoWithCredenzialiApiKey";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        Soggetto sogg = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("tipoauth = ?");
            sqlQueryObject.addWhereCondition("utente = ?");
            sqlQueryObject.addWhereCondition("issuer = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int index = 1;
            stmt.setString(index++, CredenzialeTipo.APIKEY.getValue());
            stmt.setString(index++, utente);
            stmt.setString(index++, CostantiDB.getIssuerApiKey(appId));
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                sogg = this.soggettiDriver.getSoggetto(risultato.getLong("id"));
            }
            soggetto = sogg;
        }
        catch (Exception qe) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return soggetto;
    }

    protected Soggetto getSoggettoByCredenzialiBasic(String user, String password, CryptConfig config) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getEngineSoggettoAutenticato(CredenzialeTipo.BASIC, user, password, null, null, null, false, null, config, false, false);
    }

    protected Soggetto getSoggettoByCredenzialiApiKey(String user, String password, boolean appId, CryptConfig config) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getEngineSoggettoAutenticato(CredenzialeTipo.APIKEY, user, password, null, null, null, false, null, config, appId, false);
    }

    protected Soggetto getSoggettoByCredenzialiSsl(String subject, String issuer) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            return this.getEngineSoggettoAutenticato(CredenzialeTipo.SSL, null, null, subject, issuer, null, false, null, null, false, false);
        }
        catch (DriverRegistroServiziNotFound notFound) {
            return this.getEngineSoggettoAutenticato(CredenzialeTipo.SSL, null, null, subject, issuer, null, false, null, null, false, true);
        }
    }

    protected Soggetto getSoggettoByCredenzialiSsl(CertificateInfo certificate, boolean strictVerifier) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            return this.getEngineSoggettoAutenticato(CredenzialeTipo.SSL, null, null, null, null, certificate, strictVerifier, null, null, false, false);
        }
        catch (DriverRegistroServiziNotFound notFound) {
            return this.getEngineSoggettoAutenticato(CredenzialeTipo.SSL, null, null, null, null, certificate, strictVerifier, null, null, false, true);
        }
    }

    protected Soggetto getSoggettoByCredenzialiPrincipal(String principal) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getEngineSoggettoAutenticato(CredenzialeTipo.PRINCIPAL, null, null, null, null, null, false, principal, null, false, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Soggetto getEngineSoggettoAutenticato(CredenzialeTipo tipoCredenziale, String user, String password, String aSubject, String aIssuer, CertificateInfo aCertificate, boolean aStrictVerifier, String principal, CryptConfig config, boolean appId, boolean searchInCredenzialiUlteriori) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        IDSoggetto idSoggetto;
        ResultSet rs;
        PreparedStatement stm;
        Connection con;
        block59: {
            IJDBCAdapter jdbcAdapter;
            block60: {
                if (tipoCredenziale == null) {
                    throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro tipoCredenziale is null");
                }
                switch (tipoCredenziale) {
                    case BASIC: {
                        if (user == null || "".equalsIgnoreCase(user)) {
                            throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro user is null (required for basic auth)");
                        }
                        if (password != null && !"".equalsIgnoreCase(password)) break;
                        throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro password is null (required for basic auth)");
                    }
                    case APIKEY: {
                        if (user == null || "".equalsIgnoreCase(user)) {
                            throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro user is null (required for apikey auth)");
                        }
                        if (password != null && !"".equalsIgnoreCase(password)) break;
                        throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro password is null (required for apikey auth)");
                    }
                    case SSL: {
                        if (aSubject != null && !"".equalsIgnoreCase(aSubject) || aCertificate != null) break;
                        throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro subject/certificate is null (required for ssl auth)");
                    }
                    case PRINCIPAL: {
                        if (principal != null && !"".equalsIgnoreCase(principal)) break;
                        throw new DriverRegistroServiziException("[getSoggettoAutenticato] Parametro principal is null (required for principal auth)");
                    }
                }
                con = null;
                stm = null;
                rs = null;
                if (this.driver.atomica) {
                    try {
                        con = this.driver.getConnectionFromDatasource("getSoggettoAutenticato");
                    }
                    catch (Exception e) {
                        throw new DriverRegistroServiziException("DriverRegistroServiziDB::getSoggettoAutenticato] Exception accedendo al datasource :" + e.getMessage(), e);
                    }
                } else {
                    con = this.driver.globalConnection;
                }
                this.driver.logDebug("operazione atomica = " + this.driver.atomica);
                idSoggetto = null;
                try {
                    String tabella = "soggetti";
                    if (searchInCredenzialiUlteriori) {
                        tabella = "soggetti_credenziali";
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable("soggetti");
                    if (searchInCredenzialiUlteriori) {
                        sqlQueryObject.addFromTable("soggetti_credenziali");
                    }
                    sqlQueryObject.addSelectField("tipo_soggetto");
                    sqlQueryObject.addSelectField("nome_soggetto");
                    if (searchInCredenzialiUlteriori) {
                        sqlQueryObject.addWhereCondition("soggetti_credenziali.id_soggetto=soggetti.id");
                    }
                    sqlQueryObject.addWhereCondition("tipoauth = ?");
                    switch (tipoCredenziale) {
                        case BASIC: {
                            sqlQueryObject.addSelectField("password");
                            sqlQueryObject.addWhereCondition("utente = ?");
                            break;
                        }
                        case APIKEY: {
                            sqlQueryObject.addSelectField("password");
                            sqlQueryObject.addWhereCondition("utente = ?");
                            sqlQueryObject.addWhereCondition("issuer = ?");
                            break;
                        }
                        case SSL: {
                            if (aSubject != null && !"".equals(aSubject)) {
                                List listValues;
                                sqlQueryObject.addSelectAliasField(tabella, "subject", "soggettoSubject");
                                sqlQueryObject.addSelectAliasField(tabella, "issuer", "soggettoIssuer");
                                Map hashSubject = CertificateUtils.getPrincipalIntoMap((String)aSubject, (PrincipalType)PrincipalType.SUBJECT);
                                Map hashIssuer = null;
                                if (StringUtils.isNotEmpty((CharSequence)aIssuer)) {
                                    hashIssuer = CertificateUtils.getPrincipalIntoMap((String)aIssuer, (PrincipalType)PrincipalType.ISSUER);
                                }
                                for (String key : hashSubject.keySet()) {
                                    listValues = (List)hashSubject.get(key);
                                    for (String value : listValues) {
                                        sqlQueryObject.addWhereLikeCondition(tabella + ".subject", "/" + CertificateUtils.formatKeyPrincipal((String)key) + "=" + CertificateUtils.formatValuePrincipal((String)value) + "/", true, true, false);
                                    }
                                }
                                if (hashIssuer != null) {
                                    for (String key : hashIssuer.keySet()) {
                                        listValues = (List)hashIssuer.get(key);
                                        for (String value : listValues) {
                                            sqlQueryObject.addWhereLikeCondition(tabella + ".issuer", "/" + CertificateUtils.formatKeyPrincipal((String)key) + "=" + CertificateUtils.formatValuePrincipal((String)value) + "/", true, true, false);
                                        }
                                    }
                                    break;
                                } else {
                                    sqlQueryObject.addWhereIsNullCondition(tabella + ".issuer");
                                    break;
                                }
                            }
                            sqlQueryObject.addSelectAliasField(tabella, "cn_subject", "soggettoCNSubject");
                            sqlQueryObject.addSelectAliasField(tabella, "cn_issuer", "soggettoCNIssuer");
                            sqlQueryObject.addSelectAliasField(tabella, "cert_strict_verification", "soggettoCertStrictVerification");
                            sqlQueryObject.addSelectAliasField(tabella, "certificate", "soggettoCertificate");
                            sqlQueryObject.addWhereCondition(tabella + ".cn_subject = ?");
                            sqlQueryObject.addWhereCondition(tabella + ".cn_issuer = ?");
                            sqlQueryObject.addWhereCondition(tabella + ".cert_strict_verification = ?");
                            break;
                        }
                        case PRINCIPAL: {
                            sqlQueryObject.addWhereCondition("utente = ?");
                            break;
                        }
                    }
                    sqlQueryObject.setANDLogicOperator(true);
                    String sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    int index = 1;
                    stm.setString(index++, tipoCredenziale.toString());
                    switch (tipoCredenziale) {
                        case BASIC: {
                            stm.setString(index++, user);
                            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, tipoCredenziale.toString(), user));
                            break;
                        }
                        case APIKEY: {
                            stm.setString(index++, user);
                            stm.setString(index++, CostantiDB.getIssuerApiKey(appId));
                            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, tipoCredenziale.toString(), user, CostantiDB.getIssuerApiKey(appId)));
                            break;
                        }
                        case SSL: {
                            if (aSubject != null && !"".equals(aSubject)) {
                                this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, tipoCredenziale.toString()));
                                break;
                            }
                            String cnSubject = aCertificate.getSubject().getCN();
                            String cnIssuer = aCertificate.getIssuer().getCN();
                            stm.setString(index++, cnSubject);
                            stm.setString(index++, cnIssuer);
                            if (aStrictVerifier) {
                                stm.setInt(index++, 1);
                            } else {
                                stm.setInt(index++, 0);
                            }
                            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, tipoCredenziale.toString(), cnSubject, cnIssuer, aStrictVerifier ? 1 : 0));
                            break;
                        }
                        case PRINCIPAL: {
                            stm.setString(index++, principal);
                            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, tipoCredenziale.toString(), principal));
                            break;
                        }
                    }
                    rs = stm.executeQuery();
                    if (CredenzialeTipo.BASIC.equals(tipoCredenziale) || CredenzialeTipo.APIKEY.equals(tipoCredenziale)) {
                        boolean testInChiaro = false;
                        ICrypt crypt = null;
                        if (CredenzialeTipo.BASIC.equals(tipoCredenziale)) {
                            if (config == null || config.isBackwardCompatibility()) {
                                testInChiaro = true;
                            }
                            if (config != null) {
                                crypt = CryptFactory.getCrypt((Logger)this.driver.log, (CryptConfig)config);
                            }
                        } else if (config != null) {
                            crypt = CryptFactory.getCrypt((Logger)this.driver.log, (CryptConfig)config);
                        } else {
                            testInChiaro = true;
                        }
                        while (rs.next()) {
                            String passwordDB = rs.getString("password");
                            boolean found = false;
                            if (testInChiaro) {
                                found = password.equals(passwordDB);
                            }
                            if (!found && crypt != null) {
                                found = crypt.check(password, passwordDB);
                            }
                            if (!found) continue;
                            idSoggetto = new IDSoggetto();
                            idSoggetto.setTipo(rs.getString("tipo_soggetto"));
                            idSoggetto.setNome(rs.getString("nome_soggetto"));
                            break block59;
                        }
                        break block59;
                    }
                    if (CredenzialeTipo.SSL.equals(tipoCredenziale)) {
                        jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)this.driver.tipoDB);
                        break block60;
                    }
                    if (!rs.next()) break block59;
                    idSoggetto = new IDSoggetto();
                    idSoggetto.setTipo(rs.getString("tipo_soggetto"));
                    idSoggetto.setNome(rs.getString("nome_soggetto"));
                    break block59;
                }
                catch (SQLException se) {
                    try {
                        throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggettoAutenticato] SqlException: " + se.getMessage(), se);
                        catch (Exception se2) {
                            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggettoAutenticato] Exception: " + se2.getMessage(), se2);
                        }
                    }
                    catch (Throwable throwable) {
                        JDBCUtilities.closeResources(rs, stm);
                        this.driver.closeConnection(con);
                        throw throwable;
                    }
                }
            }
            while (rs.next()) {
                if (aSubject != null && !"".equals(aSubject)) {
                    String subjectPotenziale = rs.getString("soggettoSubject");
                    boolean subjectValid = CertificateUtils.sslVerify((String)subjectPotenziale, (String)aSubject, (PrincipalType)PrincipalType.SUBJECT, (Logger)this.driver.log);
                    boolean issuerValid = true;
                    if (StringUtils.isNotEmpty((CharSequence)aIssuer)) {
                        String issuerPotenziale = rs.getString("soggettoIssuer");
                        issuerValid = StringUtils.isNotEmpty((CharSequence)issuerPotenziale) ? CertificateUtils.sslVerify((String)issuerPotenziale, (String)aIssuer, (PrincipalType)PrincipalType.ISSUER, (Logger)this.driver.log) : false;
                    }
                    if (!subjectValid || !issuerValid) continue;
                    idSoggetto = new IDSoggetto();
                    idSoggetto.setTipo(rs.getString("tipo_soggetto"));
                    idSoggetto.setNome(rs.getString("nome_soggetto"));
                    break;
                }
                byte[] certificatoBytes = jdbcAdapter.getBinaryData(rs, "soggettoCertificate");
                Certificate certificato = ArchiveLoader.load((ArchiveType)ArchiveType.CER, (byte[])certificatoBytes, (int)0, null);
                if (!aCertificate.equals(certificato.getCertificate(), aStrictVerifier)) continue;
                idSoggetto = new IDSoggetto();
                idSoggetto.setTipo(rs.getString("tipo_soggetto"));
                idSoggetto.setNome(rs.getString("nome_soggetto"));
                break;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        if (idSoggetto == null) {
            throw new DriverRegistroServiziNotFound("Nessun soggetto trovato che possiede le credenziali '" + tipoCredenziale.toString() + "' fornite");
        }
        return this.soggettiDriver.getSoggetto(idSoggetto);
    }

    protected List<Soggetto> soggettoWithCredenzialiSslList(CertificateInfo certificate, boolean strictVerifier) throws DriverRegistroServiziException {
        String nomeMetodo = "soggettoWithCredenzialiSslList";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Soggetto> lista = new ArrayList<Soggetto>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            for (int i = 0; i < 2; ++i) {
                String tabella = null;
                tabella = i == 0 ? "soggetti" : "soggetti_credenziali";
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                if (i > 0) {
                    sqlQueryObject.addFromTable("soggetti_credenziali");
                }
                sqlQueryObject.addSelectAliasField("soggetti", "id", "soggettoIdentificativo");
                sqlQueryObject.addSelectAliasField(tabella, "cn_subject", "soggettoCNSubject");
                sqlQueryObject.addSelectAliasField(tabella, "cn_issuer", "soggettoCNIssuer");
                sqlQueryObject.addSelectAliasField(tabella, "cert_strict_verification", "soggettoCertStrictVerification");
                sqlQueryObject.addSelectAliasField(tabella, "certificate", "soggettoCertificate");
                if (i > 0) {
                    sqlQueryObject.addWhereCondition("soggetti_credenziali.id_soggetto=soggetti.id");
                }
                sqlQueryObject.addWhereCondition("soggetti.tipoauth = ?");
                sqlQueryObject.addWhereCondition(tabella + ".cn_subject = ?");
                sqlQueryObject.addWhereCondition(tabella + ".cn_issuer = ?");
                sqlQueryObject.setANDLogicOperator(true);
                String queryString = sqlQueryObject.createSQLQuery();
                String cnSubject = certificate.getSubject().getCN();
                String cnIssuer = certificate.getIssuer().getCN();
                stmt = con.prepareStatement(queryString);
                int indexStmt = 1;
                stmt.setString(indexStmt++, CredenzialeTipo.SSL.getValue());
                stmt.setString(indexStmt++, cnSubject);
                stmt.setString(indexStmt++, cnIssuer);
                risultato = stmt.executeQuery();
                IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)this.driver.tipoDB);
                while (risultato.next()) {
                    byte[] certificatoBytes = jdbcAdapter.getBinaryData(risultato, "soggettoCertificate");
                    Certificate certificato = ArchiveLoader.load((ArchiveType)ArchiveType.CER, (byte[])certificatoBytes, (int)0, null);
                    if (!certificate.equals(certificato.getCertificate(), strictVerifier)) continue;
                    Soggetto soggetto = this.soggettiDriver.getSoggetto(risultato.getLong("soggettoIdentificativo"));
                    lista.add(soggetto);
                }
                risultato.close();
                risultato = null;
                stmt.close();
                stmt = null;
            }
            ArrayList<Soggetto> i = lista;
            return i;
        }
        catch (Exception qe) {
            throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            JDBCUtilities.closeResources(risultato, stmt);
            this.driver.closeConnection(con);
        }
    }

    protected List<IDSoggettoDB> getSoggettiFromTipoAutenticazione(List<String> tipiSoggetto, String superuser, CredenzialeTipo credenziale, Boolean appId, PddTipologia pddTipologia) throws DriverRegistroServiziException {
        ArrayList<IDSoggettoDB> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        int offset = 0;
        int limit = 1000;
        this.driver.logDebug("getSoggettiFromTipoAutenticazione...");
        ArrayList<IDSoggettoDB> soggetti = null;
        try {
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = this.driver.atomica ? this.driver.getConnectionFromDatasource("getSoggettiFromTipoAutenticazione") : this.driver.globalConnection;
            ISQLQueryObject sqlQueryObjectPdd = null;
            if (pddTipologia != null && PddTipologia.ESTERNO.equals((Object)pddTipologia)) {
                ISQLQueryObject sqlQueryObjectExistsPdd = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectExistsPdd.addSelectField("pdd.nome");
                sqlQueryObjectExistsPdd.addFromTable("pdd");
                sqlQueryObjectExistsPdd.setANDLogicOperator(true);
                sqlQueryObjectExistsPdd.addWhereCondition("pdd.nome=soggetti.server");
                sqlQueryObjectExistsPdd.addWhereCondition("pdd.tipo=?");
                sqlQueryObjectPdd = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectPdd.setANDLogicOperator(false);
                sqlQueryObjectPdd.addWhereIsNullCondition("soggetti.server");
                sqlQueryObjectPdd.addWhereExistsCondition(false, sqlQueryObjectExistsPdd);
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectAliasField("soggetti", "id", "idTableSoggetto");
            sqlQueryObject.addSelectField("tipo_soggetto");
            sqlQueryObject.addSelectField("nome_soggetto");
            sqlQueryObject.setANDLogicOperator(true);
            if (tipiSoggetto != null && tipiSoggetto.size() > 0) {
                sqlQueryObject.addWhereINCondition("tipo_soggetto", true, tipiSoggetto.toArray(new String[1]));
            }
            if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
            }
            if (credenziale != null) {
                sqlQueryObject.addWhereCondition("tipoauth = ?");
                if (CredenzialeTipo.APIKEY.equals(credenziale) && appId != null) {
                    sqlQueryObject.addWhereCondition("issuer = ?");
                }
            }
            if (pddTipologia != null) {
                if (PddTipologia.ESTERNO.equals((Object)pddTipologia)) {
                    sqlQueryObject.addWhereCondition(sqlQueryObjectPdd.createSQLConditions());
                } else {
                    sqlQueryObject.addFromTable("pdd");
                    sqlQueryObject.addWhereCondition(true, new String[]{"pdd.nome=soggetti.server", "pdd.tipo=?"});
                }
            }
            sqlQueryObject.addOrderBy("nome_soggetto");
            sqlQueryObject.addOrderBy("tipo_soggetto");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.setOffset(offset);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int index = 1;
            if (this.driver.useSuperUser && superuser != null && !superuser.equals("")) {
                stmt.setString(index++, superuser);
            }
            if (credenziale != null) {
                stmt.setString(index++, credenziale.toString());
                if (CredenzialeTipo.APIKEY.equals(credenziale) && appId != null) {
                    stmt.setString(index++, CostantiDB.getIssuerApiKey(appId));
                }
            }
            if (pddTipologia != null) {
                stmt.setString(index++, pddTipologia.toString());
            }
            risultato = stmt.executeQuery();
            soggetti = new ArrayList<IDSoggettoDB>();
            while (risultato.next()) {
                IDSoggettoDB sog = new IDSoggettoDB();
                sog.setId(risultato.getLong("idTableSoggetto"));
                sog.setNome(risultato.getString("nome_soggetto"));
                sog.setTipo(risultato.getString("tipo_soggetto"));
                soggetti.add(sog);
            }
            arrayList = soggetti;
        }
        catch (Exception qe) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getSoggettiFromTipoAutenticazione] Exception: " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }
}

