/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.wsdl;

import com.ibm.wsdl.xml.WSDLReaderImpl;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Service;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.id.IDUtilities;
import org.openspcoop2.utils.wsdl.DefinitionWrapper;
import org.openspcoop2.utils.wsdl.WSDLException;
import org.openspcoop2.utils.wsdl.WSDLUtilities;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.openspcoop2.utils.xml.PrettyPrintXMLUtils;
import org.openspcoop2.utils.xml.XSDUtils;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RegistroOpenSPCoopUtilities {
    private Logger logger = null;
    private MessageXMLUtils xmlUtils = null;
    private XSDUtils xsdUtils = null;
    private WSDLUtilities wsdlUtilities = null;
    private OpenSPCoop2MessageFactory messageFactory;
    private IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();

    public RegistroOpenSPCoopUtilities(OpenSPCoop2MessageFactory messageFactory, Logger log) {
        this.logger = log != null ? log : LoggerWrapperFactory.getLogger(RegistroOpenSPCoopUtilities.class);
        this.messageFactory = messageFactory;
        this.xmlUtils = MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)this.messageFactory);
        this.xsdUtils = new XSDUtils((AbstractXMLUtils)this.xmlUtils);
        this.wsdlUtilities = WSDLUtilities.getInstance((AbstractXMLUtils)this.xmlUtils);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Definition buildWsdlFromObjects(AccordoServizioParteComune parteComune, byte[] implementativoByte, boolean implementativoErogatore) throws DriverRegistroServiziException {
        try {
            int indexOf;
            int endIndexOf;
            AccordoServizioParteComune parteComuneNormalizzata = (AccordoServizioParteComune)parteComune.clone();
            this.updateLocation(parteComuneNormalizzata, false, false);
            byte[] logicoByte = null;
            if (implementativoErogatore) {
                if (parteComuneNormalizzata.getByteWsdlLogicoErogatore() == null) throw new DriverRegistroServiziException("Byte del WSDL logico erogatore non presenti");
                logicoByte = parteComuneNormalizzata.getByteWsdlLogicoErogatore();
            } else {
                if (parteComuneNormalizzata.getByteWsdlLogicoFruitore() == null) throw new DriverRegistroServiziException("Byte del WSDL logico fruitore non presenti");
                logicoByte = parteComuneNormalizzata.getByteWsdlLogicoFruitore();
            }
            WSDLReaderImpl builderWSDL = new WSDLReaderImpl();
            Definition wsdl = null;
            if (logicoByte == null) {
                throw new Exception("Wsdl logico (byte[]) non definito");
            }
            this.logger.debug("Leggo WSDL logico");
            Document documentLogico = this.xmlUtils.newDocument(logicoByte);
            Element wsdlElement = documentLogico.getDocumentElement();
            String prefix = wsdlElement.getPrefix();
            ByteArrayOutputStream xsd = new ByteArrayOutputStream();
            HashMap<String, String> prefixForWSDL = new HashMap<String, String>();
            for (int k = 0; k < 2; ++k) {
                boolean firstIteration = k == 0;
                List importIntoWSDL = this.wsdlUtilities.readImportsSchemaIntoTypes(documentLogico);
                block9: for (int i = 0; i < importIntoWSDL.size(); ++i) {
                    String file;
                    Node n = (Node)importIntoWSDL.get(i);
                    String namespaceImport = null;
                    try {
                        namespaceImport = this.xsdUtils.getImportNamespace(n);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String location = null;
                    try {
                        location = this.xsdUtils.getImportSchemaLocation(n);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (location == null) continue;
                    if ("InterfacciaDefinitoria.xsd".equals(location)) {
                        if (parteComuneNormalizzata.getByteWsdlDefinitorio() == null) continue;
                        xsd.write("\n".getBytes());
                        this.risoluzioneImportIncludeInXSD(firstIteration, parteComuneNormalizzata, parteComuneNormalizzata.getByteWsdlDefinitorio(), xsd, wsdlElement, prefixForWSDL, true, namespaceImport);
                        continue;
                    }
                    if (location.startsWith("allegati")) {
                        for (int j = 0; j < parteComuneNormalizzata.sizeAllegatoList(); ++j) {
                            Documento allegato = parteComuneNormalizzata.getAllegato(j);
                            file = "allegati" + File.separatorChar + allegato.getFile();
                            if (!location.equals(file)) continue;
                            xsd.write("\n".getBytes());
                            this.risoluzioneImportIncludeInXSD(firstIteration, parteComuneNormalizzata, parteComuneNormalizzata.getAllegato(j).getByteContenuto(), xsd, wsdlElement, prefixForWSDL, true, namespaceImport);
                            continue block9;
                        }
                        continue;
                    }
                    if (!location.startsWith("specificaSemiformale")) continue;
                    for (int j = 0; j < parteComuneNormalizzata.sizeSpecificaSemiformaleList(); ++j) {
                        Documento specificaSemiformale = parteComuneNormalizzata.getSpecificaSemiformale(j);
                        file = "specificaSemiformale" + File.separatorChar + specificaSemiformale.getFile();
                        if (!location.equals(file)) continue;
                        xsd.write("\n".getBytes());
                        this.risoluzioneImportIncludeInXSD(firstIteration, parteComuneNormalizzata, parteComuneNormalizzata.getSpecificaSemiformale(j).getByteContenuto(), xsd, wsdlElement, prefixForWSDL, true, namespaceImport);
                        continue block9;
                    }
                }
                List includeIntoWSDL = this.wsdlUtilities.readIncludesSchemaIntoTypes(documentLogico);
                block12: for (int i = 0; i < includeIntoWSDL.size(); ++i) {
                    String file;
                    Node n = (Node)includeIntoWSDL.get(i);
                    Object o = n.getUserData("TargetNamespaceSchema");
                    String targetNamespaceXSD = null;
                    if (o != null) {
                        targetNamespaceXSD = (String)o;
                    }
                    String location = null;
                    try {
                        location = this.xsdUtils.getIncludeSchemaLocation(n);
                    }
                    catch (Exception file2) {
                        // empty catch block
                    }
                    if (location == null) continue;
                    if ("InterfacciaDefinitoria.xsd".equals(location)) {
                        if (parteComuneNormalizzata.getByteWsdlDefinitorio() == null) continue;
                        xsd.write("\n".getBytes());
                        this.risoluzioneImportIncludeInXSD(firstIteration, parteComuneNormalizzata, parteComuneNormalizzata.getByteWsdlDefinitorio(), xsd, wsdlElement, prefixForWSDL, false, targetNamespaceXSD);
                        continue;
                    }
                    if (location.startsWith("allegati")) {
                        for (int j = 0; j < parteComuneNormalizzata.sizeAllegatoList(); ++j) {
                            Documento allegato = parteComuneNormalizzata.getAllegato(j);
                            file = "allegati" + File.separatorChar + allegato.getFile();
                            if (!location.equals(file)) continue;
                            xsd.write("\n".getBytes());
                            this.risoluzioneImportIncludeInXSD(firstIteration, parteComuneNormalizzata, parteComuneNormalizzata.getAllegato(j).getByteContenuto(), xsd, wsdlElement, prefixForWSDL, false, targetNamespaceXSD);
                            continue block12;
                        }
                        continue;
                    }
                    if (!location.startsWith("specificaSemiformale")) continue;
                    for (int j = 0; j < parteComuneNormalizzata.sizeSpecificaSemiformaleList(); ++j) {
                        Documento specificaSemiformale = parteComuneNormalizzata.getSpecificaSemiformale(j);
                        file = "specificaSemiformale" + File.separatorChar + specificaSemiformale.getFile();
                        if (!location.equals(file)) continue;
                        xsd.write("\n".getBytes());
                        this.risoluzioneImportIncludeInXSD(firstIteration, parteComuneNormalizzata, parteComuneNormalizzata.getSpecificaSemiformale(j).getByteContenuto(), xsd, wsdlElement, prefixForWSDL, false, targetNamespaceXSD);
                        continue block12;
                    }
                }
            }
            if (this.wsdlUtilities.existsTypes(documentLogico)) {
                List schemi = this.wsdlUtilities.getSchemiXSD(documentLogico);
                if (schemi != null && schemi.size() > 0) {
                    for (Node schema : schemi) {
                        boolean schemaWithOnlyImportOrIncludes = this.xsdUtils.isSchemaWithOnlyImportsAndIncludes(schema);
                        if (schemaWithOnlyImportOrIncludes) {
                            this.wsdlUtilities.getIfExistsTypesElementIntoWSDL(documentLogico).removeChild(schema);
                            continue;
                        }
                        List nl = this.xsdUtils.readImportsAndIncludes(schema);
                        if (nl == null) continue;
                        for (Node importInclude : nl) {
                            schema.removeChild(importInclude);
                        }
                    }
                }
            } else {
                this.wsdlUtilities.addEmptyTypesIfNotExists(documentLogico);
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            bout.write(this.xmlUtils.toByteArray(documentLogico));
            bout.flush();
            bout.close();
            Object typesStart = null;
            Object typesClosed = null;
            Object typesEnd = null;
            Object definitionLine = null;
            if (prefix != null) {
                typesStart = "<" + prefix + ":types>";
                typesClosed = "<" + prefix + ":types/>";
                typesEnd = "</" + prefix + ":types>";
                definitionLine = "<" + prefix + ":definitions ";
            } else {
                typesStart = "<types>";
                typesClosed = "<types/>";
                typesEnd = "</types>";
                definitionLine = "<definitions ";
            }
            Object wsdlTrasformato = bout.toString();
            wsdlTrasformato = ((String)wsdlTrasformato).contains((CharSequence)typesStart) ? ((String)wsdlTrasformato).replace((CharSequence)typesStart, (String)typesStart + "\n" + xsd.toString()) : ((String)wsdlTrasformato).replace((CharSequence)typesClosed, (String)typesStart + "\n" + xsd.toString() + "\n\t" + (String)typesEnd);
            if (((String)wsdlTrasformato).contains("<?xml") && (endIndexOf = ((String)wsdlTrasformato).indexOf(">", (indexOf = ((String)wsdlTrasformato).indexOf("<?xml")) + "<?xml".length())) > 0 && indexOf >= 0) {
                wsdlTrasformato = indexOf > 0 ? ((String)wsdlTrasformato).substring(0, indexOf) + ((String)wsdlTrasformato).substring(endIndexOf + 1) : ((String)wsdlTrasformato).substring(endIndexOf + 1);
            }
            for (String key : prefixForWSDL.keySet()) {
                wsdlTrasformato = ((String)wsdlTrasformato).replaceFirst((String)definitionLine, (String)definitionLine + key + "=\"" + prefixForWSDL.get(key) + "\" ");
            }
            documentLogico = this.xmlUtils.newDocument(((String)wsdlTrasformato).getBytes());
            this.logger.debug("Costruisco WSDL Logico per la seconda volta, stavolta con i types corretti");
            wsdl = builderWSDL.readWSDL(null, documentLogico);
            if (implementativoByte == null) return wsdl;
            this.logger.debug("Leggo WSDL implementativo");
            Document documentImplementativo = this.xmlUtils.newDocument(implementativoByte);
            this.logger.debug("Rimuovo import da WSDL Loimplementativogico");
            this.wsdlUtilities.removeImports(documentImplementativo);
            this.wsdlUtilities.removeTypes(documentImplementativo);
            this.logger.debug("Costruisco WSDL Implementativo");
            Definition wsdlImplementativo = builderWSDL.readWSDL(null, documentImplementativo);
            this.addParteImplementativa(wsdl, wsdlImplementativo);
            return wsdl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante la costruzione del wsdl dai bytes: " + e.getMessage(), e);
        }
    }

    public void updateLocation(AccordoServizioParteComune accordoServizioOpenspcoop, boolean strutturaPackageCNIPA, boolean prettyDocument) throws DriverRegistroServiziException {
        try {
            String targetNamespace;
            String file;
            File fLocalName;
            Documento doc;
            int i;
            byte[] wsdlDefinitorio = accordoServizioOpenspcoop.getByteWsdlDefinitorio();
            byte[] wsdlConcettuale = accordoServizioOpenspcoop.getByteWsdlConcettuale();
            byte[] wsdlLogicoErogatore = accordoServizioOpenspcoop.getByteWsdlLogicoErogatore();
            byte[] wsdlLogicoFruitore = accordoServizioOpenspcoop.getByteWsdlLogicoFruitore();
            HashMap<String, String> targetNamespacesXSD = new HashMap<String, String>();
            HashMap<String, String> includePath = new HashMap<String, String>();
            if (wsdlDefinitorio != null) {
                Object file2 = "InterfacciaDefinitoria.xsd";
                if (strutturaPackageCNIPA) {
                    file2 = ".." + File.separatorChar + "allegati" + File.separatorChar + (String)file2;
                }
                String targetNamespace2 = null;
                try {
                    targetNamespace2 = this.xsdUtils.getTargetNamespace(wsdlDefinitorio);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (targetNamespace2 != null) {
                    targetNamespacesXSD.put(targetNamespace2, (String)file2);
                } else {
                    this.logger.debug("Target namespace non trovato per il wsdl definitorio [InterfacciaDefinitoria.xsd]");
                }
                includePath.put("InterfacciaDefinitoria.xsd", (String)file2);
                includePath.put("allegati" + File.separatorChar + "InterfacciaDefinitoria.xsd", (String)file2);
            } else {
                this.logger.debug("Bytes non presenti per il wsdl definitorio [InterfacciaDefinitoria.xsd]");
            }
            for (i = 0; i < accordoServizioOpenspcoop.sizeAllegatoList(); ++i) {
                doc = accordoServizioOpenspcoop.getAllegato(i);
                fLocalName = new File(doc.getFile());
                file = "allegati" + File.separatorChar + fLocalName.getName();
                if (strutturaPackageCNIPA) {
                    file = ".." + File.separatorChar + file;
                }
                if (doc.getByteContenuto() != null) {
                    targetNamespace = null;
                    try {
                        targetNamespace = this.xsdUtils.getTargetNamespace(doc.getByteContenuto());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (targetNamespace == null) {
                        try {
                            targetNamespace = this.wsdlUtilities.getTargetNamespace(doc.getByteContenuto());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (targetNamespace != null) {
                        targetNamespacesXSD.put(targetNamespace, file);
                    } else {
                        this.logger.debug("Target namespace non trovato per l'allegato [" + doc.getFile() + "] (tipo:" + doc.getTipo() + ")");
                    }
                } else {
                    this.logger.debug("Bytes non presenti per l'allegato [" + doc.getFile() + "] (tipo:" + doc.getTipo() + ")");
                }
                includePath.put(fLocalName.getName(), file);
                includePath.put("allegati" + File.separatorChar + fLocalName.getName(), file);
            }
            for (i = 0; i < accordoServizioOpenspcoop.sizeSpecificaSemiformaleList(); ++i) {
                doc = accordoServizioOpenspcoop.getSpecificaSemiformale(i);
                fLocalName = new File(doc.getFile());
                file = "specificaSemiformale" + File.separatorChar + fLocalName.getName();
                if (strutturaPackageCNIPA) {
                    file = ".." + File.separatorChar + file;
                }
                if (doc.getByteContenuto() != null) {
                    targetNamespace = null;
                    try {
                        targetNamespace = this.xsdUtils.getTargetNamespace(doc.getByteContenuto());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (targetNamespace == null) {
                        try {
                            targetNamespace = this.wsdlUtilities.getTargetNamespace(doc.getByteContenuto());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (targetNamespace != null) {
                        targetNamespacesXSD.put(targetNamespace, file);
                    } else {
                        this.logger.debug("Target namespace non trovato per la specifica semiformale [" + doc.getFile() + "] (tipo:" + doc.getTipo() + ")");
                    }
                } else {
                    this.logger.debug("Bytes non presenti per la specifica semiformale [" + doc.getFile() + "] (tipo:" + doc.getTipo() + ")");
                }
                includePath.put(fLocalName.getName(), file);
                includePath.put("specificaSemiformale" + File.separatorChar + fLocalName.getName(), file);
            }
            if (wsdlConcettuale != null) {
                this.logger.debug("Update Wsdl Concettuale...");
                wsdlConcettuale = this.updateImportsAndIncludesWSDLLocation("WSDLConcettuale", wsdlConcettuale, targetNamespacesXSD, includePath, prettyDocument, true);
                accordoServizioOpenspcoop.setByteWsdlConcettuale(wsdlConcettuale);
                this.logger.debug("Update Wsdl Concettuale ok");
            }
            if (wsdlLogicoErogatore != null) {
                this.logger.debug("Update Wsdl Logico Erogatore...");
                wsdlLogicoErogatore = this.updateImportsAndIncludesWSDLLocation("WSDLLogicoErogatore", wsdlLogicoErogatore, targetNamespacesXSD, includePath, prettyDocument, true);
                accordoServizioOpenspcoop.setByteWsdlLogicoErogatore(wsdlLogicoErogatore);
                this.logger.debug("Update Wsdl Logico Erogatore ok");
            }
            if (wsdlLogicoFruitore != null) {
                this.logger.debug("Update Wsdl Logico Fruitore...");
                wsdlLogicoFruitore = this.updateImportsAndIncludesWSDLLocation("WSDLLogicoFruitore", wsdlLogicoFruitore, targetNamespacesXSD, includePath, prettyDocument, true);
                accordoServizioOpenspcoop.setByteWsdlLogicoFruitore(wsdlLogicoFruitore);
                this.logger.debug("Update Wsdl Logico Fruitore ok");
            }
            if (wsdlDefinitorio != null) {
                this.logger.debug("Update Wsdl Definitorio (import)...");
                wsdlDefinitorio = this.updateImportXSDLocation(wsdlDefinitorio, targetNamespacesXSD, prettyDocument);
                this.logger.debug("Update Wsdl Definitorio (include)...");
                wsdlDefinitorio = this.updateIncludeXSDLocation(wsdlDefinitorio, includePath, prettyDocument);
                this.logger.debug("Update Wsdl Definitorio ok");
                accordoServizioOpenspcoop.setByteWsdlDefinitorio(wsdlDefinitorio);
            }
            for (i = 0; i < accordoServizioOpenspcoop.sizeAllegatoList(); ++i) {
                doc = accordoServizioOpenspcoop.getAllegato(i);
                if (doc.getByteContenuto() == null) continue;
                this.logger.debug("Update Allegato di tipo [" + doc.getTipo() + "] [" + doc.getFile() + "] (import)...");
                byte[] allegato = this.updateImportXSDLocation(doc.getByteContenuto(), targetNamespacesXSD, prettyDocument);
                if (allegato != null) {
                    this.logger.debug("Update Allegato di tipo [" + doc.getTipo() + "] [" + doc.getFile() + "] (include)...");
                    allegato = this.updateIncludeXSDLocation(allegato, includePath, prettyDocument);
                    if (allegato != null) {
                        doc.setByteContenuto(allegato);
                        this.logger.debug("Update Allegato di tipo [" + doc.getTipo() + "] [" + doc.getFile() + "] ok");
                        continue;
                    }
                    this.logger.debug("Update (include) Allegato di tipo [" + doc.getTipo() + "] [" + doc.getFile() + "] non effettuato, il documento non e' uno schema XSD");
                    continue;
                }
                this.logger.debug("Update (import) Allegato di tipo [" + doc.getTipo() + "] [" + doc.getFile() + "] non effettuato, il documento non e' uno schema XSD");
            }
            for (i = 0; i < accordoServizioOpenspcoop.sizeSpecificaSemiformaleList(); ++i) {
                doc = accordoServizioOpenspcoop.getSpecificaSemiformale(i);
                if (doc.getByteContenuto() == null) continue;
                this.logger.debug("Update SpecificaSemiformale di tipo [" + doc.getTipo() + "] [" + doc.getFile() + "] (import)...");
                byte[] specificaSemiformale = this.updateImportXSDLocation(doc.getByteContenuto(), targetNamespacesXSD, prettyDocument);
                if (specificaSemiformale != null) {
                    this.logger.debug("Update SpecificaSemiformale di tipo [" + doc.getTipo() + "] [" + doc.getFile() + "] (include)...");
                    specificaSemiformale = this.updateIncludeXSDLocation(specificaSemiformale, includePath, prettyDocument);
                    if (specificaSemiformale != null) {
                        doc.setByteContenuto(specificaSemiformale);
                        this.logger.debug("Update SpecificaSemiformale di tipo [" + doc.getTipo() + "] [" + doc.getFile() + "] ok");
                        continue;
                    }
                    this.logger.debug("Update (include) SpecificaSemiformale di tipo [" + doc.getTipo() + "] [" + doc.getFile() + "] non effettuato, il documento non e' uno schema XSD");
                    continue;
                }
                this.logger.debug("Update (import)SpecificaSemiformale di tipo [" + doc.getTipo() + "] [" + doc.getFile() + "] non effettuato, il documento non e' uno schema XSD");
            }
        }
        catch (Exception e) {
            this.logger.error("Correzione import non riuscita: " + e.getMessage(), (Throwable)e);
            throw new DriverRegistroServiziException("Riscontrato errore durante la lettura del wsdl: " + e.getMessage(), e);
        }
    }

    public void updateLocation(AccordoServizioParteSpecifica servizioOpenspcoop, boolean strutturaPackageCNIPA, boolean prettyDocument) throws DriverRegistroServiziException {
        try {
            Object file;
            String targetNamespace;
            byte[] wsdlImplementativoErogatore = servizioOpenspcoop.getByteWsdlImplementativoErogatore();
            byte[] wsdlImplementativoFruitore = servizioOpenspcoop.getByteWsdlImplementativoFruitore();
            HashMap<String, String> targetNamespacesXSD = new HashMap<String, String>();
            IDAccordo idAccordoParteComune = this.idAccordoFactory.getIDAccordoFromUri(servizioOpenspcoop.getAccordoServizioParteComune());
            if (wsdlImplementativoErogatore != null) {
                targetNamespace = this.wsdlUtilities.getTargetNamespace(wsdlImplementativoErogatore);
                if (targetNamespace != null) {
                    file = "InterfacciaLogicaErogatore.wsdl";
                    if (strutturaPackageCNIPA) {
                        file = ".." + File.separatorChar + ".." + File.separatorChar + idAccordoParteComune.getNome() + File.separatorChar + "specificaInterfaccia" + File.separatorChar + (String)file;
                    }
                    targetNamespacesXSD.put(targetNamespace, (String)file);
                } else {
                    this.logger.debug("Target namespace non trovato per il wsdl implementativo erogatore [InterfacciaLogicaErogatore.wsdl]");
                }
                this.logger.debug("Update Wsdl Implementativo Erogatore...");
                wsdlImplementativoErogatore = this.updateImportsAndIncludesWSDLLocation("WSDLImplementativoErogatore", wsdlImplementativoErogatore, targetNamespacesXSD, null, prettyDocument, false);
                servizioOpenspcoop.setByteWsdlImplementativoErogatore(wsdlImplementativoErogatore);
                this.logger.debug("Update Wsdl Implementativo Erogatore ok");
            }
            if (wsdlImplementativoFruitore != null) {
                targetNamespace = this.wsdlUtilities.getTargetNamespace(wsdlImplementativoFruitore);
                if (targetNamespace != null) {
                    file = "InterfacciaLogicaFruitore.wsdl";
                    if (strutturaPackageCNIPA) {
                        file = ".." + File.separatorChar + ".." + File.separatorChar + idAccordoParteComune.getNome() + File.separatorChar + "specificaInterfaccia" + File.separatorChar + (String)file;
                    }
                    targetNamespacesXSD.put(targetNamespace, (String)file);
                } else {
                    this.logger.debug("Target namespace non trovato per il wsdl implementativo fruitore [InterfacciaLogicaFruitore.wsdl]");
                }
                this.logger.debug("Update Wsdl Implementativo Fruitore...");
                wsdlImplementativoFruitore = this.updateImportsAndIncludesWSDLLocation("WSDLImplementativoFruitore", wsdlImplementativoFruitore, targetNamespacesXSD, null, prettyDocument, false);
                servizioOpenspcoop.setByteWsdlImplementativoFruitore(wsdlImplementativoFruitore);
                this.logger.debug("Update Wsdl Implementativo Fruitore ok");
            }
        }
        catch (Exception e) {
            this.logger.error("Correzione import non riuscita: " + e.getMessage(), (Throwable)e);
            throw new DriverRegistroServiziException("Riscontrato errore durante la lettura del wsdl: " + e.getMessage(), e);
        }
    }

    public byte[] eliminaASParteComune(byte[] wsdlBytes, boolean implementativoErogatore) throws DriverRegistroServiziException {
        try {
            Document d = this.xmlUtils.newDocument(wsdlBytes);
            this.wsdlUtilities.removeTypes(d);
            this.wsdlUtilities.removeImports(d);
            DefinitionWrapper wsdl = new DefinitionWrapper(d, (AbstractXMLUtils)this.xmlUtils);
            wsdl.createTypes();
            Import importLogico = wsdl.createImport();
            if (implementativoErogatore) {
                importLogico.setLocationURI("InterfacciaLogicaErogatore.wsdl");
            } else {
                importLogico.setLocationURI("InterfacciaLogicaFruitore.wsdl");
            }
            importLogico.setNamespaceURI(this.wsdlUtilities.getTargetNamespace(wsdlBytes));
            wsdl.addImport(importLogico);
            wsdl.removeAllMessages();
            wsdl.removeAllPortTypes();
            byte[] wsdlSenzaParteComune = wsdl.toByteArray();
            return wsdlSenzaParteComune;
        }
        catch (Exception e) {
            this.logger.error("Eliminazione  ASParteComune non riuscita: " + e.getMessage(), (Throwable)e);
            throw new DriverRegistroServiziException("Riscontrato errore durante l'eliminazione dell'ASParteComune del wsdl: " + e.getMessage(), e);
        }
    }

    public byte[] aggiungiImportASParteComune(byte[] wsdlBytes, boolean implementativoErogatore) throws DriverRegistroServiziException {
        try {
            Document d = this.xmlUtils.newDocument(wsdlBytes);
            this.wsdlUtilities.removeTypes(d);
            this.wsdlUtilities.removeImports(d);
            DefinitionWrapper wsdl = new DefinitionWrapper(d, (AbstractXMLUtils)this.xmlUtils);
            wsdl.createTypes();
            Import importLogico = wsdl.createImport();
            if (implementativoErogatore) {
                importLogico.setLocationURI("InterfacciaLogicaErogatore.wsdl");
            } else {
                importLogico.setLocationURI("InterfacciaLogicaFruitore.wsdl");
            }
            importLogico.setNamespaceURI(this.wsdlUtilities.getTargetNamespace(wsdlBytes));
            wsdl.addImport(importLogico);
            return wsdl.toByteArray();
        }
        catch (Exception e) {
            this.logger.error("aggiungiImportASParteComune non riuscito: " + e.getMessage(), (Throwable)e);
            throw new DriverRegistroServiziException("Riscontrato errore durante l'eliminazione dell'ASParteComune del wsdl: " + e.getMessage(), e);
        }
    }

    public byte[] eliminaImportASParteComune(byte[] wsdlBytes) throws DriverRegistroServiziException {
        try {
            Document d = this.xmlUtils.newDocument(wsdlBytes);
            this.wsdlUtilities.removeTypes(d);
            this.wsdlUtilities.removeImports(d);
            DefinitionWrapper wsdl = new DefinitionWrapper(d, (AbstractXMLUtils)this.xmlUtils);
            return wsdl.toByteArray();
        }
        catch (Exception e) {
            this.logger.error("Eliminazione  ASParteComune non riuscita: " + e.getMessage(), (Throwable)e);
            throw new DriverRegistroServiziException("Riscontrato errore durante l'eliminazione dell'ASParteComune del wsdl: " + e.getMessage(), e);
        }
    }

    public void addParteImplementativa(Definition wsdlOriginale, Definition wsdlImplementativo) {
        this.logger.debug("Aggiungo wsdl-binding...");
        Map bindings = wsdlImplementativo.getAllBindings();
        if (bindings != null && bindings.size() > 0) {
            this.logger.debug("Aggiungo wsdl-binding [" + bindings.size() + "] a wsdl ritornato");
            for (Binding bindingWSDL : bindings.values()) {
                wsdlOriginale.addBinding(bindingWSDL);
            }
        }
        this.logger.debug("Aggiungo wsdl-service...");
        Map services = wsdlImplementativo.getAllServices();
        if (services != null && services.size() > 0) {
            this.logger.debug("Aggiungo wsdl-service [" + services.size() + "] a wsdl ritornato");
            for (Service serviceWSDL : services.values()) {
                wsdlOriginale.addService(serviceWSDL);
            }
        }
    }

    private void risoluzioneImportIncludeInXSD(boolean firstIteration, AccordoServizioParteComune parteComuneNormalizzata, byte[] documentXSD, ByteArrayOutputStream xsd, Element wsdlElement, HashMap<String, String> prefixForWSDL, boolean docImportato, String targetNamespaceParent) throws DriverRegistroServiziException {
        this.risoluzioneImportIncludeInXSD(firstIteration, parteComuneNormalizzata, documentXSD, xsd, wsdlElement, prefixForWSDL, docImportato, targetNamespaceParent, new HashSet<String>(), 1);
    }

    private void risoluzioneImportIncludeInXSD(boolean firstIteration, AccordoServizioParteComune parteComuneNormalizzata, byte[] documentXSD, ByteArrayOutputStream xsd, Element wsdlElement, HashMap<String, String> prefixForWSDL, boolean docImportato, String targetNamespaceParent, Set<String> observedLocations, int profondita) throws DriverRegistroServiziException {
        try {
            Document doc = this.xmlUtils.newDocument(documentXSD);
            Element docElement = doc.getDocumentElement();
            String targetNamespace = null;
            if (this.xsdUtils.isXSDSchema(doc) && (targetNamespace = this.xsdUtils.getTargetNamespace(doc)) != null && targetNamespace.equals("http://www.w3.org/XML/1998/namespace")) {
                return;
            }
            String uniquePrefix = "_p" + profondita + "_n" + IDUtilities.getUniqueSerialNumber((String)"risoluzioneImportIncludeInXSD") + "_";
            targetNamespace = this.wsdlUtilities.normalizzazioneSchemaPerInserimentoInWsdl(docElement, wsdlElement, prefixForWSDL, uniquePrefix, docImportato, targetNamespaceParent);
            List importIntoXSD = this.xsdUtils.readImports(doc);
            block6: for (int i = 0; i < importIntoXSD.size(); ++i) {
                String file;
                Node n = (Node)importIntoXSD.get(i);
                String location = null;
                try {
                    location = this.xsdUtils.getImportSchemaLocation(n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (observedLocations.contains(location)) continue;
                if (location != null && location.startsWith("allegati")) {
                    for (int j = 0; j < parteComuneNormalizzata.sizeAllegatoList(); ++j) {
                        Documento allegato = parteComuneNormalizzata.getAllegato(j);
                        file = "allegati" + File.separatorChar + allegato.getFile();
                        if (!location.equals(file)) continue;
                        xsd.write("\n".getBytes());
                        observedLocations.add(location);
                        this.risoluzioneImportIncludeInXSD(firstIteration, parteComuneNormalizzata, parteComuneNormalizzata.getAllegato(j).getByteContenuto(), xsd, wsdlElement, prefixForWSDL, true, targetNamespace, observedLocations, profondita + 1);
                        continue block6;
                    }
                    continue;
                }
                if (location == null || !location.startsWith("specificaSemiformale")) continue;
                for (int j = 0; j < parteComuneNormalizzata.sizeSpecificaSemiformaleList(); ++j) {
                    Documento specificaSemiformale = parteComuneNormalizzata.getSpecificaSemiformale(j);
                    file = "specificaSemiformale" + File.separatorChar + specificaSemiformale.getFile();
                    if (!location.equals(file)) continue;
                    xsd.write("\n".getBytes());
                    observedLocations.add(location);
                    this.risoluzioneImportIncludeInXSD(firstIteration, parteComuneNormalizzata, parteComuneNormalizzata.getSpecificaSemiformale(j).getByteContenuto(), xsd, wsdlElement, prefixForWSDL, true, targetNamespace, observedLocations, profondita + 1);
                    continue block6;
                }
            }
            List includeIntoXSD = this.xsdUtils.readIncludes(doc);
            block9: for (int i = 0; i < includeIntoXSD.size(); ++i) {
                String file;
                Node n = (Node)includeIntoXSD.get(i);
                String location = null;
                try {
                    location = this.xsdUtils.getIncludeSchemaLocation(n);
                }
                catch (Exception specificaSemiformale) {
                    // empty catch block
                }
                if (observedLocations.contains(location)) continue;
                if (location != null && location.startsWith("allegati")) {
                    for (int j = 0; j < parteComuneNormalizzata.sizeAllegatoList(); ++j) {
                        Documento allegato = parteComuneNormalizzata.getAllegato(j);
                        file = "allegati" + File.separatorChar + allegato.getFile();
                        if (!location.equals(file)) continue;
                        xsd.write("\n".getBytes());
                        observedLocations.add(location);
                        this.risoluzioneImportIncludeInXSD(firstIteration, parteComuneNormalizzata, parteComuneNormalizzata.getAllegato(j).getByteContenuto(), xsd, wsdlElement, prefixForWSDL, false, targetNamespace, observedLocations, profondita + 1);
                        continue block9;
                    }
                    continue;
                }
                if (location == null || !location.startsWith("specificaSemiformale")) continue;
                for (int j = 0; j < parteComuneNormalizzata.sizeSpecificaSemiformaleList(); ++j) {
                    Documento specificaSemiformale = parteComuneNormalizzata.getSpecificaSemiformale(j);
                    file = "specificaSemiformale" + File.separatorChar + specificaSemiformale.getFile();
                    if (!location.equals(file)) continue;
                    xsd.write("\n".getBytes());
                    observedLocations.add(location);
                    this.risoluzioneImportIncludeInXSD(firstIteration, parteComuneNormalizzata, parteComuneNormalizzata.getSpecificaSemiformale(j).getByteContenuto(), xsd, wsdlElement, prefixForWSDL, false, targetNamespace, observedLocations, profondita + 1);
                    continue block9;
                }
            }
            if (!firstIteration) {
                this.xsdUtils.removeImportsAndIncludes(doc);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                this.xmlUtils.writeTo(doc, (OutputStream)bout, true);
                bout.flush();
                bout.close();
                xsd.write(bout.toByteArray());
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante la costruzione del xsd dai bytes: " + e.getMessage(), e);
        }
    }

    private byte[] updateImportsAndIncludesWSDLLocation(String file, byte[] wsdl, HashMap<String, String> targetNamespacesXSD, HashMap<String, String> includePath, boolean prettyDocument, boolean traduciImportIntoTypesImport) throws WSDLException {
        try {
            String location;
            if (!this.xmlUtils.isDocument(wsdl)) {
                throw new WSDLException("WSDL[" + file + "] non e' un documento valido");
            }
            Document doc = this.xmlUtils.newDocument(wsdl);
            List importsIntoTypesIntoWSDL = this.wsdlUtilities.readImportsSchemaIntoTypes(doc);
            for (int i = 0; i < importsIntoTypesIntoWSDL.size(); ++i) {
                Node n = (Node)importsIntoTypesIntoWSDL.get(i);
                String namespaceImport = null;
                try {
                    namespaceImport = this.xsdUtils.getImportNamespace(n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                location = null;
                try {
                    location = this.xsdUtils.getImportSchemaLocation(n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (namespaceImport != null) {
                    String path = targetNamespacesXSD.get(namespaceImport);
                    if (path == null) {
                        this.logger.debug("Schema non trovato per il namespace " + namespaceImport);
                        continue;
                    }
                    this.xsdUtils.updateSchemaLocation(n, path);
                    this.logger.debug("Reimpostata location: " + path);
                    continue;
                }
                this.logger.debug("Import presente nel WSDL[" + file + "] [" + location + "] non possiede il target namespace");
            }
            if (includePath != null) {
                List includesIntoTypesIntoWSDL = this.wsdlUtilities.readIncludesSchemaIntoTypes(doc);
                for (int i = 0; i < includesIntoTypesIntoWSDL.size(); ++i) {
                    Node n = (Node)includesIntoTypesIntoWSDL.get(i);
                    location = null;
                    try {
                        location = this.xsdUtils.getIncludeSchemaLocation(n);
                    }
                    catch (Exception path) {
                        // empty catch block
                    }
                    if (location != null) {
                        Object key;
                        File locationF = new File(location);
                        String path = null;
                        if (locationF.getParentFile() != null) {
                            key = locationF.getParentFile().getName() + File.separatorChar + locationF.getName();
                            path = includePath.get(key);
                        }
                        if (path == null) {
                            key = locationF.getName();
                            path = includePath.get(key);
                        }
                        if (path == null) {
                            this.logger.debug("Schema non trovato per la location " + location);
                            continue;
                        }
                        this.xsdUtils.updateSchemaLocation(n, path);
                        this.logger.debug("Reimpostata location: " + path);
                        continue;
                    }
                    this.logger.debug("Include presente nel XSD [" + location + "] non possiede la location?");
                }
            }
            List importsIntoWSDL = this.wsdlUtilities.readImports(doc);
            ArrayList<Element> newSchemi = new ArrayList<Element>();
            for (int i = 0; i < importsIntoWSDL.size(); ++i) {
                Node n = (Node)importsIntoWSDL.get(i);
                String namespaceImport = null;
                try {
                    namespaceImport = this.wsdlUtilities.getImportNamespace(n);
                }
                catch (Exception path) {
                    // empty catch block
                }
                String location2 = null;
                try {
                    location2 = this.wsdlUtilities.getImportLocation(n);
                }
                catch (Exception key) {
                    // empty catch block
                }
                if (namespaceImport != null) {
                    String path = targetNamespacesXSD.get(namespaceImport);
                    if (path == null) {
                        this.logger.debug("Schema non trovato per il namespace " + namespaceImport);
                        continue;
                    }
                    if (traduciImportIntoTypesImport) {
                        Element schemaElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "schema");
                        schemaElement.setPrefix("xsd");
                        schemaElement.setAttribute("targetNamespace", this.wsdlUtilities.getTargetNamespace(wsdl));
                        Element importElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "import");
                        importElement.setPrefix("xsd");
                        importElement.setAttribute("schemaLocation", path);
                        importElement.setAttribute("namespace", namespaceImport);
                        schemaElement.appendChild(importElement);
                        newSchemi.add(schemaElement);
                        continue;
                    }
                    this.wsdlUtilities.updateLocation(n, path);
                    this.logger.debug("Reimpostata location: " + path);
                    continue;
                }
                this.logger.debug("Import presente nel WSDL[" + file + "] [" + location2 + "] non possiede il target namespace");
            }
            if (traduciImportIntoTypesImport) {
                this.wsdlUtilities.removeImports(doc);
            }
            if (newSchemi.size() > 0) {
                Node types = this.wsdlUtilities.getIfExistsTypesElementIntoWSDL(doc);
                if (types == null) {
                    Node definition = this.wsdlUtilities.getIfExistsDefinitionsElementIntoWSDL(doc);
                    if (definition == null) {
                        this.logger.debug("Definition non esistente");
                    } else {
                        types = this.wsdlUtilities.addEmptyTypesIfNotExists(doc);
                        for (int i = 0; i < newSchemi.size(); ++i) {
                            this.wsdlUtilities.addSchemaIntoTypes(doc, (Node)newSchemi.get(i));
                        }
                    }
                } else {
                    for (int i = 0; i < newSchemi.size(); ++i) {
                        this.wsdlUtilities.addSchemaIntoTypes(doc, (Node)newSchemi.get(i));
                    }
                }
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            if (prettyDocument) {
                PrettyPrintXMLUtils.prettyPrintWithTrAX((Document)doc, (OutputStream)bout);
            } else {
                this.xmlUtils.writeTo(doc, (OutputStream)bout);
            }
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), (Throwable)e);
        }
    }

    private byte[] updateImportXSDLocation(byte[] xsd, HashMap<String, String> targetNamespacesXSD, boolean prettyDocument) throws WSDLException {
        try {
            if (!this.xmlUtils.isDocument(xsd)) {
                return null;
            }
            Document doc = this.xmlUtils.newDocument(xsd);
            List importsIntoXSD = this.xsdUtils.readImports(doc);
            for (int i = 0; i < importsIntoXSD.size(); ++i) {
                Node n = (Node)importsIntoXSD.get(i);
                String namespaceImport = null;
                try {
                    namespaceImport = this.xsdUtils.getImportNamespace(n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String location = null;
                try {
                    location = this.xsdUtils.getImportSchemaLocation(n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (namespaceImport != null && location != null) {
                    String path = targetNamespacesXSD.get(namespaceImport);
                    if (path == null) {
                        this.logger.debug("Schema non trovato per il namespace " + namespaceImport);
                        continue;
                    }
                    this.xsdUtils.updateSchemaLocation(n, path);
                    this.logger.debug("Reimpostata location: " + path);
                    continue;
                }
                this.logger.debug("Import presente nel XSD [" + location + "] non possiede il target namespace");
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            if (prettyDocument) {
                PrettyPrintXMLUtils.prettyPrintWithTrAX((Document)doc, (OutputStream)bout);
            } else {
                this.xmlUtils.writeTo(doc, (OutputStream)bout);
            }
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), (Throwable)e);
        }
    }

    private byte[] updateIncludeXSDLocation(byte[] xsd, HashMap<String, String> includePath, boolean prettyDocument) throws WSDLException {
        try {
            if (!this.xmlUtils.isDocument(xsd)) {
                return null;
            }
            Document doc = this.xmlUtils.newDocument(xsd);
            List includeIntoXSD = this.xsdUtils.readIncludes(doc);
            for (int i = 0; i < includeIntoXSD.size(); ++i) {
                Node n = (Node)includeIntoXSD.get(i);
                String location = null;
                try {
                    location = this.xsdUtils.getIncludeSchemaLocation(n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (location != null) {
                    Object key;
                    File locationF = new File(location);
                    String path = null;
                    if (locationF.getParentFile() != null) {
                        key = locationF.getParentFile().getName() + File.separatorChar + locationF.getName();
                        path = includePath.get(key);
                    }
                    if (path == null) {
                        key = locationF.getName();
                        path = includePath.get(key);
                    }
                    if (path == null) {
                        this.logger.debug("Schema non trovato per la location " + location);
                        continue;
                    }
                    this.xsdUtils.updateSchemaLocation(n, path);
                    this.logger.debug("Reimpostata location: " + path);
                    continue;
                }
                this.logger.debug("Include presente nel XSD [" + location + "] non possiede la location?");
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            if (prettyDocument) {
                PrettyPrintXMLUtils.prettyPrintWithTrAX((Document)doc, (OutputStream)bout);
            } else {
                this.xmlUtils.writeTo(doc, (OutputStream)bout);
            }
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new WSDLException(e.getMessage(), (Throwable)e);
        }
    }
}

