/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.statistiche.dao.jdbc;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.statistiche.StatisticaMensile;
import org.openspcoop2.core.statistiche.dao.IDBStatisticaMensileServiceSearch;
import org.openspcoop2.core.statistiche.dao.jdbc.JDBCLimitedServiceManager;
import org.openspcoop2.core.statistiche.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.statistiche.utils.ProjectInfo;
import org.openspcoop2.generic_project.beans.FunctionField;
import org.openspcoop2.generic_project.beans.IDMappingBehaviour;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.beans.InUse;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.beans.Union;
import org.openspcoop2.generic_project.beans.UnionExpression;
import org.openspcoop2.generic_project.dao.IDBServiceUtilities;
import org.openspcoop2.generic_project.dao.jdbc.IJDBCServiceSearchWithoutId;
import org.openspcoop2.generic_project.dao.jdbc.JDBCExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCPaginatedExpression;
import org.openspcoop2.generic_project.dao.jdbc.JDBCProperties;
import org.openspcoop2.generic_project.dao.jdbc.JDBCServiceManagerProperties;
import org.openspcoop2.generic_project.dao.jdbc.utils.IJDBCFetch;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBC_SQLObjectFactory;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.MultipleResultException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.exception.ValidationException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.impl.sql.ISQLFieldConverter;
import org.openspcoop2.generic_project.utils.XSDValidator;
import org.openspcoop2.utils.beans.BaseBean;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.xml.AbstractValidatoreXSD;
import org.slf4j.Logger;

public class JDBCStatisticaMensileServiceSearch
implements IDBStatisticaMensileServiceSearch,
IDBServiceUtilities<StatisticaMensile> {
    protected JDBCServiceManagerProperties jdbcProperties = null;
    protected JDBCServiceManager jdbcServiceManager = null;
    protected Logger log = null;
    protected IJDBCServiceSearchWithoutId<StatisticaMensile, JDBCServiceManager> serviceSearch = null;
    protected JDBC_SQLObjectFactory jdbcSqlObjectFactory = null;
    private static final String PARAMETER_TYPE_PREFIX = "Parameter (type:";

    public JDBCStatisticaMensileServiceSearch(JDBCServiceManager jdbcServiceManager) throws ServiceException {
        this.jdbcServiceManager = jdbcServiceManager;
        this.jdbcProperties = jdbcServiceManager.getJdbcProperties();
        this.log = jdbcServiceManager.getLog();
        String msgInit = JDBCStatisticaMensileServiceSearch.class.getName() + " initialized";
        this.log.debug(msgInit);
        this.serviceSearch = (IJDBCServiceSearchWithoutId)JDBCProperties.getInstance((Package)JDBCServiceManager.class.getPackage(), (IProjectInfo)ProjectInfo.getInstance()).getServiceSearch("statisticaMensile");
        this.serviceSearch.setServiceManager((Object)new JDBCLimitedServiceManager(this.jdbcServiceManager));
        this.jdbcSqlObjectFactory = new JDBC_SQLObjectFactory();
    }

    protected void logError(Exception e) {
        if (e != null && this.log != null) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void logDebug(Exception e) {
        if (e != null && this.log != null) {
            this.log.debug(e.getMessage(), (Throwable)e);
        }
    }

    protected void logJDBCExpression(JDBCExpression jdbcExpression) throws ExpressionException {
        if (this.log != null) {
            String msgDebug = "sql = " + jdbcExpression.toSql();
            this.log.debug(msgDebug);
        }
    }

    protected void logJDBCPaginatedExpression(JDBCPaginatedExpression jdbcPaginatedExpression) throws ExpressionException {
        if (this.log != null) {
            String msgDebug = "sql = " + jdbcPaginatedExpression.toSql();
            this.log.debug(msgDebug);
        }
    }

    private ServiceException newServiceExceptionParameterIdMappingResolutionBehaviourIsNull() {
        return new ServiceException(PARAMETER_TYPE_PREFIX + IDMappingBehaviour.class.getName() + ") 'idMappingResolutionBehaviour' is null");
    }

    protected ServiceException newServiceExceptionParameterExpressionWrongType(IExpression expression) {
        return new ServiceException(PARAMETER_TYPE_PREFIX + expression.getClass().getName() + ") 'expression' has wrong type, expect " + JDBCExpression.class.getName());
    }

    protected ServiceException newServiceExceptionParameterExpressionIsNull() {
        return new ServiceException(PARAMETER_TYPE_PREFIX + IExpression.class.getName() + ") 'expression' is null");
    }

    private ServiceException newServiceExceptionParameterPaginatedExpressionIsNull() {
        return new ServiceException(PARAMETER_TYPE_PREFIX + IPaginatedExpression.class.getName() + ") 'expression' is null");
    }

    private ServiceException newServiceExceptionParameterPaginatedExpressionIsNullErrorParameterPaginated() {
        return new ServiceException(PARAMETER_TYPE_PREFIX + IPaginatedExpression.class.getName() + ") 'paginatedExpression' is null");
    }

    private ServiceException newServiceExceptionParameterPaginatedExpressionWrongType(IPaginatedExpression expression) {
        return new ServiceException(PARAMETER_TYPE_PREFIX + expression.getClass().getName() + ") 'expression' has wrong type, expect " + JDBCPaginatedExpression.class.getName());
    }

    private ServiceException newServiceExceptionParameterPaginatedExpressionWrongTypeErrorParameterPaginated(IPaginatedExpression paginatedExpression) {
        return new ServiceException(PARAMETER_TYPE_PREFIX + paginatedExpression.getClass().getName() + ") 'paginatedExpression' has wrong type, expect " + JDBCPaginatedExpression.class.getName());
    }

    private ServiceException newServiceExceptionParameterUnionExpressionIsNull() {
        return new ServiceException(PARAMETER_TYPE_PREFIX + UnionExpression.class.getName() + ") 'unionExpression' is null");
    }

    private ServiceException newServiceExceptionParameterTableIdLessEqualsZero() {
        return new ServiceException("Parameter 'tableId' is less equals 0");
    }

    public void validate(StatisticaMensile statisticaMensile) throws ServiceException, ValidationException, NotImplementedException {
        XSDValidator.validate((BaseBean)statisticaMensile, (Logger)this.log, (AbstractValidatoreXSD)org.openspcoop2.core.statistiche.utils.XSDValidator.getXSDValidator(this.log));
    }

    public IJDBCFetch getFetch() {
        return this.serviceSearch.getFetch();
    }

    public ISQLFieldConverter getFieldConverter() {
        return this.serviceSearch.getFieldConverter();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<StatisticaMensile> findAll(IPaginatedExpression expression) throws ServiceException, NotImplementedException {
        List list;
        block8: {
            Connection connection = null;
            try {
                if (expression == null) {
                    throw this.newServiceExceptionParameterPaginatedExpressionIsNull();
                }
                if (!(expression instanceof JDBCPaginatedExpression)) {
                    throw this.newServiceExceptionParameterPaginatedExpressionWrongType(expression);
                }
                JDBCPaginatedExpression jdbcPaginatedExpression = (JDBCPaginatedExpression)expression;
                this.logJDBCPaginatedExpression(jdbcPaginatedExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                list = this.serviceSearch.findAll(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcPaginatedExpression, null);
                if (connection == null) break block8;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (Exception e2) {
                        this.logError(e2);
                        throw new ServiceException("FindAll not completed: " + e2.getMessage(), (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<StatisticaMensile> findAll(IPaginatedExpression expression, IDMappingBehaviour idMappingResolutionBehaviour) throws ServiceException, NotImplementedException {
        List list;
        block9: {
            Connection connection = null;
            try {
                if (idMappingResolutionBehaviour == null) {
                    throw this.newServiceExceptionParameterIdMappingResolutionBehaviourIsNull();
                }
                if (expression == null) {
                    throw this.newServiceExceptionParameterPaginatedExpressionIsNull();
                }
                if (!(expression instanceof JDBCPaginatedExpression)) {
                    throw this.newServiceExceptionParameterPaginatedExpressionWrongType(expression);
                }
                JDBCPaginatedExpression jdbcPaginatedExpression = (JDBCPaginatedExpression)expression;
                this.logJDBCPaginatedExpression(jdbcPaginatedExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                list = this.serviceSearch.findAll(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcPaginatedExpression, idMappingResolutionBehaviour);
                if (connection == null) break block9;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (Exception e2) {
                        this.logError(e2);
                        throw new ServiceException("FindAll not completed: " + e2.getMessage(), (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StatisticaMensile find(IExpression expression) throws ServiceException, NotFoundException, MultipleResultException, NotImplementedException {
        StatisticaMensile statisticaMensile;
        block9: {
            Connection connection = null;
            try {
                if (expression == null) {
                    throw this.newServiceExceptionParameterExpressionIsNull();
                }
                if (!(expression instanceof JDBCExpression)) {
                    throw this.newServiceExceptionParameterExpressionWrongType(expression);
                }
                JDBCExpression jdbcExpression = (JDBCExpression)expression;
                this.logJDBCExpression(jdbcExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                statisticaMensile = (StatisticaMensile)this.serviceSearch.find(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcExpression, null);
                if (connection == null) break block9;
            }
            catch (MultipleResultException | NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("Find not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return statisticaMensile;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StatisticaMensile find(IExpression expression, IDMappingBehaviour idMappingResolutionBehaviour) throws ServiceException, NotFoundException, MultipleResultException, NotImplementedException {
        StatisticaMensile statisticaMensile;
        block10: {
            Connection connection = null;
            try {
                if (idMappingResolutionBehaviour == null) {
                    throw this.newServiceExceptionParameterIdMappingResolutionBehaviourIsNull();
                }
                if (expression == null) {
                    throw this.newServiceExceptionParameterExpressionIsNull();
                }
                if (!(expression instanceof JDBCExpression)) {
                    throw this.newServiceExceptionParameterExpressionWrongType(expression);
                }
                JDBCExpression jdbcExpression = (JDBCExpression)expression;
                this.logJDBCExpression(jdbcExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                statisticaMensile = (StatisticaMensile)this.serviceSearch.find(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcExpression, idMappingResolutionBehaviour);
                if (connection == null) break block10;
            }
            catch (MultipleResultException | NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("Find not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return statisticaMensile;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NonNegativeNumber count(IExpression expression) throws ServiceException, NotImplementedException {
        NonNegativeNumber nonNegativeNumber;
        block8: {
            Connection connection = null;
            try {
                if (expression == null) {
                    throw this.newServiceExceptionParameterExpressionIsNull();
                }
                if (!(expression instanceof JDBCExpression)) {
                    throw this.newServiceExceptionParameterExpressionWrongType(expression);
                }
                JDBCExpression jdbcExpression = (JDBCExpression)expression;
                this.logJDBCExpression(jdbcExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                nonNegativeNumber = this.serviceSearch.count(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcExpression);
                if (connection == null) break block8;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (Exception e2) {
                        this.logError(e2);
                        throw new ServiceException("Count not completed: " + e2.getMessage(), (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return nonNegativeNumber;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Object> select(IPaginatedExpression paginatedExpression, IField field) throws ServiceException, NotFoundException, NotImplementedException {
        List list;
        block9: {
            Connection connection = null;
            try {
                if (paginatedExpression == null) {
                    throw this.newServiceExceptionParameterPaginatedExpressionIsNullErrorParameterPaginated();
                }
                if (!(paginatedExpression instanceof JDBCPaginatedExpression)) {
                    throw this.newServiceExceptionParameterPaginatedExpressionWrongTypeErrorParameterPaginated(paginatedExpression);
                }
                JDBCPaginatedExpression jdbcPaginatedExpression = (JDBCPaginatedExpression)paginatedExpression;
                this.logJDBCPaginatedExpression(jdbcPaginatedExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                list = this.serviceSearch.select(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcPaginatedExpression, field);
                if (connection == null) break block9;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("Select 'field' not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Object> select(IPaginatedExpression paginatedExpression, boolean distinct, IField field) throws ServiceException, NotFoundException, NotImplementedException {
        List list;
        block9: {
            Connection connection = null;
            try {
                if (paginatedExpression == null) {
                    throw this.newServiceExceptionParameterPaginatedExpressionIsNullErrorParameterPaginated();
                }
                if (!(paginatedExpression instanceof JDBCPaginatedExpression)) {
                    throw this.newServiceExceptionParameterPaginatedExpressionWrongTypeErrorParameterPaginated(paginatedExpression);
                }
                JDBCPaginatedExpression jdbcPaginatedExpression = (JDBCPaginatedExpression)paginatedExpression;
                this.logJDBCPaginatedExpression(jdbcPaginatedExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                list = this.serviceSearch.select(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcPaginatedExpression, distinct, field);
                if (connection == null) break block9;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("Select 'distinct:" + distinct + "' field not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Map<String, Object>> select(IPaginatedExpression paginatedExpression, IField ... field) throws ServiceException, NotFoundException, NotImplementedException {
        List list;
        block9: {
            Connection connection = null;
            try {
                if (paginatedExpression == null) {
                    throw this.newServiceExceptionParameterPaginatedExpressionIsNullErrorParameterPaginated();
                }
                if (!(paginatedExpression instanceof JDBCPaginatedExpression)) {
                    throw this.newServiceExceptionParameterPaginatedExpressionWrongTypeErrorParameterPaginated(paginatedExpression);
                }
                JDBCPaginatedExpression jdbcPaginatedExpression = (JDBCPaginatedExpression)paginatedExpression;
                this.logJDBCPaginatedExpression(jdbcPaginatedExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                list = this.serviceSearch.select(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcPaginatedExpression, field);
                if (connection == null) break block9;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("Select not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Map<String, Object>> select(IPaginatedExpression paginatedExpression, boolean distinct, IField ... field) throws ServiceException, NotFoundException, NotImplementedException {
        List list;
        block9: {
            Connection connection = null;
            try {
                if (paginatedExpression == null) {
                    throw this.newServiceExceptionParameterPaginatedExpressionIsNullErrorParameterPaginated();
                }
                if (!(paginatedExpression instanceof JDBCPaginatedExpression)) {
                    throw this.newServiceExceptionParameterPaginatedExpressionWrongTypeErrorParameterPaginated(paginatedExpression);
                }
                JDBCPaginatedExpression jdbcPaginatedExpression = (JDBCPaginatedExpression)paginatedExpression;
                this.logJDBCPaginatedExpression(jdbcPaginatedExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                list = this.serviceSearch.select(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcPaginatedExpression, distinct, field);
                if (connection == null) break block9;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("Select distinct:" + distinct + " not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object aggregate(IExpression expression, FunctionField functionField) throws ServiceException, NotFoundException, NotImplementedException {
        Object object;
        block9: {
            Connection connection = null;
            try {
                if (expression == null) {
                    throw this.newServiceExceptionParameterExpressionIsNull();
                }
                if (!(expression instanceof JDBCExpression)) {
                    throw this.newServiceExceptionParameterExpressionWrongType(expression);
                }
                JDBCExpression jdbcExpression = (JDBCExpression)expression;
                this.logJDBCExpression(jdbcExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                object = this.serviceSearch.aggregate(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcExpression, functionField);
                if (connection == null) break block9;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("Aggregate not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return object;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> aggregate(IExpression expression, FunctionField ... functionField) throws ServiceException, NotFoundException, NotImplementedException {
        Map map;
        block9: {
            Connection connection = null;
            try {
                if (expression == null) {
                    throw this.newServiceExceptionParameterExpressionIsNull();
                }
                if (!(expression instanceof JDBCExpression)) {
                    throw this.newServiceExceptionParameterExpressionWrongType(expression);
                }
                JDBCExpression jdbcExpression = (JDBCExpression)expression;
                this.logJDBCExpression(jdbcExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                map = this.serviceSearch.aggregate(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcExpression, functionField);
                if (connection == null) break block9;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("Aggregate not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return map;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Map<String, Object>> groupBy(IExpression expression, FunctionField ... functionField) throws ServiceException, NotFoundException, NotImplementedException {
        List list;
        block9: {
            Connection connection = null;
            try {
                if (expression == null) {
                    throw this.newServiceExceptionParameterExpressionIsNull();
                }
                if (!(expression instanceof JDBCExpression)) {
                    throw this.newServiceExceptionParameterExpressionWrongType(expression);
                }
                JDBCExpression jdbcExpression = (JDBCExpression)expression;
                this.logJDBCExpression(jdbcExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                list = this.serviceSearch.groupBy(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcExpression, functionField);
                if (connection == null) break block9;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("GroupBy not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Map<String, Object>> groupBy(IPaginatedExpression paginatedExpression, FunctionField ... functionField) throws ServiceException, NotFoundException, NotImplementedException {
        List list;
        block9: {
            Connection connection = null;
            try {
                if (paginatedExpression == null) {
                    throw this.newServiceExceptionParameterPaginatedExpressionIsNullErrorParameterPaginated();
                }
                if (!(paginatedExpression instanceof JDBCPaginatedExpression)) {
                    throw this.newServiceExceptionParameterPaginatedExpressionWrongTypeErrorParameterPaginated(paginatedExpression);
                }
                JDBCPaginatedExpression jdbcPaginatedExpression = (JDBCPaginatedExpression)paginatedExpression;
                this.logJDBCPaginatedExpression(jdbcPaginatedExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                list = this.serviceSearch.groupBy(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcPaginatedExpression, functionField);
                if (connection == null) break block9;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("GroupBy not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Map<String, Object>> union(Union union, UnionExpression ... unionExpression) throws ServiceException, NotFoundException, NotImplementedException {
        List list;
        block8: {
            Connection connection = null;
            try {
                if (unionExpression == null) {
                    throw this.newServiceExceptionParameterUnionExpressionIsNull();
                }
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                list = this.serviceSearch.union(this.jdbcProperties, this.log, connection, sqlQueryObject, union, unionExpression);
                if (connection == null) break block8;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("Union not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NonNegativeNumber unionCount(Union union, UnionExpression ... unionExpression) throws ServiceException, NotFoundException, NotImplementedException {
        NonNegativeNumber nonNegativeNumber;
        block8: {
            Connection connection = null;
            try {
                if (unionExpression == null) {
                    throw this.newServiceExceptionParameterUnionExpressionIsNull();
                }
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                nonNegativeNumber = this.serviceSearch.unionCount(this.jdbcProperties, this.log, connection, sqlQueryObject, union, unionExpression);
                if (connection == null) break block8;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("UnionCount not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return nonNegativeNumber;
    }

    public IExpression newExpression() throws ServiceException, NotImplementedException {
        return this.serviceSearch.newExpression(this.log);
    }

    public IPaginatedExpression newPaginatedExpression() throws ServiceException, NotImplementedException {
        return this.serviceSearch.newPaginatedExpression(this.log);
    }

    public IExpression toExpression(IPaginatedExpression paginatedExpression) throws ServiceException, NotImplementedException {
        return this.serviceSearch.toExpression((JDBCPaginatedExpression)paginatedExpression, this.log);
    }

    public IPaginatedExpression toPaginatedExpression(IExpression expression) throws ServiceException, NotImplementedException {
        return this.serviceSearch.toPaginatedExpression((JDBCExpression)expression, this.log);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StatisticaMensile get(long tableId) throws ServiceException, NotFoundException, MultipleResultException, NotImplementedException {
        StatisticaMensile statisticaMensile;
        block8: {
            Connection connection = null;
            try {
                if (tableId <= 0L) {
                    throw this.newServiceExceptionParameterTableIdLessEqualsZero();
                }
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                statisticaMensile = (StatisticaMensile)this.serviceSearch.get(this.jdbcProperties, this.log, connection, sqlQueryObject, tableId, null);
                if (connection == null) break block8;
            }
            catch (MultipleResultException | NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("Get(tableId) not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return statisticaMensile;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StatisticaMensile get(long tableId, IDMappingBehaviour idMappingResolutionBehaviour) throws ServiceException, NotFoundException, MultipleResultException, NotImplementedException {
        StatisticaMensile statisticaMensile;
        block9: {
            Connection connection = null;
            try {
                if (tableId <= 0L) {
                    throw this.newServiceExceptionParameterTableIdLessEqualsZero();
                }
                if (idMappingResolutionBehaviour == null) {
                    throw this.newServiceExceptionParameterIdMappingResolutionBehaviourIsNull();
                }
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                statisticaMensile = (StatisticaMensile)this.serviceSearch.get(this.jdbcProperties, this.log, connection, sqlQueryObject, tableId, idMappingResolutionBehaviour);
                if (connection == null) break block9;
            }
            catch (MultipleResultException | NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("Get(tableId,idMappingResolutionBehaviour) not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return statisticaMensile;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exists(long tableId) throws MultipleResultException, ServiceException, NotImplementedException {
        boolean bl;
        block7: {
            Connection connection = null;
            try {
                if (tableId <= 0L) {
                    throw this.newServiceExceptionParameterTableIdLessEqualsZero();
                }
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                bl = this.serviceSearch.exists(this.jdbcProperties, this.log, connection, sqlQueryObject, tableId);
                if (connection == null) break block7;
            }
            catch (MultipleResultException | NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (Exception e2) {
                        this.logError(e2);
                        throw new ServiceException("Exists(tableId) not completed: " + e2.getMessage(), (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Long> findAllTableIds(IPaginatedExpression expression) throws ServiceException, NotImplementedException {
        List list;
        block8: {
            Connection connection = null;
            try {
                if (expression == null) {
                    throw this.newServiceExceptionParameterPaginatedExpressionIsNull();
                }
                if (!(expression instanceof JDBCPaginatedExpression)) {
                    throw this.newServiceExceptionParameterPaginatedExpressionWrongType(expression);
                }
                JDBCPaginatedExpression jdbcPaginatedExpression = (JDBCPaginatedExpression)expression;
                this.logJDBCPaginatedExpression(jdbcPaginatedExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                list = this.serviceSearch.findAllTableIds(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcPaginatedExpression);
                if (connection == null) break block8;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (Exception e2) {
                        this.logError(e2);
                        throw new ServiceException("findAllTableIds not completed: " + e2.getMessage(), (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long findTableId(IExpression expression) throws ServiceException, NotFoundException, MultipleResultException, NotImplementedException {
        long l;
        block9: {
            Connection connection = null;
            try {
                if (expression == null) {
                    throw this.newServiceExceptionParameterPaginatedExpressionIsNull();
                }
                if (!(expression instanceof JDBCExpression)) {
                    throw this.newServiceExceptionParameterExpressionWrongType(expression);
                }
                JDBCExpression jdbcExpression = (JDBCExpression)expression;
                this.logJDBCExpression(jdbcExpression);
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                l = this.serviceSearch.findTableId(this.jdbcProperties, this.log, connection, sqlQueryObject, jdbcExpression);
                if (connection == null) break block9;
            }
            catch (MultipleResultException | NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("findTableId not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return l;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InUse inUse(long tableId) throws ServiceException, NotFoundException, NotImplementedException {
        InUse inUse;
        block8: {
            Connection connection = null;
            try {
                if (tableId <= 0L) {
                    throw this.newServiceExceptionParameterTableIdLessEqualsZero();
                }
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                inUse = this.serviceSearch.inUse(this.jdbcProperties, this.log, connection, sqlQueryObject, tableId);
                if (connection == null) break block8;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("InUse(tableId) not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return inUse;
    }

    public void disableSelectForUpdate() throws ServiceException, NotImplementedException {
        this.jdbcSqlObjectFactory.setSelectForUpdate(false);
    }

    public void enableSelectForUpdate() throws ServiceException, NotImplementedException {
        this.jdbcSqlObjectFactory.setSelectForUpdate(true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<List<Object>> nativeQuery(String sql, List<Class<?>> returnClassTypes, Object ... param) throws ServiceException, NotFoundException, NotImplementedException {
        List list;
        block8: {
            Connection connection = null;
            try {
                if (returnClassTypes == null || returnClassTypes.isEmpty()) {
                    throw new ServiceException("Parameter 'returnClassTypes' is less equals 0");
                }
                ISQLQueryObject sqlQueryObject = this.jdbcSqlObjectFactory.createSQLQueryObject(this.jdbcProperties.getDatabase());
                sqlQueryObject.setANDLogicOperator(true);
                connection = this.jdbcServiceManager.getConnection();
                list = this.serviceSearch.nativeQuery(this.jdbcProperties, this.log, connection, sqlQueryObject, sql, returnClassTypes, param);
                if (connection == null) break block8;
            }
            catch (NotImplementedException | ServiceException e) {
                try {
                    this.logError((Exception)e);
                    throw e;
                    catch (NotFoundException e2) {
                        this.logDebug((Exception)((Object)e2));
                        throw e2;
                    }
                    catch (Exception e3) {
                        this.logError(e3);
                        throw new ServiceException("nativeQuery not completed: " + e3.getMessage(), (Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        this.jdbcServiceManager.closeConnection(connection);
                    }
                    throw throwable;
                }
            }
            this.jdbcServiceManager.closeConnection(connection);
        }
        return list;
    }
}

