/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.transazioni.constants;

import java.io.Serializable;
import org.openspcoop2.generic_project.beans.IEnumeration;

public enum RuoloTransazione implements IEnumeration,
Serializable
{
    INVOCAZIONE_ONEWAY("1"),
    INVOCAZIONE_SINCRONA("2"),
    INVOCAZIONE_ASINCRONA_SIMMETRICA("3"),
    RISPOSTA_ASINCRONA_SIMMETRICA("4"),
    INVOCAZIONE_ASINCRONA_ASIMMETRICA("5"),
    RICHIESTA_STATO_ASINCRONA_ASIMMETRICA("6"),
    INTEGRATION_MANAGER("7"),
    CONSEGNA_CONTENUTI_APPLICATIVI("8");

    private final String valore;

    private RuoloTransazione(String valore) {
        this.valore = valore;
    }

    public String getValore() {
        return this.valore;
    }

    public int getValoreAsInt() {
        return Integer.parseInt(this.valore);
    }

    public static String[] toStringArray() {
        String[] res = new String[RuoloTransazione.values().length];
        int i = 0;
        for (RuoloTransazione tmp : RuoloTransazione.values()) {
            res[i] = tmp.getValore();
            ++i;
        }
        return res;
    }

    public static int[] toIntArray() {
        int[] res = new int[RuoloTransazione.values().length];
        int i = 0;
        for (RuoloTransazione tmp : RuoloTransazione.values()) {
            res[i] = tmp.getValoreAsInt();
            ++i;
        }
        return res;
    }

    public static String[] toEnumNameArray() {
        String[] res = new String[RuoloTransazione.values().length];
        int i = 0;
        for (RuoloTransazione tmp : RuoloTransazione.values()) {
            res[i] = tmp.name();
            ++i;
        }
        return res;
    }

    public static RuoloTransazione toEnumConstant(int val) {
        return RuoloTransazione.toEnumConstant("" + val);
    }

    public static RuoloTransazione toEnumConstant(String val) {
        RuoloTransazione res = null;
        if (INVOCAZIONE_ONEWAY.toString().equals(val)) {
            res = INVOCAZIONE_ONEWAY;
        } else if (INVOCAZIONE_SINCRONA.toString().equals(val)) {
            res = INVOCAZIONE_SINCRONA;
        } else if (INVOCAZIONE_ASINCRONA_SIMMETRICA.toString().equals(val)) {
            res = INVOCAZIONE_ASINCRONA_SIMMETRICA;
        } else if (RISPOSTA_ASINCRONA_SIMMETRICA.toString().equals(val)) {
            res = RISPOSTA_ASINCRONA_SIMMETRICA;
        } else if (INVOCAZIONE_ASINCRONA_ASIMMETRICA.toString().equals(val)) {
            res = INVOCAZIONE_ASINCRONA_ASIMMETRICA;
        } else if (RICHIESTA_STATO_ASINCRONA_ASIMMETRICA.toString().equals(val)) {
            res = RICHIESTA_STATO_ASINCRONA_ASIMMETRICA;
        } else if (INTEGRATION_MANAGER.toString().equals(val)) {
            res = INTEGRATION_MANAGER;
        } else if (CONSEGNA_CONTENUTI_APPLICATIVI.toString().equals(val)) {
            res = CONSEGNA_CONTENUTI_APPLICATIVI;
        }
        return res;
    }

    public Object getValue() {
        return this.valore;
    }

    public String toString() {
        return this.valore;
    }

    public boolean equals(IEnumeration esito) {
        return this.toString().equals(esito.toString());
    }

    public static RuoloTransazione getEnumConstantFromOpenSPCoopValue(String val) {
        if ("OneWay_InvocazioneServizio".equals(val)) {
            return INVOCAZIONE_ONEWAY;
        }
        if ("Sincrono_InvocazioneServizio".equals(val)) {
            return INVOCAZIONE_SINCRONA;
        }
        if ("AsincronoSimmetrico_InvocazioneServizio".equals(val)) {
            return INVOCAZIONE_ASINCRONA_SIMMETRICA;
        }
        if ("AsincronoSimmetrico_ConsegnaRisposta".equals(val)) {
            return RISPOSTA_ASINCRONA_SIMMETRICA;
        }
        if ("AsincronoAsimmetrico_InvocazioneServizio".equals(val)) {
            return INVOCAZIONE_ASINCRONA_ASIMMETRICA;
        }
        if ("AsincronoAsimmetrico_Polling".equals(val)) {
            return RICHIESTA_STATO_ASINCRONA_ASIMMETRICA;
        }
        if ("ConsegnaContenutiApplicativi".equals(val)) {
            return CONSEGNA_CONTENUTI_APPLICATIVI;
        }
        return null;
    }
}

