/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.transazioni.utils;

import java.io.Serializable;
import java.util.Date;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.transazioni.utils.TempiElaborazione;
import org.openspcoop2.core.transazioni.utils.TempiElaborazioneFunzionalita;
import org.openspcoop2.utils.date.DateTimeFormatterWrapper;
import org.openspcoop2.utils.date.DateUtils;

public class TempiElaborazioneUtils
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String format = "yyyyMMddHHmmssSSS";
    private static final String FUNZIONALITA_SEPARATOR = "-";
    private static final String FUNZIONALITA_DATE_UNDEFINED = "0";
    private static final String TEMPI_SEPARATOR = " ";

    private static String _convertToDBValue(TempiElaborazioneFunzionalita tempiElaborazioneFunzionalita) {
        DateTimeFormatterWrapper dateformat = DateUtils.getDefaultDateTimeFormatter((String)format);
        StringBuilder bf = new StringBuilder("");
        if (tempiElaborazioneFunzionalita != null && tempiElaborazioneFunzionalita.dataIngresso != null) {
            bf.append(dateformat.format(tempiElaborazioneFunzionalita.dataIngresso));
        } else {
            bf.append(FUNZIONALITA_DATE_UNDEFINED);
        }
        bf.append(FUNZIONALITA_SEPARATOR);
        if (tempiElaborazioneFunzionalita != null && tempiElaborazioneFunzionalita.dataUscita != null) {
            bf.append(dateformat.format(tempiElaborazioneFunzionalita.dataUscita));
        } else {
            bf.append(FUNZIONALITA_DATE_UNDEFINED);
        }
        return bf.toString();
    }

    public static String convertToDBValue(TempiElaborazione tempiElaborazione) {
        StringBuilder bf = new StringBuilder();
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.token)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.autenticazione)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.autenticazioneToken)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.autorizzazione)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.autorizzazioneContenuti)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.validazioneRichiesta)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.validazioneRisposta)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.controlloTraffico_maxRequests)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.controlloTraffico_rateLimiting)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.sicurezzaMessaggioRichiesta)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.sicurezzaMessaggioRisposta)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.gestioneAttachmentsRichiesta)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.gestioneAttachmentsRisposta)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.correlazioneApplicativaRichiesta)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.correlazioneApplicativaRisposta)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.tracciamentoRichiesta)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.tracciamentoRisposta)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.dumpRichiestaIngresso)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.dumpRichiestaUscita)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.dumpRispostaIngresso)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.dumpRispostaUscita)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.dumpBinarioRichiestaIngresso)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.dumpBinarioRichiestaUscita)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.dumpBinarioRispostaIngresso)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.dumpBinarioRispostaUscita)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.dumpIntegrationManager)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.responseCachingCalcoloDigest)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.responseCachingReadFromCache)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.responseCachingSaveInCache)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.trasformazioneRichiesta)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.trasformazioneRisposta)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.attributeAuthority)).append(TEMPI_SEPARATOR);
        bf.append(TempiElaborazioneUtils._convertToDBValue(tempiElaborazione.autenticazioneApplicativoToken)).append(TEMPI_SEPARATOR);
        return bf.toString();
    }

    private static TempiElaborazioneFunzionalita _convertFromDBValue(String dbValue) throws CoreException {
        if (dbValue == null || "".equals(dbValue)) {
            return null;
        }
        DateTimeFormatterWrapper dateformat = DateUtils.getDefaultDateTimeFormatter((String)format);
        String[] date = dbValue.split(FUNZIONALITA_SEPARATOR);
        if (date == null || date.length != 2) {
            return null;
        }
        String dataInizio = date[0];
        String dataFine = date[1];
        TempiElaborazioneFunzionalita tempi = null;
        try {
            Date d;
            if (!FUNZIONALITA_DATE_UNDEFINED.equals(dataInizio)) {
                d = dateformat.parse(dataInizio);
                if (tempi == null) {
                    tempi = new TempiElaborazioneFunzionalita();
                }
                tempi.setDataIngresso(d);
            }
            if (!FUNZIONALITA_DATE_UNDEFINED.equals(dataFine)) {
                d = dateformat.parse(dataFine);
                if (tempi == null) {
                    tempi = new TempiElaborazioneFunzionalita();
                }
                tempi.setDataUscita(d);
            }
        }
        catch (Exception e) {
            throw new CoreException(e.getMessage(), e);
        }
        return tempi;
    }

    public static TempiElaborazione convertFromDBValue(String dbValue) throws CoreException {
        if (dbValue == null || "".equals(dbValue)) {
            return null;
        }
        String[] tempi = dbValue.split(TEMPI_SEPARATOR);
        if (tempi == null || tempi.length <= 0) {
            return null;
        }
        TempiElaborazione tempiElaborazione = null;
        for (int i = 0; i < tempi.length; ++i) {
            String tempo = tempi[i];
            TempiElaborazioneFunzionalita funzionalita = TempiElaborazioneUtils._convertFromDBValue(tempo);
            if (funzionalita == null) continue;
            if (funzionalita != null && tempiElaborazione == null) {
                tempiElaborazione = new TempiElaborazione();
            }
            if (i == 0) {
                tempiElaborazione.token = funzionalita;
                continue;
            }
            if (i == 1) {
                tempiElaborazione.autenticazione = funzionalita;
                continue;
            }
            if (i == 2) {
                tempiElaborazione.autenticazioneToken = funzionalita;
                continue;
            }
            if (i == 3) {
                tempiElaborazione.autorizzazione = funzionalita;
                continue;
            }
            if (i == 4) {
                tempiElaborazione.autorizzazioneContenuti = funzionalita;
                continue;
            }
            if (i == 5) {
                tempiElaborazione.validazioneRichiesta = funzionalita;
                continue;
            }
            if (i == 6) {
                tempiElaborazione.validazioneRisposta = funzionalita;
                continue;
            }
            if (i == 7) {
                tempiElaborazione.controlloTraffico_maxRequests = funzionalita;
                continue;
            }
            if (i == 8) {
                tempiElaborazione.controlloTraffico_rateLimiting = funzionalita;
                continue;
            }
            if (i == 9) {
                tempiElaborazione.sicurezzaMessaggioRichiesta = funzionalita;
                continue;
            }
            if (i == 10) {
                tempiElaborazione.sicurezzaMessaggioRisposta = funzionalita;
                continue;
            }
            if (i == 11) {
                tempiElaborazione.gestioneAttachmentsRichiesta = funzionalita;
                continue;
            }
            if (i == 12) {
                tempiElaborazione.gestioneAttachmentsRisposta = funzionalita;
                continue;
            }
            if (i == 13) {
                tempiElaborazione.correlazioneApplicativaRichiesta = funzionalita;
                continue;
            }
            if (i == 14) {
                tempiElaborazione.correlazioneApplicativaRisposta = funzionalita;
                continue;
            }
            if (i == 15) {
                tempiElaborazione.tracciamentoRichiesta = funzionalita;
                continue;
            }
            if (i == 16) {
                tempiElaborazione.tracciamentoRisposta = funzionalita;
                continue;
            }
            if (i == 17) {
                tempiElaborazione.dumpRichiestaIngresso = funzionalita;
                continue;
            }
            if (i == 18) {
                tempiElaborazione.dumpRichiestaUscita = funzionalita;
                continue;
            }
            if (i == 19) {
                tempiElaborazione.dumpRispostaIngresso = funzionalita;
                continue;
            }
            if (i == 20) {
                tempiElaborazione.dumpRispostaUscita = funzionalita;
                continue;
            }
            if (i == 21) {
                tempiElaborazione.dumpBinarioRichiestaIngresso = funzionalita;
                continue;
            }
            if (i == 22) {
                tempiElaborazione.dumpBinarioRichiestaUscita = funzionalita;
                continue;
            }
            if (i == 23) {
                tempiElaborazione.dumpBinarioRispostaIngresso = funzionalita;
                continue;
            }
            if (i == 24) {
                tempiElaborazione.dumpBinarioRispostaUscita = funzionalita;
                continue;
            }
            if (i == 25) {
                tempiElaborazione.dumpIntegrationManager = funzionalita;
                continue;
            }
            if (i == 26) {
                tempiElaborazione.responseCachingCalcoloDigest = funzionalita;
                continue;
            }
            if (i == 27) {
                tempiElaborazione.responseCachingReadFromCache = funzionalita;
                continue;
            }
            if (i == 28) {
                tempiElaborazione.responseCachingSaveInCache = funzionalita;
                continue;
            }
            if (i == 29) {
                tempiElaborazione.trasformazioneRichiesta = funzionalita;
                continue;
            }
            if (i == 30) {
                tempiElaborazione.trasformazioneRisposta = funzionalita;
                continue;
            }
            if (i == 31) {
                tempiElaborazione.attributeAuthority = funzionalita;
                continue;
            }
            if (i != 32) continue;
            tempiElaborazione.autenticazioneApplicativoToken = funzionalita;
        }
        return tempiElaborazione;
    }
}

