/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.transazioni.utils.credenziali;

import org.openspcoop2.core.transazioni.CredenzialeMittente;
import org.openspcoop2.core.transazioni.dao.ICredenzialeMittenteService;
import org.openspcoop2.core.transazioni.utils.TipoCredenzialeMittente;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.LikeMode;
import org.openspcoop2.utils.UtilsException;

public abstract class AbstractSearchCredenziale {
    protected TipoCredenzialeMittente tipo;
    protected boolean convertToDBValue = true;

    protected AbstractSearchCredenziale(TipoCredenzialeMittente tipo) {
        this.tipo = tipo;
    }

    public void disableConvertToDBValue() {
        this.convertToDBValue = false;
    }

    public String getTipo() {
        return this.tipo.getRawValue();
    }

    public TipoCredenzialeMittente getTipoCredenzialeMittente() {
        return this.tipo;
    }

    protected abstract String getExactValueDatabase(String var1, boolean var2) throws UtilsException;

    public IPaginatedExpression createExpression(ICredenzialeMittenteService credenzialeMittentiService, String credentialParam, boolean ricercaEsatta, boolean caseSensitive) throws UtilsException {
        try {
            IPaginatedExpression pagExpression = credenzialeMittentiService.newPaginatedExpression();
            pagExpression.and();
            String credential = this.convertToDBValue ? this.getExactValueDatabase(credentialParam, ricercaEsatta) : credentialParam;
            pagExpression.equals(CredenzialeMittente.model().TIPO, (Object)this.tipo.getRawValue());
            this.setLikeCondition(pagExpression, ricercaEsatta, caseSensitive, credential, credentialParam);
            return pagExpression;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    private void setLikeCondition(IPaginatedExpression pagExpression, boolean ricercaEsatta, boolean caseSensitive, String credential, String credentialParam) throws ExpressionNotImplementedException, ExpressionException {
        if (ricercaEsatta) {
            if (caseSensitive) {
                if (this.convertToDBValue) {
                    pagExpression.like(CredenzialeMittente.model().CREDENZIALE, credential, LikeMode.ANYWHERE);
                } else {
                    pagExpression.equals(CredenzialeMittente.model().CREDENZIALE, (Object)credential);
                }
            } else if (this.convertToDBValue) {
                pagExpression.ilike(CredenzialeMittente.model().CREDENZIALE, credential, LikeMode.ANYWHERE);
            } else {
                pagExpression.ilike(CredenzialeMittente.model().CREDENZIALE, credential, LikeMode.EXACT);
            }
        } else if (!caseSensitive) {
            pagExpression.ilike(CredenzialeMittente.model().CREDENZIALE, credentialParam, LikeMode.ANYWHERE);
        } else {
            pagExpression.like(CredenzialeMittente.model().CREDENZIALE, credentialParam, LikeMode.ANYWHERE);
        }
    }
}

