/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.transazioni.utils.credenziali;

import org.openspcoop2.core.transazioni.utils.TipoCredenzialeMittente;
import org.openspcoop2.core.transazioni.utils.credenziali.AbstractCredenziale;
import org.openspcoop2.utils.UtilsException;

public class CredenzialeClientAddress
extends AbstractCredenziale {
    private String socketAddress;
    private String transportAddress;
    private static final String PREFIX_SOCKET = "#S#";
    private static final String PREFIX_TRANSPORT = "#T#";

    public CredenzialeClientAddress(String socketAddress, String transportAddress) {
        super(TipoCredenzialeMittente.CLIENT_ADDRESS);
        this.socketAddress = socketAddress;
        this.transportAddress = transportAddress;
    }

    @Override
    public String getCredenziale() throws UtilsException {
        boolean transportAddressDefined;
        boolean socketAddressDefined = this.socketAddress != null && !"".equals(this.socketAddress);
        boolean bl = transportAddressDefined = this.transportAddress != null && !"".equals(this.transportAddress);
        if (socketAddressDefined && transportAddressDefined) {
            return CredenzialeClientAddress.getSocketAddressDBValue(this.socketAddress) + " " + CredenzialeClientAddress.getTransportAddressDBValue(this.transportAddress);
        }
        if (socketAddressDefined) {
            return CredenzialeClientAddress.getSocketAddressDBValue(this.socketAddress);
        }
        return CredenzialeClientAddress.getTransportAddressDBValue(this.transportAddress);
    }

    public static String getSocketAddressDBValue(String address) {
        return CredenzialeClientAddress.getSocketAddressDBValue(address, true);
    }

    public static String getSocketAddressDBValue(String address, boolean ricercaEsatta) {
        if (ricercaEsatta) {
            return PREFIX_SOCKET + address + PREFIX_SOCKET;
        }
        return "#S#%" + address + "%#S#";
    }

    public static String getTransportAddressDBValue(String address) {
        return CredenzialeClientAddress.getTransportAddressDBValue(address, true);
    }

    public static String getTransportAddressDBValue(String address, boolean ricercaEsatta) {
        if (ricercaEsatta) {
            return PREFIX_TRANSPORT + address + PREFIX_TRANSPORT;
        }
        return "#T#%" + address + "%#T#";
    }

    public static boolean isSocketAddressDBValue(String address) {
        return address.contains(PREFIX_SOCKET);
    }

    public static boolean isTransportAddressDBValue(String address) {
        return address.contains(PREFIX_TRANSPORT);
    }

    public static String convertSocketDBValueToOriginal(String address) {
        if (CredenzialeClientAddress.isSocketAddressDBValue(address)) {
            address = address.trim();
            String[] tmp = address.split(PREFIX_SOCKET);
            for (int i = 0; i < tmp.length; ++i) {
                String s = tmp[i];
                if (s == null || "".equals(s = s.trim()) || CredenzialeClientAddress.isTransportAddressDBValue(s)) continue;
                return s;
            }
        }
        return null;
    }

    public static String convertTransportDBValueToOriginal(String address) {
        if (CredenzialeClientAddress.isTransportAddressDBValue(address)) {
            address = address.trim();
            String[] tmp = address.split(PREFIX_TRANSPORT);
            for (int i = 0; i < tmp.length; ++i) {
                String s = tmp[i];
                if (s == null || "".equals(s = s.trim()) || CredenzialeClientAddress.isSocketAddressDBValue(s)) continue;
                return s;
            }
        }
        return null;
    }

    @Override
    public void updateCredenziale(String newCredential) throws UtilsException {
        throw new UtilsException("Aggiornamento non supportato dal tipo di credenziale");
    }
}

