/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.transazioni.utils.credenziali;

import org.openspcoop2.core.transazioni.CredenzialeMittente;
import org.openspcoop2.core.transazioni.dao.ICredenzialeMittenteService;
import org.openspcoop2.core.transazioni.utils.TipoCredenzialeMittente;
import org.openspcoop2.core.transazioni.utils.credenziali.AbstractSearchCredenziale;
import org.openspcoop2.core.transazioni.utils.credenziali.CredenzialeTokenClient;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.LikeMode;
import org.openspcoop2.utils.UtilsException;

public class CredenzialeSearchTokenClient
extends AbstractSearchCredenziale {
    private boolean clientId;
    private boolean application;
    private boolean andOperator;

    public CredenzialeSearchTokenClient(boolean clientId, boolean application, boolean and) {
        super(TipoCredenzialeMittente.TOKEN_CLIENT_ID);
        this.clientId = clientId;
        this.application = application;
        this.andOperator = and;
    }

    @Override
    protected String getExactValueDatabase(String credentialParam, boolean ricercaEsatta) throws UtilsException {
        throw new UtilsException("Not Implemented");
    }

    @Override
    public IPaginatedExpression createExpression(ICredenzialeMittenteService credenzialeMittentiService, String credentialParam, boolean ricercaEsatta, boolean caseSensitive) throws UtilsException {
        try {
            IPaginatedExpression pagExpression = credenzialeMittentiService.newPaginatedExpression();
            pagExpression.and();
            String credentialClientId = this.convertToDBValue ? CredenzialeTokenClient.getClientIdDBValue(credentialParam, ricercaEsatta) : credentialParam;
            String credentialApplication = this.convertToDBValue ? CredenzialeTokenClient.getApplicationDBValue(credentialParam, ricercaEsatta) : credentialParam;
            pagExpression.equals(CredenzialeMittente.model().TIPO, (Object)this.tipo.getRawValue());
            if (ricercaEsatta) {
                if (caseSensitive) {
                    this.setLikeConditionRicercaEsattaCaseSensitive(credenzialeMittentiService, pagExpression, credentialClientId, credentialApplication, credentialParam);
                } else {
                    this.setLikeConditionRicercaEsattaCaseInsensitive(credenzialeMittentiService, pagExpression, credentialClientId, credentialApplication);
                }
            } else if (!caseSensitive) {
                pagExpression.ilike(CredenzialeMittente.model().CREDENZIALE, credentialParam, LikeMode.ANYWHERE);
            } else {
                pagExpression.like(CredenzialeMittente.model().CREDENZIALE, credentialParam, LikeMode.ANYWHERE);
            }
            return pagExpression;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), (Throwable)e);
        }
    }

    private void setLikeConditionRicercaEsattaCaseSensitive(ICredenzialeMittenteService credenzialeMittentiService, IPaginatedExpression pagExpression, String credentialClientId, String credentialApplication, String credentialParam) throws ExpressionNotImplementedException, ExpressionException, ServiceException, NotImplementedException {
        if (this.clientId && this.application) {
            this.setLikeConditionRicercaEsattaCaseSensitiveBoth(credenzialeMittentiService, pagExpression, credentialClientId, credentialApplication);
        } else if (this.clientId) {
            if (this.convertToDBValue) {
                IPaginatedExpression pagExpressionOr = credenzialeMittentiService.newPaginatedExpression();
                pagExpressionOr.like(CredenzialeMittente.model().CREDENZIALE, credentialClientId, LikeMode.ANYWHERE);
                pagExpressionOr.or();
                pagExpressionOr.equals(CredenzialeMittente.model().CREDENZIALE, (Object)credentialParam);
                pagExpression.and(new IExpression[]{pagExpressionOr});
            } else {
                pagExpression.equals(CredenzialeMittente.model().CREDENZIALE, (Object)credentialClientId);
            }
        } else if (this.application) {
            if (this.convertToDBValue) {
                pagExpression.like(CredenzialeMittente.model().CREDENZIALE, credentialApplication, LikeMode.ANYWHERE);
            } else {
                pagExpression.equals(CredenzialeMittente.model().CREDENZIALE, (Object)credentialApplication);
            }
        }
    }

    private void setLikeConditionRicercaEsattaCaseSensitiveBoth(ICredenzialeMittenteService credenzialeMittentiService, IPaginatedExpression pagExpression, String credentialClientId, String credentialApplication) throws ExpressionNotImplementedException, ExpressionException, ServiceException, NotImplementedException {
        IPaginatedExpression pagExpressionClientId = credenzialeMittentiService.newPaginatedExpression();
        if (this.convertToDBValue) {
            pagExpressionClientId.like(CredenzialeMittente.model().CREDENZIALE, credentialClientId, LikeMode.ANYWHERE);
        } else {
            pagExpressionClientId.equals(CredenzialeMittente.model().CREDENZIALE, (Object)credentialClientId);
        }
        IPaginatedExpression pagExpressionApplication = credenzialeMittentiService.newPaginatedExpression();
        if (this.convertToDBValue) {
            pagExpressionApplication.like(CredenzialeMittente.model().CREDENZIALE, credentialApplication, LikeMode.ANYWHERE);
        } else {
            pagExpressionApplication.equals(CredenzialeMittente.model().CREDENZIALE, (Object)credentialApplication);
        }
        if (this.andOperator) {
            pagExpression.and((IExpression)pagExpressionClientId, (IExpression)pagExpressionApplication);
        } else {
            pagExpression.or((IExpression)pagExpressionClientId, (IExpression)pagExpressionApplication);
        }
    }

    private void setLikeConditionRicercaEsattaCaseInsensitive(ICredenzialeMittenteService credenzialeMittentiService, IPaginatedExpression pagExpression, String credentialClientId, String credentialApplication) throws ExpressionNotImplementedException, ExpressionException, ServiceException, NotImplementedException {
        if (this.clientId && this.application) {
            this.setLikeConditionRicercaEsattaCaseInsensitiveBoth(credenzialeMittentiService, pagExpression, credentialClientId, credentialApplication);
        } else if (this.clientId) {
            if (this.convertToDBValue) {
                pagExpression.ilike(CredenzialeMittente.model().CREDENZIALE, credentialClientId, LikeMode.ANYWHERE);
            } else {
                pagExpression.ilike(CredenzialeMittente.model().CREDENZIALE, credentialClientId, LikeMode.EXACT);
            }
        } else if (this.application) {
            if (this.convertToDBValue) {
                pagExpression.ilike(CredenzialeMittente.model().CREDENZIALE, credentialApplication, LikeMode.ANYWHERE);
            } else {
                pagExpression.ilike(CredenzialeMittente.model().CREDENZIALE, credentialApplication, LikeMode.EXACT);
            }
        }
    }

    private void setLikeConditionRicercaEsattaCaseInsensitiveBoth(ICredenzialeMittenteService credenzialeMittentiService, IPaginatedExpression pagExpression, String credentialClientId, String credentialApplication) throws ExpressionNotImplementedException, ExpressionException, ServiceException, NotImplementedException {
        IPaginatedExpression pagExpressionClientId = credenzialeMittentiService.newPaginatedExpression();
        if (this.convertToDBValue) {
            pagExpressionClientId.ilike(CredenzialeMittente.model().CREDENZIALE, credentialClientId, LikeMode.ANYWHERE);
        } else {
            pagExpressionClientId.ilike(CredenzialeMittente.model().CREDENZIALE, credentialClientId, LikeMode.EXACT);
        }
        IPaginatedExpression pagExpressionApplication = credenzialeMittentiService.newPaginatedExpression();
        if (this.convertToDBValue) {
            pagExpressionApplication.ilike(CredenzialeMittente.model().CREDENZIALE, credentialApplication, LikeMode.ANYWHERE);
        } else {
            pagExpressionApplication.ilike(CredenzialeMittente.model().CREDENZIALE, credentialApplication, LikeMode.EXACT);
        }
        if (this.andOperator) {
            pagExpression.and((IExpression)pagExpressionClientId, (IExpression)pagExpressionApplication);
        } else {
            pagExpression.or((IExpression)pagExpressionClientId, (IExpression)pagExpressionApplication);
        }
    }
}

