/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.abstraction.template;

import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openspcoop2.protocol.abstraction.template.TemplateCore;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.resources.TemplateUtils;

public class TemplateFruizione
extends TemplateCore {
    private List<byte[]> serviziApplicativi = new ArrayList<byte[]>();
    private List<byte[]> porteDelegate = new ArrayList<byte[]>();

    public TemplateFruizione() throws ProtocolException {
        super(false);
        try {
            String baseUrl = "/templates/fruizione.zip";
            InputStream is = TemplateFruizione.class.getResourceAsStream(baseUrl);
            if (is == null) {
                throw new ProtocolException("Resource with url [" + baseUrl + "] not found");
            }
            byte[] zipFile = Utilities.getAsByteArray((InputStream)is);
            is.close();
            this.updateTemplates(zipFile);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    public List<byte[]> getServiziApplicativi() {
        return this.serviziApplicativi;
    }

    public void setServiziApplicativi(List<byte[]> serviziApplicativi) {
        this.serviziApplicativi = serviziApplicativi;
    }

    public List<Template> getTemplateServiziApplicativi() throws IOException {
        ArrayList<Template> templates = new ArrayList<Template>();
        for (int i = 0; i < this.serviziApplicativi.size(); ++i) {
            templates.add(TemplateUtils.buildTemplate((String)"sa_i", (byte[])this.serviziApplicativi.get(i)));
        }
        return templates;
    }

    public List<byte[]> getPorteDelegate() {
        return this.porteDelegate;
    }

    public void setPorteDelegate(List<byte[]> porteDelegate) {
        this.porteDelegate = porteDelegate;
    }

    public List<Template> getTemplatePorteDelegate() throws IOException {
        ArrayList<Template> templates = new ArrayList<Template>();
        for (int i = 0; i < this.porteDelegate.size(); ++i) {
            templates.add(TemplateUtils.buildTemplate((String)"pd_i", (byte[])this.porteDelegate.get(i)));
        }
        return templates;
    }

    @Override
    public void updateOtherResource(String entryName, InputStream inputStream, byte[] xml, Map<String, Boolean> mapFound) throws ProtocolException {
        String rootDirNameExpected = this.getRootDirName() + File.separatorChar;
        if (entryName.startsWith(rootDirNameExpected + "pd" + File.separatorChar)) {
            if (!mapFound.containsKey("pd") || !mapFound.get("pd").booleanValue()) {
                this.getPorteDelegate().clear();
            }
            this.getPorteDelegate().add(xml);
            mapFound.put("pd", true);
        } else if (entryName.startsWith(rootDirNameExpected + "sa" + File.separatorChar)) {
            if (!mapFound.containsKey("sa") || !mapFound.get("sa").booleanValue()) {
                this.getServiziApplicativi().clear();
            }
            this.getServiziApplicativi().add(xml);
            mapFound.put("sa", true);
        } else {
            throw new ProtocolException("Elemento [" + entryName + "] non atteso");
        }
    }
}

