/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic;

import org.openspcoop2.core.config.driver.IDriverConfigurazioneGet;
import org.openspcoop2.core.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop2.protocol.basic.BasicStaticInstanceConfig;
import org.openspcoop2.protocol.basic.archive.BasicArchive;
import org.openspcoop2.protocol.basic.builder.BustaBuilder;
import org.openspcoop2.protocol.basic.builder.ErroreApplicativoBuilder;
import org.openspcoop2.protocol.basic.builder.EsitoBuilder;
import org.openspcoop2.protocol.basic.config.BasicProtocolIntegrationConfiguration;
import org.openspcoop2.protocol.basic.config.BasicTraduttore;
import org.openspcoop2.protocol.basic.diagnostica.DiagnosticDriver;
import org.openspcoop2.protocol.basic.diagnostica.DiagnosticProducer;
import org.openspcoop2.protocol.basic.diagnostica.DiagnosticSerializer;
import org.openspcoop2.protocol.basic.dump.DumpProducer;
import org.openspcoop2.protocol.basic.properties.BasicDynamicConfiguration;
import org.openspcoop2.protocol.basic.registry.ConfigIntegrationReader;
import org.openspcoop2.protocol.basic.registry.RegistryReader;
import org.openspcoop2.protocol.basic.tracciamento.TracciaDriver;
import org.openspcoop2.protocol.basic.tracciamento.TracciaProducer;
import org.openspcoop2.protocol.basic.tracciamento.TracciaSerializer;
import org.openspcoop2.protocol.basic.validator.ValidatoreErrori;
import org.openspcoop2.protocol.basic.validator.ValidazioneAccordi;
import org.openspcoop2.protocol.basic.validator.ValidazioneConSchema;
import org.openspcoop2.protocol.basic.validator.ValidazioneDocumenti;
import org.openspcoop2.protocol.basic.validator.ValidazioneSemantica;
import org.openspcoop2.protocol.basic.validator.ValidazioneSintattica;
import org.openspcoop2.protocol.manifest.Openspcoop2;
import org.openspcoop2.protocol.registry.CachedRegistryReader;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.ConfigurazionePdD;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.InformazioniProtocollo;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.IArchive;
import org.openspcoop2.protocol.sdk.builder.IBustaBuilder;
import org.openspcoop2.protocol.sdk.builder.IErroreApplicativoBuilder;
import org.openspcoop2.protocol.sdk.builder.IEsitoBuilder;
import org.openspcoop2.protocol.sdk.config.IProtocolIntegrationConfiguration;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticDriver;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticProducer;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticSerializer;
import org.openspcoop2.protocol.sdk.dump.IDumpProducer;
import org.openspcoop2.protocol.sdk.properties.IConsoleDynamicConfiguration;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaDriver;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaProducer;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaSerializer;
import org.openspcoop2.protocol.sdk.validator.IValidatoreErrori;
import org.openspcoop2.protocol.sdk.validator.IValidazioneAccordi;
import org.openspcoop2.protocol.sdk.validator.IValidazioneConSchema;
import org.openspcoop2.protocol.sdk.validator.IValidazioneDocumenti;
import org.openspcoop2.protocol.sdk.validator.IValidazioneSemantica;
import org.openspcoop2.protocol.sdk.validator.IValidazioneSintattica;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.protocol.utils.ProtocolUtils;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.MapKey;
import org.slf4j.Logger;

public abstract class BasicFactory<BustaRawType>
implements IProtocolFactory<BustaRawType> {
    private static final long serialVersionUID = 1L;
    private String protocol;
    private MapKey<String> protocolMapKey;
    private InformazioniProtocollo informazioniProtocollo;
    protected Logger log;
    protected Logger logProtocol;
    private ConfigurazionePdD configPdD;
    private Openspcoop2 manifest;
    protected BasicStaticInstanceConfig staticInstanceConfig;
    private static Map<IErroreApplicativoBuilder> staticInstanceErroreApplicativoBuilder = null;
    private static Map<IEsitoBuilder> staticInstanceEsitoBuilder = null;
    private static Map<ITraduttore> staticInstanceTraduttore = null;
    private static Map<IProtocolIntegrationConfiguration> staticInstanceProtocolIntegrationConfiguration = null;

    @Override
    public void init(Logger log, String protocol, ConfigurazionePdD configPdD, Openspcoop2 manifest) throws ProtocolException {
        this.protocol = protocol;
        this.protocolMapKey = ProtocolUtils.protocolToMapKey(this.protocol);
        this.log = log;
        this.configPdD = configPdD;
        this.manifest = manifest;
        this.informazioniProtocollo = new InformazioniProtocollo();
        this.informazioniProtocollo.setName(this.protocol);
        this.informazioniProtocollo.setLabel(manifest.getProtocol().getLabel());
        this.informazioniProtocollo.setWebSite(manifest.getProtocol().getWebSite());
        this.informazioniProtocollo.setDescription(manifest.getProtocol().getDescrizione());
        if (manifest.getProtocol().getTransaction() != null) {
            this.informazioniProtocollo.setErrorProtocol(manifest.getProtocol().getTransaction().isErrorProtocol());
            this.informazioniProtocollo.setEnvelopeErrorProtocol(manifest.getProtocol().getTransaction().isEnvelopeErrorProtocol());
            this.informazioniProtocollo.setLabelErrorProtocol(manifest.getProtocol().getTransaction().getLabelErrorProtocol());
            this.informazioniProtocollo.setExternalFault(manifest.getProtocol().getTransaction().isExternalFault());
            this.informazioniProtocollo.setLabelExternalFault(manifest.getProtocol().getTransaction().getLabelExternalFault());
        }
    }

    protected void initStaticInstance(BasicStaticInstanceConfig staticInstanceConfig) throws ProtocolException {
        if (staticInstanceConfig != null) {
            this.staticInstanceConfig = staticInstanceConfig;
            if (staticInstanceConfig.isStaticConfig()) {
                if (staticInstanceTraduttore == null) {
                    BasicFactory.initStaticInstanceTraduttore();
                }
                this.createTraduttore();
                if (staticInstanceProtocolIntegrationConfiguration == null) {
                    BasicFactory.initStaticInstanceProtocolIntegrationConfiguration();
                }
                this.createProtocolIntegrationConfiguration();
            }
            if (staticInstanceConfig.isStaticErrorBuilder()) {
                if (staticInstanceErroreApplicativoBuilder == null) {
                    BasicFactory.initStaticInstanceErroreApplicativoBuilder();
                }
                this.createErroreApplicativoBuilder();
            }
            if (staticInstanceConfig.isStaticEsitoBuilder() && EsitiProperties.isInitializedProtocol(this.getProtocolMapKey())) {
                if (staticInstanceEsitoBuilder == null) {
                    BasicFactory.initStaticInstanceEsitoBuilder();
                }
                this.createEsitoBuilder();
            }
        }
    }

    public void initStaticInstance() throws ProtocolException {
        if (this.staticInstanceConfig != null && this.staticInstanceConfig.isStaticEsitoBuilder() && EsitiProperties.isInitializedProtocol(this.getProtocolMapKey()) && (staticInstanceEsitoBuilder == null || !staticInstanceEsitoBuilder.containsKey(this.getProtocolMapKey()))) {
            if (staticInstanceEsitoBuilder == null) {
                BasicFactory.initStaticInstanceEsitoBuilder();
            }
            this.createEsitoBuilder();
        }
    }

    @Override
    public void initProtocolLogger(Logger protocolLogger) throws ProtocolException {
        this.logProtocol = protocolLogger;
    }

    @Override
    public Logger getLogger() {
        return this.log;
    }

    @Override
    public Logger getProtocolLogger() {
        if (this.logProtocol != null) {
            return this.logProtocol;
        }
        return this.log;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public MapKey<String> getProtocolMapKey() {
        return this.protocolMapKey;
    }

    @Override
    public InformazioniProtocollo getInformazioniProtocol() {
        return this.informazioniProtocollo;
    }

    @Override
    public ConfigurazionePdD getConfigurazionePdD() {
        return this.configPdD;
    }

    @Override
    public Openspcoop2 getManifest() {
        return this.manifest;
    }

    @Override
    public IBustaBuilder<BustaRawType> createBustaBuilder(IState state) throws ProtocolException {
        return new BustaBuilder(this, state);
    }

    private static synchronized void initStaticInstanceErroreApplicativoBuilder() {
        if (staticInstanceErroreApplicativoBuilder == null) {
            staticInstanceErroreApplicativoBuilder = new Map();
        }
    }

    @Override
    public IErroreApplicativoBuilder createErroreApplicativoBuilder() throws ProtocolException {
        if (staticInstanceErroreApplicativoBuilder != null) {
            IErroreApplicativoBuilder builder = (IErroreApplicativoBuilder)staticInstanceErroreApplicativoBuilder.get(this.getProtocolMapKey());
            if (builder == null) {
                this.initErroreApplicativoBuilder(this.getProtocolMapKey());
                builder = (IErroreApplicativoBuilder)staticInstanceErroreApplicativoBuilder.get(this.getProtocolMapKey());
            }
            return builder;
        }
        return new ErroreApplicativoBuilder(this);
    }

    private synchronized void initErroreApplicativoBuilder(MapKey<String> protocolMapKey) throws ProtocolException {
        if (!staticInstanceErroreApplicativoBuilder.containsKey(protocolMapKey)) {
            staticInstanceErroreApplicativoBuilder.put(protocolMapKey, (Object)new ErroreApplicativoBuilder(this));
        }
    }

    private static synchronized void initStaticInstanceEsitoBuilder() {
        if (staticInstanceEsitoBuilder == null) {
            staticInstanceEsitoBuilder = new Map();
        }
    }

    @Override
    public IEsitoBuilder createEsitoBuilder() throws ProtocolException {
        if (staticInstanceEsitoBuilder != null) {
            IEsitoBuilder builder = (IEsitoBuilder)staticInstanceEsitoBuilder.get(this.getProtocolMapKey());
            if (builder == null) {
                this.initEsitoBuilder(this.getProtocolMapKey());
                builder = (IEsitoBuilder)staticInstanceEsitoBuilder.get(this.getProtocolMapKey());
            }
            return builder;
        }
        return new EsitoBuilder(this);
    }

    private synchronized void initEsitoBuilder(MapKey<String> protocolMapKey) throws ProtocolException {
        if (!staticInstanceEsitoBuilder.containsKey(protocolMapKey)) {
            staticInstanceEsitoBuilder.put(protocolMapKey, (Object)new EsitoBuilder(this));
        }
    }

    @Override
    public IValidatoreErrori createValidatoreErrori(IState state) throws ProtocolException {
        return new ValidatoreErrori(this, state);
    }

    @Override
    public IValidazioneSintattica<BustaRawType> createValidazioneSintattica(IState state) throws ProtocolException {
        return new ValidazioneSintattica(this, state);
    }

    @Override
    public IValidazioneSemantica createValidazioneSemantica(IState state) throws ProtocolException {
        return new ValidazioneSemantica(this, state);
    }

    @Override
    public IValidazioneConSchema createValidazioneConSchema(IState state) throws ProtocolException {
        return new ValidazioneConSchema(this, state);
    }

    @Override
    public IValidazioneDocumenti createValidazioneDocumenti() throws ProtocolException {
        return new ValidazioneDocumenti(this);
    }

    @Override
    public IValidazioneAccordi createValidazioneAccordi() throws ProtocolException {
        return new ValidazioneAccordi(this);
    }

    @Override
    public IDiagnosticDriver createDiagnosticDriver() throws ProtocolException {
        return new DiagnosticDriver(this);
    }

    @Override
    public IDiagnosticProducer createDiagnosticProducer() throws ProtocolException {
        return new DiagnosticProducer(this);
    }

    @Override
    public IDiagnosticSerializer createDiagnosticSerializer() throws ProtocolException {
        return new DiagnosticSerializer(this);
    }

    @Override
    public ITracciaDriver createTracciaDriver() throws ProtocolException {
        return new TracciaDriver(this);
    }

    @Override
    public ITracciaProducer createTracciaProducer() throws ProtocolException {
        return new TracciaProducer(this);
    }

    @Override
    public ITracciaSerializer createTracciaSerializer() throws ProtocolException {
        return new TracciaSerializer(this);
    }

    @Override
    public IDumpProducer createDumpProducer() throws ProtocolException {
        return new DumpProducer(this);
    }

    @Override
    public IArchive createArchive() throws ProtocolException {
        return new BasicArchive(this);
    }

    private static synchronized void initStaticInstanceTraduttore() {
        if (staticInstanceTraduttore == null) {
            staticInstanceTraduttore = new Map();
        }
    }

    @Override
    public ITraduttore createTraduttore() throws ProtocolException {
        if (staticInstanceTraduttore != null) {
            ITraduttore traduttore = (ITraduttore)staticInstanceTraduttore.get(this.getProtocolMapKey());
            if (traduttore == null) {
                this.initTraduttore(this.getProtocolMapKey());
                traduttore = (ITraduttore)staticInstanceTraduttore.get(this.getProtocolMapKey());
            }
            return traduttore;
        }
        return new BasicTraduttore(this);
    }

    private synchronized void initTraduttore(MapKey<String> protocolMapKey) throws ProtocolException {
        if (!staticInstanceTraduttore.containsKey(protocolMapKey)) {
            staticInstanceTraduttore.put(protocolMapKey, (Object)new BasicTraduttore(this));
        }
    }

    private static synchronized void initStaticInstanceProtocolIntegrationConfiguration() {
        if (staticInstanceProtocolIntegrationConfiguration == null) {
            staticInstanceProtocolIntegrationConfiguration = new Map();
        }
    }

    @Override
    public IProtocolIntegrationConfiguration createProtocolIntegrationConfiguration() throws ProtocolException {
        if (staticInstanceProtocolIntegrationConfiguration != null) {
            IProtocolIntegrationConfiguration config = (IProtocolIntegrationConfiguration)staticInstanceProtocolIntegrationConfiguration.get(this.getProtocolMapKey());
            if (config == null) {
                this.initProtocolIntegrationConfiguration(this.getProtocolMapKey());
                config = (IProtocolIntegrationConfiguration)staticInstanceProtocolIntegrationConfiguration.get(this.getProtocolMapKey());
            }
            return config;
        }
        return new BasicProtocolIntegrationConfiguration(this);
    }

    private synchronized void initProtocolIntegrationConfiguration(MapKey<String> protocolMapKey) throws ProtocolException {
        if (!staticInstanceProtocolIntegrationConfiguration.containsKey(protocolMapKey)) {
            staticInstanceProtocolIntegrationConfiguration.put(protocolMapKey, (Object)new BasicProtocolIntegrationConfiguration(this));
        }
    }

    @Override
    public IConsoleDynamicConfiguration createDynamicConfigurationConsole() throws ProtocolException {
        return new BasicDynamicConfiguration(this);
    }

    @Override
    public IRegistryReader getRegistryReader(IDriverRegistroServiziGet driverRegistry) throws ProtocolException {
        try {
            return new RegistryReader(driverRegistry, this.log);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    @Override
    public IRegistryReader getCachedRegistryReader(IState state, RequestInfo requestInfo) throws ProtocolException {
        try {
            return new CachedRegistryReader(this.log, this, state, requestInfo);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    @Override
    public IRegistryReader getCachedRegistryReader(Object registryReader, RequestInfo requestInfo) throws ProtocolException {
        try {
            return new CachedRegistryReader(this.log, this, (RegistroServiziManager)registryReader, requestInfo);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    @Override
    public IConfigIntegrationReader getConfigIntegrationReader(IDriverConfigurazioneGet driver) throws ProtocolException {
        try {
            return new ConfigIntegrationReader(driver, this.log);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    @Override
    public IConfigIntegrationReader getCachedConfigIntegrationReader(IState state, RequestInfo requestInfo) throws ProtocolException {
        try {
            Class<?> c = Class.forName("org.openspcoop2.pdd.config.CachedConfigIntegrationReader");
            return (IConfigIntegrationReader)c.getConstructor(Logger.class, IProtocolFactory.class, IState.class, RequestInfo.class).newInstance(this.log, this, state, requestInfo);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }

    @Override
    public IConfigIntegrationReader getCachedConfigIntegrationReader(Object configReader, RequestInfo requestInfo) throws ProtocolException {
        try {
            Class<?> cConfigurazionePdDManager = Class.forName("org.openspcoop2.pdd.config.ConfigurazionePdDManager");
            Class<?> c = Class.forName("org.openspcoop2.pdd.config.CachedConfigIntegrationReader");
            return (IConfigIntegrationReader)c.getConstructor(Logger.class, IProtocolFactory.class, cConfigurazionePdDManager, RequestInfo.class).newInstance(this.log, this, configReader, requestInfo);
        }
        catch (Exception e) {
            throw new ProtocolException(e.getMessage(), e);
        }
    }
}

