/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.builder;

import jakarta.xml.soap.Detail;
import jakarta.xml.soap.Name;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPFactory;
import jakarta.xml.soap.SOAPFault;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.openspcoop2.core.eccezione.router_details.Dettaglio;
import org.openspcoop2.core.eccezione.router_details.DettaglioRouting;
import org.openspcoop2.core.eccezione.router_details.Dominio;
import org.openspcoop2.core.eccezione.router_details.DominioSoggetto;
import org.openspcoop2.core.eccezione.router_details.utils.XMLUtils;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ErroreApplicativoMessageUtils {
    public static void addPrefixToElement(Element elementErroreApplicativo, String prefix) {
    }

    public static void addErroreApplicativoIntoSOAPFaultDetail(SOAPElement erroreApplicativo, OpenSPCoop2Message msg, Logger log) throws ProtocolException {
        try {
            if (msg == null) {
                throw new ProtocolException("Messaggio non presente");
            }
            SOAPBody soapBody = msg.castAsSoap().getSOAPBody();
            if (soapBody == null) {
                throw new ProtocolException("SOAPBody non presente");
            }
            SOAPFault fault = null;
            if (!soapBody.hasFault()) {
                throw new ProtocolException("SOAPFault non presente");
            }
            fault = soapBody.getFault();
            if (fault == null) {
                throw new ProtocolException("SOAPFault is null");
            }
            Detail detail = fault.getDetail();
            if (detail == null) {
                detail = fault.addDetail();
                detail = fault.getDetail();
            }
            if (detail != null) {
                detail.addChildElement(erroreApplicativo);
            }
            msg.saveChanges();
        }
        catch (Exception e) {
            log.error("Errore durante la costruzione del messaggio di errore applicativo (InsertDetail)", (Throwable)e);
            throw new ProtocolException("Errore durante la costruzione del messaggio di errore (InsertDetail)", e);
        }
    }

    @Deprecated
    public static void insertErroreApplicativoIntoSOAPFault(SOAPElement erroreApplicativo, OpenSPCoop2Message msg, Logger log) throws ProtocolException {
        try {
            if (msg == null) {
                throw new ProtocolException("Messaggio non presente");
            }
            SOAPBody soapBody = msg.castAsSoap().getSOAPBody();
            if (soapBody == null) {
                throw new ProtocolException("SOAPBody non presente");
            }
            SOAPFault faultOriginale = null;
            if (!soapBody.hasFault()) {
                throw new ProtocolException("SOAPFault non presente");
            }
            faultOriginale = soapBody.getFault();
            if (faultOriginale == null) {
                throw new ProtocolException("SOAPFault is null");
            }
            QName nameDetail = null;
            nameDetail = MessageType.SOAP_12.equals((Object)msg.getMessageType()) ? new QName("http://www.w3.org/2003/05/soap-envelope", "Detail") : new QName("detail");
            SOAPElement detailsFaultOriginale = null;
            Iterator itDetailsOriginali = faultOriginale.getChildElements(nameDetail);
            if (itDetailsOriginali != null && itDetailsOriginali.hasNext()) {
                detailsFaultOriginale = (SOAPElement)itDetailsOriginali.next();
            }
            String faultActor = faultOriginale.getFaultActor();
            Name faultCode = faultOriginale.getFaultCodeAsName();
            Iterator faultSubCode = null;
            String faultNode = null;
            if (MessageType.SOAP_12.equals((Object)msg.getMessageType())) {
                faultSubCode = faultOriginale.getFaultSubcodes();
                faultNode = faultOriginale.getFaultNode();
            }
            String faultString = faultOriginale.getFaultString();
            soapBody.removeChild((Node)soapBody.getFault());
            SOAPFault faultPulito = soapBody.addFault();
            if (faultActor != null) {
                faultPulito.setFaultActor(faultActor);
            }
            if (faultCode != null) {
                faultPulito.setFaultCode(faultCode);
            }
            if (faultSubCode != null) {
                while (faultSubCode.hasNext()) {
                    QName faultSubCodeQname = (QName)faultSubCode.next();
                    faultPulito.appendFaultSubcode(faultSubCodeQname);
                }
            }
            if (faultNode != null) {
                faultPulito.setFaultNode(faultNode);
            }
            if (faultString != null) {
                SoapUtils.setFaultString((SOAPFault)faultPulito, (String)faultString);
            }
            Detail detailFaultPulito = faultPulito.addDetail();
            detailFaultPulito = faultPulito.getDetail();
            if (detailsFaultOriginale != null) {
                Iterator it = detailsFaultOriginale.getChildElements();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (!(o instanceof SOAPElement)) continue;
                    SOAPElement elem = (SOAPElement)o;
                    detailFaultPulito.addChildElement(elem);
                }
            }
            detailFaultPulito.addChildElement(erroreApplicativo);
            msg.saveChanges();
        }
        catch (Exception e) {
            log.error("Errore durante la costruzione del messaggio di errore applicativo (InsertDetail)", (Throwable)e);
            throw new ProtocolException("Errore durante la costruzione del messaggio di errore (InsertDetail)", e);
        }
    }

    public static void insertRoutingErrorInSOAPFault(IDSoggetto identitaRouter, String idFunzione, String msgErrore, OpenSPCoop2Message msg, Logger log, AbstractXMLUtils xmlUtils) throws ProtocolException {
        try {
            if (msg == null) {
                throw new ProtocolException("Messaggio non presente");
            }
            DettaglioRouting dettaglioRouting = new DettaglioRouting();
            Dominio dominio = new Dominio();
            DominioSoggetto dominioSoggetto = new DominioSoggetto();
            dominioSoggetto.setType(identitaRouter.getTipo());
            dominioSoggetto.setBase(identitaRouter.getNome());
            dominio.setOrganization(dominioSoggetto);
            dominio.setId(identitaRouter.getCodicePorta());
            dominio.setModule(idFunzione);
            dettaglioRouting.setDomain(dominio);
            dettaglioRouting.setTimestamp(DateManager.getDate());
            Dettaglio dettaglio = new Dettaglio();
            dettaglio.setDescription(msgErrore);
            dettaglio.setState("ERROR");
            dettaglioRouting.setDetail(dettaglio);
            byte[] xmlDettaglioRouting = XMLUtils.generateDettaglioRouting((DettaglioRouting)dettaglioRouting);
            Element elementDettaglioRouting = xmlUtils.newElement(xmlDettaglioRouting);
            ErroreApplicativoMessageUtils.addPrefixToElement(elementDettaglioRouting, "op2RoutingDetail");
            SOAPFactory sf = SoapUtils.getSoapFactory((OpenSPCoop2MessageFactory)msg.getFactory(), (MessageType)msg.getMessageType());
            SOAPElement dettaglioRoutingElementSOAP = sf.createElement(elementDettaglioRouting);
            ErroreApplicativoMessageUtils.addErroreApplicativoIntoSOAPFaultDetail(dettaglioRoutingElementSOAP, msg, log);
        }
        catch (Exception e) {
            log.error("Errore durante la costruzione del messaggio di errore", (Throwable)e);
            throw new ProtocolException("Errore durante la costruzione del messaggio di errore", e);
        }
    }
}

