/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.config;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.message.config.ServiceBindingConfiguration;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.basic.BasicComponentFactory;
import org.openspcoop2.protocol.basic.config.ServiceBindingConfigurationReader;
import org.openspcoop2.protocol.manifest.Binding;
import org.openspcoop2.protocol.manifest.CollaborationProfile;
import org.openspcoop2.protocol.manifest.Functionality;
import org.openspcoop2.protocol.manifest.InterfaceConfiguration;
import org.openspcoop2.protocol.manifest.Openspcoop2;
import org.openspcoop2.protocol.manifest.OrganizationType;
import org.openspcoop2.protocol.manifest.Registry;
import org.openspcoop2.protocol.manifest.ServiceType;
import org.openspcoop2.protocol.manifest.SoapHeaderBypassMustUnderstandHeader;
import org.openspcoop2.protocol.manifest.Version;
import org.openspcoop2.protocol.manifest.constants.InterfaceType;
import org.openspcoop2.protocol.sdk.BypassMustUnderstandCheck;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.config.IProtocolConfiguration;
import org.openspcoop2.protocol.sdk.constants.FunzionalitaProtocollo;
import org.openspcoop2.protocol.sdk.constants.InitialIdConversationType;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.registry.RegistryNotFound;
import org.openspcoop2.utils.certificate.remote.RemoteStoreConfig;
import org.openspcoop2.utils.transport.TransportRequestContext;

public class BasicConfiguration
extends BasicComponentFactory
implements IProtocolConfiguration {
    private Registry registroManifest;
    private Binding bindingManifest;
    private Openspcoop2 manifest;

    public BasicConfiguration(IProtocolFactory<?> factory) throws ProtocolException {
        super(factory);
        this.manifest = this.protocolFactory.getManifest();
        this.registroManifest = this.manifest.getRegistry();
        this.bindingManifest = this.manifest.getBinding();
    }

    @Override
    public ServiceBindingConfiguration getDefaultServiceBindingConfiguration(TransportRequestContext transportRequest) throws ProtocolException {
        return ServiceBindingConfigurationReader.getDefaultServiceBindingConfiguration(this.manifest, transportRequest);
    }

    @Override
    public ServiceBinding getIntegrationServiceBinding(IDServizio idServizio, IRegistryReader registryReader) throws ProtocolException, RegistryNotFound {
        return ServiceBindingConfigurationReader.getServiceBinding(idServizio, registryReader);
    }

    @Override
    public ServiceBinding getProtocolServiceBinding(ServiceBinding integrationServiceBinding, TransportRequestContext transportRequest) throws ProtocolException {
        return integrationServiceBinding;
    }

    @Override
    public ServiceBindingConfiguration getServiceBindingConfiguration(TransportRequestContext transportRequest, ServiceBinding serviceBinding, IDServizio idServizio, IRegistryReader registryReader) throws ProtocolException, RegistryNotFound {
        return ServiceBindingConfigurationReader.getServiceBindingConfiguration(this.manifest, transportRequest, serviceBinding, idServizio, registryReader);
    }

    @Override
    public List<InterfaceType> getInterfacceSupportate(ServiceBinding serviceBinding) {
        ArrayList<InterfaceType> list = new ArrayList<InterfaceType>();
        switch (serviceBinding) {
            case SOAP: {
                if (this.bindingManifest.getSoap() == null || this.bindingManifest.getSoap().getInterfaces() == null || this.bindingManifest.getSoap().getInterfaces().sizeSpecificationList() <= 0) break;
                for (InterfaceConfiguration interfaceConfiguration : this.bindingManifest.getSoap().getInterfaces().getSpecificationList()) {
                    list.add(interfaceConfiguration.getType());
                }
                break;
            }
            case REST: {
                if (this.bindingManifest.getRest() == null || this.bindingManifest.getRest().getInterfaces() == null || this.bindingManifest.getRest().getInterfaces().sizeSpecificationList() <= 0) break;
                for (InterfaceConfiguration interfaceConfiguration : this.bindingManifest.getRest().getInterfaces().getSpecificationList()) {
                    list.add(interfaceConfiguration.getType());
                }
                break;
            }
        }
        return list;
    }

    @Override
    public boolean isSupportoSchemaEsternoInterfaccia(ServiceBinding serviceBinding, InterfaceType interfaceType) {
        switch (serviceBinding) {
            case SOAP: {
                if (this.bindingManifest.getSoap() == null || this.bindingManifest.getSoap().getInterfaces() == null || this.bindingManifest.getSoap().getInterfaces().sizeSpecificationList() <= 0) break;
                for (InterfaceConfiguration interfaceConfiguration : this.bindingManifest.getSoap().getInterfaces().getSpecificationList()) {
                    if (!interfaceType.equals(interfaceConfiguration.getType())) continue;
                    return interfaceConfiguration.isSchema();
                }
                break;
            }
            case REST: {
                if (this.bindingManifest.getRest() == null || this.bindingManifest.getRest().getInterfaces() == null || this.bindingManifest.getRest().getInterfaces().sizeSpecificationList() <= 0) break;
                for (InterfaceConfiguration interfaceConfiguration : this.bindingManifest.getRest().getInterfaces().getSpecificationList()) {
                    if (!interfaceType.equals(interfaceConfiguration.getType())) continue;
                    return interfaceConfiguration.isSchema();
                }
                break;
            }
        }
        return false;
    }

    @Override
    public boolean isSupportoSpecificaConversazioni(ServiceBinding serviceBinding, InterfaceType interfaceType) {
        switch (serviceBinding) {
            case SOAP: {
                if (this.bindingManifest.getSoap() == null || this.bindingManifest.getSoap().getInterfaces() == null || this.bindingManifest.getSoap().getInterfaces().sizeSpecificationList() <= 0) break;
                for (InterfaceConfiguration interfaceConfiguration : this.bindingManifest.getSoap().getInterfaces().getSpecificationList()) {
                    if (!interfaceType.equals(interfaceConfiguration.getType())) continue;
                    return interfaceConfiguration.isConversations();
                }
                break;
            }
            case REST: {
                if (this.bindingManifest.getRest() == null || this.bindingManifest.getRest().getInterfaces() == null || this.bindingManifest.getRest().getInterfaces().sizeSpecificationList() <= 0) break;
                for (InterfaceConfiguration interfaceConfiguration : this.bindingManifest.getRest().getInterfaces().getSpecificationList()) {
                    if (!interfaceType.equals(interfaceConfiguration.getType())) continue;
                    return interfaceConfiguration.isConversations();
                }
                break;
            }
        }
        return false;
    }

    @Override
    public boolean isSupportoPortiAccessoAccordiParteSpecifica(ServiceBinding serviceBinding, InterfaceType interfaceType) {
        switch (serviceBinding) {
            case SOAP: {
                if (this.bindingManifest.getSoap() == null || this.bindingManifest.getSoap().getInterfaces() == null || this.bindingManifest.getSoap().getInterfaces().sizeSpecificationList() <= 0) break;
                for (InterfaceConfiguration interfaceConfiguration : this.bindingManifest.getSoap().getInterfaces().getSpecificationList()) {
                    if (!interfaceType.equals(interfaceConfiguration.getType())) continue;
                    return interfaceConfiguration.isImplementation();
                }
                break;
            }
            case REST: {
                if (this.bindingManifest.getRest() == null || this.bindingManifest.getRest().getInterfaces() == null || this.bindingManifest.getRest().getInterfaces().sizeSpecificationList() <= 0) break;
                for (InterfaceConfiguration interfaceConfiguration : this.bindingManifest.getRest().getInterfaces().getSpecificationList()) {
                    if (!interfaceType.equals(interfaceConfiguration.getType())) continue;
                    return interfaceConfiguration.isImplementation();
                }
                break;
            }
        }
        return false;
    }

    @Override
    public boolean isSupportoAutenticazioneSoggetti() {
        return this.registroManifest.getOrganization().getAuthentication();
    }

    @Override
    public boolean isSupportatoAutenticazioneApplicativiHttpsConToken() {
        return this.registroManifest.getOrganization().getHttpsWithTokenAuthentication();
    }

    @Override
    public boolean isSupportoAutenticazioneApplicativiErogazioni() {
        return this.registroManifest.getOrganization().getInboundApplicativeAuthentication();
    }

    @Override
    public boolean isSupportatoAutorizzazioneRichiedenteSenzaAutenticazioneErogazioni() {
        return this.registroManifest.getOrganization().getInboundOrganizationAuthorizationWithoutAuthentication();
    }

    @Override
    public boolean isSupportoAutenticazioneApplicativiEsterniErogazioni() {
        return this.registroManifest.getOrganization().getInboundExternalApplicationAuthentication();
    }

    @Override
    public boolean isSupportoCodiceIPA() {
        return this.registroManifest.getOrganization().isCodeIPA();
    }

    @Override
    public boolean isSupportoIdentificativoPortaSoggetto() {
        return this.registroManifest.getOrganization().isCodeDomain();
    }

    @Override
    public boolean isSupportoIndirizzoRisposta() {
        return this.registroManifest.getOrganization().isReplyToAddress();
    }

    @Override
    public boolean isSupportoSoggettoUtilizzoTrattino() {
        return this.registroManifest.getOrganization().isDash();
    }

    @Override
    public boolean isSupportoSoggettoReferenteAccordiParteComune() {
        return this.registroManifest.getService().isApiReferent();
    }

    @Override
    public boolean isSupportoVersionamentoAccordiParteSpecifica() {
        return this.registroManifest.getService().isVersion();
    }

    @Override
    public boolean isSupportoSbustamentoProtocollo() {
        return this.registroManifest.getService().isProtocolEnvelopeManagement();
    }

    @Override
    public boolean isSupportoSceltaFault() {
        return this.registroManifest.getService().isFaultChoice();
    }

    @Override
    public boolean isAbilitatoRiusoIdCorrelazioneApplicativa() {
        return this.registroManifest.getService().isCorrelationReuseProtocolId();
    }

    @Override
    public boolean isAbilitataGenerazioneTracce() {
        return this.registroManifest.getService().isTrace();
    }

    @Override
    public boolean isAbilitatoSalvataggioHeaderProtocolloTracce() {
        return true;
    }

    @Override
    public List<String> getTipiSoggetti() throws ProtocolException {
        ArrayList<String> tipi = new ArrayList<String>();
        List<OrganizationType> l = this.registroManifest.getOrganization().getTypes().getTypeList();
        for (int i = 0; i < l.size(); ++i) {
            tipi.add(l.get(i).getName());
        }
        return tipi;
    }

    @Override
    public String getTipoSoggettoDefault() throws ProtocolException {
        return this.registroManifest.getOrganization().getTypes().getType(0).getName();
    }

    private org.openspcoop2.protocol.manifest.constants.ServiceBinding convert(ServiceBinding serviceBinding) {
        switch (serviceBinding) {
            case SOAP: {
                return org.openspcoop2.protocol.manifest.constants.ServiceBinding.SOAP;
            }
            case REST: {
                return org.openspcoop2.protocol.manifest.constants.ServiceBinding.REST;
            }
        }
        return null;
    }

    @Override
    public List<String> getTipiServizi(ServiceBinding serviceBinding) throws ProtocolException {
        org.openspcoop2.protocol.manifest.constants.ServiceBinding sb = null;
        if (serviceBinding != null) {
            sb = this.convert(serviceBinding);
        }
        ArrayList<String> tipi = new ArrayList<String>();
        List<ServiceType> l = this.registroManifest.getService().getTypes().getTypeList();
        for (int i = 0; i < l.size(); ++i) {
            org.openspcoop2.protocol.manifest.constants.ServiceBinding serviceBindingTmp = l.get(i).getBinding();
            if (serviceBindingTmp != null && (sb == null || !serviceBindingTmp.equals(sb))) continue;
            tipi.add(l.get(i).getName());
        }
        return tipi;
    }

    @Override
    public String getTipoServizioDefault(ServiceBinding serviceBinding) throws ProtocolException {
        List<String> l = this.getTipiServizi(serviceBinding);
        if (l != null && l.size() > 0) {
            return l.get(0);
        }
        return null;
    }

    @Override
    public List<String> getVersioni() throws ProtocolException {
        ArrayList<String> tipi = new ArrayList<String>();
        List<Version> l = this.registroManifest.getVersions().getVersionList();
        for (int i = 0; i < l.size(); ++i) {
            tipi.add(l.get(i).getName());
        }
        return tipi;
    }

    @Override
    public String getVersioneDefault() throws ProtocolException {
        return this.registroManifest.getVersions().getVersion(0).getName();
    }

    @Override
    public boolean isSupportato(ServiceBinding serviceBinding, ProfiloDiCollaborazione profiloCollaborazione) throws ProtocolException {
        if (profiloCollaborazione == null || serviceBinding == null) {
            throw new ProtocolException("Params not defined");
        }
        CollaborationProfile profilo = null;
        if (ServiceBinding.REST.equals((Object)serviceBinding)) {
            if (this.bindingManifest.getRest() != null) {
                profilo = new CollaborationProfile();
                if (this.bindingManifest.getRest().getProfile() != null) {
                    if (this.bindingManifest.getRest().getProfile().isOneway()) {
                        profilo.setInputOutput(false);
                        profilo.setOneway(true);
                    } else {
                        profilo.setInputOutput(true);
                        profilo.setOneway(false);
                    }
                } else {
                    profilo.setInputOutput(true);
                    profilo.setOneway(false);
                }
                profilo.setAsyncInputOutput(false);
                profilo.setPolledInputOutput(false);
            }
        } else if (this.bindingManifest.getSoap() != null) {
            profilo = this.bindingManifest.getSoap().getProfile();
        }
        switch (profiloCollaborazione) {
            case ONEWAY: {
                return profilo != null ? profilo.isOneway() : true;
            }
            case SINCRONO: {
                return profilo != null ? profilo.isInputOutput() : true;
            }
            case ASINCRONO_SIMMETRICO: {
                return profilo != null ? profilo.isAsyncInputOutput() : false;
            }
            case ASINCRONO_ASIMMETRICO: {
                return profilo != null ? profilo.isPolledInputOutput() : false;
            }
            case UNKNOWN: {
                throw new ProtocolException("Param [" + ProfiloDiCollaborazione.UNKNOWN.name() + "] not valid for this method");
            }
        }
        throw new ProtocolException("Param [" + profiloCollaborazione.getEngineValue() + "] not supported");
    }

    @Override
    public boolean isSupportato(ServiceBinding serviceBinding, FunzionalitaProtocollo funzionalitaProtocollo) throws ProtocolException {
        if (funzionalitaProtocollo == null || serviceBinding == null) {
            throw new ProtocolException("Params not defined");
        }
        Functionality funzionalita = null;
        if (ServiceBinding.REST.equals((Object)serviceBinding)) {
            if (this.bindingManifest.getRest() != null) {
                funzionalita = this.bindingManifest.getRest().getFunctionality();
            }
        } else if (this.bindingManifest.getSoap() != null) {
            funzionalita = this.bindingManifest.getSoap().getFunctionality();
        }
        switch (funzionalitaProtocollo) {
            case FILTRO_DUPLICATI: {
                return funzionalita != null ? funzionalita.isDuplicateFilter() : false;
            }
            case CONFERMA_RICEZIONE: {
                return funzionalita != null ? funzionalita.isAcknowledgement() : false;
            }
            case COLLABORAZIONE: {
                return funzionalita != null ? funzionalita.isConversationIdentifier() : false;
            }
            case RIFERIMENTO_ID_RICHIESTA: {
                return funzionalita != null ? funzionalita.isReferenceToRequestIdentifier() : false;
            }
            case CONSEGNA_IN_ORDINE: {
                return funzionalita != null ? funzionalita.isDeliveryOrder() : false;
            }
            case SCADENZA: {
                return funzionalita != null ? funzionalita.isExpiration() : false;
            }
            case MANIFEST_ATTACHMENTS: {
                return funzionalita != null ? funzionalita.getManifestAttachments() : false;
            }
        }
        throw new ProtocolException("Param [" + funzionalitaProtocollo.getEngineValue() + "] not supported");
    }

    @Override
    public boolean isIntegrationInfoRequired(TipoPdD tipoPdD, ServiceBinding serviceBinding, FunzionalitaProtocollo funzionalitaProtocollo) throws ProtocolException {
        return false;
    }

    @Override
    public InitialIdConversationType isGenerateInitialIdConversation(TipoPdD tipoPdD, FunzionalitaProtocollo funzionalitaProtocollo) throws ProtocolException {
        return InitialIdConversationType.ID_TRANSAZIONE;
    }

    @Override
    public boolean isDataPresenteInIdentificativoMessaggio() {
        return false;
    }

    @Override
    public List<BypassMustUnderstandCheck> getBypassMustUnderstandCheck() {
        ArrayList<BypassMustUnderstandCheck> list = new ArrayList<BypassMustUnderstandCheck>();
        if (this.manifest.getBinding().getSoap() != null && this.manifest.getBinding().getSoap().getSoapHeaderBypassMustUnderstand() != null && this.manifest.getBinding().getSoap().getSoapHeaderBypassMustUnderstand().sizeHeaderList() > 0) {
            for (SoapHeaderBypassMustUnderstandHeader header : this.manifest.getBinding().getSoap().getSoapHeaderBypassMustUnderstand().getHeaderList()) {
                BypassMustUnderstandCheck bypassMustUnderstandCheck = new BypassMustUnderstandCheck();
                bypassMustUnderstandCheck.setElementName(header.getLocalName());
                bypassMustUnderstandCheck.setNamespace(header.getNamespace());
                list.add(bypassMustUnderstandCheck);
            }
        }
        return list;
    }

    @Override
    public List<RemoteStoreConfig> getRemoteStoreConfig() throws ProtocolException {
        return new ArrayList<RemoteStoreConfig>();
    }
}

