/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.diagnostica;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.openspcoop2.protocol.basic.BasicComponentFactory;
import org.openspcoop2.protocol.basic.diagnostica.DiagnosticDriverUtilities;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.diagnostica.DriverMsgDiagnosticiException;
import org.openspcoop2.protocol.sdk.diagnostica.DriverMsgDiagnosticiNotFoundException;
import org.openspcoop2.protocol.sdk.diagnostica.FiltroRicercaDiagnostici;
import org.openspcoop2.protocol.sdk.diagnostica.FiltroRicercaDiagnosticiConPaginazione;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticDriver;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.StringWrapper;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.resources.GestoreJNDI;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.slf4j.Logger;

public class DiagnosticDriver
extends BasicComponentFactory
implements IDiagnosticDriver {
    DataSource datasource = null;
    String tipoDatabase = null;
    Connection con = null;
    boolean connectionOpenViaJDBCInCostructor = false;
    private static final String QUERY_PREFIX = "Query : ";
    private static final String ROWS_SUFFIX = " rows";
    public static final String IDDIAGNOSTICI = "@@@@@-----@@@@-----IDDIAGNOSTICI-DB----@@@@@-----@@@@";
    private List<String> propertiesMsgDiagnostici;

    public DiagnosticDriver(IProtocolFactory<?> factory) throws ProtocolException {
        super(factory);
    }

    public void setPropertiesMsgDiagnostici(List<String> properties) {
        this.propertiesMsgDiagnostici = properties;
    }

    public void init(String nomeDataSource, String tipoDatabase, Properties jndiProperties) throws DriverMsgDiagnosticiException {
        this.init(nomeDataSource, tipoDatabase, jndiProperties, null);
    }

    public void init(String nomeDataSource, String tipoDatabase, Properties jndiProperties, Logger log) throws DriverMsgDiagnosticiException {
        try {
            this.log = log == null ? LoggerWrapperFactory.getLogger((String)"DRIVER_DB_LOGANALIZER") : log;
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("Errore durante l'inizializzazione del logger (datasource params): " + e.getMessage(), e);
        }
        try {
            this.log.info("Inizializzo DriverLogAnalyzer...");
            GestoreJNDI gestoreJNDI = new GestoreJNDI(jndiProperties);
            this.datasource = (DataSource)gestoreJNDI.lookup(nomeDataSource);
            if (this.datasource == null) {
                throw new DriverMsgDiagnosticiException("datasource is null");
            }
            this.log.info("Inizializzo DriverLogAnalyzer terminata.");
        }
        catch (Exception e) {
            this.logError("Errore durante la ricerca del datasource (datasource params): " + e.getMessage(), e);
            throw new DriverMsgDiagnosticiException("Errore durante la ricerca del datasource (datasource params): " + e.getMessage(), e);
        }
        try {
            this.log.info("Inizializzo ISQLQueryObject (datasource params)");
            if (!TipiDatabase.isAMember((String)tipoDatabase)) {
                throw new DriverMsgDiagnosticiException("Tipo database non gestito (datasource params)");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info("Inizializzo ISQLQueryObject terminata (datasource params)");
        }
        catch (Exception e) {
            this.logError("Errore durante la ricerca del SQLQueryObject (datasource params): " + e.getMessage(), e);
            throw new DriverMsgDiagnosticiException("Errore durante la ricerca del SQLQueryObject (datasource params): " + e.getMessage(), e);
        }
    }

    public void init(DataSource dataSourceObject, String tipoDatabase) throws DriverMsgDiagnosticiException {
        this.init(dataSourceObject, tipoDatabase, null);
    }

    public void init(DataSource dataSourceObject, String tipoDatabase, Logger log) throws DriverMsgDiagnosticiException {
        try {
            this.log = log == null ? LoggerWrapperFactory.getLogger((String)"DRIVER_DB_LOGANALIZER") : log;
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("Errore durante l'inizializzazione del logger (datasource): " + e.getMessage(), e);
        }
        try {
            this.datasource = dataSourceObject;
            if (this.datasource == null) {
                throw new DriverMsgDiagnosticiException("datasource is null");
            }
        }
        catch (Exception e) {
            this.logError("Errore durante l'assegnamento del datasource (datasource): " + e.getMessage(), e);
            throw new DriverMsgDiagnosticiException("Errore durante l'assegnamento del datasource (datasource): " + e.getMessage(), e);
        }
        try {
            this.log.info("Inizializzo ISQLQueryObject (datasource)");
            if (!TipiDatabase.isAMember((String)tipoDatabase)) {
                throw new DriverMsgDiagnosticiException("Tipo database non gestito (datasource)");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info("Inizializzo ISQLQueryObject terminata (datasource)");
        }
        catch (Exception e) {
            this.logError("Errore durante la ricerca del SQLQueryObject (datasource): " + e.getMessage(), e);
            throw new DriverMsgDiagnosticiException("Errore durante la ricerca del SQLQueryObject (datasource): " + e.getMessage(), e);
        }
    }

    public void init(Connection connection, String tipoDatabase, Logger log) throws DriverMsgDiagnosticiException {
        try {
            this.log = log;
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("Errore durante l'inizializzazione del logger (connection): " + e.getMessage(), e);
        }
        this.con = connection;
        try {
            this.log.info("Inizializzo ISQLQueryObject (connection)");
            if (!TipiDatabase.isAMember((String)tipoDatabase)) {
                throw new DriverMsgDiagnosticiException("Tipo database non gestito (connection)");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info("Inizializzo ISQLQueryObject terminata (connection)");
        }
        catch (Exception e) {
            this.logError("Errore durante la ricerca del SQLQueryObject (connection): " + e.getMessage(), e);
            throw new DriverMsgDiagnosticiException("Errore durante la ricerca del SQLQueryObject (connection): " + e.getMessage(), e);
        }
    }

    public void init(String urlJDBC, String driverJDBC, String username, String password, String tipoDatabase, Logger log) throws DriverMsgDiagnosticiException {
        try {
            this.log = log;
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException("Errore durante l'inizializzazione del logger (connectionUrl params): " + e.getMessage(), e);
        }
        try {
            Class.forName(driverJDBC);
            this.con = username != null ? DriverManager.getConnection(urlJDBC, username, password) : DriverManager.getConnection(urlJDBC);
            this.connectionOpenViaJDBCInCostructor = true;
        }
        catch (Exception e) {
            this.logError("Errore durante l'inizializzazione della connessione (connectionUrl params): " + e.getMessage(), e);
            throw new DriverMsgDiagnosticiException("Errore durante l'inizializzazione della connessione (connectionUrl params): " + e.getMessage(), e);
        }
        try {
            this.log.info("Inizializzo ISQLQueryObject (connectionUrl params)");
            if (!TipiDatabase.isAMember((String)tipoDatabase)) {
                throw new DriverMsgDiagnosticiException("Tipo database non gestito (connectionUrl params)");
            }
            this.tipoDatabase = tipoDatabase;
            this.log.info("Inizializzo ISQLQueryObject terminata (connectionUrl params)");
        }
        catch (Exception e) {
            this.logError("Errore durante la ricerca del SQLQueryObject (connectionUrl params): " + e.getMessage(), e);
            throw new DriverMsgDiagnosticiException("Errore durante la ricerca del SQLQueryObject (connectionUrl params): " + e.getMessage(), e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int countMessaggiDiagnostici(FiltroRicercaDiagnostici filtro) throws DriverMsgDiagnosticiException {
        int n;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection connectionDB = null;
        boolean closeConnection = true;
        ISQLQueryObject sqlObj = null;
        int countDiagnostici = 0;
        try {
            if (this.con != null) {
                connectionDB = this.con;
                closeConnection = false;
            } else {
                connectionDB = this.datasource.getConnection();
            }
            this.checkConnection(connectionDB);
            sqlObj = DiagnosticDriverUtilities.createSQLQueryObj_countMessaggiDiagnostici(filtro, this.tipoDatabase);
            StringWrapper sqlDebug = new StringWrapper(sqlObj.createSQLQuery());
            DiagnosticDriverUtilities.setValues_countMessaggiDiagnostici(filtro, sqlDebug, 1);
            this.logDebug(QUERY_PREFIX + String.valueOf(sqlDebug));
            String sql = sqlObj.createSQLQuery();
            stmt = connectionDB.prepareStatement(sql);
            DiagnosticDriverUtilities.setValues_countMessaggiDiagnostici(filtro, stmt, 1);
            rs = stmt.executeQuery();
            if (rs.next()) {
                countDiagnostici = rs.getInt("countMsgDiagnostici");
            }
            this.logDebug("Query found " + countDiagnostici + ROWS_SUFFIX);
            n = countDiagnostici;
        }
        catch (DriverMsgDiagnosticiException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new DriverMsgDiagnosticiException(e2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stmt);
                if (!closeConnection) throw throwable;
                try {
                    JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)connectionDB, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmt);
        if (!closeConnection) return n;
        try {
            JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)connectionDB, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
            return n;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    @Override
    public List<MsgDiagnostico> getMessaggiDiagnostici(FiltroRicercaDiagnosticiConPaginazione filtro) throws DriverMsgDiagnosticiException, DriverMsgDiagnosticiNotFoundException {
        boolean closeConnection;
        Connection connectionDB;
        ResultSet rs;
        PreparedStatement stmt;
        block15: {
            stmt = null;
            rs = null;
            connectionDB = null;
            closeConnection = true;
            ISQLQueryObject sqlObj = null;
            ArrayList<MsgDiagnostico> listaMSGDiagnostici = new ArrayList<MsgDiagnostico>();
            if (this.con != null) {
                connectionDB = this.con;
                closeConnection = false;
            } else {
                connectionDB = this.datasource.getConnection();
            }
            this.checkConnection(connectionDB);
            sqlObj = DiagnosticDriverUtilities.createSQLQueryObj_searchMessaggiDiagnostici(filtro, this.tipoDatabase);
            StringWrapper sqlDebug = new StringWrapper(sqlObj.createSQLQuery());
            DiagnosticDriverUtilities.setValues_searchMessaggiDiagnostici(filtro, sqlDebug, 1);
            this.logDebug(QUERY_PREFIX + String.valueOf(sqlDebug));
            String sql = sqlObj.createSQLQuery();
            stmt = connectionDB.prepareStatement(sql);
            DiagnosticDriverUtilities.setValues_searchMessaggiDiagnostici(filtro, stmt, 1);
            rs = stmt.executeQuery();
            while (rs.next()) {
                long idMsgDiagnostico = rs.getLong("idMsgDiagnostico");
                MsgDiagnostico msgDiag = DiagnosticDriverUtilities.getMsgDiagnostico(connectionDB, this.tipoDatabase, this.log, idMsgDiagnostico, this.propertiesMsgDiagnostici);
                listaMSGDiagnostici.add(msgDiag);
            }
            rs.close();
            stmt.close();
            this.logDebug("Query found " + listaMSGDiagnostici.size() + ROWS_SUFFIX);
            if (listaMSGDiagnostici.isEmpty()) break block15;
            ArrayList<MsgDiagnostico> arrayList = listaMSGDiagnostici;
            JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stmt);
            if (closeConnection) {
                try {
                    JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)connectionDB, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return arrayList;
        }
        try {
            try {
                throw new DriverMsgDiagnosticiNotFoundException("Non sono stati trovati diagnostici che rispettano il filtro impostato");
            }
            catch (DriverMsgDiagnosticiException | DriverMsgDiagnosticiNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DriverMsgDiagnosticiException(e);
            }
        }
        catch (Throwable throwable) {
            JDBCUtilities.closeResources(rs, stmt);
            if (closeConnection) {
                try {
                    JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)connectionDB, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int deleteMessaggiDiagnostici(FiltroRicercaDiagnostici filter) throws DriverMsgDiagnosticiException {
        int n;
        PreparedStatement stmt = null;
        int deleted = 0;
        Connection connectionDB = null;
        boolean closeConnection = true;
        ISQLQueryObject sqlObj = null;
        try {
            if (this.con != null) {
                connectionDB = this.con;
                closeConnection = false;
            } else {
                connectionDB = this.datasource.getConnection();
            }
            this.checkConnection(connectionDB);
            sqlObj = DiagnosticDriverUtilities.createSQLQueryObj_deleteMessaggiDiagnostici(filter, this.tipoDatabase);
            StringWrapper sqlDebug = new StringWrapper(sqlObj.createSQLDelete());
            DiagnosticDriverUtilities.setValues_deleteMessaggiDiagnostici(filter, sqlDebug, 1);
            this.logDebug(QUERY_PREFIX + String.valueOf(sqlDebug));
            String sql = sqlObj.createSQLDelete();
            stmt = connectionDB.prepareStatement(sql);
            DiagnosticDriverUtilities.setValues_deleteMessaggiDiagnostici(filter, stmt, 1);
            deleted = stmt.executeUpdate();
            stmt.close();
            this.logDebug("Deleted " + deleted + ROWS_SUFFIX);
            n = deleted;
        }
        catch (DriverMsgDiagnosticiException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new DriverMsgDiagnosticiException(e2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(stmt);
                if (!closeConnection) throw throwable;
                try {
                    JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)connectionDB, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((PreparedStatement)stmt);
        if (!closeConnection) return n;
        try {
            JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)connectionDB, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
            return n;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    @Override
    public void close() throws DriverMsgDiagnosticiException {
        try {
            if (this.connectionOpenViaJDBCInCostructor && this.con != null && !this.con.isClosed()) {
                JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)this.con, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
            }
        }
        catch (Exception e) {
            throw new DriverMsgDiagnosticiException(e.getMessage(), e);
        }
    }

    private void checkConnection(Connection con) throws DriverMsgDiagnosticiException {
        if (con == null && this.con == null) {
            throw new DriverMsgDiagnosticiException("Connection non ottenuta dal datasource[" + String.valueOf(this.datasource) + "]");
        }
    }

    public Connection getConnection() {
        if (this.datasource == null) {
            return null;
        }
        Connection connectionDB = null;
        try {
            connectionDB = this.datasource.getConnection();
        }
        catch (Exception e) {
            return null;
        }
        return connectionDB;
    }

    public void releaseConnection(Connection connectionDB) {
        try {
            JDBCUtilities.closeConnection((Logger)BasicComponentFactory.getCheckLogger(), (Connection)connectionDB, (boolean)BasicComponentFactory.isCheckAutocommit(), (boolean)BasicComponentFactory.isCheckIsClosed());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public String getTipoDatabase() {
        return this.tipoDatabase;
    }
}

