/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.basic.registry;

import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.registry.RegistryException;
import org.openspcoop2.protocol.sdk.registry.RegistryNotFound;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.utils.PorteNamingUtils;
import org.openspcoop2.utils.transport.TransportRequestContext;
import org.slf4j.Logger;

public abstract class AbstractIdentificazionePorta {
    protected String location;
    protected String urlCompleta;
    protected boolean nomePortaURLBased = true;
    protected PorteNamingUtils porteNamingUtils;
    protected ErroreIntegrazione erroreIntegrazione;
    protected Object identificativoPorta;
    protected IProtocolFactory<?> protocolFactory = null;
    protected IRegistryReader registryReader;
    protected IConfigIntegrationReader configIntegrationReader;
    protected RequestInfo requestInfo;
    protected Logger log;

    public AbstractIdentificazionePorta(TransportRequestContext urlProtocolContext, Logger log, boolean portaUrlBased, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, IProtocolFactory<?> protocolFactory) throws ProtocolException {
        this.location = urlProtocolContext.getFunctionParameters();
        this.urlCompleta = urlProtocolContext.getUrlInvocazione_formBased();
        this.nomePortaURLBased = portaUrlBased;
        this.protocolFactory = protocolFactory;
        this.log = log;
        this.registryReader = registryReader;
        this.configIntegrationReader = configIntegrationReader;
        this.porteNamingUtils = new PorteNamingUtils(this.protocolFactory);
    }

    public AbstractIdentificazionePorta(Logger log, IProtocolFactory<?> protocolFactory, RegistroServiziManager registroServiziManager, Object configurazioneManager, RequestInfo requestInfo) throws ProtocolException {
        this.protocolFactory = protocolFactory;
        this.log = log;
        this.registryReader = this.protocolFactory.getCachedRegistryReader(registroServiziManager, requestInfo);
        this.configIntegrationReader = this.protocolFactory.getCachedConfigIntegrationReader(configurazioneManager, requestInfo);
        this.requestInfo = requestInfo;
    }

    public AbstractIdentificazionePorta(Logger log, IProtocolFactory<?> protocolFactory, IRegistryReader registryReader, IConfigIntegrationReader configIntegrationReader, RequestInfo requestInfo) throws ProtocolException {
        this.protocolFactory = protocolFactory;
        this.log = log;
        this.registryReader = registryReader;
        this.configIntegrationReader = configIntegrationReader;
        this.requestInfo = requestInfo;
    }

    protected abstract Object getIDPorta(String var1) throws RegistryNotFound, RegistryException;

    protected abstract String enrichPorta(String var1) throws RegistryException;

    public boolean process() {
        try {
            if (this.location == null || "".equals(this.location)) {
                this.erroreIntegrazione = ErroriIntegrazione.ERRORE_401_PORTA_INESISTENTE.getErrore401_PortaInesistente("nella url di invocazione non e' stata fornita il nome di una Porta");
                return false;
            }
            if (this.nomePortaURLBased) {
                String porta = new String(this.location);
                if (porta.endsWith("/")) {
                    porta = porta.substring(0, porta.length() - 1);
                }
                while (porta.contains("/")) {
                    try {
                        this.identificativoPorta = this.getIDPorta(porta);
                    }
                    catch (RegistryNotFound registryNotFound) {
                        // empty catch block
                    }
                    if (this.identificativoPorta != null) break;
                    String enrichPorta = this.enrichPorta(porta);
                    try {
                        this.identificativoPorta = this.getIDPorta(enrichPorta);
                    }
                    catch (RegistryNotFound registryNotFound) {
                        // empty catch block
                    }
                    if (this.identificativoPorta != null) break;
                    int indexCut = -1;
                    for (int i = porta.length() - 1; i >= 0; --i) {
                        if (porta.charAt(i) != '/') continue;
                        indexCut = i;
                        break;
                    }
                    porta = porta.substring(0, indexCut);
                }
                if (this.identificativoPorta == null) {
                    try {
                        this.identificativoPorta = this.getIDPorta(porta);
                    }
                    catch (RegistryNotFound enrichPorta) {
                        // empty catch block
                    }
                }
                if (this.identificativoPorta != null) {
                    // empty if block
                }
            }
            if (this.identificativoPorta == null) {
                try {
                    this.identificativoPorta = this.getIDPorta(this.location);
                }
                catch (RegistryNotFound dNotFound) {
                    this.erroreIntegrazione = ErroriIntegrazione.ERRORE_401_PORTA_INESISTENTE.getErrore401_PortaInesistente("verificare i parametri di accesso utilizzati", this.location, this.urlCompleta);
                    this.log.error(this.erroreIntegrazione.getDescrizione(this.protocolFactory) + ": " + dNotFound.getMessage(), (Throwable)dNotFound);
                    return false;
                }
                if (this.identificativoPorta != null) {
                    // empty if block
                }
            }
            if (this.identificativoPorta == null) {
                this.erroreIntegrazione = ErroriIntegrazione.ERRORE_401_PORTA_INESISTENTE.getErrore401_PortaInesistente("verificare i parametri di accesso utilizzati", this.location, this.urlCompleta);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.log.error("Identificazione porta non riuscita location[" + this.location + "] urlInvocazione[" + this.urlCompleta + "]", (Throwable)e);
            try {
                this.erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_502_IDENTIFICAZIONE_PORTA);
            }
            catch (Exception eError) {
                throw new RuntimeException(eError.getMessage(), eError);
            }
            return false;
        }
    }

    public CodiceErroreIntegrazione getCodiceErrore() {
        return this.erroreIntegrazione.getCodiceErrore();
    }

    public String getMessaggioErrore() throws ProtocolException {
        return this.erroreIntegrazione.getDescrizione(this.protocolFactory);
    }

    public ErroreIntegrazione getErroreIntegrazione() {
        return this.erroreIntegrazione;
    }
}

