/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.registry;

import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoAzione;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.id.IDPortType;
import org.openspcoop2.core.id.IDPortTypeAzione;
import org.openspcoop2.core.id.IDResource;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDScope;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.Scope;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.constants.TipiDocumentoLivelloServizio;
import org.openspcoop2.core.registry.constants.TipiDocumentoSemiformale;
import org.openspcoop2.core.registry.constants.TipiDocumentoSicurezza;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziAzioneNotFound;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziCorrelatoNotFound;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziPortTypeNotFound;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziServizioNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicerca;
import org.openspcoop2.core.registry.driver.FiltroRicercaAccordi;
import org.openspcoop2.core.registry.driver.FiltroRicercaAzioni;
import org.openspcoop2.core.registry.driver.FiltroRicercaFruizioniServizio;
import org.openspcoop2.core.registry.driver.FiltroRicercaGruppi;
import org.openspcoop2.core.registry.driver.FiltroRicercaOperations;
import org.openspcoop2.core.registry.driver.FiltroRicercaPortTypes;
import org.openspcoop2.core.registry.driver.FiltroRicercaResources;
import org.openspcoop2.core.registry.driver.FiltroRicercaRuoli;
import org.openspcoop2.core.registry.driver.FiltroRicercaScope;
import org.openspcoop2.core.registry.driver.FiltroRicercaServizi;
import org.openspcoop2.core.registry.driver.FiltroRicercaSoggetti;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.registry.rest.AccordoServizioWrapper;
import org.openspcoop2.protocol.registry.Allegati;
import org.openspcoop2.protocol.registry.CertificateCheck;
import org.openspcoop2.protocol.registry.EsitoAutorizzazioneRegistro;
import org.openspcoop2.protocol.registry.RegistroServiziReader;
import org.openspcoop2.protocol.registry.RisultatoValidazione;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.Servizio;
import org.openspcoop2.protocol.sdk.constants.InformationApiSource;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.crypt.CryptConfig;
import org.openspcoop2.utils.transport.http.IBYOKUnwrapFactory;
import org.slf4j.Logger;

public class RegistroServiziManager {
    private static RegistroServiziManager staticInstanceWithoutState = null;
    private boolean singleInstance = false;
    private RegistroServiziReader registroServiziReader = RegistroServiziReader.getInstance();
    private StateMessage state = null;
    private StateMessage responseState = null;

    private static synchronized void initStaticInstanceWithoutState() {
        if (staticInstanceWithoutState == null) {
            staticInstanceWithoutState = new RegistroServiziManager();
            RegistroServiziManager.staticInstanceWithoutState.singleInstance = true;
        }
    }

    public static RegistroServiziManager getInstance() {
        if (staticInstanceWithoutState == null) {
            if (RegistroServiziReader.getInstance() == null) {
                return new RegistroServiziManager();
            }
            RegistroServiziManager.initStaticInstanceWithoutState();
        }
        return staticInstanceWithoutState;
    }

    public static RegistroServiziManager getInstance(IState state) {
        if (state != null && state instanceof StateMessage) {
            return RegistroServiziManager.getInstance((StateMessage)state);
        }
        return RegistroServiziManager.getInstance();
    }

    public static RegistroServiziManager getInstance(StateMessage state) {
        if (state != null) {
            return new RegistroServiziManager(state);
        }
        return RegistroServiziManager.getInstance();
    }

    public static RegistroServiziManager getInstance(IState requestStateParam, IState responseStateParam) {
        StateMessage requestState = null;
        StateMessage responseState = null;
        if (requestStateParam != null && requestStateParam instanceof StateMessage) {
            requestState = (StateMessage)requestStateParam;
        }
        if (responseStateParam != null && responseStateParam instanceof StateMessage) {
            responseState = (StateMessage)responseStateParam;
        }
        if (requestState != null || responseState != null) {
            return new RegistroServiziManager(requestState, responseState);
        }
        return RegistroServiziManager.getInstance();
    }

    public static RegistroServiziManager getInstance(StateMessage requestState, StateMessage responseState) {
        if (requestState != null || responseState != null) {
            return new RegistroServiziManager(requestState, responseState);
        }
        return RegistroServiziManager.getInstance();
    }

    public StateMessage getState() {
        return this.state;
    }

    public StateMessage getResponseState() {
        return this.responseState;
    }

    public RegistroServiziManager() {
    }

    public RegistroServiziManager(StateMessage state) {
        this();
        this.state = state;
    }

    public RegistroServiziManager(StateMessage requestState, StateMessage responseState) {
        this();
        this.state = requestState;
        this.responseState = responseState;
    }

    public RegistroServiziManager refreshState(IState requestStateParam, IState responseStateParam) {
        StateMessage requestState = null;
        StateMessage responseState = null;
        if (requestStateParam != null && requestStateParam instanceof StateMessage) {
            requestState = (StateMessage)requestStateParam;
        }
        if (responseStateParam != null && responseStateParam instanceof StateMessage) {
            responseState = (StateMessage)responseStateParam;
        }
        return this.refreshState(requestState, responseState);
    }

    public RegistroServiziManager refreshState(StateMessage requestState, StateMessage responseState) {
        if (requestState == null && responseState == null) {
            return RegistroServiziManager.getInstance();
        }
        if (this.singleInstance) {
            return RegistroServiziManager.getInstance(requestState, responseState);
        }
        this.state = requestState;
        this.responseState = responseState;
        return this;
    }

    private Connection getConnection() {
        Connection c;
        if (this.state != null && (c = StateMessage.getConnection(this.state)) != null) {
            return c;
        }
        if (this.responseState != null && (c = StateMessage.getConnection(this.responseState)) != null) {
            return c;
        }
        return null;
    }

    public RegistroServiziReader getRegistroServiziReader() {
        return this.registroServiziReader;
    }

    public void isAlive(boolean controlloTotale) throws CoreException {
        this.registroServiziReader.isAlive(controlloTotale);
    }

    public void validazioneSemantica(boolean controlloTotale, boolean verificaURI, String[] tipiSoggettiValidi, String[] tipiServiziSoapValidi, String[] tipiServiziRestValidi, String[] tipiConnettoriValidi, boolean validazioneSemanticaAbilitataXML, boolean validazioneSemanticaAbilitataAltriRegistri, Logger logConsole) throws CoreException {
        this.registroServiziReader.validazioneSemantica(controlloTotale, verificaURI, tipiSoggettiValidi, tipiServiziSoapValidi, tipiServiziRestValidi, tipiConnettoriValidi, validazioneSemanticaAbilitataXML, validazioneSemanticaAbilitataAltriRegistri, logConsole);
    }

    public void setValidazioneSemanticaModificaRegistroServiziXML(boolean verificaURI, String[] tipiSoggettiValidi, String[] tipiServiziSoapValidi, String[] tipiServiziRestValidi, String[] tipiConnettoriValidi) throws CoreException {
        this.registroServiziReader.setValidazioneSemanticaModificaRegistroServiziXML(verificaURI, tipiSoggettiValidi, tipiServiziSoapValidi, tipiServiziRestValidi, tipiConnettoriValidi);
    }

    public void verificaConsistenzaRegistroServizi() throws DriverRegistroServiziException {
        this.registroServiziReader.verificaConsistenzaRegistroServizi();
    }

    public String getProfiloGestioneFruizioneServizio(IDServizio idServizio, String nomeRegistro, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && idServizio != null && idServizio.equals(requestInfo.getRequestConfig().getIdServizio(), false);
        if (useRequestInfo && requestInfo.getRequestConfig().getServizioVersioneProtocollo() != null) {
            return requestInfo.getRequestConfig().getServizioVersioneProtocollo();
        }
        String v = this.registroServiziReader.getProfiloGestioneFruizioneServizio(this.getConnection(), idServizio, nomeRegistro, requestInfo);
        if (useRequestInfo && requestInfo.getRequestConfig().getServizioVersioneProtocollo() == null) {
            requestInfo.getRequestConfig().setServizioVersioneProtocollo(v);
        }
        return v;
    }

    public String getProfiloGestioneErogazioneServizio(IDSoggetto idFruitore, IDServizio idServizio, String nomeRegistro, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        boolean useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && idFruitore != null;
        boolean useRequestInfoSoggettoFruitore = false;
        boolean useRequestInfoSoggettoErogatore = false;
        if (useRequestInfo) {
            boolean bl = useRequestInfoSoggettoFruitore = useRequestInfo && requestInfo.getRequestConfig().getIdFruitore() != null && requestInfo.getRequestConfig().getIdFruitore().equals((Object)idFruitore);
            if (useRequestInfoSoggettoFruitore) {
                if (requestInfo.getRequestConfig().getSoggettoFruitoreVersioneProtocollo() != null) {
                    return requestInfo.getRequestConfig().getSoggettoFruitoreVersioneProtocollo();
                }
            } else {
                boolean bl2 = useRequestInfoSoggettoErogatore = useRequestInfo && requestInfo.getRequestConfig().getIdServizio() != null && requestInfo.getRequestConfig().getIdServizio().getSoggettoErogatore() != null && requestInfo.getRequestConfig().getIdServizio().getSoggettoErogatore().equals((Object)idFruitore);
                if (useRequestInfoSoggettoErogatore && requestInfo.getRequestConfig().getSoggettoErogatoreVersioneProtocollo() != null) {
                    return requestInfo.getRequestConfig().getSoggettoErogatoreVersioneProtocollo();
                }
            }
        }
        String v = this.registroServiziReader.getProfiloGestioneErogazioneServizio(this.getConnection(), idFruitore, idServizio, nomeRegistro, requestInfo);
        if (useRequestInfoSoggettoFruitore) {
            if (requestInfo.getRequestConfig().getSoggettoFruitoreVersioneProtocollo() == null) {
                requestInfo.getRequestConfig().setSoggettoFruitoreVersioneProtocollo(v);
            }
        } else if (useRequestInfoSoggettoErogatore && requestInfo.getRequestConfig().getSoggettoErogatoreVersioneProtocollo() == null) {
            requestInfo.getRequestConfig().setSoggettoErogatoreVersioneProtocollo(v);
        }
        return v;
    }

    public String getProfiloGestioneSoggetto(IDSoggetto idSoggetto, String nomeRegistro, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        boolean useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && idSoggetto != null;
        boolean useRequestInfoSoggettoFruitore = false;
        boolean useRequestInfoSoggettoErogatore = false;
        if (useRequestInfo) {
            boolean bl = useRequestInfoSoggettoFruitore = useRequestInfo && requestInfo.getRequestConfig().getIdFruitore() != null && requestInfo.getRequestConfig().getIdFruitore().equals((Object)idSoggetto);
            if (useRequestInfoSoggettoFruitore) {
                if (requestInfo.getRequestConfig().getSoggettoFruitoreVersioneProtocollo() != null) {
                    return requestInfo.getRequestConfig().getSoggettoFruitoreVersioneProtocollo();
                }
            } else {
                boolean bl2 = useRequestInfoSoggettoErogatore = useRequestInfo && requestInfo.getRequestConfig().getIdServizio() != null && requestInfo.getRequestConfig().getIdServizio().getSoggettoErogatore() != null && requestInfo.getRequestConfig().getIdServizio().getSoggettoErogatore().equals((Object)idSoggetto);
                if (useRequestInfoSoggettoErogatore && requestInfo.getRequestConfig().getSoggettoErogatoreVersioneProtocollo() != null) {
                    return requestInfo.getRequestConfig().getSoggettoErogatoreVersioneProtocollo();
                }
            }
        }
        String v = this.registroServiziReader.getProfiloGestioneSoggetto(this.getConnection(), idSoggetto, nomeRegistro, requestInfo);
        if (useRequestInfoSoggettoFruitore) {
            if (requestInfo.getRequestConfig().getSoggettoFruitoreVersioneProtocollo() == null) {
                requestInfo.getRequestConfig().setSoggettoFruitoreVersioneProtocollo(v);
            }
        } else if (useRequestInfoSoggettoErogatore && requestInfo.getRequestConfig().getSoggettoErogatoreVersioneProtocollo() == null) {
            requestInfo.getRequestConfig().setSoggettoErogatoreVersioneProtocollo(v);
        }
        return v;
    }

    public Servizio getInfoServizio(IDSoggetto idSoggetto, IDServizio idService, String nomeRegistro, boolean verificaEsistenzaServizioAzioneCorrelato, boolean throwAzioneNotFound, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverRegistroServiziAzioneNotFound, DriverRegistroServiziPortTypeNotFound, DriverRegistroServiziCorrelatoNotFound {
        if (requestInfo != null && requestInfo.getRequestConfig() != null && idService != null && requestInfo.getRequestConfig().getInfoServizio() != null && requestInfo.getRequestConfig().getInfoServizio().getIDServizio().equals((Object)idService)) {
            return requestInfo.getRequestConfig().getInfoServizio();
        }
        Servizio s = this.registroServiziReader.getInfoServizio(this.getConnection(), idSoggetto, idService, nomeRegistro, verificaEsistenzaServizioAzioneCorrelato, throwAzioneNotFound);
        if (requestInfo != null && requestInfo.getRequestConfig() != null && requestInfo.getRequestConfig().getInfoServizio() == null) {
            requestInfo.getRequestConfig().setInfoServizio(s);
        }
        return s;
    }

    public Servizio getInfoServizioCorrelato(IDSoggetto idSoggetto, IDServizio idService, String nomeRegistro, boolean throwAzioneNotFound, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverRegistroServiziAzioneNotFound, DriverRegistroServiziPortTypeNotFound, DriverRegistroServiziCorrelatoNotFound {
        if (requestInfo != null && requestInfo.getRequestConfig() != null && idService != null && requestInfo.getRequestConfig().getInfoServizioCorrelato() != null && requestInfo.getRequestConfig().getInfoServizioCorrelato().getIDServizio().equals((Object)idService)) {
            return requestInfo.getRequestConfig().getInfoServizioCorrelato();
        }
        Servizio s = this.registroServiziReader.getInfoServizioCorrelato(this.getConnection(), idSoggetto, idService, nomeRegistro, throwAzioneNotFound);
        if (requestInfo != null && requestInfo.getRequestConfig() != null && requestInfo.getRequestConfig().getInfoServizioCorrelato() == null) {
            requestInfo.getRequestConfig().setInfoServizioCorrelato(s);
        }
        return s;
    }

    public Servizio getInfoServizioAzioneCorrelata(IDSoggetto idSoggetto, IDServizio idService, String nomeRegistro, boolean throwAzioneNotFound, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverRegistroServiziAzioneNotFound, DriverRegistroServiziPortTypeNotFound, DriverRegistroServiziCorrelatoNotFound {
        if (requestInfo != null && requestInfo.getRequestConfig() != null && idService != null && requestInfo.getRequestConfig().getInfoServizioAzioneCorrelata() != null && requestInfo.getRequestConfig().getInfoServizioAzioneCorrelata().getIDServizio().equals((Object)idService)) {
            return requestInfo.getRequestConfig().getInfoServizioAzioneCorrelata();
        }
        Servizio s = this.registroServiziReader.getInfoServizioAzioneCorrelata(this.getConnection(), idSoggetto, idService, nomeRegistro, throwAzioneNotFound);
        if (requestInfo != null && requestInfo.getRequestConfig() != null && requestInfo.getRequestConfig().getInfoServizioAzioneCorrelata() == null) {
            requestInfo.getRequestConfig().setInfoServizioAzioneCorrelata(s);
        }
        return s;
    }

    public Allegati getAllegati(IDServizio idASPS) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getAllegati(this.getConnection(), idASPS);
    }

    public Documento getAllegato(IDAccordo idAccordo, String nome, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getAllegato(this.getConnection(), idAccordo, nome, requestInfo);
    }

    public Documento getSpecificaSemiformale(IDAccordo idAccordo, TipiDocumentoSemiformale tipo, String nome, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getSpecificaSemiformale(this.getConnection(), idAccordo, tipo, nome, requestInfo);
    }

    public Documento getAllegato(IDServizio idASPS, String nome, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getAllegato(this.getConnection(), idASPS, nome, requestInfo);
    }

    public Documento getSpecificaSemiformale(IDServizio idASPS, TipiDocumentoSemiformale tipo, String nome, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getSpecificaSemiformale(this.getConnection(), idASPS, tipo, nome, requestInfo);
    }

    public Documento getSpecificaSicurezza(IDServizio idASPS, TipiDocumentoSicurezza tipo, String nome, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getSpecificaSicurezza(this.getConnection(), idASPS, tipo, nome, requestInfo);
    }

    public Documento getSpecificaLivelloServizio(IDServizio idASPS, TipiDocumentoLivelloServizio tipo, String nome, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getSpecificaLivelloServizio(this.getConnection(), idASPS, tipo, nome, requestInfo);
    }

    public org.openspcoop2.core.registry.wsdl.AccordoServizioWrapper getWsdlAccordoServizio(IDServizio idService, InformationApiSource infoWsdlSource, boolean buildSchemaXSD, boolean readDatiRegistro, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        org.openspcoop2.core.registry.wsdl.AccordoServizioWrapper w;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && idService != null && infoWsdlSource != null;
        if (useRequestInfo && (w = requestInfo.getRequestConfig().getAsWrapperSoap(infoWsdlSource, buildSchemaXSD, readDatiRegistro)) != null) {
            return w;
        }
        w = this.registroServiziReader.getWsdlAccordoServizio(this.getConnection(), idService, infoWsdlSource, buildSchemaXSD, readDatiRegistro);
        if (useRequestInfo && requestInfo != null && requestInfo.getRequestConfig().getAsWrapperSoap(infoWsdlSource, buildSchemaXSD, readDatiRegistro) == null) {
            requestInfo.getRequestConfig().setAsWrapperSoap(w, infoWsdlSource, buildSchemaXSD, readDatiRegistro, requestInfo.getIdTransazione());
        }
        return w;
    }

    public AccordoServizioWrapper getRestAccordoServizio(IDServizio idService, InformationApiSource infoWsdlSource, boolean buildSchemaXSD, boolean processIncludeForOpenApi, boolean readDatiRegistro, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioWrapper w;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && idService != null && infoWsdlSource != null;
        if (useRequestInfo && (w = requestInfo.getRequestConfig().getAsWrapperRest(infoWsdlSource, buildSchemaXSD, processIncludeForOpenApi, readDatiRegistro)) != null) {
            return w;
        }
        w = this.registroServiziReader.getRestAccordoServizio(this.getConnection(), idService, infoWsdlSource, buildSchemaXSD, processIncludeForOpenApi, readDatiRegistro);
        if (useRequestInfo && requestInfo != null && requestInfo.getRequestConfig().getAsWrapperRest(infoWsdlSource, buildSchemaXSD, processIncludeForOpenApi, readDatiRegistro) == null) {
            requestInfo.getRequestConfig().setAsWrapperRest(w, infoWsdlSource, buildSchemaXSD, processIncludeForOpenApi, readDatiRegistro, requestInfo.getIdTransazione());
        }
        return w;
    }

    public ServiceBinding getServiceBinding(IDServizio idService, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && idService != null;
        if (useRequestInfo && requestInfo.getRequestConfig().getServiceBinding() != null) {
            return requestInfo.getRequestConfig().getServiceBinding();
        }
        ServiceBinding serviceBinding = this.registroServiziReader.getServiceBinding(this.getConnection(), idService);
        if (useRequestInfo && requestInfo.getRequestConfig().getServiceBinding() == null) {
            requestInfo.getRequestConfig().setServiceBinding(serviceBinding);
        }
        return serviceBinding;
    }

    public EsitoAutorizzazioneRegistro isFruitoreServizioAutorizzato(String pdd, String servizioApplicativo, IDSoggetto soggetto, IDServizio servizio) throws DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverRegistroServiziServizioNotFound {
        return this.registroServiziReader.isFruitoreServizioAutorizzato(this.getConnection(), pdd, servizioApplicativo, soggetto, servizio);
    }

    public Connettore getConnettore(IDSoggetto idSoggetto, IDServizio idService, String nomeRegistro, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && idSoggetto != null && idService != null && requestInfo.getRequestConfig().getIdFruitore() != null && idSoggetto.equals((Object)requestInfo.getRequestConfig().getIdFruitore()) && requestInfo.getRequestConfig().getIdServizio() != null && idService.equals(requestInfo.getRequestConfig().getIdServizio(), false);
        if (useRequestInfo && requestInfo.getRequestConfig().getConnettoreFrutoreServizio() != null) {
            return requestInfo.getRequestConfig().getConnettoreFrutoreServizio();
        }
        Connettore c = this.registroServiziReader.getConnettore(this.getConnection(), idSoggetto, idService, nomeRegistro);
        if (useRequestInfo && requestInfo.getRequestConfig().getConnettoreFrutoreServizio() == null) {
            requestInfo.getRequestConfig().setConnettoreFrutoreServizio(c);
        }
        return c;
    }

    public Connettore getConnettore(IDSoggetto idSoggetto, String nomeRegistro, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && idSoggetto != null && requestInfo.getRequestConfig().getIdServizio() != null && requestInfo.getRequestConfig().getIdServizio().getSoggettoErogatore() != null && requestInfo.getRequestConfig().getIdServizio().getSoggettoErogatore().equals((Object)idSoggetto);
        if (useRequestInfo && requestInfo.getRequestConfig().getConnettoreSoggettoErogatore() != null) {
            return requestInfo.getRequestConfig().getConnettoreSoggettoErogatore();
        }
        Connettore c = this.registroServiziReader.getConnettore(this.getConnection(), idSoggetto, nomeRegistro);
        if (useRequestInfo && requestInfo.getRequestConfig().getConnettoreSoggettoErogatore() == null) {
            requestInfo.getRequestConfig().setConnettoreSoggettoErogatore(c);
        }
        return c;
    }

    public String getDominio(IDSoggetto idSoggetto, String nomeRegistro, IProtocolFactory<?> protocolFactory, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && idSoggetto != null;
        if (useRequestInfo) {
            if (requestInfo.getRequestConfig().getSoggettoErogatoreConfig() != null && requestInfo.getRequestConfig().getSoggettoErogatoreIdentificativoPorta() != null && idSoggetto.getTipo().equals(requestInfo.getRequestConfig().getSoggettoErogatoreConfig().getTipo()) && idSoggetto.getNome().equals(requestInfo.getRequestConfig().getSoggettoErogatoreConfig().getNome())) {
                return requestInfo.getRequestConfig().getSoggettoErogatoreIdentificativoPorta();
            }
            if (requestInfo.getRequestConfig().getSoggettoFruitoreConfig() != null && requestInfo.getRequestConfig().getSoggettoFruitoreIdentificativoPorta() != null && idSoggetto.getTipo().equals(requestInfo.getRequestConfig().getSoggettoFruitoreConfig().getTipo()) && idSoggetto.getNome().equals(requestInfo.getRequestConfig().getSoggettoFruitoreConfig().getNome())) {
                return requestInfo.getRequestConfig().getSoggettoFruitoreIdentificativoPorta();
            }
        }
        if (requestInfo != null && requestInfo.getRequestThreadContext() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo().getSoggettoFruitoreConfig() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo().getSoggettoFruitoreIdentificativoPorta() != null && idSoggetto.getTipo().equals(requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo().getSoggettoFruitoreConfig().getTipo()) && idSoggetto.getNome().equals(requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo().getSoggettoFruitoreConfig().getNome())) {
            return requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo().getSoggettoFruitoreIdentificativoPorta();
        }
        if (requestInfo != null && requestInfo.getRequestThreadContext() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo().getSoggettoFruitoreConfig() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo().getSoggettoFruitoreIdentificativoPorta() != null && idSoggetto.getTipo().equals(requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo().getSoggettoFruitoreConfig().getTipo()) && idSoggetto.getNome().equals(requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo().getSoggettoFruitoreConfig().getNome())) {
            return requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo().getSoggettoFruitoreIdentificativoPorta();
        }
        return this.registroServiziReader.getDominio(this.getConnection(), idSoggetto, nomeRegistro, protocolFactory);
    }

    public String getImplementazionePdD(IDSoggetto idSoggetto, String nomeRegistro, RequestInfo requestInfo) throws DriverRegistroServiziException {
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && idSoggetto != null;
        if (useRequestInfo) {
            if (requestInfo.getRequestConfig().getSoggettoErogatoreConfig() != null && requestInfo.getRequestConfig().getSoggettoErogatoreImplementazionePdd() != null && idSoggetto.getTipo().equals(requestInfo.getRequestConfig().getSoggettoErogatoreConfig().getTipo()) && idSoggetto.getNome().equals(requestInfo.getRequestConfig().getSoggettoErogatoreConfig().getNome())) {
                return requestInfo.getRequestConfig().getSoggettoErogatoreImplementazionePdd();
            }
            if (requestInfo.getRequestConfig().getSoggettoFruitoreConfig() != null && requestInfo.getRequestConfig().getSoggettoFruitoreImplementazionePdd() != null && idSoggetto.getTipo().equals(requestInfo.getRequestConfig().getSoggettoFruitoreConfig().getTipo()) && idSoggetto.getNome().equals(requestInfo.getRequestConfig().getSoggettoFruitoreConfig().getNome())) {
                return requestInfo.getRequestConfig().getSoggettoFruitoreImplementazionePdd();
            }
        }
        if (requestInfo != null && requestInfo.getRequestThreadContext() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo().getSoggettoFruitoreConfig() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo().getSoggettoFruitoreImplementazionePdd() != null && idSoggetto.getTipo().equals(requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo().getSoggettoFruitoreConfig().getTipo()) && idSoggetto.getNome().equals(requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo().getSoggettoFruitoreConfig().getNome())) {
            return requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo().getSoggettoFruitoreImplementazionePdd();
        }
        if (requestInfo != null && requestInfo.getRequestThreadContext() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo().getSoggettoFruitoreConfig() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo().getSoggettoFruitoreImplementazionePdd() != null && idSoggetto.getTipo().equals(requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo().getSoggettoFruitoreConfig().getTipo()) && idSoggetto.getNome().equals(requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo().getSoggettoFruitoreConfig().getNome())) {
            return requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo().getSoggettoFruitoreImplementazionePdd();
        }
        return this.registroServiziReader.getImplementazionePdD(this.getConnection(), idSoggetto, nomeRegistro);
    }

    public String getIdPortaDominio(IDSoggetto idSoggetto, String nomeRegistro, RequestInfo requestInfo) throws DriverRegistroServiziException {
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && idSoggetto != null;
        if (useRequestInfo) {
            if (requestInfo.getRequestConfig().getSoggettoErogatoreConfig() != null && requestInfo.getRequestConfig().getSoggettoErogatorePddReaded() != null && requestInfo.getRequestConfig().getSoggettoErogatorePddReaded().booleanValue() && idSoggetto.getTipo().equals(requestInfo.getRequestConfig().getSoggettoErogatoreConfig().getTipo()) && idSoggetto.getNome().equals(requestInfo.getRequestConfig().getSoggettoErogatoreConfig().getNome())) {
                return requestInfo.getRequestConfig().getSoggettoErogatorePdd() != null ? requestInfo.getRequestConfig().getSoggettoErogatorePdd().getNome() : null;
            }
            if (requestInfo.getRequestConfig().getSoggettoFruitoreConfig() != null && requestInfo.getRequestConfig().getSoggettoFruitorePddReaded() != null && requestInfo.getRequestConfig().getSoggettoFruitorePddReaded().booleanValue() && idSoggetto.getTipo().equals(requestInfo.getRequestConfig().getSoggettoFruitoreConfig().getTipo()) && idSoggetto.getNome().equals(requestInfo.getRequestConfig().getSoggettoFruitoreConfig().getNome())) {
                return requestInfo.getRequestConfig().getSoggettoFruitorePdd() != null ? requestInfo.getRequestConfig().getSoggettoFruitorePdd().getNome() : null;
            }
        }
        if (requestInfo != null && requestInfo.getRequestThreadContext() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo().getSoggettoFruitoreConfig() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo().getSoggettoFruitorePddReaded() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo().getSoggettoFruitorePddReaded().booleanValue() && idSoggetto.getTipo().equals(requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo().getSoggettoFruitoreConfig().getTipo()) && idSoggetto.getNome().equals(requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo().getSoggettoFruitoreConfig().getNome())) {
            return requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo().getSoggettoFruitorePdd() != null ? requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo().getSoggettoFruitorePdd().getNome() : null;
        }
        if (requestInfo != null && requestInfo.getRequestThreadContext() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo().getSoggettoFruitoreConfig() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo().getSoggettoFruitorePddReaded() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo().getSoggettoFruitorePddReaded().booleanValue() && idSoggetto.getTipo().equals(requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo().getSoggettoFruitoreConfig().getTipo()) && idSoggetto.getNome().equals(requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo().getSoggettoFruitoreConfig().getNome())) {
            return requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo().getSoggettoFruitorePdd() != null ? requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo().getSoggettoFruitorePdd().getNome() : null;
        }
        return this.registroServiziReader.getIdPortaDominio(this.getConnection(), idSoggetto, nomeRegistro);
    }

    public RisultatoValidazione validaServizio(IDSoggetto soggettoFruitore, IDServizio idService, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziPortTypeNotFound {
        return this.registroServiziReader.validaServizio(this.getConnection(), soggettoFruitore, idService, nomeRegistro);
    }

    public Soggetto getSoggettoByCredenzialiBasic(String username, String password, CryptConfig cryptConfig, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getSoggettoByCredenzialiBasic(this.getConnection(), username, password, cryptConfig, nomeRegistro);
    }

    public Soggetto getSoggettoByCredenzialiApiKey(String username, String password, boolean appId, CryptConfig cryptConfig, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getSoggettoByCredenzialiApiKey(this.getConnection(), username, password, appId, cryptConfig, nomeRegistro);
    }

    public Soggetto getSoggettoByCredenzialiSsl(String subject, String issuer, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getSoggettoByCredenzialiSsl(this.getConnection(), subject, issuer, nomeRegistro);
    }

    public Soggetto getSoggettoByCredenzialiSsl(CertificateInfo certificate, boolean strictVerifier, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getSoggettoByCredenzialiSsl(this.getConnection(), certificate, strictVerifier, nomeRegistro);
    }

    public Soggetto getSoggettoByCredenzialiPrincipal(String principal, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getSoggettoByCredenzialiPrincipal(this.getConnection(), principal, nomeRegistro);
    }

    public IDSoggetto getIdSoggettoByCredenzialiBasic(String username, String password, CryptConfig cryptConfig, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getIdSoggettoByCredenzialiBasic(this.getConnection(), username, password, cryptConfig, nomeRegistro);
    }

    public IDSoggetto getIdSoggettoByCredenzialiApiKey(String username, String password, boolean appId, CryptConfig cryptConfig, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getIdSoggettoByCredenzialiApiKey(this.getConnection(), username, password, appId, cryptConfig, nomeRegistro);
    }

    public IDSoggetto getIdSoggettoByCredenzialiSsl(String subject, String issuer, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getIdSoggettoByCredenzialiSsl(this.getConnection(), subject, issuer, nomeRegistro);
    }

    public IDSoggetto getIdSoggettoByCredenzialiSsl(CertificateInfo certificate, boolean strictVerifier, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getIdSoggettoByCredenzialiSsl(this.getConnection(), certificate, strictVerifier, nomeRegistro);
    }

    public IDSoggetto getIdSoggettoByCredenzialiPrincipal(String principal, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getIdSoggettoByCredenzialiPrincipal(this.getConnection(), principal, nomeRegistro);
    }

    public Map<String, String> getProprietaConfigurazione(Soggetto soggetto) throws DriverRegistroServiziException {
        return this.registroServiziReader.getProprietaConfigurazione(soggetto);
    }

    public CertificateCheck checkCertificatoSoggettoWithoutCache(long idSoggetto, int sogliaWarningGiorni, boolean addCertificateDetails, String separator, String newLine) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.checkCertificatoSoggetto(null, false, idSoggetto, sogliaWarningGiorni, addCertificateDetails, separator, newLine);
    }

    public CertificateCheck checkCertificatoSoggettoWithoutCache(IDSoggetto idSoggetto, int sogliaWarningGiorni, boolean addCertificateDetails, String separator, String newLine) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.checkCertificatoSoggetto(null, false, idSoggetto, sogliaWarningGiorni, addCertificateDetails, separator, newLine);
    }

    public CertificateCheck checkCertificatiConnettoreHttpsByIdWithoutCache(long idConnettore, int sogliaWarningGiorni, IBYOKUnwrapFactory byokUnwrapFactory, boolean addCertificateDetails, String separator, String newLine) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.checkCertificatiConnettoreHttpsById(null, false, idConnettore, sogliaWarningGiorni, byokUnwrapFactory, addCertificateDetails, separator, newLine);
    }

    public CertificateCheck checkCertificatiModIErogazioneByIdWithoutCache(long idErogazione, int sogliaWarningGiorni, IBYOKUnwrapFactory byokUnwrapFactory, boolean addCertificateDetails, String separator, String newLine) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.checkCertificatiModIErogazioneById(null, false, idErogazione, sogliaWarningGiorni, byokUnwrapFactory, addCertificateDetails, separator, newLine);
    }

    public CertificateCheck checkCertificatiModIFruizioneByIdWithoutCache(long idFruizione, int sogliaWarningGiorni, IBYOKUnwrapFactory byokUnwrapFactory, boolean addCertificateDetails, String separator, String newLine) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.checkCertificatiModIFruizioneById(null, false, idFruizione, sogliaWarningGiorni, byokUnwrapFactory, addCertificateDetails, separator, newLine);
    }

    public PortaDominio getPortaDominio(String nome, String nomeRegistro, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && nome != null;
        if (useRequestInfo) {
            if (requestInfo.getRequestConfig().getSoggettoErogatorePdd() != null && nome.equals(requestInfo.getRequestConfig().getSoggettoErogatorePdd().getNome())) {
                return requestInfo.getRequestConfig().getSoggettoErogatorePdd();
            }
            if (requestInfo.getRequestConfig().getSoggettoFruitorePdd() != null && nome.equals(requestInfo.getRequestConfig().getSoggettoFruitorePdd().getNome())) {
                return requestInfo.getRequestConfig().getSoggettoFruitorePdd();
            }
        }
        if (requestInfo != null && requestInfo.getRequestThreadContext() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo().getSoggettoFruitorePdd() != null && nome != null && nome.equals(requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo().getSoggettoFruitorePdd().getNome())) {
            return requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo().getSoggettoFruitorePdd();
        }
        if (requestInfo != null && requestInfo.getRequestThreadContext() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo().getSoggettoFruitorePdd() != null && nome != null && nome.equals(requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo().getSoggettoFruitorePdd().getNome())) {
            return requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo().getSoggettoFruitorePdd();
        }
        return this.registroServiziReader.getPortaDominio(this.getConnection(), nome, nomeRegistro);
    }

    public Ruolo getRuolo(String nome, String nomeRegistro, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Ruolo ruolo;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && nome != null;
        if (useRequestInfo && (ruolo = requestInfo.getRequestConfig().getRuolo(nome)) != null) {
            return ruolo;
        }
        Ruolo r = this.registroServiziReader.getRuolo(this.getConnection(), nome, nomeRegistro);
        if (useRequestInfo && requestInfo != null) {
            requestInfo.getRequestConfig().addRuolo(nome, r, requestInfo.getIdTransazione());
        }
        return r;
    }

    public Ruolo getRuolo(IDRuolo idRuolo, String nomeRegistro, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getRuolo(idRuolo.getNome(), nomeRegistro, requestInfo);
    }

    public Scope getScope(String nome, String nomeRegistro, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Scope scope;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && nome != null;
        if (useRequestInfo && (scope = requestInfo.getRequestConfig().getScope(nome)) != null) {
            return scope;
        }
        Scope s = this.registroServiziReader.getScope(this.getConnection(), nome, nomeRegistro);
        if (useRequestInfo && requestInfo != null) {
            requestInfo.getRequestConfig().addScope(nome, s, requestInfo.getIdTransazione());
        }
        return s;
    }

    public Scope getScope(IDScope idScope, String nomeRegistro, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getScope(idScope.getNome(), nomeRegistro, requestInfo);
    }

    public Soggetto getSoggetto(IDSoggetto idSoggetto, String nomeRegistro, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Soggetto soggetto = RegistroServiziManager._getSoggettoFromRequestInfo(idSoggetto, requestInfo);
        if (soggetto != null) {
            return soggetto;
        }
        return this.registroServiziReader.getSoggetto(this.getConnection(), idSoggetto, nomeRegistro);
    }

    static Soggetto _getSoggettoFromRequestInfo(IDSoggetto idSoggetto, RequestInfo requestInfo) {
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && idSoggetto != null;
        if (useRequestInfo) {
            if (requestInfo.getRequestConfig().getSoggettoErogatoreRegistry() != null && idSoggetto.getTipo().equals(requestInfo.getRequestConfig().getSoggettoErogatoreRegistry().getTipo()) && idSoggetto.getNome().equals(requestInfo.getRequestConfig().getSoggettoErogatoreRegistry().getNome())) {
                return requestInfo.getRequestConfig().getSoggettoErogatoreRegistry();
            }
            if (requestInfo.getRequestConfig().getSoggettoFruitoreRegistry() != null && idSoggetto.getTipo().equals(requestInfo.getRequestConfig().getSoggettoFruitoreRegistry().getTipo()) && idSoggetto.getNome().equals(requestInfo.getRequestConfig().getSoggettoFruitoreRegistry().getNome())) {
                return requestInfo.getRequestConfig().getSoggettoFruitoreRegistry();
            }
        }
        if (requestInfo != null && requestInfo.getRequestThreadContext() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo().getSoggettoFruitoreRegistry() != null && idSoggetto != null && idSoggetto.getTipo().equals(requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo().getSoggettoFruitoreRegistry().getTipo()) && idSoggetto.getNome().equals(requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo().getSoggettoFruitoreRegistry().getNome())) {
            return requestInfo.getRequestThreadContext().getRequestFruitoreTrasportoInfo().getSoggettoFruitoreRegistry();
        }
        if (requestInfo != null && requestInfo.getRequestThreadContext() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo() != null && requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo().getSoggettoFruitoreRegistry() != null && idSoggetto != null && idSoggetto.getTipo().equals(requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo().getSoggettoFruitoreRegistry().getTipo()) && idSoggetto.getNome().equals(requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo().getSoggettoFruitoreRegistry().getNome())) {
            return requestInfo.getRequestThreadContext().getRequestFruitoreTokenInfo().getSoggettoFruitoreRegistry();
        }
        return null;
    }

    public AccordoServizioParteComune getAccordoServizioParteComune(IDAccordo idAccordo, String nomeRegistro, Boolean readContenutiAllegati, Boolean readDatiRegistro, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String uriParam;
        IDAccordoFactory idAccordoFactory;
        String uriAspc;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = !(requestInfo == null || requestInfo.getRequestConfig() == null || idAccordo == null || readContenutiAllegati != null && readContenutiAllegati != false || readDatiRegistro != null && readDatiRegistro != false);
        if (useRequestInfo && requestInfo.getRequestConfig().getAspc() != null && (uriAspc = (idAccordoFactory = IDAccordoFactory.getInstance()).getUriFromAccordo(requestInfo.getRequestConfig().getAspc())).equals(uriParam = idAccordoFactory.getUriFromIDAccordo(idAccordo))) {
            return requestInfo.getRequestConfig().getAspc();
        }
        AccordoServizioParteComune aspc = this.registroServiziReader.getAccordoServizioParteComune(this.getConnection(), idAccordo, readContenutiAllegati, readDatiRegistro, nomeRegistro);
        if (useRequestInfo && requestInfo.getRequestConfig().getAspc() == null) {
            requestInfo.getRequestConfig().setAspc(aspc);
        }
        return aspc;
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idServizio, String nomeRegistro, Boolean readContenutiAllegati, RequestInfo requestInfo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String uriParam;
        IDServizioFactory idServizioFactory;
        String uriAsps;
        boolean useRequestInfo;
        boolean bl = useRequestInfo = requestInfo != null && requestInfo.getRequestConfig() != null && idServizio != null && (readContenutiAllegati == null || readContenutiAllegati == false);
        if (useRequestInfo && requestInfo.getRequestConfig().getAsps() != null && (uriAsps = (idServizioFactory = IDServizioFactory.getInstance()).getUriFromAccordo(requestInfo.getRequestConfig().getAsps())).equals(uriParam = idServizioFactory.getUriFromIDServizio(idServizio))) {
            return requestInfo.getRequestConfig().getAsps();
        }
        AccordoServizioParteSpecifica asps = this.registroServiziReader.getAccordoServizioParteSpecifica(this.getConnection(), idServizio, readContenutiAllegati, nomeRegistro);
        if (useRequestInfo && requestInfo.getRequestConfig().getAsps() == null) {
            requestInfo.getRequestConfig().setAsps(asps);
        }
        return asps;
    }

    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo, String nomeRegistro, Boolean readContenutiAllegati) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getAccordoCooperazione(this.getConnection(), idAccordo, readContenutiAllegati, nomeRegistro);
    }

    public List<String> getAllIdPorteDominio(FiltroRicerca filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getAllIdPorteDominio(this.getConnection(), filtroRicerca, nomeRegistro);
    }

    public List<IDGruppo> getAllIdGruppi(FiltroRicercaGruppi filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getAllIdGruppi(this.getConnection(), filtroRicerca, nomeRegistro);
    }

    public List<IDRuolo> getAllIdRuoli(FiltroRicercaRuoli filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getAllIdRuoli(this.getConnection(), filtroRicerca, nomeRegistro);
    }

    public List<IDScope> getAllIdScope(FiltroRicercaScope filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getAllIdScope(this.getConnection(), filtroRicerca, nomeRegistro);
    }

    public List<IDSoggetto> getAllIdSoggetti(FiltroRicercaSoggetti filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getAllIdSoggetti(this.getConnection(), filtroRicerca, nomeRegistro);
    }

    public List<IDAccordoCooperazione> getAllIdAccordiCooperazione(FiltroRicercaAccordi filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getAllIdAccordiCooperazione(this.getConnection(), filtroRicerca, nomeRegistro);
    }

    public List<IDAccordo> getAllIdAccordiServizioParteComune(FiltroRicercaAccordi filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getAllIdAccordiServizioParteComune(this.getConnection(), filtroRicerca, nomeRegistro);
    }

    public List<IDPortType> getAllIdPortType(FiltroRicercaPortTypes filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getAllIdPortType(this.getConnection(), filtroRicerca, nomeRegistro);
    }

    public List<IDPortTypeAzione> getAllIdAzionePortType(FiltroRicercaOperations filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getAllIdAzionePortType(this.getConnection(), filtroRicerca, nomeRegistro);
    }

    public List<IDAccordoAzione> getAllIdAzioneAccordo(FiltroRicercaAzioni filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getAllIdAzioneAccordo(this.getConnection(), filtroRicerca, nomeRegistro);
    }

    public List<IDResource> getAllIdResource(FiltroRicercaResources filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getAllIdResource(this.getConnection(), filtroRicerca, nomeRegistro);
    }

    public List<IDServizio> getAllIdServizi(FiltroRicercaServizi filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getAllIdServizi(this.getConnection(), filtroRicerca, nomeRegistro);
    }

    public List<IDFruizione> getAllIdFruizioniServizio(FiltroRicercaFruizioniServizio filtroRicerca, String nomeRegistro) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getAllIdFruizioniServizio(this.getConnection(), filtroRicerca, nomeRegistro);
    }

    public Serializable getGenericObject(String keyObject) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.getGenericObject(keyObject);
    }

    public Serializable pushGenericObject(String keyObject, Serializable object) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.registroServiziReader.pushGenericObject(keyObject, object);
    }
}

