/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk.archive;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.ArchiveIdCorrelazione;
import org.openspcoop2.protocol.sdk.archive.IArchiveObject;

public class ArchiveAccordoCooperazione
implements IArchiveObject {
    private IDSoggetto idSoggettoReferente;
    private IDAccordoCooperazione idAccordoCooperazione;
    private List<IDSoggetto> idSoggettiPartecipanti = new ArrayList<IDSoggetto>();
    private AccordoCooperazione accordoCooperazione;
    private ArchiveIdCorrelazione idCorrelazione;

    public static String buildKey(String tipoSoggetto, String nomeSoggetto, String nomeAccordo, Integer versione) throws ProtocolException {
        if (tipoSoggetto == null) {
            throw new ProtocolException("tipoSoggetto non fornito");
        }
        if (nomeSoggetto == null) {
            throw new ProtocolException("nomeSoggetto non fornito");
        }
        if (nomeAccordo == null) {
            throw new ProtocolException("nomeAccordo non fornito");
        }
        if (versione == null) {
            throw new ProtocolException("versione non fornita");
        }
        StringBuilder bf = new StringBuilder();
        bf.append("AccordoCooperazione_");
        bf.append(tipoSoggetto);
        bf.append("/");
        bf.append(nomeSoggetto);
        bf.append("_");
        bf.append(nomeAccordo);
        bf.append("_");
        bf.append(versione);
        return bf.toString();
    }

    @Override
    public String key() throws ProtocolException {
        String tipoSoggetto = "-";
        String nomeSoggetto = "-";
        String nomeAccordo = this.accordoCooperazione.getNome();
        Integer versione = null;
        if (this.accordoCooperazione.getSoggettoReferente() != null) {
            if (this.accordoCooperazione.getSoggettoReferente().getTipo() != null) {
                tipoSoggetto = this.accordoCooperazione.getSoggettoReferente().getTipo();
            }
            if (this.accordoCooperazione.getSoggettoReferente().getNome() != null) {
                nomeSoggetto = this.accordoCooperazione.getSoggettoReferente().getNome();
            }
        }
        if (this.accordoCooperazione.getVersione() != null) {
            versione = this.accordoCooperazione.getVersione();
        }
        return ArchiveAccordoCooperazione.buildKey(tipoSoggetto, nomeSoggetto, nomeAccordo, versione);
    }

    public ArchiveAccordoCooperazione(IDSoggetto idSoggettoProprietario, AccordoCooperazione accordoCooperazione, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        this(ArchiveAccordoCooperazione.injectProprietario(idSoggettoProprietario, accordoCooperazione), idCorrelazione, false);
    }

    public ArchiveAccordoCooperazione(IDSoggetto idSoggettoProprietario, AccordoCooperazione accordoCooperazione, ArchiveIdCorrelazione idCorrelazione, boolean informationMissingManagementEnabled) throws ProtocolException {
        this(ArchiveAccordoCooperazione.injectProprietario(idSoggettoProprietario, accordoCooperazione), idCorrelazione, informationMissingManagementEnabled);
    }

    public ArchiveAccordoCooperazione(AccordoCooperazione accordoCooperazione, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        this(accordoCooperazione, idCorrelazione, false);
    }

    public ArchiveAccordoCooperazione(AccordoCooperazione accordoCooperazione, ArchiveIdCorrelazione idCorrelazione, boolean informationMissingManagementEnabled) throws ProtocolException {
        this.update(accordoCooperazione, informationMissingManagementEnabled);
        this.idCorrelazione = idCorrelazione;
    }

    private static AccordoCooperazione injectProprietario(IDSoggetto idSoggettoProprietario, AccordoCooperazione accordoCooperazione) throws ProtocolException {
        if (accordoCooperazione == null) {
            throw new ProtocolException("AccordoCooperazione non fornito");
        }
        if (idSoggettoProprietario == null) {
            throw new ProtocolException("idSoggettoProprietario non fornito");
        }
        if (idSoggettoProprietario.getTipo() == null) {
            throw new ProtocolException("idSoggettoProprietario.tipo non definito");
        }
        if (idSoggettoProprietario.getNome() == null) {
            throw new ProtocolException("idSoggettoProprietario.nome non definito");
        }
        IdSoggetto soggettoReferente = new IdSoggetto();
        soggettoReferente.setTipo(idSoggettoProprietario.getTipo());
        soggettoReferente.setNome(idSoggettoProprietario.getNome());
        accordoCooperazione.setSoggettoReferente(soggettoReferente);
        return accordoCooperazione;
    }

    public void update() throws ProtocolException {
        this.update(this.accordoCooperazione, false);
    }

    public void update(AccordoCooperazione accordoCooperazione) throws ProtocolException {
        this.update(accordoCooperazione, false);
    }

    public void update(AccordoCooperazione accordoCooperazione, boolean informationMissingManagementEnabled) throws ProtocolException {
        if (accordoCooperazione == null) {
            throw new ProtocolException("AccordoCooperazione non fornito");
        }
        if (accordoCooperazione.getNome() == null) {
            throw new ProtocolException("AccordoCooperazione.nome non definito");
        }
        this.accordoCooperazione = accordoCooperazione;
        if (!informationMissingManagementEnabled) {
            if (accordoCooperazione.getVersione() == null) {
                throw new ProtocolException("AccordoCooperazione.versione non definito");
            }
            if (accordoCooperazione.getSoggettoReferente() == null) {
                throw new ProtocolException("AccordoCooperazione.soggettoReferente non definito");
            }
            if (accordoCooperazione.getSoggettoReferente().getTipo() == null) {
                throw new ProtocolException("AccordoCooperazione.soggettoReferente.tipo non definito");
            }
            if (accordoCooperazione.getSoggettoReferente().getNome() == null) {
                throw new ProtocolException("AccordoCooperazione.soggettoReferente.nome non definito");
            }
            this.idSoggettoReferente = new IDSoggetto(accordoCooperazione.getSoggettoReferente().getTipo(), accordoCooperazione.getSoggettoReferente().getNome());
            try {
                this.idAccordoCooperazione = IDAccordoCooperazioneFactory.getInstance().getIDAccordoFromAccordo(accordoCooperazione);
            }
            catch (Exception e) {
                throw new ProtocolException(e.getMessage(), e);
            }
            if (accordoCooperazione.getElencoPartecipanti() != null) {
                for (int i = 0; i < accordoCooperazione.getElencoPartecipanti().sizeSoggettoPartecipanteList(); ++i) {
                    IdSoggetto partecipante = accordoCooperazione.getElencoPartecipanti().getSoggettoPartecipante(i);
                    if (partecipante == null) {
                        throw new ProtocolException("AccordoCooperazione.elencoPartecipanti[" + i + "] non definito");
                    }
                    if (partecipante.getTipo() == null) {
                        throw new ProtocolException("AccordoCooperazione.elencoPartecipanti[" + i + "].tipo non definito");
                    }
                    if (partecipante.getNome() == null) {
                        throw new ProtocolException("AccordoCooperazione.elencoPartecipanti[" + i + "].nome non definito");
                    }
                    IDSoggetto idSoggettoPartecipante = new IDSoggetto(partecipante.getTipo(), partecipante.getNome());
                    this.idSoggettiPartecipanti.add(idSoggettoPartecipante);
                }
            }
        }
    }

    public IDSoggetto getIdSoggettoReferente() {
        return this.idSoggettoReferente;
    }

    public IDAccordoCooperazione getIdAccordoCooperazione() {
        return this.idAccordoCooperazione;
    }

    public List<IDSoggetto> getIdSoggettiPartecipanti() {
        return this.idSoggettiPartecipanti;
    }

    public AccordoCooperazione getAccordoCooperazione() {
        return this.accordoCooperazione;
    }

    public ArchiveIdCorrelazione getIdCorrelazione() {
        return this.idCorrelazione;
    }
}

