/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk.archive;

import java.util.List;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.ArchiveIdCorrelazione;
import org.openspcoop2.protocol.sdk.archive.IArchiveObject;

public class ArchiveFruitore
implements IArchiveObject {
    private IDSoggetto idSoggettoFruitore;
    private IDServizio idAccordoServizioParteSpecifica;
    private Fruitore fruitore;
    private List<MappingFruizionePortaDelegata> mappingPorteDelegateAssociate;
    private ArchiveIdCorrelazione idCorrelazione;

    public static String buildKey(String tipoSoggettoFruitore, String nomeSoggettoFruitore, String tipoSoggettoErogatore, String nomeSoggettoErogatore, String tipoServizio, String nomeServizio, Integer versione) throws ProtocolException {
        if (tipoSoggettoFruitore == null) {
            throw new ProtocolException("tipoSoggettoFruitore non fornito");
        }
        if (nomeSoggettoFruitore == null) {
            throw new ProtocolException("nomeSoggettoFruitore non fornito");
        }
        if (tipoSoggettoErogatore == null) {
            throw new ProtocolException("tipoSoggettoErogatore non fornito");
        }
        if (nomeSoggettoErogatore == null) {
            throw new ProtocolException("nomeSoggettoErogatore non fornito");
        }
        if (tipoServizio == null) {
            throw new ProtocolException("tipoServizio non fornito");
        }
        if (nomeServizio == null) {
            throw new ProtocolException("nomeServizio non fornito");
        }
        if (versione == null) {
            throw new ProtocolException("versioneServizio non fornito");
        }
        StringBuilder bf = new StringBuilder();
        bf.append("Fruitore_");
        bf.append(tipoSoggettoFruitore);
        bf.append("/");
        bf.append(nomeSoggettoFruitore);
        bf.append("_AccordoServizioParteSpecifica_");
        bf.append(tipoSoggettoErogatore);
        bf.append("/");
        bf.append(nomeSoggettoErogatore);
        bf.append("_");
        bf.append(tipoServizio);
        bf.append("/");
        bf.append(nomeServizio);
        bf.append("_");
        bf.append(versione);
        return bf.toString();
    }

    @Override
    public String key() throws ProtocolException {
        return ArchiveFruitore.buildKey(this.idSoggettoFruitore.getTipo(), this.idSoggettoFruitore.getNome(), this.idAccordoServizioParteSpecifica.getSoggettoErogatore().getTipo(), this.idAccordoServizioParteSpecifica.getSoggettoErogatore().getNome(), this.idAccordoServizioParteSpecifica.getTipo(), this.idAccordoServizioParteSpecifica.getNome(), this.idAccordoServizioParteSpecifica.getVersione());
    }

    public List<MappingFruizionePortaDelegata> getMappingPorteDelegateAssociate() {
        return this.mappingPorteDelegateAssociate;
    }

    public void setMappingPorteDelegateAssociate(List<MappingFruizionePortaDelegata> mappingPorteDelegateAssociate) {
        this.mappingPorteDelegateAssociate = mappingPorteDelegateAssociate;
    }

    public ArchiveFruitore(IDServizio idAccordoServizioParteSpecifica, Fruitore fruitore, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        this(idAccordoServizioParteSpecifica, fruitore, idCorrelazione, false);
    }

    public ArchiveFruitore(IDServizio idAccordoServizioParteSpecifica, Fruitore fruitore, ArchiveIdCorrelazione idCorrelazione, boolean informationMissingManagementEnabled) throws ProtocolException {
        this.update(idAccordoServizioParteSpecifica, fruitore, informationMissingManagementEnabled);
        this.idCorrelazione = idCorrelazione;
    }

    public void update() throws ProtocolException {
        this.update(this.idAccordoServizioParteSpecifica, this.fruitore, false);
    }

    public void update(IDServizio idAccordoServizioParteSpecifica, Fruitore fruitore) throws ProtocolException {
        this.update(idAccordoServizioParteSpecifica, fruitore, false);
    }

    public void update(IDServizio idAccordoServizioParteSpecifica, Fruitore fruitore, boolean informationMissingManagementEnabled) throws ProtocolException {
        if (fruitore == null) {
            throw new ProtocolException("fruitore non definito");
        }
        if (fruitore.getTipo() == null) {
            throw new ProtocolException("fruitore.tipo non definito");
        }
        if (fruitore.getNome() == null) {
            throw new ProtocolException("fruitore.nome non definito");
        }
        this.idSoggettoFruitore = new IDSoggetto(fruitore.getTipo(), fruitore.getNome());
        this.fruitore = fruitore;
        if (idAccordoServizioParteSpecifica == null) {
            throw new ProtocolException("idAccordoServizioParteSpecifica non fornito");
        }
        if (idAccordoServizioParteSpecifica.getTipo() == null) {
            throw new ProtocolException("idAccordoServizioParteSpecifica.tipo non definito");
        }
        if (idAccordoServizioParteSpecifica.getNome() == null) {
            throw new ProtocolException("idAccordoServizioParteSpecifica.nome non definito");
        }
        if (!informationMissingManagementEnabled) {
            if (idAccordoServizioParteSpecifica.getVersione() == null) {
                throw new ProtocolException("idAccordoServizioParteSpecifica.versione non definito");
            }
            if (idAccordoServizioParteSpecifica.getSoggettoErogatore() == null) {
                throw new ProtocolException("idAccordoServizioParteSpecifica.soggettoErogatore non definito");
            }
            if (idAccordoServizioParteSpecifica.getSoggettoErogatore().getTipo() == null) {
                throw new ProtocolException("idAccordoServizioParteSpecifica.soggettoErogatore.tipo non definito");
            }
            if (idAccordoServizioParteSpecifica.getSoggettoErogatore().getNome() == null) {
                throw new ProtocolException("idAccordoServizioParteSpecifica.soggettoErogatore.nome non definito");
            }
        }
        this.idAccordoServizioParteSpecifica = idAccordoServizioParteSpecifica;
    }

    public IDSoggetto getIdSoggettoFruitore() {
        return this.idSoggettoFruitore;
    }

    public IDServizio getIdAccordoServizioParteSpecifica() {
        return this.idAccordoServizioParteSpecifica;
    }

    public Fruitore getFruitore() {
        return this.fruitore;
    }

    public ArchiveIdCorrelazione getIdCorrelazione() {
        return this.idCorrelazione;
    }
}

