/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk.archive;

import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.registry.Gruppo;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.ArchiveIdCorrelazione;
import org.openspcoop2.protocol.sdk.archive.IArchiveObject;

public class ArchiveGruppo
implements IArchiveObject {
    private IDGruppo idGruppo;
    private Gruppo gruppo;
    private ArchiveIdCorrelazione idCorrelazione;

    public static String buildKey(String nomeGruppo) throws ProtocolException {
        if (nomeGruppo == null) {
            throw new ProtocolException("nomeGruppo non fornito");
        }
        StringBuilder bf = new StringBuilder();
        bf.append("Gruppo_");
        bf.append(nomeGruppo);
        return bf.toString();
    }

    @Override
    public String key() throws ProtocolException {
        return ArchiveGruppo.buildKey(this.idGruppo.getNome());
    }

    public ArchiveGruppo(Gruppo gruppo, ArchiveIdCorrelazione idCorrelazione) throws ProtocolException {
        if (gruppo == null) {
            throw new ProtocolException("Gruppo non fornito");
        }
        if (gruppo.getNome() == null) {
            throw new ProtocolException("Gruppo.nome non definito");
        }
        this.idGruppo = new IDGruppo(gruppo.getNome());
        this.gruppo = gruppo;
        this.idCorrelazione = idCorrelazione;
    }

    public IDGruppo getIdGruppo() {
        return this.idGruppo;
    }

    public Gruppo getGruppo() {
        return this.gruppo;
    }

    public ArchiveIdCorrelazione getIdCorrelazione() {
        return this.idCorrelazione;
    }
}

