/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.sdk.constants;

import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroreCooperazione;

public enum ErroriCooperazione {
    MITTENTE_SCONOSCIUTO("Il Mittente non risulta registrato nel Registro dei Servizi", CodiceErroreCooperazione.MITTENTE_SCONOSCIUTO),
    MITTENTE_NON_VALIDO("Il Mittente presente nella busta non \u00e8 valido", CodiceErroreCooperazione.MITTENTE_NON_VALIDO),
    TIPO_MITTENTE_NON_VALIDO("Il Tipo del mittente presente nella busta non \u00e8 valido", CodiceErroreCooperazione.TIPO_MITTENTE_NON_VALIDO),
    DESTINATARIO_SCONOSCIUTO("Il Destinatario non risulta registrato nel Registro dei Servizi", CodiceErroreCooperazione.DESTINATARIO_SCONOSCIUTO),
    DESTINATARIO_NON_VALIDO("Il Destinatario presente nella busta non \u00e8 valido", CodiceErroreCooperazione.DESTINATARIO_NON_VALIDO),
    TIPO_DESTINATARIO_NON_VALIDO("Il Tipo del destinatario presente nella busta non \u00e8 valido", CodiceErroreCooperazione.TIPO_DESTINATARIO_NON_VALIDO),
    SERVIZIO_SCONOSCIUTO("Il Servizio non risulta registrato nel Registro dei Servizi", CodiceErroreCooperazione.SERVIZIO_SCONOSCIUTO),
    SERVIZIO_NON_VALIDO("Il Servizio presente nella busta non \u00e8 valido", CodiceErroreCooperazione.SERVIZIO_NON_VALIDO),
    TIPO_SERVIZIO_NON_VALIDO("Il Tipo del servizio presente nella busta non \u00e8 valido", CodiceErroreCooperazione.TIPO_SERVIZIO_NON_VALIDO),
    VERSIONE_SERVIZIO_NON_VALIDO("La versione del servizio presente nella busta non \u00e8 valido", CodiceErroreCooperazione.VERSIONE_SERVIZIO_NON_VALIDO),
    AZIONE_NON_VALIDA("L'azione presente nella busta non \u00e8 valida", CodiceErroreCooperazione.AZIONE_NON_VALIDA),
    IDENTIFICATIVO_MESSAGGIO_GIA_PROCESSATO("La busta presenta un identificativo gi\u00e0 processato in precedenza", CodiceErroreCooperazione.IDENTIFICATIVO_MESSAGGIO_GIA_PROCESSATO),
    RIFERIMENTO_MESSAGGIO_NON_PRESENTE("La busta non contiene un RiferimentoMessaggio alla precedente busta a cui \u00e8 correlata logicamente come richiede il profilo", CodiceErroreCooperazione.RIFERIMENTO_MESSAGGIO_NON_PRESENTE),
    RIFERIMENTO_MESSAGGIO_NON_VALIDO("IdentificativoBusta presente nel RiferimentoMessaggio non \u00e8 valido", CodiceErroreCooperazione.RIFERIMENTO_MESSAGGIO_NON_VALIDO),
    MESSAGGIO_SCADUTO("Messaggio scaduto", CodiceErroreCooperazione.MESSAGGIO_SCADUTO),
    PROFILO_COLLABORAZIONE_SCONOSCIUTO("Busta con profilo di collaborazione sconosciuto", CodiceErroreCooperazione.PROFILO_COLLABORAZIONE_SCONOSCIUTO),
    PROFILO_COLLABORAZIONE_NON_VALIDO("Busta con profilo di collaborazione non valido rispetto al tipo di cooperazione in corso", CodiceErroreCooperazione.PROFILO_COLLABORAZIONE_NON_VALIDO),
    COLLABORAZIONE_NON_VALIDA("La collaborazione presente nella busta non \u00e8 valida", CodiceErroreCooperazione.COLLABORAZIONE_NON_VALIDA),
    COLLABORAZIONE_SCONOSCIUTA("La collaborazione presente nella busta non appartiene a nessuna sessione valida", CodiceErroreCooperazione.COLLABORAZIONE_SCONOSCIUTA),
    PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_NON_PRESENTE("La busta non contiene una richiesta di 'conferma ricezione', nonostante il servizio indicato richieda, tramite la definizione dell'accordo nel registro, una consegna affidabile", CodiceErroreCooperazione.PROFILO_TRASMISSIONE_CONFERMA_RICEZIONE_NON_PRESENTE),
    CONSEGNA_IN_ORDINE_NON_GESTIBILE("La busta non contiene una richiesta di 'consegna in ordine', nonostante il servizio indicato richieda, tramite la definizione dell'accordo nel registro, un ordinamento", CodiceErroreCooperazione.CONSEGNA_IN_ORDINE_NON_GESTIBILE),
    CONSEGNA_IN_ORDINE_FUORI_SEQUENZA("Riscontrato numero di sequenza diverso da 1, in una busta capostipite di una sequenza", CodiceErroreCooperazione.CONSEGNA_IN_ORDINE_FUORI_SEQUENZA),
    CONSEGNA_IN_ORDINE_TIPO_MITTENTE_NON_VALIDO("Il tipo di mittente non rispetta quello atteso nella gestione della collaborazione con consegna in ordine", CodiceErroreCooperazione.CONSEGNA_IN_ORDINE_TIPO_MITTENTE_NON_VALIDO),
    CONSEGNA_IN_ORDINE_MITTENTE_NON_VALIDO("Il nome del mittente non rispetta quello atteso nella gestione della collaborazione con consegna in ordine", CodiceErroreCooperazione.CONSEGNA_IN_ORDINE_MITTENTE_NON_VALIDO),
    CONSEGNA_IN_ORDINE_TIPO_DESTINATARIO_NON_VALIDO("Il tipo di destinatario non rispetta quello atteso nella gestione della collaborazione con consegna in ordine", CodiceErroreCooperazione.CONSEGNA_IN_ORDINE_TIPO_DESTINATARIO_NON_VALIDO),
    CONSEGNA_IN_ORDINE_DESTINATARIO_NON_VALIDO("Il nome del destinatario non rispetta quello atteso nella gestione della collaborazione con consegna in ordine", CodiceErroreCooperazione.CONSEGNA_IN_ORDINE_DESTINATARIO_NON_VALIDO),
    CONSEGNA_IN_ORDINE_TIPO_SERVIZIO_NON_VALIDO("Il tipo di servizio non rispetta quello atteso nella gestione della collaborazione con consegna in ordine", CodiceErroreCooperazione.CONSEGNA_IN_ORDINE_TIPO_SERVIZIO_NON_VALIDO),
    CONSEGNA_IN_ORDINE_SERVIZIO_NON_VALIDO("Il nome del servizio non rispetta quello atteso nella gestione della collaborazione con consegna in ordine", CodiceErroreCooperazione.CONSEGNA_IN_ORDINE_SERVIZIO_NON_VALIDO),
    CONSEGNA_IN_ORDINE_AZIONE_NON_VALIDA("Il nome dell'azione non rispetta quello atteso nella gestione della collaborazione con consegna in ordine", CodiceErroreCooperazione.CONSEGNA_IN_ORDINE_AZIONE_NON_VALIDA),
    CONSEGNA_IN_ORDINE_COLLABORAZIONE_IN_BUSTA_NON_CAPOSTIPITE_SCONOSCIUTA("Busta non capostipite che richiede funzionalit\u00e0 di consegna in ordine presenta una collaborazione non registrata per le funzioni di consegna in ordine", CodiceErroreCooperazione.CONSEGNA_IN_ORDINE_COLLABORAZIONE_IN_BUSTA_NON_CAPOSTIPITE_SCONOSCIUTA),
    CONSEGNA_IN_ORDINE_NON_SUPPORTATA("Funzionalit\u00e0 di consegna in ordine non supportata", CodiceErroreCooperazione.CONSEGNA_IN_ORDINE_NON_SUPPORTATA),
    MESSAGE_SECURITY("E' occorso un errore durante la gestione della Sicurezza sul Messaggio", null),
    AUTENTICAZIONE_FALLITA_CREDENZIALI_NON_FORNITE("Autenticazione fallita, credenziali non fornite", CodiceErroreCooperazione.MITTENTE_NON_VALORIZZATO),
    AUTENTICAZIONE_FALLITA_CREDENZIALI_FORNITE_NON_CORRETTE("Autenticazione fallita, credenziali fornite non corrette", CodiceErroreCooperazione.MITTENTE_SCONOSCIUTO),
    AUTORIZZAZIONE_FALLITA("Il Mittente non \u00e8 autorizzato a fruire del servizio richiesto", null),
    ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO("E' occorso un errore durante il processamento del messaggio", CodiceErroreCooperazione.ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO),
    ERRORE_GENERICO_PROTOCOLLO_NON_CORRETTO("E' stato rilevata una violazione per quanto concerne le informazioni richieste del protocollo in gestione", CodiceErroreCooperazione.FORMATO_NON_CORRETTO),
    TOKEN_NON_PRESENTE("Token non presente", CodiceErroreCooperazione.SICUREZZA_TOKEN_NON_PRESENTE),
    TOKEN_NON_VALIDO("Token non valido", CodiceErroreCooperazione.SICUREZZA_TOKEN_NON_VALIDO),
    TOKEN_AUTORIZZAZIONE_FALLITA("La richiesta presenta un token non sufficiente per fruire del servizio richiesto", CodiceErroreCooperazione.SICUREZZA_TOKEN_AUTORIZZAZIONE_FALLITA),
    TOKEN_PRESENTE_PIU_VOLTE("Token presente pi\u00f9 volte", CodiceErroreCooperazione.SICUREZZA_TOKEN_PRESENTE_PIU_VOLTE);

    private final String descrizione;
    private final CodiceErroreCooperazione codiceErrore;

    private ErroriCooperazione(String descrizione, CodiceErroreCooperazione codiceErrore) {
        this.descrizione = descrizione;
        this.codiceErrore = codiceErrore;
    }

    public String toString() {
        return this.newErroreCooperazione().toString();
    }

    private ErroreCooperazione newErroreCooperazione() {
        return this.newErroreCooperazione(this.descrizione, this.codiceErrore);
    }

    private ErroreCooperazione newErroreCooperazione(String descrizioneParam) {
        return this.newErroreCooperazione(descrizioneParam, this.codiceErrore);
    }

    private ErroreCooperazione newErroreCooperazione(CodiceErroreCooperazione codiceParam) {
        return this.newErroreCooperazione(this.descrizione, codiceParam);
    }

    private ErroreCooperazione newErroreCooperazione(String descrizioneParam, CodiceErroreCooperazione codiceParam) {
        String newDescrizione = new String(descrizioneParam);
        return new ErroreCooperazione(newDescrizione, codiceParam);
    }

    public ErroreCooperazione getErroreCooperazione() {
        return this.getErroreCooperazione(null);
    }

    public ErroreCooperazione getErroreCooperazione(String descrizione) {
        if (this.equals((Object)MESSAGE_SECURITY) || this.equals((Object)AUTORIZZAZIONE_FALLITA)) {
            throw new RuntimeException("Il metodo non pu\u00f2 essere utilizzato con il messaggio " + this.name());
        }
        if (descrizione != null) {
            return this.newErroreCooperazione(descrizione);
        }
        return this.newErroreCooperazione();
    }

    public ErroreCooperazione getErroreProfiloCollaborazioneSconosciuto(String profiloCollaborazione) {
        if (this.equals((Object)PROFILO_COLLABORAZIONE_SCONOSCIUTO)) {
            if (profiloCollaborazione == null) {
                return this.newErroreCooperazione("Busta senza Profilo di Collaborazione");
            }
            return this.newErroreCooperazione("Busta con profilo di collaborazione non gestito [" + profiloCollaborazione + "]");
        }
        throw new RuntimeException("Il metodo pu\u00f2 essere utilizzato solo con il messaggio " + PROFILO_COLLABORAZIONE_SCONOSCIUTO.name());
    }

    public ErroreCooperazione getErroreProfiloCollaborazioneNonValido(String descrizione) {
        if (this.equals((Object)PROFILO_COLLABORAZIONE_NON_VALIDO)) {
            return this.newErroreCooperazione(descrizione);
        }
        throw new RuntimeException("Il metodo pu\u00f2 essere utilizzato solo con il messaggio " + PROFILO_COLLABORAZIONE_NON_VALIDO.name());
    }

    public ErroreCooperazione getErroreMessageSecurity(String descrizione, CodiceErroreCooperazione codiceErrore) {
        if (this.equals((Object)MESSAGE_SECURITY)) {
            if (!(CodiceErroreCooperazione.isEccezioneMessageSecurity(codiceErrore) || CodiceErroreCooperazione.isEccezioneSicurezzaAutorizzazione(codiceErrore) || CodiceErroreCooperazione.isEccezioneSicurezzaToken(codiceErrore))) {
                throw new RuntimeException("Il metodo pu\u00f2 essere utilizzato solo con codici associati alla sicurezza, relativamente ad errori di messageSecurity, token o erroreAutorizzazione, codice fornito: " + String.valueOf(codiceErrore));
            }
            return this.newErroreCooperazione(descrizione, codiceErrore);
        }
        throw new RuntimeException("Il metodo pu\u00f2 essere utilizzato solo con il messaggio " + MESSAGE_SECURITY.name());
    }

    public ErroreCooperazione getErroreAutorizzazione(String descrizione, CodiceErroreCooperazione codiceErrore) {
        if (this.equals((Object)AUTORIZZAZIONE_FALLITA)) {
            if (!CodiceErroreCooperazione.isEccezioneSicurezzaAutorizzazione(codiceErrore)) {
                throw new RuntimeException("Il metodo pu\u00f2 essere utilizzato solo con codici associati alla sicurezza, relativamente a fallimenti di autorizzazione, codice fornito: " + String.valueOf(codiceErrore));
            }
            return this.newErroreCooperazione(descrizione, codiceErrore);
        }
        throw new RuntimeException("Il metodo pu\u00f2 essere utilizzato solo con il messaggio " + AUTORIZZAZIONE_FALLITA.name());
    }

    public ErroreCooperazione getErroreProcessamento(String descrizione) {
        if (this.equals((Object)ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO)) {
            return this.newErroreCooperazione(descrizione);
        }
        throw new RuntimeException("Il metodo pu\u00f2 essere utilizzato solo con il messaggio " + ERRORE_GENERICO_PROCESSAMENTO_MESSAGGIO.name());
    }

    public ErroreCooperazione getErroreGestioneProtocollo(String descrizione) {
        if (this.equals((Object)ERRORE_GENERICO_PROTOCOLLO_NON_CORRETTO)) {
            return this.newErroreCooperazione(descrizione);
        }
        throw new RuntimeException("Il metodo pu\u00f2 essere utilizzato solo con il messaggio " + ERRORE_GENERICO_PROTOCOLLO_NON_CORRETTO.name());
    }

    public ErroreCooperazione getErroreCredenzialiForniteNonCorrette(String errore) {
        if (this.equals((Object)AUTENTICAZIONE_FALLITA_CREDENZIALI_FORNITE_NON_CORRETTE)) {
            return this.newErroreCooperazione("Autenticazione fallita, credenziali fornite non corrette: " + errore, CodiceErroreCooperazione.MITTENTE_SCONOSCIUTO);
        }
        throw new RuntimeException("Il metodo pu\u00f2 essere utilizzato solo con il messaggio " + AUTENTICAZIONE_FALLITA_CREDENZIALI_FORNITE_NON_CORRETTE.name());
    }
}

