/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit.html;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.renderkit.AjaxContainerRenderer;
import org.ajax4jsf.renderkit.RendererUtils;

public class AjaxPageRenderer
extends AjaxContainerRenderer {
    public static final String RENDERER_TYPE = "org.ajax4jsf.components.AjaxPageRenderer";
    private static final Map<String, String[]> doctypes = new HashMap<String, String[]>();

    protected void preEncodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public void doEncodeBegin(ResponseWriter out, FacesContext context, UIComponent component) throws IOException {
        Map attributes = component.getAttributes();
        String format = (String)attributes.get("format");
        String contentType = null;
        String namespace = null;
        String[] docType = null;
        if (null != format) {
            docType = doctypes.get(format);
        } else {
            contentType = out.getContentType();
            for (String[] types : doctypes.values()) {
                if (!types[1].equals(contentType)) continue;
                docType = types;
                break;
            }
        }
        if (null != docType) {
            contentType = docType[1];
            namespace = docType[2];
            out.write(docType[0]);
        }
        if (null == contentType) {
            contentType = (String)attributes.get("contentType");
        }
        if (null != contentType) {
            // empty if block
        }
        out.startElement("html", component);
        if (null == namespace) {
            namespace = (String)attributes.get("namespace");
        }
        if (null != namespace) {
            out.writeAttribute("xmlns", (Object)namespace, "namespace");
        }
        Locale locale = context.getViewRoot().getLocale();
        out.writeAttribute("lang", (Object)locale.toString(), "lang");
        if (!AjaxContext.getCurrentInstance((FacesContext)context).isAjaxRequest()) {
            out.startElement("head", component);
            Object title = attributes.get("pageTitle");
            String viewId = context.getViewRoot().getViewId();
            if (null == title) {
                title = viewId;
            }
            out.startElement("title", component);
            out.writeText(title, "pageTitle");
            out.endElement("title");
            UIComponent headFacet = component.getFacet("head");
            if (headFacet != null) {
                this.renderChild(context, headFacet);
            }
            if (null != contentType) {
                out.startElement("meta", component);
                out.writeAttribute("http-equiv", (Object)"Content-Type", null);
                out.writeAttribute("content", (Object)contentType, null);
                out.endElement("meta");
            }
            if (null == context.getExternalContext().getRequestMap().get("com.exade.vcp.Filter.ResponseWrapper")) {
                this.encodeResourcesArray(context, component, this.getScripts());
                this.encodeResourcesArray(context, component, this.getStyles());
            }
            out.endElement("head");
        }
        out.startElement("body", component);
        this.getUtils().encodePassThru(context, component);
        this.getUtils().encodeAttributesFromArray(context, component, RendererUtils.HTML.PASS_THRU_STYLES);
        this.getUtils().encodeAttribute(context, component, "onload");
        this.getUtils().encodeAttribute(context, component, "onunload");
    }

    public void doEncodeEnd(ResponseWriter out, FacesContext context, UIComponent component) throws IOException {
        out.endElement("body");
        out.endElement("html");
    }

    public boolean getRendersChildren() {
        FacesContext context = FacesContext.getCurrentInstance();
        return AjaxContext.getCurrentInstance((FacesContext)context).isAjaxRequest();
    }

    static {
        doctypes.put("html-transitional", new String[]{"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n", "text/html", null});
        doctypes.put("html", new String[]{"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"\n\"http://www.w3.org/TR/html4/strict.dtd\">\n", "text/html", null});
        doctypes.put("html-frameset", new String[]{"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\"\n\"http://www.w3.org/TR/html4/frameset.dtd\">\n", "text/html", null});
        doctypes.put("xhtml", new String[]{"<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n", "application/xhtml+xml", "http://www.w3.org/1999/xhtml"});
        doctypes.put("xhtml-transitional", new String[]{"<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n", "application/xhtml+xml", "http://www.w3.org/1999/xhtml"});
        doctypes.put("xhtml-frameset", new String[]{"<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Frameset//EN\"\n\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd\">\n", "application/xhtml+xml", "http://www.w3.org/1999/xhtml"});
        doctypes.put("html-3.2", new String[]{"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">\n", "text/html", null});
        doctypes.put("html5", new String[]{"<!DOCTYPE html>\n", "text/html", null});
    }
}

