/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.richfaces.component.UIColumn;
import org.richfaces.component.UIExtendedDataTable;
import org.richfaces.json.JSONArray;
import org.richfaces.json.JSONCollection;
import org.richfaces.json.JSONException;

class ColumnsOrder
implements Serializable {
    private static final long serialVersionUID = 907700564445889954L;
    private JSONArray value;

    private ColumnsOrder() {
    }

    static ColumnsOrder getColumnsOrder(UIExtendedDataTable extendedDataTable, JSONCollection collection) {
        ColumnsOrder columnsOrder = new ColumnsOrder();
        columnsOrder.init(extendedDataTable, collection);
        return columnsOrder;
    }

    static ColumnsOrder getColumnsOrder(UIExtendedDataTable extendedDataTable, String val) throws JSONException {
        ColumnsOrder columnsOrder = new ColumnsOrder();
        columnsOrder.init(extendedDataTable, new JSONCollection(val));
        return columnsOrder;
    }

    private void init(UIExtendedDataTable extendedDataTable, JSONCollection collection) {
        this.value = null;
        if (collection != null && collection.size() > 0) {
            this.value = new JSONArray((Collection)collection);
        }
        if (this.value == null) {
            this.createDefaultColumnsOrder(extendedDataTable);
        }
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    public JSONArray toJSON() {
        return this.value;
    }

    private void createDefaultColumnsOrder(UIExtendedDataTable extendedDataTable) {
        this.value = new JSONArray();
        Iterator<UIColumn> iter = extendedDataTable.getChildColumns();
        while (iter.hasNext()) {
            UIColumn col = iter.next();
            this.value.put((Object)col.getId());
        }
    }

    private int getColumnIndex(String columnId) {
        if (this.value == null) {
            return -1;
        }
        for (int i = 0; i < this.value.length(); ++i) {
            Object val = this.value.opt(i);
            if (!columnId.equals(val)) continue;
            return i;
        }
        return -1;
    }

    void changeOrder(String sourceColumnId, String targetColumnId, boolean dropBefore) {
        int targetIndex;
        if (this.value == null) {
            return;
        }
        if (sourceColumnId.equals(targetColumnId)) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>(this.value.length());
        for (int i = 0; i < this.value.length(); ++i) {
            list.add(this.value.optString(i));
        }
        int sourceIndex = list.indexOf(sourceColumnId);
        if (sourceIndex != -1) {
            list.remove(sourceIndex);
        }
        if ((targetIndex = list.indexOf(targetColumnId)) == -1) {
            list.add(sourceColumnId);
        } else {
            list.add(targetIndex + (dropBefore ? 0 : 1), sourceColumnId);
        }
        this.value = new JSONArray(list);
    }

    List<UIComponent> sortColumns(FacesContext context, List<UIComponent> children) {
        ArrayList<UIComponent> childs = new ArrayList<UIComponent>(children);
        Collections.sort(childs, new Comparator<UIComponent>(){

            @Override
            public int compare(UIComponent o1, UIComponent o2) {
                Integer index1 = ColumnsOrder.this.getColumnIndex(o1.getId());
                Integer index2 = ColumnsOrder.this.getColumnIndex(o2.getId());
                if (index1 == -1) {
                    return index2 == -1 ? 0 : 1;
                }
                return index2 == -1 ? -1 : index1.compareTo(index2);
            }
        });
        return childs;
    }
}

