/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.monitor.sdk.parameters;

import org.openspcoop2.monitor.sdk.constants.ParameterType;
import org.openspcoop2.monitor.sdk.exceptions.ParameterException;
import org.openspcoop2.monitor.sdk.parameters.Parameter;

public class CheckBoxParameter
extends Parameter<Boolean> {
    public CheckBoxParameter(String id) {
        super(id, ParameterType.CHECK_BOX);
    }

    @Override
    public void setValueAsString(String value) throws ParameterException {
        if (value != null) {
            try {
                Boolean b = "true".equalsIgnoreCase(value);
                this.setValue(b);
            }
            catch (Exception e) {
                throw new ParameterException("Value [" + value + "] uncorrected: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public String getValueAsString() throws ParameterException {
        if (this.getValue() != null) {
            try {
                if (this.getValue() != null) {
                    return "" + (Boolean)this.getValue();
                }
            }
            catch (Exception e) {
                throw new ParameterException("Error occurs: " + e.getMessage(), e);
            }
        }
        return null;
    }
}

