/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openspcoop2.utils.ILimitExceededNotifier;
import org.openspcoop2.utils.LimitExceededIOException;
import org.openspcoop2.utils.LimitedInputStream;
import org.openspcoop2.utils.Map;

public class LimitedInputStreamEngine
extends FilterInputStream {
    private long limitBytes;
    private long count;
    private InputStream isWrapped = null;
    private String prefixError = "";
    private Map<Object> ctx;
    private boolean checkDisabled = false;
    private ILimitExceededNotifier notifier;

    protected LimitedInputStreamEngine(InputStream inputStream, long limitBytes, String prefixError, Map<Object> ctx, ILimitExceededNotifier notifier) throws IOException {
        super(inputStream);
        this.limitBytes = limitBytes;
        this.isWrapped = inputStream;
        if (prefixError != null) {
            this.prefixError = prefixError;
        }
        this.ctx = ctx;
        if (this.limitBytes <= 0L) {
            throw new IOException("Invalid limit");
        }
        this.notifier = notifier;
    }

    public InputStream getIsWrapped() {
        return this.isWrapped;
    }

    protected void disableCheck() {
        this.checkDisabled = true;
    }

    protected void updateThreshold(long limitBytes) throws IOException {
        if (this.limitBytes <= 0L) {
            throw new IOException("Invalid limit");
        }
        this.limitBytes = limitBytes;
    }

    protected void updateContext(Map<Object> ctx) {
        this.ctx = ctx;
    }

    protected void updateNotifier(ILimitExceededNotifier notifier) {
        this.notifier = notifier;
    }

    private void checkLimit() throws IOException {
        if (this.checkDisabled) {
            return;
        }
        if (this.count > this.limitBytes) {
            LimitedInputStreamEngine.payloadTooLarge(this.prefixError, this.ctx, this.notifier, this.count);
        }
    }

    public static void payloadTooLarge(String prefixError, Map<Object> ctx, ILimitExceededNotifier notifier, long count) throws LimitExceededIOException {
        LimitedInputStreamEngine.limitExceeded(prefixError, "Payload too large", false, ctx, notifier, count);
    }

    public static void contentLenghtLimitExceeded(String prefixError, Map<Object> ctx, ILimitExceededNotifier notifier, long count) throws LimitExceededIOException {
        LimitedInputStreamEngine.limitExceeded(prefixError, "Content-Length exceeds the allowed limit", true, ctx, notifier, count);
    }

    private static void limitExceeded(String prefixError, String error, boolean contentLengthExceeded, Map<Object> ctx, ILimitExceededNotifier notifier, long count) throws LimitExceededIOException {
        String errorMsg = prefixError + error;
        if (ctx != null) {
            ctx.put(LimitedInputStream.ERROR_MSG_KEY, (Object)errorMsg);
        }
        LimitExceededIOException exc = new LimitExceededIOException(errorMsg);
        if (ctx != null) {
            ctx.put(LimitedInputStream.EXCEPTION_KEY, (Object)exc);
        }
        if (notifier != null) {
            notifier.notify(count, contentLengthExceeded);
        }
        throw exc;
    }

    @Override
    public int read() throws IOException {
        int res = super.read();
        if (res != -1) {
            ++this.count;
            this.checkLimit();
        }
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int res = super.read(b, off, len);
        if (res > 0) {
            this.count += (long)res;
            this.checkLimit();
        }
        return res;
    }
}

