/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.SemaphoreRuntimeException;
import org.openspcoop2.utils.SemaphoreType;
import org.openspcoop2.utils.UtilsException;
import org.slf4j.Logger;

public class Semaphore {
    public static final long DEFAULT_LOCK_ACQUISITION_TIMEOUT_MS = 30000L;
    private static long defaultLockAcquisitionTimeoutMs = 30000L;
    public static final long DEFAULT_LOCK_HOLD_TIMEOUT_MS = 60000L;
    private static long defaultLockHoldTimeoutMs = 60000L;
    private static Logger logDebug = null;
    private static boolean defaultDebug = false;
    private Long instanceLockAcquisitionTimeoutMs = null;
    private long instanceLockHoldTimeoutMs = -1L;
    private boolean instanceDebug = false;
    private static SemaphoreType semaphoreType = SemaphoreType.Semaphore;
    private static boolean fair = true;
    private final java.util.concurrent.Semaphore concurrentSemaphore;
    private final ReentrantLock reentrantLock;
    private String semaphoreName = null;
    private int permits = -1;

    public static long getDefaultLockAcquisitionTimeoutMs() {
        return defaultLockAcquisitionTimeoutMs;
    }

    public static void setDefaultLockAcquisitionTimeoutMs(long timeoutMs) {
        defaultLockAcquisitionTimeoutMs = timeoutMs;
    }

    public static long getDefaultLockHoldTimeoutMs() {
        return defaultLockHoldTimeoutMs;
    }

    public static void setDefaultLockHoldTimeoutMs(long timeoutMs) {
        defaultLockHoldTimeoutMs = timeoutMs;
    }

    public static Logger getLogDebug() {
        return logDebug;
    }

    public static void setLogDebug(Logger logDebug) {
        Semaphore.logDebug = logDebug;
    }

    public static boolean isDefaultDebug() {
        return defaultDebug;
    }

    public static void setDefaultDebug(boolean d) {
        defaultDebug = d;
    }

    public long getInstanceLockAcquisitionTimeoutMs() {
        return this.instanceLockAcquisitionTimeoutMs != null && this.instanceLockAcquisitionTimeoutMs > 0L ? this.instanceLockAcquisitionTimeoutMs : defaultLockAcquisitionTimeoutMs;
    }

    public void setInstanceLockAcquisitionTimeoutMs(Long timeoutMs) {
        this.instanceLockAcquisitionTimeoutMs = timeoutMs;
    }

    public void setInstanceLockAcquisitionTimeoutMs(long timeoutMs) {
        this.instanceLockAcquisitionTimeoutMs = timeoutMs;
    }

    public long getInstanceLockHoldTimeoutMs() {
        return this.instanceLockHoldTimeoutMs > 0L ? this.instanceLockHoldTimeoutMs : defaultLockHoldTimeoutMs;
    }

    public void setInstanceLockHoldTimeoutMs(long timeoutMs) {
        this.instanceLockHoldTimeoutMs = timeoutMs;
    }

    public boolean isInstanceDebug() {
        return this.instanceDebug || defaultDebug;
    }

    public void setInstanceDebug(boolean d) {
        this.instanceDebug = d;
    }

    public static SemaphoreType getSemaphoreType() {
        return semaphoreType;
    }

    public static void setSemaphoreType(SemaphoreType semaphoreType) {
        Semaphore.semaphoreType = semaphoreType;
    }

    public static boolean isFair() {
        return fair;
    }

    public static void setFair(boolean fair) {
        Semaphore.fair = fair;
    }

    public Semaphore(String name) {
        this(name, semaphoreType, fair);
    }

    public Semaphore(String name, boolean fair) {
        this(name, semaphoreType, fair);
    }

    public Semaphore(String name, SemaphoreType semaphoreType, boolean fair) {
        this.semaphoreName = name;
        switch (semaphoreType) {
            case ReentrantLock: {
                this.reentrantLock = new ReentrantLock(fair);
                this.concurrentSemaphore = null;
                break;
            }
            case Semaphore: {
                this.reentrantLock = null;
                this.concurrentSemaphore = new java.util.concurrent.Semaphore(1, fair);
                break;
            }
            default: {
                this.reentrantLock = null;
                this.concurrentSemaphore = null;
            }
        }
        this.permits = 1;
    }

    public Semaphore(String name, int permits) {
        this(name, permits, fair);
    }

    public Semaphore(String name, int permits, boolean fair) {
        this.semaphoreName = name;
        this.concurrentSemaphore = new java.util.concurrent.Semaphore(permits, fair);
        this.reentrantLock = null;
        this.permits = permits;
    }

    public boolean hasQueuedThreads() {
        if (this.concurrentSemaphore != null) {
            return this.concurrentSemaphore.hasQueuedThreads();
        }
        return this.reentrantLock.hasQueuedThreads();
    }

    public boolean available() {
        if (this.concurrentSemaphore != null) {
            return this.concurrentSemaphore.availablePermits() > 0;
        }
        return !this.reentrantLock.isLocked();
    }

    public int availablePermits() {
        if (this.concurrentSemaphore != null) {
            return this.concurrentSemaphore.availablePermits();
        }
        return -1;
    }

    String getPrefix(String methodName, String idTransazione) {
        Object idTr = "";
        if (idTransazione != null) {
            idTr = " (idTransazione:" + idTransazione + ")";
        }
        return this.semaphoreName + "." + methodName + " [Thread:" + Thread.currentThread().getName() + "]" + (String)idTr + " ";
    }

    public SemaphoreLock acquire(String methodName) throws UtilsException {
        return this.acquire(methodName, null);
    }

    public SemaphoreLock acquire(String methodName, String idTransazione) throws UtilsException {
        try {
            if (this.getInstanceLockAcquisitionTimeoutMs() <= 0L) {
                return this.acquireWithoutTimeout(methodName, idTransazione);
            }
            return this.acquireWithTimeout(methodName, idTransazione);
        }
        catch (InterruptedException ie) {
            if (this.isInstanceDebug()) {
                this.debug(this.getPrefix(methodName, idTransazione) + " acquire(" + this.getInstanceLockAcquisitionTimeoutMs() + "ms) failed: " + ie.getMessage());
            }
            Thread.currentThread().interrupt();
            throw new UtilsException(ie.getMessage(), ie);
        }
    }

    private SemaphoreLock acquireWithoutTimeout(String methodName, String idTransazione) throws InterruptedException {
        if (this.isInstanceDebug()) {
            this.debug(this.getPrefix(methodName, idTransazione) + " acquire ...");
        }
        if (this.concurrentSemaphore != null) {
            this.concurrentSemaphore.acquire();
        } else {
            this.reentrantLock.lock();
        }
        if (this.isInstanceDebug()) {
            this.debug(this.getPrefix(methodName, idTransazione) + " acquired");
        }
        return new SemaphoreLock(this, methodName, idTransazione);
    }

    private SemaphoreLock acquireWithTimeout(String methodName, String idTransazione) throws InterruptedException {
        if (this.isInstanceDebug()) {
            this.debug(this.getPrefix(methodName, idTransazione) + " acquire(" + this.getInstanceLockAcquisitionTimeoutMs() + "ms) ...");
        }
        boolean acquire = false;
        acquire = this.concurrentSemaphore != null ? this.concurrentSemaphore.tryAcquire(this.getInstanceLockAcquisitionTimeoutMs(), TimeUnit.MILLISECONDS) : this.reentrantLock.tryLock(this.getInstanceLockAcquisitionTimeoutMs(), TimeUnit.MILLISECONDS);
        if (!acquire) {
            throw new InterruptedException("[" + this.semaphoreName + "] Could not acquire semaphore after " + this.getInstanceLockAcquisitionTimeoutMs() + "ms");
        }
        if (this.isInstanceDebug()) {
            this.debug(this.getPrefix(methodName, idTransazione) + " acquired");
        }
        return new SemaphoreLock(this, methodName, idTransazione);
    }

    public SemaphoreLock acquireThrowRuntime(String methodName) throws SemaphoreRuntimeException {
        return this.acquireThrowRuntime(methodName, null);
    }

    public SemaphoreLock acquireThrowRuntime(String methodName, String idTransazione) throws SemaphoreRuntimeException {
        try {
            return this.acquire(methodName, idTransazione);
        }
        catch (Exception t) {
            throw new SemaphoreRuntimeException(t.getMessage(), t);
        }
    }

    public void release(SemaphoreLock semaphoreLock, String methodName) {
        this.release(semaphoreLock, methodName, null);
    }

    public void release(SemaphoreLock semaphoreLock, String methodName, String idTransazione) {
        if (this.isInstanceDebug()) {
            this.debug(this.getPrefix(methodName, idTransazione) + " release ...");
        }
        if (this.concurrentSemaphore != null) {
            if (this.concurrentSemaphore.availablePermits() < this.permits) {
                this.concurrentSemaphore.release();
            }
        } else {
            this.reentrantLock.unlock();
        }
        if (semaphoreLock != null) {
            semaphoreLock.release(methodName, idTransazione);
        }
        if (this.isInstanceDebug()) {
            this.debug(this.getPrefix(methodName, idTransazione) + " released");
        }
    }

    void debug(String msg) {
        System.out.println(msg);
    }
}

