/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.utils.UtilsException;

public class SortedMap<T> {
    protected List<String> list = new ArrayList<String>();
    protected Map<String, T> map = new HashMap<String, T>();

    public int size() {
        return this.list.size();
    }

    public List<String> keys() {
        return this.list;
    }

    public List<T> values() {
        return new ArrayList<T>(this.map.values());
    }

    public void clear() {
        this.list.clear();
        this.map.clear();
    }

    public void put(String key, T archive) throws UtilsException {
        this.add(key, archive);
    }

    public void add(String key, T archive) throws UtilsException {
        if (this.map.containsKey(key)) {
            throw new UtilsException("Key [" + key + "] already exists");
        }
        this.list.add(key);
        this.map.put(key, archive);
    }

    public T get(int index) {
        String key = this.list.get(index);
        return this.map.get(key);
    }

    public T get(String key) {
        return this.map.get(key);
    }

    public T remove(int index) {
        String key = this.list.remove(index);
        return this.map.remove(key);
    }

    public T remove(String key) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (!this.list.get(i).equals(key)) continue;
            this.list.remove(i);
            break;
        }
        return this.map.remove(key);
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(T value) {
        return this.map.containsValue(value);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

