/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openspcoop2.utils.ITimeoutNotifier;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.TimeoutIOException;
import org.openspcoop2.utils.TimeoutInputStream;

public class TimeoutInputStreamEngine
extends InputStream {
    private long createDateMs = System.currentTimeMillis();
    private int timeoutMs;
    private InputStream isWrapped = null;
    private String prefixError = "";
    private Map<Object> ctx;
    private boolean checkDisabled = false;
    private ITimeoutNotifier notifier;

    protected TimeoutInputStreamEngine(InputStream is, int timeoutMs, String prefixError, Map<Object> ctx, ITimeoutNotifier notifier) throws IOException {
        this.timeoutMs = timeoutMs;
        this.isWrapped = is;
        if (prefixError != null) {
            this.prefixError = prefixError;
        }
        this.ctx = ctx;
        if (this.timeoutMs <= 0) {
            throw new IOException("Invalid timeout");
        }
        this.notifier = notifier;
    }

    public InputStream getIsWrapped() {
        return this.isWrapped;
    }

    protected void disableCheckTimeout() {
        this.checkDisabled = true;
    }

    protected void updateThreshold(int timeoutMs) throws IOException {
        if (this.timeoutMs <= 0) {
            throw new IOException("Invalid timeout");
        }
        this.timeoutMs = timeoutMs;
    }

    protected void updateContext(Map<Object> ctx) {
        this.ctx = ctx;
    }

    protected void updateNotifier(ITimeoutNotifier notifier) {
        this.notifier = notifier;
    }

    private void checkTimeout() throws IOException {
        if (this.checkDisabled) {
            return;
        }
        long now = System.currentTimeMillis() - this.createDateMs;
        if (now > (long)this.timeoutMs) {
            String errorMsg = this.prefixError + "Read timed out";
            if (this.ctx != null) {
                this.ctx.put(TimeoutInputStream.ERROR_MSG_KEY, (Object)errorMsg);
            }
            TimeoutIOException exc = new TimeoutIOException(errorMsg);
            if (this.ctx != null) {
                this.ctx.put(TimeoutInputStream.EXCEPTION_KEY, (Object)exc);
            }
            if (this.notifier != null) {
                this.notifier.notify(now);
            }
            throw exc;
        }
    }

    @Override
    public int read() throws IOException {
        this.checkTimeout();
        return this.isWrapped.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.checkTimeout();
        return this.isWrapped.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkTimeout();
        return this.isWrapped.read(b, off, len);
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        this.checkTimeout();
        return this.isWrapped.readAllBytes();
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        this.checkTimeout();
        return this.isWrapped.readNBytes(len);
    }

    @Override
    public int readNBytes(byte[] b, int off, int len) throws IOException {
        this.checkTimeout();
        return this.isWrapped.readNBytes(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkTimeout();
        return this.isWrapped.skip(n);
    }

    @Override
    public int available() throws IOException {
        this.checkTimeout();
        return this.isWrapped.available();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.checkTimeout();
        this.isWrapped.reset();
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        this.checkTimeout();
        return this.isWrapped.transferTo(out);
    }

    @Override
    public void close() throws IOException {
        this.checkTimeout();
        this.isWrapped.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.isWrapped.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.isWrapped.markSupported();
    }
}

