/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.cache;

import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.cache.AbstractCacheJmx;
import org.openspcoop2.utils.jmx.GestoreRisorseJMX;
import org.openspcoop2.utils.jmx.RisorseJMXException;
import org.slf4j.Logger;

public class CacheJMXUtils {
    private static String JMX_DOMAIN = "org.openspcoop2.utils";
    private static String JMX_TYPE = "type";
    private static GestoreRisorseJMX gestoreRisorse = null;

    private static synchronized void initGestoreRisorseJMX(Logger log) throws RisorseJMXException {
        if (gestoreRisorse == null) {
            gestoreRisorse = new GestoreRisorseJMX(log);
        }
    }

    public static void register(Logger log, AbstractCacheJmx cache) throws UtilsException {
        CacheJMXUtils.register(log, cache, null, null, cache.getCacheWrapper().getCacheName());
    }

    public static void register(Logger log, AbstractCacheJmx cache, String jmxName) throws UtilsException {
        CacheJMXUtils.register(log, cache, null, null, jmxName);
    }

    public static void register(Logger log, AbstractCacheJmx cache, String jmxDomain, String jmxName) throws UtilsException {
        CacheJMXUtils.register(log, cache, jmxDomain, null, jmxName);
    }

    public static void register(Logger log, AbstractCacheJmx cache, String jmxDomain, String jmxType, String jmxName) throws UtilsException {
        try {
            if (jmxName == null) {
                throw new Exception("JmxName undefined");
            }
            if (jmxDomain == null) {
                jmxDomain = JMX_DOMAIN;
            }
            if (jmxType == null) {
                jmxType = JMX_TYPE;
            }
            if (gestoreRisorse == null) {
                CacheJMXUtils.initGestoreRisorseJMX(log);
            }
            gestoreRisorse.registerMBean(cache.getClass(), jmxDomain, jmxType, jmxName);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void unregister() {
        if (gestoreRisorse != null) {
            gestoreRisorse.unregisterMBeans();
        }
    }
}

