/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.cache;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.admin.CountingOnlyOutputStream;
import org.apache.commons.jcs3.admin.JCSAdminBean;
import org.apache.commons.jcs3.engine.CacheElementSerialized;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;
import org.apache.commons.jcs3.engine.control.CompositeCache;
import org.apache.commons.jcs3.engine.memory.behavior.IMemoryCache;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.cache.AbstractCacheImpl;
import org.openspcoop2.utils.cache.Cache;
import org.openspcoop2.utils.cache.CacheAlgorithm;
import org.openspcoop2.utils.cache.CacheResponse;
import org.openspcoop2.utils.cache.CacheType;
import org.openspcoop2.utils.properties.CollectionProperties;
import org.openspcoop2.utils.properties.PropertiesUtilities;
import org.slf4j.Logger;

public class JCS3CacheImpl
extends AbstractCacheImpl {
    private CacheAccess<Object, Serializable> cache = null;
    private JCSAdminBean cacheAdmin = null;
    private boolean errorOccursCountingBytes_debug = false;
    private boolean errorOccursCountingBytes = false;

    public static void setLog4jSystem() {
        System.setProperty("jcs.logSystem", "log4j2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean initialize(Logger logConsole, Logger logCore, String cachePropertiesName, String rootDirectory, Properties objectProperties, String OPENSPCOOP2_LOCAL_HOME, String OPENSPCOOP2_CACHE_PROPERTIES, String OPENSPCOOP2_CACHE_LOCAL_PATH) {
        try {
            String value;
            String key;
            Enumeration<Object> ridefinito;
            Properties cacheProperties = new Properties();
            File loggerFile = new File(rootDirectory + cachePropertiesName);
            if (!loggerFile.exists()) {
                cacheProperties.load(Cache.class.getResourceAsStream("/" + cachePropertiesName));
            } else {
                FileInputStream fin = null;
                try {
                    fin = new FileInputStream(loggerFile);
                    cacheProperties.load(fin);
                }
                finally {
                    try {
                        if (fin != null) {
                            fin.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            CollectionProperties cachePropertiesRidefinito = PropertiesUtilities.searchLocalImplementation(OPENSPCOOP2_LOCAL_HOME, logConsole, OPENSPCOOP2_CACHE_PROPERTIES, OPENSPCOOP2_CACHE_LOCAL_PATH, rootDirectory);
            if (cachePropertiesRidefinito != null && cachePropertiesRidefinito.size() > 0) {
                ridefinito = cachePropertiesRidefinito.keys();
                while (ridefinito.hasMoreElements()) {
                    key = (String)ridefinito.nextElement();
                    value = cachePropertiesRidefinito.get(key);
                    if (cacheProperties.containsKey(key)) {
                        cacheProperties.remove(key);
                    }
                    cacheProperties.put(key, value);
                }
            }
            if (objectProperties != null && objectProperties.size() > 0) {
                ridefinito = objectProperties.keys();
                while (ridefinito.hasMoreElements()) {
                    key = (String)ridefinito.nextElement();
                    value = (String)objectProperties.get(key);
                    if (cacheProperties.containsKey(key)) {
                        cacheProperties.remove(key);
                    }
                    cacheProperties.put(key, value);
                }
            }
            JCS.setConfigProperties((Properties)cacheProperties);
            return true;
        }
        catch (Exception e) {
            logCore.error("Riscontrato errore durante l'inizializzazione del sistema di cache: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private JCS3CacheImpl() {
        JCS3CacheImpl.setLog4jSystem();
        this.cacheAdmin = new JCSAdminBean();
    }

    public JCS3CacheImpl(String name) throws UtilsException {
        this(name, Cache.DEFAULT_DISABLE_SYNCRONIZED_GET);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    private JCS3CacheImpl(String name, boolean disableSyncronizedGet) throws UtilsException {
        super(CacheType.JCS, name);
        JCS3CacheImpl.setLog4jSystem();
        try {
            this.cacheAdmin = new JCSAdminBean();
            this.cache = JCS.getInstance((String)this.cacheName);
            if (!disableSyncronizedGet) return;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    @Override
    public int getCacheSize() {
        return this.cache.getCacheAttributes().getMaxObjects();
    }

    @Override
    public void setCacheSize(int cacheSize) {
        ICompositeCacheAttributes attr = this.cache.getCacheAttributes();
        attr.setMaxObjects(cacheSize);
        this.cache.setCacheAttributes(attr);
    }

    @Override
    public CacheAlgorithm getCacheAlgoritm() {
        return CacheAlgorithm.toEnum(this.cache.getCacheAttributes().getCacheName());
    }

    @Override
    public void setCacheAlgoritm(CacheAlgorithm cacheAlgoritm) {
        ICompositeCacheAttributes attr = this.cache.getCacheAttributes();
        attr.setCacheName(cacheAlgoritm.getAlgorithm());
        this.cache.setCacheAttributes(attr);
    }

    @Override
    public long getItemIdleTime() throws UtilsException {
        try {
            return this.cache.getDefaultElementAttributes().getIdleTime();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    @Override
    public void setItemIdleTime(long itemIdleTimeCache) throws UtilsException {
        try {
            IElementAttributes el = this.cache.getDefaultElementAttributes();
            el.setIdleTime(itemIdleTimeCache);
            this.cache.setDefaultElementAttributes(el);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    @Override
    public long getItemLifeTime() throws UtilsException {
        try {
            return this.cache.getDefaultElementAttributes().getMaxLife();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isEternal() throws UtilsException {
        try {
            return this.cache.getDefaultElementAttributes().getIsEternal();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    @Override
    public void setItemLifeTime(long itemLifeTimeCache) throws UtilsException {
        try {
            IElementAttributes el = this.cache.getDefaultElementAttributes();
            if (itemLifeTimeCache > 0L) {
                el.setIsEternal(false);
                el.setMaxLife(itemLifeTimeCache);
            } else {
                el.setIsEternal(true);
                el.setMaxLife(-1L);
            }
            this.cache.setDefaultElementAttributes(el);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    @Override
    public void build() throws UtilsException {
    }

    @Override
    public void clear() throws UtilsException {
        if (this.cache != null) {
            try {
                this.cache.clear();
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
    }

    @Override
    public Object get(String key) {
        return this.cache.get((Object)this.formatKeyCache(key));
    }

    @Override
    public void remove(String key) throws UtilsException {
        try {
            this.cache.remove((Object)this.formatKeyCache(key));
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    @Override
    public void put(String key, CacheResponse value) throws UtilsException {
        try {
            this.cache.put((Object)this.formatKeyCache(key), (Object)value);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    @Override
    public void put(String key, Serializable value) throws UtilsException {
        try {
            this.cache.put((Object)this.formatKeyCache(key), (Object)value);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private String formatKeyCache(String key) {
        if (key.endsWith(":")) {
            return key + "_";
        }
        return key;
    }

    @Override
    public int getItemCount() throws UtilsException {
        CompositeCache cache = JCSAdminBean.getCompositeCacheManager().getCache(this.cacheName);
        return cache.getSize();
    }

    @Override
    public List<String> keys() throws UtilsException {
        try {
            ArrayList<String> keys = new ArrayList<String>();
            Serializable[] keysObject = this.cache.getCacheControl().getKeySet().toArray(new Serializable[0]);
            if (keysObject != null) {
                for (int i = 0; i < keysObject.length; ++i) {
                    keys.add((String)((Object)keysObject[i]));
                }
            }
            return keys;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    @Override
    public void printStats(OutputStream out, String separator) throws UtilsException {
        this.printStats(this.cacheName, out, separator, true);
    }

    private void printStats(String cacheName, OutputStream out, String separator, boolean thisCache) throws UtilsException {
        try {
            StringBuilder bf = new StringBuilder();
            CompositeCache cache = JCSAdminBean.getCompositeCacheManager().getCache(cacheName);
            long sizeAttuale = -1L;
            for (int tentativi = 0; tentativi < 10; ++tentativi) {
                sizeAttuale = this.getByteCount(cache);
                if (!this.errorOccursCountingBytes || !thisCache) break;
                cache = JCSAdminBean.getCompositeCacheManager().getCache(cacheName);
            }
            bf.append("Nome:");
            bf.append(cacheName);
            bf.append(" ");
            bf.append(separator);
            bf.append("Tipo:");
            bf.append((Object)CacheType.JCS);
            bf.append(" ");
            bf.append(separator);
            bf.append("Stato:");
            bf.append(cache.getStatus());
            bf.append(" ");
            bf.append(separator);
            if (cache.getCacheAttributes() != null) {
                bf.append("Algoritmo:");
                String cacheAlgoName = cache.getCacheAttributes().getCacheName();
                CacheAlgorithm cacheEnum = CacheAlgorithm.toEnum(cacheAlgoName);
                if (cacheEnum != null) {
                    bf.append(cacheEnum.name());
                } else {
                    bf.append(cacheAlgoName);
                }
                bf.append(" ");
                bf.append(separator);
                bf.append("Dimensione:");
                bf.append(cache.getCacheAttributes().getMaxObjects());
                bf.append(" ");
                bf.append(separator);
            }
            bf.append("ElementiInCache:");
            bf.append(cache.getSize());
            bf.append(" ");
            bf.append(separator);
            bf.append("MemoriaOccupata:");
            if (this.errorOccursCountingBytes) {
                bf.append("[WARN !Error occurs counting bytes, re-try!]");
            }
            bf.append(Utilities.convertBytesToFormatString(sizeAttuale));
            bf.append(" ");
            bf.append(separator);
            if (cache.getElementAttributes() != null) {
                bf.append("IdleTime:");
                long idleTime = cache.getElementAttributes().getIdleTime();
                if (idleTime > 0L) {
                    bf.append(Utilities.convertSystemTimeIntoStringMillisecondi(idleTime * 1000L, false));
                } else if (idleTime == 0L) {
                    bf.append("0");
                } else if (idleTime < 0L) {
                    bf.append("Infinito");
                }
                bf.append(" ");
                bf.append(separator);
                bf.append("LifeTime:");
                long lifeTime = cache.getElementAttributes().getMaxLife();
                if (lifeTime > 0L) {
                    bf.append(Utilities.convertSystemTimeIntoStringMillisecondi(lifeTime * 1000L, false));
                } else if (lifeTime == 0L) {
                    bf.append("0");
                } else if (lifeTime < 0L) {
                    if (cache.getElementAttributes().getIsEternal()) {
                        bf.append("Infinito");
                    } else {
                        bf.append("Infinito (NoEternal?)");
                    }
                }
                bf.append(" ");
                bf.append(separator);
            }
            bf.append("PutCount:");
            bf.append(cache.getUpdateCount());
            bf.append(" ");
            bf.append(separator);
            bf.append("HitCount(Aux):");
            bf.append(cache.getHitCountAux());
            bf.append(" ");
            bf.append(separator);
            bf.append("HitCount(Ram):");
            bf.append(cache.getHitCountRam());
            bf.append(" ");
            bf.append(separator);
            bf.append("MissCount(Expired):");
            bf.append(cache.getMissCountExpired());
            bf.append(" ");
            bf.append(separator);
            bf.append("MissCount(NotFound):");
            bf.append(cache.getMissCountNotFound());
            bf.append(" ");
            out.write(bf.toString().getBytes());
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> long getByteCount(CompositeCache<K, V> cache) {
        this.errorOccursCountingBytes = false;
        if (cache == null) {
            throw new IllegalArgumentException("The cache object specified was null.");
        }
        long size = 0L;
        IMemoryCache memCache = cache.getMemoryCache();
        try {
            for (Object key : memCache.getKeySet()) {
                ICacheElement ice = null;
                try {
                    ice = memCache.get(key);
                }
                catch (IOException e) {
                    if (this.errorOccursCountingBytes_debug) {
                        System.err.println("[" + this.cacheName + "] Element cache get");
                        e.printStackTrace(System.err);
                    }
                    this.errorOccursCountingBytes = true;
                    continue;
                }
                if (ice == null) continue;
                if (ice instanceof CacheElementSerialized) {
                    size += (long)((CacheElementSerialized)ice).getSerializedValue().length;
                    continue;
                }
                Object element = ice.getVal();
                if (element == null) {
                    if (this.errorOccursCountingBytes_debug) {
                        System.err.println("[" + this.cacheName + "] Element cache is null");
                    }
                    this.errorOccursCountingBytes = true;
                    continue;
                }
                CountingOnlyOutputStream counter = new CountingOnlyOutputStream();
                try (ObjectOutputStream out = new ObjectOutputStream((OutputStream)counter);){
                    out.writeObject(element);
                }
                catch (IOException e) {
                    if (this.errorOccursCountingBytes_debug) {
                        System.err.println("[" + this.cacheName + "] Element cache writeObject (" + element.getClass().getName() + ")");
                        e.printStackTrace(System.err);
                    }
                    this.errorOccursCountingBytes = true;
                    continue;
                }
                finally {
                    try {
                        counter.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                size += (long)(counter.getCount() - 4);
            }
        }
        catch (Exception e) {
            System.err.println("Problem getting byte count (Modified by GovWay).  Likley cause is a non serilizable object." + e.getMessage());
            e.printStackTrace(System.err);
        }
        return size;
    }

    public static String printAllStats(String separatorStat, String separatorCache) throws UtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            JCS3CacheImpl.printAllStats(bout, separatorStat, separatorCache);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static void printAllStats(OutputStream out, String separatorStat, String separatorCache) throws UtilsException {
        try {
            JCS3CacheImpl cacheUtility = new JCS3CacheImpl();
            Set cacheNames_tmp = JCSAdminBean.getCompositeCacheManager().getCacheNames();
            if (cacheNames_tmp.size() > 0) {
                Object[] cacheNames = new String[cacheNames_tmp.size()];
                int index = 0;
                for (String name : cacheNames_tmp) {
                    cacheNames[index] = name;
                    ++index;
                }
                Arrays.sort(cacheNames);
                for (int i = 0; i < cacheNames.length; ++i) {
                    cacheUtility.printStats((String)cacheNames[i], out, separatorStat, false);
                    out.write(separatorCache.getBytes());
                }
            }
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    @Override
    @Deprecated
    public void disableSyncronizedGet() throws UtilsException {
        if (this.cache == null) {
            throw new UtilsException("Cache disabled");
        }
    }

    @Override
    @Deprecated
    public boolean isDisableSyncronizedGet() throws UtilsException {
        if (this.cache == null) {
            throw new UtilsException("Cache disabled");
        }
        try {
            return true;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    @Override
    @Deprecated
    public void enableDebugSystemOut() throws UtilsException {
        if (this.cache == null) {
            throw new UtilsException("Cache disabled");
        }
    }

    @Override
    @Deprecated
    public boolean isEnableDebugSystemOut() throws UtilsException {
        if (this.cache == null) {
            throw new UtilsException("Cache disabled");
        }
        try {
            return false;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

