/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.cache.test;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.cache.test.ExampleExceptionNotFound;
import org.openspcoop2.utils.cache.test.ExampleServletInitListener;
import org.slf4j.Logger;

public class ExampleService
extends HttpServlet {
    private static int uuid = 1;
    private static Logger log = LoggerWrapperFactory.getLogger(ExampleService.class);
    private static final long serialVersionUID = 1L;

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            this.doGet(req, res);
        }
        catch (Exception e) {
            try {
                res.sendError(500, e.getMessage());
            }
            catch (Exception eSendError) {
                log.error(eSendError.getMessage(), (Throwable)eSendError);
            }
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (!ExampleServletInitListener.isInitialized()) {
            try {
                res.sendError(500, "Applicazione non inizializzata");
                return;
            }
            catch (Exception eSendError) {
                log.error(eSendError.getMessage(), (Throwable)eSendError);
            }
        }
        Logger log = LoggerWrapperFactory.getLogger(ExampleService.class);
        Object prefix = "";
        Object con = null;
        try {
            boolean DEBUG = true;
            String idTransazione = "" + uuid++;
            prefix = "[" + idTransazione + "] ";
            log.info((String)prefix + "Ricevuta richiesta ...");
            con = null;
            String method = "getName";
            String surname = "Green";
            int age = 23;
            Object key = surname + "_" + age;
            Object name = ExampleServletInitListener.configManager.getObjectCache(con, DEBUG, (String)key, method, surname, age);
            log.info((String)prefix + "Name: " + String.valueOf(name));
            ExampleServletInitListener.configManager.duplicateObjectCache((String)key, method, (String)key + "NEW", method + "NEW", DEBUG, false);
            name = ExampleServletInitListener.configManager.getObjectCache(con, DEBUG, (String)key + "NEW", method + "NEW", surname, age);
            log.info((String)prefix + "NameDuplicate: " + String.valueOf(name));
            method = "isTest";
            key = "EXCEPTION";
            try {
                ExampleServletInitListener.configManager.getObjectCache(con, DEBUG, (String)key, method, "EXCEPTION");
            }
            catch (ExampleExceptionNotFound notFound) {
                log.info((String)prefix + "Eccezione attesa: " + notFound.getClass().getName());
            }
            catch (Throwable e) {
                log.error((String)prefix + "Errore: " + e.getMessage(), e);
            }
            method = "isTest";
            key = "GENERIC_EXCEPTION";
            try {
                ExampleServletInitListener.configManager.getObjectCache(con, DEBUG, (String)key, method, "GENERIC_EXCEPTION");
            }
            catch (Throwable e) {
                log.info((String)prefix + "altra eccezione: " + e.getClass().getName());
            }
            method = "isTest";
            try {
                ExampleServletInitListener.configManager.getObjectCache(con, DEBUG, null, method, "NULL");
            }
            catch (ExampleExceptionNotFound notFound) {
                log.info((String)prefix + "Eccezione attesa: " + notFound.getClass().getName());
            }
            catch (Throwable e) {
                log.error((String)prefix + "Errore: " + e.getMessage(), e);
            }
            log.info((String)prefix + "Terminata attivita");
        }
        catch (Throwable e) {
            log.error((String)prefix + "Errore: " + e.getMessage(), e);
        }
    }
}

