/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.cache.test;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.cache.LimitedHashMap;

public class LimitedHashMapTest {
    public static void main(String[] args) throws Exception {
        LimitedHashMapTest.test();
    }

    public static void test() throws Exception {
        String key;
        int ix;
        int maxSize = 50;
        int maxLifeTime = 10000;
        int threads = 10;
        ExecutorService threadsPool = Executors.newFixedThreadPool(threads);
        final Random random = new Random();
        final LimitedHashMap<String, CallSite> map = new LimitedHashMap<String, CallSite>("TEST", maxSize, maxLifeTime);
        for (ix = 0; ix < 100; ++ix) {
            key = Integer.toString(ix);
            map.put(key, (CallSite)((Object)("test-" + key)));
        }
        for (ix = 0; ix < 100; ++ix) {
            key = Integer.toString(ix);
            System.out.println(key + " : " + String.valueOf(map.get(key)));
        }
        System.out.println("Attuale size: " + map.size());
        System.out.println("\n\nTest con " + threads + " threads");
        HashMap<CallSite, 1> threadsMap = new HashMap<CallSite, 1>();
        final CountDownLatch latch = new CountDownLatch(threads);
        for (int i = 0; i < threads; ++i) {
            final String id = "thread-" + i;
            threadsMap.put((CallSite)((Object)id), new Runnable(){

                @Override
                public void run() {
                    for (int ix = 0; ix < 100; ++ix) {
                        Utilities.sleep(random.nextInt(50));
                        String key = Integer.toString(ix);
                        map.put(key, id + "_test-" + key);
                    }
                    latch.countDown();
                }
            });
            threadsPool.execute((Runnable)threadsMap.get(id));
        }
        latch.await();
        threadsPool.shutdown();
        for (int ix2 = 0; ix2 < 100; ++ix2) {
            String key2 = Integer.toString(ix2);
            System.out.println(key2 + " : " + String.valueOf(map.get(key2)));
        }
        System.out.println("Attuale size: " + map.size());
        System.out.println("\n\nTestsuite terminata");
    }
}

