/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.openspcoop2.utils.certificate.CRLDistributionPoint;

public class CRLDistributionPoints {
    private List<CRLDistributionPoint> distributionPoints = new ArrayList<CRLDistributionPoint>();

    public List<CRLDistributionPoint> getCRLDistributionPoints() {
        return this.distributionPoints;
    }

    public CRLDistributionPoint getCRLDistributionPoint(int index) {
        return this.distributionPoints != null && this.distributionPoints.size() > index ? this.distributionPoints.get(index) : null;
    }

    public static CRLDistributionPoints getCRLDistributionPoints(byte[] encoded) {
        CRLDistPoint crlDistPoint;
        Certificate c = Certificate.getInstance((Object)encoded);
        Extensions exts = c.getTBSCertificate().getExtensions();
        if (exts != null && (crlDistPoint = CRLDistPoint.fromExtensions((Extensions)exts)) != null) {
            return CRLDistributionPoints.readCRLDistributionPoints(crlDistPoint);
        }
        return null;
    }

    private static CRLDistributionPoints readCRLDistributionPoints(CRLDistPoint crlDistPoint) {
        CRLDistributionPoints crls = null;
        if (crlDistPoint.getDistributionPoints() != null && crlDistPoint.getDistributionPoints().length > 0) {
            crls = new CRLDistributionPoints();
            for (int i = 0; i < crlDistPoint.getDistributionPoints().length; ++i) {
                DistributionPoint dt = crlDistPoint.getDistributionPoints()[i];
                if (dt == null) continue;
                CRLDistributionPoint crl = CRLDistributionPoints.readCRLDistributionPoint(dt);
                crls.distributionPoints.add(crl);
            }
        }
        return crls;
    }

    private static CRLDistributionPoint readCRLDistributionPoint(DistributionPoint dt) {
        CRLDistributionPoint crl = new CRLDistributionPoint();
        if (dt.getCRLIssuer() != null && dt.getCRLIssuer().getNames() != null && dt.getCRLIssuer().getNames().length > 0) {
            for (GeneralName gn : dt.getCRLIssuer().getNames()) {
                crl.crlIssuers.add(gn);
            }
        }
        if (dt.getReasons() != null) {
            crl.reasonFlags = dt.getReasons();
        }
        if (dt.getDistributionPoint() != null) {
            CRLDistributionPoints.setCRLDistributionPoint(crl, dt);
        }
        return crl;
    }

    private static void setCRLDistributionPoint(CRLDistributionPoint crl, DistributionPoint dt) {
        GeneralNames gns;
        crl.distributionPointName = dt.getDistributionPoint();
        if (dt.getDistributionPoint().getName() instanceof GeneralNames && (gns = (GeneralNames)dt.getDistributionPoint().getName()).getNames() != null && gns.getNames().length > 0) {
            for (GeneralName gn : gns.getNames()) {
                crl.distributionPointNames.add(gn);
            }
        }
    }
}

