/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.CertificatePolicies;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.openspcoop2.utils.certificate.CertificatePolicyEntry;

public class CertificatePolicy {
    private static final String PARAM_OID_UNDEFINED = "Param oid undefined";
    private ASN1ObjectIdentifier asn1ObjectIdentifier;
    private List<CertificatePolicyEntry> qualifiers = new ArrayList<CertificatePolicyEntry>();

    public ASN1ObjectIdentifier getAsn1ObjectIdentifier() {
        return this.asn1ObjectIdentifier;
    }

    public String getOID() {
        return this.asn1ObjectIdentifier != null ? this.asn1ObjectIdentifier.getId() : null;
    }

    public List<CertificatePolicyEntry> getQualifiers() {
        return this.qualifiers;
    }

    public CertificatePolicyEntry getQualifier(int index) {
        return this.qualifiers != null ? this.qualifiers.get(index) : null;
    }

    public CertificatePolicyEntry getQualifier(String oid) throws CertificateParsingException {
        return this.getQualifierByOID(oid);
    }

    public CertificatePolicyEntry getQualifierByOID(String oid) throws CertificateParsingException {
        if (oid == null) {
            throw new CertificateParsingException(PARAM_OID_UNDEFINED);
        }
        if (this.qualifiers != null && !this.qualifiers.isEmpty()) {
            for (CertificatePolicyEntry certificatePolicyQualifier : this.qualifiers) {
                if (!oid.equals(certificatePolicyQualifier.getOID())) continue;
                return certificatePolicyQualifier;
            }
        }
        return null;
    }

    public boolean hasCertificatePolicyQualifier(String oid) throws CertificateParsingException {
        if (oid == null) {
            throw new CertificateParsingException(PARAM_OID_UNDEFINED);
        }
        return this.getQualifierByOID(oid) != null;
    }

    public static boolean existsCertificatePolicy(X509Certificate x509, String oid) throws CertificateParsingException, CertificateEncodingException {
        if (oid == null) {
            throw new CertificateParsingException(PARAM_OID_UNDEFINED);
        }
        List<CertificatePolicy> list = CertificatePolicy.getCertificatePolicies(x509.getEncoded());
        if (!list.isEmpty()) {
            for (CertificatePolicy certificatePolicy : list) {
                if (!oid.equals(certificatePolicy.getOID())) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.asn1ObjectIdentifier != null) {
            sb.append("OID:");
            sb.append(this.asn1ObjectIdentifier.getId());
        }
        if (this.qualifiers != null && !this.qualifiers.isEmpty()) {
            int index = 0;
            for (CertificatePolicyEntry o : this.qualifiers) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append("Qualifier[" + index + "]{\n");
                sb.append(o.toString("\t"));
                sb.append("}");
                ++index;
            }
        }
        return sb.toString();
    }

    public static List<CertificatePolicy> getCertificatePolicies(byte[] encoded) {
        PolicyInformation[] pi;
        CertificatePolicies certPolicies;
        ArrayList<CertificatePolicy> l = new ArrayList<CertificatePolicy>();
        Certificate c = Certificate.getInstance((Object)encoded);
        Extensions exts = c.getTBSCertificate().getExtensions();
        if (exts != null && (certPolicies = CertificatePolicies.fromExtensions((Extensions)exts)) != null && (pi = certPolicies.getPolicyInformation()) != null && pi.length > 0) {
            CertificatePolicy.read(pi, l);
        }
        return l;
    }

    private static void read(PolicyInformation[] pi, List<CertificatePolicy> l) {
        for (PolicyInformation policyInformation : pi) {
            CertificatePolicy cp = new CertificatePolicy();
            cp.asn1ObjectIdentifier = policyInformation.getPolicyIdentifier();
            if (policyInformation.getPolicyQualifiers() != null) {
                for (int i = 0; i < policyInformation.getPolicyQualifiers().size(); ++i) {
                    ASN1Encodable e = policyInformation.getPolicyQualifiers().getObjectAt(i);
                    if (!(e instanceof DLSequence)) continue;
                    DLSequence dl = (DLSequence)e;
                    CertificatePolicyEntry cpe = new CertificatePolicyEntry(dl);
                    cp.qualifiers.add(cpe);
                }
            }
            l.add(cp);
        }
    }
}

