/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;

public class Extensions {
    private org.bouncycastle.asn1.x509.Extensions exts;

    public org.bouncycastle.asn1.x509.Extensions getAll() {
        return this.exts;
    }

    public org.bouncycastle.asn1.x509.Extensions getExtensions() {
        return this.exts;
    }

    public Extension getExtension(String id) {
        ASN1ObjectIdentifier asn1 = new ASN1ObjectIdentifier(id);
        return this.getExtension(asn1);
    }

    public Extension getExtension(ASN1ObjectIdentifier id) {
        if (this.exts != null) {
            return this.exts.getExtension(id);
        }
        return null;
    }

    public List<String> getOIDs() {
        return this.getExtensionOIDsEngine(this.getASN1OIDs());
    }

    public List<ASN1ObjectIdentifier> getASN1OIDs() {
        return this.getExtensionASN1OIDsEngine(this.exts != null ? this.exts.getExtensionOIDs() : null);
    }

    public List<String> getCriticalOIDs() {
        return this.getExtensionOIDsEngine(this.getCriticalASN1OIDs());
    }

    public List<ASN1ObjectIdentifier> getCriticalASN1OIDs() {
        return this.getExtensionASN1OIDsEngine(this.exts != null ? this.exts.getCriticalExtensionOIDs() : null);
    }

    public List<String> getNonCriticalOIDs() {
        return this.getExtensionOIDsEngine(this.getNonCriticalASN1OIDs());
    }

    public List<ASN1ObjectIdentifier> getNonCriticalASN1OIDs() {
        return this.getExtensionASN1OIDsEngine(this.exts != null ? this.exts.getNonCriticalExtensionOIDs() : null);
    }

    private List<String> getExtensionOIDsEngine(List<ASN1ObjectIdentifier> l) {
        ArrayList<String> lR = null;
        if (l != null && !l.isEmpty()) {
            lR = new ArrayList<String>();
            for (ASN1ObjectIdentifier asn1 : l) {
                lR.add(asn1.getId());
            }
        }
        return lR;
    }

    private List<ASN1ObjectIdentifier> getExtensionASN1OIDsEngine(ASN1ObjectIdentifier[] ids) {
        ArrayList<ASN1ObjectIdentifier> l = null;
        if (ids != null && ids.length > 0) {
            l = new ArrayList<ASN1ObjectIdentifier>();
            l.addAll(Arrays.asList(ids));
        }
        return l;
    }

    public boolean hasExtension(String id) {
        return this.getExtension(id) != null;
    }

    public boolean hasExtension(ASN1ObjectIdentifier id) {
        return this.getExtension(id) != null;
    }

    public boolean hasCriticalExtension(String id) {
        List<String> criticalList = this.getCriticalOIDs();
        if (criticalList != null) {
            return criticalList.contains(id);
        }
        return false;
    }

    public boolean hasCriticalExtension(ASN1ObjectIdentifier id) {
        List<ASN1ObjectIdentifier> criticalList = this.getCriticalASN1OIDs();
        if (criticalList != null) {
            return criticalList.contains(id);
        }
        return false;
    }

    public boolean hasNonCriticalExtension(String id) {
        List<String> nonCriticalList = this.getNonCriticalOIDs();
        if (nonCriticalList != null) {
            return nonCriticalList.contains(id);
        }
        return false;
    }

    public boolean hasNonCriticalExtension(ASN1ObjectIdentifier id) {
        List<ASN1ObjectIdentifier> nonCriticalList = this.getNonCriticalASN1OIDs();
        if (nonCriticalList != null) {
            return nonCriticalList.contains(id);
        }
        return false;
    }

    public static Extensions getExtensions(byte[] encoded) {
        Extensions extObj = new Extensions();
        Certificate c = Certificate.getInstance((Object)encoded);
        extObj.exts = c.getTBSCertificate().getExtensions();
        return extObj;
    }
}

