/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Enumeration;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.CertificateFactory;
import org.slf4j.Logger;

public class FixTrustAnchorsNotEmpty {
    private static Logger log = LoggerWrapperFactory.getLogger(FixTrustAnchorsNotEmpty.class);
    private static java.security.cert.CertificateFactory cf = null;
    private static Certificate certFix = null;
    private static final String PEM = "-----BEGIN CERTIFICATE-----\nMIIC9TCCAd0CBE/Ior8wDQYJKoZIhvcNAQEFBQAwPjELMAkGA1UEBhMCSVQxLzAt\nBgNVBAMMJkZpeFRydXN0QW5jaG9yc1BhcmFtZXRlck11c3RCZU5vbkVtcHR5MCAX\nDTEyMDYwMTExMDg0N1oYDzIyODYwMzE2MTEwODQ3WjA+MQswCQYDVQQGEwJJVDEv\nMC0GA1UEAwwmRml4VHJ1c3RBbmNob3JzUGFyYW1ldGVyTXVzdEJlTm9uRW1wdHkw\nggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDDoLP0pdU4WM5DalQHPBhC\newg2vuS/S6gnG9gLr3N1FzH0efpBuUwX8R7tjX4bEAHnkJdfy+SVAOargNBJnIje\nHFmfIwWVjqnHSahZR2IbR8v9LnPgWFljmyu6rtqlSKpL2qhU0pyVaJCtzBUqsTia\nBLyQVj+aJJZIjT/BrbNogHds3Ez8Jsh24XbJWA/GcrqFOPW8VP4hg8RS+v7/rr5o\nepNQ1l5kc7lg/G4ABpBi3krqCRP2ZVlLdYdv3UbOWyUSOzn6PP17BAgaUAdHJNxg\nyxN3F39xMElgO6q9ZykgCDwlAjQtP/ejo5vvRNy7ZEnkY5st7FuUOErOReDQRnFZ\nAgMBAAEwDQYJKoZIhvcNAQEFBQADggEBAIq3c5tpfU+L3843mT1iVC2I7D85l2aG\nUgxMtBm+yYf428SR/ziL/9Z0DVA8G/6dOLpT2MdKQWEeAR8D3V0VnFZ7quysCug8\nXdmSW1kL5Z/rtXHfvQ6FOVYCaOV2f5Th9Hl0Z2dKVLNYBHzTL65OoB+yYMNGXv5Q\nITke2pz4vP3LYv4RDFl80g1Qofpeqa4AFuCkmxlntL7SBCJMtlQutRtJ99ZsxgYG\nMp0Afz8RQ2nSpTW6gUEcYx80oWRSipR7+dmMyeESYnv9l5K6raw3GIrNtzqkfRbx\nmZaYPs2bYuX52F4fNc3jqQ8Zd2XnH2nMtHShjFVVfvAY9/LueO2LTuk=\n-----END CERTIFICATE-----";

    private FixTrustAnchorsNotEmpty() {
    }

    private static synchronized void initCertificateFactory() {
        if (cf == null) {
            try (ByteArrayInputStream is = new ByteArrayInputStream(PEM.getBytes());){
                cf = CertificateFactory.getCertificateFactory();
                certFix = cf.generateCertificate(is);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void addCertificate(KeyStore keystore) throws UtilsException {
        try {
            Enumeration<String> aliases = keystore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!keystore.isCertificateEntry(alias)) continue;
                return;
            }
            if (cf == null) {
                FixTrustAnchorsNotEmpty.initCertificateFactory();
            }
            keystore.setCertificateEntry("FixTrustAnchorsParameterMustBeNonEmpty", certFix);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

