/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate;

import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.style.BCStyle;

public enum OID {
    CN(BCStyle.CN),
    C(BCStyle.C),
    OU(BCStyle.OU),
    O(BCStyle.O),
    L(BCStyle.L),
    ST(BCStyle.ST),
    ORGANIZATION_IDENTIFIER(BCStyle.ORGANIZATION_IDENTIFIER),
    T(BCStyle.T),
    SERIALNUMBER(BCStyle.SERIALNUMBER),
    NAME(BCStyle.NAME),
    SURNAME(BCStyle.SURNAME),
    GIVENNAME(BCStyle.GIVENNAME),
    STREET(BCStyle.STREET),
    POSTAL_CODE(BCStyle.POSTAL_CODE),
    POSTAL_ADDRESS(BCStyle.POSTAL_ADDRESS),
    TELEPHONE_NUMBER(BCStyle.TELEPHONE_NUMBER),
    INITIALS(BCStyle.INITIALS),
    GENERATION(BCStyle.GENERATION),
    UNIQUE_IDENTIFIER(BCStyle.UNIQUE_IDENTIFIER),
    DESCRIPTION(BCStyle.DESCRIPTION),
    BUSINESS_CATEGORY(BCStyle.BUSINESS_CATEGORY),
    DN_QUALIFIER(BCStyle.DN_QUALIFIER),
    PSEUDONYM(BCStyle.PSEUDONYM),
    ROLE(BCStyle.ROLE),
    DMD_NAME(BCStyle.DMD_NAME),
    UID(BCStyle.UID),
    DC(BCStyle.DC),
    EMAIL_ADDRESS(BCStyle.EmailAddress),
    E(BCStyle.E),
    UNSTRUCTURED_NAME(BCStyle.UnstructuredName),
    UNSTRUCTURED_ADDRESS(BCStyle.UnstructuredAddress),
    NAME_AT_BIRTH(BCStyle.NAME_AT_BIRTH),
    DATE_OF_BIRTH(BCStyle.DATE_OF_BIRTH),
    PLACE_OF_BIRTH(BCStyle.PLACE_OF_BIRTH),
    GENDER(BCStyle.GENDER),
    COUNTRY_OF_CITIZENSHIP(BCStyle.COUNTRY_OF_CITIZENSHIP),
    COUNTRY_OF_RESIDENCE(BCStyle.COUNTRY_OF_RESIDENCE);

    private String oidValue;
    private ASN1ObjectIdentifier oidBC;

    private OID(ASN1ObjectIdentifier oid) {
        this.oidValue = oid.getId();
        this.oidBC = oid;
    }

    public String getID() {
        return this.oidValue;
    }

    public ASN1ObjectIdentifier getOID() {
        if (this.oidBC != null) {
            return this.oidBC;
        }
        return new ASN1ObjectIdentifier(this.oidValue);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean printOID) {
        if (printOID) {
            return this.name() + " (" + this.oidValue + ")";
        }
        return this.name();
    }

    public static OID toOID(String id) {
        OID[] v;
        for (OID oid : v = OID.values()) {
            if (!oid.oidValue.equals(id)) continue;
            return oid;
        }
        return null;
    }

    public static OID toOID(ASN1ObjectIdentifier idBC) {
        OID[] v;
        for (OID oid : v = OID.values()) {
            if (!oid.oidBC.equals((ASN1Primitive)idBC)) continue;
            return oid;
        }
        return null;
    }
}

