/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.byok;

import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.certificate.byok.BYOKConfig;
import org.openspcoop2.utils.certificate.byok.BYOKCostanti;
import org.openspcoop2.utils.certificate.byok.BYOKMode;
import org.openspcoop2.utils.certificate.hsm.HSMManager;
import org.slf4j.Logger;

public class BYOKLocalConfig
implements Serializable {
    private static final long serialVersionUID = -3572589461109860459L;
    protected String encryptionEngine;
    protected KeystoreType keystoreType;
    protected String keystoreHsmType;
    protected String keystorePath;
    protected String keystorePassword;
    protected String keyPath;
    protected String keyInline;
    protected String keyEncoding;
    protected String keyAlgorithm;
    protected String keyAlias;
    protected String keyPassword;
    protected String keyId;
    protected boolean keyWrap = false;
    protected String publicKeyPath;
    protected String publicKeyInline;
    protected String publicKeyEncoding;
    protected String pw;
    protected String pwType;
    protected Integer pwIteration;
    protected String contentAlgorithm;
    protected String encoding;
    protected boolean joseIncludeCert;
    protected boolean joseIncludePublicKey;
    protected boolean joseIncludeKeyId;
    protected boolean joseIncludeCertSha1;
    protected boolean joseIncludeCertSha256;
    private static final String UNSUPPORTED_KEYSTORE_PREFIX = "Unsupported keystore '";
    private static final String UNSUPPORTED_PROPERTY_PREFIX = "Unsupported property '";
    private static final String VALUE_SEPARATOR = "' value '";
    private static final String TYPE_SEPARATOR = "' type '";

    protected BYOKLocalConfig() {
    }

    protected BYOKLocalConfig(String id, Properties p, Logger log, BYOKConfig config, String byokPropertyPrefix) throws UtilsException {
        if (p == null || p.isEmpty()) {
            log.error("Properties is null");
            throw new UtilsException("Properties '" + byokPropertyPrefix + id + ".*' undefined");
        }
        this.initEngine(id, p, config, byokPropertyPrefix);
        this.initKeystore(id, p, config, byokPropertyPrefix);
    }

    private void initEngine(String id, Properties p, BYOKConfig config, String byokPropertyPrefix) throws UtilsException {
        if (config != null) {
            // empty if block
        }
        this.encryptionEngine = BYOKConfig.getProperty(id, p, "local.impl", true, byokPropertyPrefix);
        if (!("java".equals(this.encryptionEngine) || "jose".equals(this.encryptionEngine) || "openssl".equals(this.encryptionEngine))) {
            throw new UtilsException(UNSUPPORTED_PROPERTY_PREFIX + byokPropertyPrefix + id + ".local.impl' value '" + this.encryptionEngine + "'");
        }
        this.contentAlgorithm = BYOKConfig.getProperty(id, p, "local.algorithm", !"openssl".equals(this.encryptionEngine), byokPropertyPrefix);
        if ("java".equals(this.encryptionEngine) || "openssl".equals(this.encryptionEngine)) {
            boolean required = "java".equals(this.encryptionEngine);
            this.encoding = BYOKConfig.getProperty(id, p, "local.encoding", required, byokPropertyPrefix);
            if (this.encoding != null && StringUtils.isNotEmpty((CharSequence)this.encoding) && !"base64".equals(this.encoding) && !"hex".equals(this.encoding)) {
                throw new UtilsException(UNSUPPORTED_PROPERTY_PREFIX + byokPropertyPrefix + id + ".local.encoding' value '" + this.encoding + "'");
            }
        }
        if ("java".equals(this.encryptionEngine)) {
            this.keyWrap = BYOKConfig.getBooleanProperty(id, p, "local.key.wrap", false, false, byokPropertyPrefix);
        }
        if ("jose".equals(this.encryptionEngine)) {
            this.joseIncludeCert = BYOKConfig.getBooleanProperty(id, p, "local.include.cert", false, false, byokPropertyPrefix);
            this.joseIncludePublicKey = BYOKConfig.getBooleanProperty(id, p, "local.include.public.key", false, false, byokPropertyPrefix);
            this.joseIncludeKeyId = BYOKConfig.getBooleanProperty(id, p, "local.include.key.id", false, false, byokPropertyPrefix);
            this.joseIncludeCertSha1 = BYOKConfig.getBooleanProperty(id, p, "local.include.cert.sha1", false, false, byokPropertyPrefix);
            this.joseIncludeCertSha256 = BYOKConfig.getBooleanProperty(id, p, "local.include.cert.sha256", false, false, byokPropertyPrefix);
            String keyIdTmp = BYOKConfig.getProperty(id, p, "local.key.id", false, byokPropertyPrefix);
            if (keyIdTmp != null) {
                this.keyId = keyIdTmp.trim();
            }
        }
    }

    private void initKeystore(String id, Properties p, BYOKConfig config, String byokPropertyPrefix) throws UtilsException {
        String tmpKeystoreType = BYOKConfig.getProperty(id, p, "local.keystore.type", true, byokPropertyPrefix);
        this.keystoreType = KeystoreType.toEnumFromName(tmpKeystoreType);
        if (this.keystoreType == null) {
            HSMManager hsmManager = HSMManager.getInstance();
            if (hsmManager.existsKeystoreType(tmpKeystoreType)) {
                this.keystoreType = KeystoreType.PKCS11;
                this.keystoreHsmType = tmpKeystoreType;
            } else {
                throw new UtilsException(UNSUPPORTED_KEYSTORE_PREFIX + byokPropertyPrefix + id + ".local.keystore.type' type '" + tmpKeystoreType + "'");
            }
        }
        String unsupportedError = UNSUPPORTED_KEYSTORE_PREFIX + byokPropertyPrefix + id + ".local.keystore.type' type '" + tmpKeystoreType + "' with " + byokPropertyPrefix + id + ".local.impl '";
        switch (this.keystoreType) {
            case JKS: 
            case PKCS12: 
            case PKCS11: 
            case JWK_SET: 
            case JCEKS: {
                if (config != null && config.getLocalConfig() != null && config.getLocalConfig().isOpenSSLEngine()) {
                    throw new UtilsException(unsupportedError + "openssl'");
                }
                this.initKeystoreEngine(id, p, config, byokPropertyPrefix);
                break;
            }
            case KEY_PAIR: 
            case PUBLIC_KEY: 
            case SYMMETRIC_KEY: {
                if (config != null && config.getLocalConfig() != null && config.getLocalConfig().isOpenSSLEngine()) {
                    throw new UtilsException(unsupportedError + "openssl'");
                }
                this.initKeyEngine(id, p, byokPropertyPrefix);
                break;
            }
            case PASSWORD_KEY_DERIVATION: {
                if ("jose".equals(this.encryptionEngine)) {
                    throw new UtilsException(unsupportedError + "jose'");
                }
                this.initPasswordEngine(id, p, byokPropertyPrefix);
                break;
            }
            default: {
                throw new UtilsException(UNSUPPORTED_KEYSTORE_PREFIX + byokPropertyPrefix + id + ".local.keystore.type' type '" + String.valueOf((Object)this.keystoreType) + "'");
            }
        }
    }

    private void initKeystoreEngine(String id, Properties p, BYOKConfig config, String byokPropertyPrefix) throws UtilsException {
        this.keystorePath = KeystoreType.PKCS11.equals((Object)this.keystoreType) ? "-" : BYOKConfig.getProperty(id, p, "local.keystore.path", true, byokPropertyPrefix);
        if (KeystoreType.PKCS11.equals((Object)this.keystoreType)) {
            this.keystorePassword = "-";
        } else if (!KeystoreType.JWK_SET.equals((Object)this.keystoreType)) {
            this.keystorePassword = BYOKConfig.getProperty(id, p, "local.keystore.password", true, byokPropertyPrefix);
        }
        this.initKeystoreKey(id, p, config, byokPropertyPrefix);
    }

    private void initKeystoreKey(String id, Properties p, BYOKConfig config, String byokPropertyPrefix) throws UtilsException {
        this.keyAlias = BYOKConfig.getProperty(id, p, "local.key.alias", true, byokPropertyPrefix);
        if (KeystoreType.JCEKS.equals((Object)this.keystoreType) || BYOKMode.UNWRAP.equals((Object)config.getMode())) {
            this.keyPassword = BYOKConfig.getProperty(id, p, "local.key.password", false, byokPropertyPrefix);
        }
        this.keyAlgorithm = BYOKConfig.getProperty(id, p, "local.key.algorithm", true, byokPropertyPrefix);
    }

    private void initKeyEngine(String id, Properties p, String byokPropertyPrefix) throws UtilsException {
        this.keyInline = BYOKConfig.getProperty(id, p, "local.key.inline", false, byokPropertyPrefix);
        this.keyPath = BYOKConfig.getProperty(id, p, "local.key.path", this.keyInline == null || StringUtils.isEmpty((CharSequence)this.keyInline), byokPropertyPrefix);
        this.keyEncoding = BYOKConfig.getProperty(id, p, "local.key.encoding", false, byokPropertyPrefix);
        if (this.keyEncoding != null && StringUtils.isNotEmpty((CharSequence)this.keyEncoding) && !"base64".equals(this.keyEncoding) && !"hex".equals(this.keyEncoding)) {
            throw new UtilsException(UNSUPPORTED_PROPERTY_PREFIX + byokPropertyPrefix + id + ".local.key.encoding' value '" + this.keyEncoding + "'");
        }
        this.keyAlgorithm = BYOKConfig.getProperty(id, p, "local.key.algorithm", true, byokPropertyPrefix);
        if (KeystoreType.KEY_PAIR.equals((Object)this.keystoreType)) {
            this.publicKeyInline = BYOKConfig.getProperty(id, p, "local.publicKey.inline", false, byokPropertyPrefix);
            this.publicKeyPath = BYOKConfig.getProperty(id, p, "local.publicKey.path", this.publicKeyInline == null || StringUtils.isEmpty((CharSequence)this.publicKeyInline), byokPropertyPrefix);
            this.publicKeyEncoding = BYOKConfig.getProperty(id, p, "local.publicKey.encoding", false, byokPropertyPrefix);
            if (this.publicKeyEncoding != null && StringUtils.isNotEmpty((CharSequence)this.publicKeyEncoding) && !"base64".equals(this.publicKeyEncoding) && !"hex".equals(this.publicKeyEncoding)) {
                throw new UtilsException(UNSUPPORTED_PROPERTY_PREFIX + byokPropertyPrefix + id + ".local.publicKey.encoding' value '" + this.publicKeyEncoding + "'");
            }
            this.keyPassword = BYOKConfig.getProperty(id, p, "local.key.password", false, byokPropertyPrefix);
        }
    }

    private void initPasswordEngine(String id, Properties p, String byokPropertyPrefix) throws UtilsException {
        this.pw = BYOKConfig.getProperty(id, p, "local.password", true, byokPropertyPrefix);
        this.pwType = BYOKConfig.getProperty(id, p, "local.password.type", false, byokPropertyPrefix);
        if (this.pwType == null || StringUtils.isEmpty((CharSequence)this.pwType.trim())) {
            this.pwType = "openssl-pbkdf2-aes-256-cbc";
        } else if (!BYOKCostanti.getLocalPasswordTypes().contains(this.pwType)) {
            throw new UtilsException(UNSUPPORTED_PROPERTY_PREFIX + byokPropertyPrefix + id + ".local.password.type' value '" + this.pwType + "'");
        }
        this.pwIteration = BYOKConfig.getIntegerProperty(id, p, "local.password.iter", false, byokPropertyPrefix);
    }

    public boolean isJavaEngine() {
        return "java".equals(this.encryptionEngine);
    }

    public boolean isJoseEngine() {
        return "jose".equals(this.encryptionEngine);
    }

    public boolean isOpenSSLEngine() {
        return "openssl".equals(this.encryptionEngine);
    }

    public KeystoreType getKeystoreType() {
        return this.keystoreType;
    }

    public String getKeystoreHsmType() {
        return this.keystoreHsmType;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getKeyPath() {
        return this.keyPath;
    }

    public String getKeyInline() {
        return this.keyInline;
    }

    public boolean isKeyBase64Encoding() {
        return "base64".equals(this.keyEncoding);
    }

    public boolean isKeyHexEncoding() {
        return "hex".equals(this.keyEncoding);
    }

    public String getKeyEncoding() {
        return this.keyEncoding;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public void generateKeyAlias() {
        this.keyAlias = UUID.randomUUID().toString();
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public boolean isKeyWrap() {
        return this.keyWrap;
    }

    public String getPublicKeyPath() {
        return this.publicKeyPath;
    }

    public String getPublicKeyInline() {
        return this.publicKeyInline;
    }

    public boolean isPublicKeyBase64Encoding() {
        return "base64".equals(this.publicKeyEncoding);
    }

    public boolean isPublicKeyHexEncoding() {
        return "hex".equals(this.publicKeyEncoding);
    }

    public String getPublicKeyEncoding() {
        return this.publicKeyEncoding;
    }

    public String getPassword() {
        return this.pw;
    }

    public String getPasswordType() {
        return this.pwType;
    }

    public Integer getPasswordIteration() {
        return this.pwIteration;
    }

    public String getContentAlgorithm() {
        return this.contentAlgorithm;
    }

    public boolean isBase64Encoding() {
        return "base64".equals(this.encoding);
    }

    public boolean isHexEncoding() {
        return "hex".equals(this.encoding);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isJoseIncludeCert() {
        return this.joseIncludeCert;
    }

    public boolean isJoseIncludePublicKey() {
        return this.joseIncludePublicKey;
    }

    public boolean isJoseIncludeKeyId() {
        return this.joseIncludeKeyId;
    }

    public boolean isJoseIncludeCertSha1() {
        return this.joseIncludeCertSha1;
    }

    public boolean isJoseIncludeCertSha256() {
        return this.joseIncludeCertSha256;
    }
}

