/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.byok;

import java.util.Map;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.byok.BYOKConfig;
import org.openspcoop2.utils.certificate.byok.BYOKManager;

public class BYOKRequestParams {
    private Map<String, Object> dynamicMap;
    private String keyIdentity;
    private BYOKConfig config;
    private Map<String, String> inputMap;

    public Map<String, Object> getDynamicMap() {
        return this.dynamicMap;
    }

    public void setDynamicMap(Map<String, Object> dynamicMap) {
        this.dynamicMap = dynamicMap;
    }

    public String getKeyIdentity() {
        return this.keyIdentity;
    }

    public void setKeyIdentity(String keyIdentity) {
        this.keyIdentity = keyIdentity;
    }

    public BYOKConfig getConfig() {
        return this.config;
    }

    public void setConfig(BYOKConfig config) {
        this.config = config;
    }

    public Map<String, String> getInputMap() {
        return this.inputMap;
    }

    public void setInputMap(Map<String, String> inputMap) {
        this.inputMap = inputMap;
    }

    public static BYOKRequestParams getBYOKRequestParamsByKmsId(String kmsId, Map<String, String> inputMap, Map<String, Object> dynamicMap) throws UtilsException {
        BYOKManager manager = BYOKManager.getInstance();
        if (manager == null) {
            throw new UtilsException("BYOKManager not initialized");
        }
        return BYOKRequestParams.getBYOKRequestParamsByKmsId(kmsId, manager, inputMap, dynamicMap);
    }

    public static BYOKRequestParams getBYOKRequestParamsByKmsId(String kmsId, BYOKManager manager, Map<String, String> inputMap, Map<String, Object> dynamicMap) throws UtilsException {
        BYOKConfig bconfig = manager.getKMSConfigByType(kmsId);
        if (bconfig == null) {
            throw new UtilsException("BYOK configuration for kms id '" + kmsId + "' not found");
        }
        BYOKRequestParams req = new BYOKRequestParams();
        req.setConfig(bconfig);
        req.setInputMap(inputMap);
        req.setDynamicMap(dynamicMap);
        req.setKeyIdentity(kmsId);
        return req;
    }
}

