/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.byok;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.byok.BYOKSecurityConfigParameter;
import org.slf4j.Logger;

public class BYOKSecurityConfig
implements Serializable {
    private static final long serialVersionUID = -3572589461109860459L;
    private String id;
    private String wrapId;
    private String unwrapId;
    private List<String> inputParametersIds;
    private List<BYOKSecurityConfigParameter> inputParameters = new ArrayList<BYOKSecurityConfigParameter>();

    protected BYOKSecurityConfig(String id, Properties p, Logger log) throws UtilsException {
        this.id = id;
        if (p == null || p.isEmpty()) {
            log.error("Properties is null");
            throw new UtilsException("Properties 'security." + id + ".*' undefined");
        }
        boolean deprecatedMode = false;
        this.wrapId = BYOKSecurityConfig.getProperty(id, p, "kms.wrap", false);
        if (this.wrapId == null) {
            this.wrapId = BYOKSecurityConfig.getProperty(id, p, "ksm.wrap", false);
            if (this.wrapId != null) {
                deprecatedMode = true;
            }
        }
        if (this.wrapId == null) {
            this.wrapId = BYOKSecurityConfig.getProperty(id, p, "kms.wrap", true);
        }
        this.unwrapId = BYOKSecurityConfig.getProperty(id, p, "kms.unwrap", false);
        if (this.unwrapId == null) {
            this.unwrapId = BYOKSecurityConfig.getProperty(id, p, "ksm.unwrap", false);
            if (this.unwrapId != null) {
                deprecatedMode = true;
            }
        }
        if (this.unwrapId == null) {
            this.unwrapId = BYOKSecurityConfig.getProperty(id, p, "kms.unwrap", true);
        }
        String securityPropertySuffixInput = deprecatedMode ? "ksm.param." : "kms.param.";
        this.inputParametersIds = new ArrayList<String>();
        this.initInput(p, this.inputParametersIds, securityPropertySuffixInput);
        if (this.inputParametersIds != null && !this.inputParametersIds.isEmpty()) {
            for (String inputId : this.inputParametersIds) {
                String value = BYOKSecurityConfig.getProperty(id, p, securityPropertySuffixInput + inputId, true);
                this.inputParameters.add(new BYOKSecurityConfigParameter(inputId, value));
            }
        }
    }

    void initInput(Properties p, List<String> idKeystore, String securityPropertySuffixInput) {
        Enumeration<Object> enKeys = p.keys();
        while (enKeys.hasMoreElements()) {
            Object object = enKeys.nextElement();
            if (!(object instanceof String)) continue;
            String key = (String)object;
            this.initInput(key, securityPropertySuffixInput, idKeystore);
        }
    }

    void initInput(String key, String prefix, List<String> idKeystore) {
        String tmp;
        if (key.startsWith(prefix) && key.length() > prefix.length() && !idKeystore.contains(tmp = key.substring(prefix.length()))) {
            idKeystore.add(tmp);
        }
    }

    static String getProperty(String id, Properties p, String name, boolean required) throws UtilsException {
        String tmp = p.getProperty(name);
        if (tmp != null) {
            return tmp.trim();
        }
        if (required) {
            throw new UtilsException("Property 'security." + id + "." + name + "' notFound");
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public String getPrefixForLog() {
        return "[Security BYOK '" + this.getId() + "'] ";
    }

    public String getWrapId() {
        return this.wrapId;
    }

    public String getUnwrapId() {
        return this.unwrapId;
    }

    public List<String> getInputParametersIds() {
        return this.inputParametersIds;
    }

    public List<BYOKSecurityConfigParameter> getInputParameters() {
        return this.inputParameters;
    }
}

